/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.type;

public class Complex {
    private double re;
    private double im;

    public Complex() {
        this.re = 0.0;
        this.im = 0.0;
    }

    public Complex(double d) {
        this.re = d;
        this.im = 0.0;
    }

    public Complex(Number number) {
        this.re = number.doubleValue();
        this.im = 0.0;
    }

    public Complex(Complex complex) {
        this.re = complex.re;
        this.im = complex.im;
    }

    public Complex(double d, double d2) {
        this.re = d;
        this.im = d2;
    }

    public double re() {
        return this.re;
    }

    public double im() {
        return this.im;
    }

    public void set(Complex complex) {
        this.re = complex.re;
        this.im = complex.im;
    }

    public void set(double d, double d2) {
        this.re = d;
        this.im = d2;
    }

    public void setRe(double d) {
        this.re = d;
    }

    public void setIm(double d) {
        this.im = d;
    }

    public boolean equals(Complex complex, double d) {
        double d2 = this.re - complex.re;
        double d3 = this.im - complex.im;
        return d2 * d2 + d3 * d3 <= d * d;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Complex)) {
            return false;
        }
        Complex complex = (Complex)object;
        return Double.doubleToLongBits(this.re) == Double.doubleToLongBits(complex.re) && Double.doubleToLongBits(this.im) == Double.doubleToLongBits(complex.im);
    }

    public int hashCode() {
        int n = 17;
        long l = Double.doubleToLongBits(this.re);
        long l2 = Double.doubleToLongBits(this.im);
        int n2 = (int)(l ^ l >> 32);
        int n3 = (int)(l2 ^ l2 >> 32);
        n = 37 * n + n2;
        n = 37 * n + n3;
        return n;
    }

    public String toString() {
        return "(" + this.re + ", " + this.im + ")";
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.re) || Double.isInfinite(this.im);
    }

    public boolean isNaN() {
        return Double.isNaN(this.re) || Double.isNaN(this.im);
    }

    public double abs() {
        double d = Math.abs(this.re);
        double d2 = Math.abs(this.im);
        if (d == 0.0 && d2 == 0.0) {
            return 0.0;
        }
        if (d > d2) {
            double d3 = d2 / d;
            return d * Math.sqrt(1.0 + d3 * d3);
        }
        double d4 = d / d2;
        return d2 * Math.sqrt(1.0 + d4 * d4);
    }

    public double abs2() {
        return this.re * this.re + this.im * this.im;
    }

    public double arg() {
        return Math.atan2(this.im, this.re);
    }

    public Complex neg() {
        return new Complex(-this.re, -this.im);
    }

    public Complex mul(double d) {
        return new Complex(this.re * d, this.im * d);
    }

    public Complex add(Complex complex) {
        return new Complex(this.re + complex.re, this.im + complex.im);
    }

    public Complex sub(Complex complex) {
        return new Complex(this.re - complex.re, this.im - complex.im);
    }

    public Complex mul(Complex complex) {
        return new Complex(this.re * complex.re - this.im * complex.im, this.im * complex.re + this.re * complex.im);
    }

    public Complex div(Complex complex) {
        double d;
        double d2;
        if (Math.abs(complex.re) >= Math.abs(complex.im)) {
            double d3 = complex.im / complex.re;
            double d4 = complex.re + d3 * complex.im;
            d2 = (this.re + d3 * this.im) / d4;
            d = (this.im - d3 * this.re) / d4;
        } else {
            double d5 = complex.re / complex.im;
            double d6 = complex.im + d5 * complex.re;
            d2 = (this.re * d5 + this.im) / d6;
            d = (this.im * d5 - this.re) / d6;
        }
        return new Complex(d2, d);
    }

    public Complex power(double d) {
        double d2 = Math.pow(this.abs(), d);
        boolean bl = false;
        int n = 0;
        if (this.im == 0.0 && this.re < 0.0) {
            bl = true;
            n = 2;
        }
        if (this.re == 0.0 && this.im > 0.0) {
            bl = true;
            n = 1;
        }
        if (this.re == 0.0 && this.im < 0.0) {
            bl = true;
            n = -1;
        }
        if (bl && (double)n * d == (double)((int)((double)n * d))) {
            short[] sArray = new short[]{0, 1, 0, -1};
            short[] sArray2 = new short[]{1, 0, -1, 0};
            int n2 = (int)((double)n * d) % 4;
            if (n2 < 0) {
                n2 = 4 + n2;
            }
            return new Complex(d2 * (double)sArray2[n2], d2 * (double)sArray[n2]);
        }
        double d3 = d * this.arg();
        return new Complex(d2 * Math.cos(d3), d2 * Math.sin(d3));
    }

    public Complex power(Complex complex) {
        if (complex.im == 0.0) {
            return this.power(complex.re);
        }
        double d = Math.log(this.abs());
        double d2 = this.arg();
        double d3 = d * complex.re - d2 * complex.im;
        double d4 = d * complex.im + d2 * complex.re;
        double d5 = Math.exp(d3);
        return new Complex(d5 * Math.cos(d4), d5 * Math.sin(d4));
    }

    public Complex log() {
        return new Complex(Math.log(this.abs()), this.arg());
    }

    public Complex sqrt() {
        Complex complex;
        if (this.re == 0.0 && this.im == 0.0) {
            complex = new Complex(0.0, 0.0);
        } else {
            double d;
            double d2;
            double d3 = Math.abs(this.re);
            if (d3 >= (d2 = Math.abs(this.im))) {
                double d4 = d2 / d3;
                d = Math.sqrt(d3) * Math.sqrt(0.5 * (1.0 + Math.sqrt(1.0 + d4 * d4)));
            } else {
                double d5 = d3 / d2;
                d = Math.sqrt(d2) * Math.sqrt(0.5 * (d5 + Math.sqrt(1.0 + d5 * d5)));
            }
            if (this.re >= 0.0) {
                complex = new Complex(d, this.im / (2.0 * d));
            } else {
                if (this.im < 0.0) {
                    d = -d;
                }
                complex = new Complex(this.im / (2.0 * d), d);
            }
        }
        return complex;
    }

    public Complex sin() {
        double d = -this.im;
        double d2 = this.re;
        double d3 = Math.exp(d);
        double d4 = d3 * Math.cos(d2);
        double d5 = d3 * Math.sin(d2);
        d3 = Math.exp(-d);
        double d6 = d3 * Math.cos(-d2);
        double d7 = d3 * Math.sin(-d2);
        return new Complex(0.5 * (d5 -= d7), -0.5 * (d4 -= d6));
    }

    public Complex cos() {
        double d = -this.im;
        double d2 = this.re;
        double d3 = Math.exp(d);
        double d4 = d3 * Math.cos(d2);
        double d5 = d3 * Math.sin(d2);
        d3 = Math.exp(-d);
        double d6 = d3 * Math.cos(-d2);
        double d7 = d3 * Math.sin(-d2);
        return new Complex(0.5 * (d4 += d6), 0.5 * (d5 += d7));
    }

    public Complex tan() {
        double d = -this.im;
        double d2 = this.re;
        double d3 = Math.exp(d);
        double d4 = d3 * Math.cos(d2);
        double d5 = d3 * Math.sin(d2);
        d3 = Math.exp(-d);
        double d6 = d3 * Math.cos(-d2);
        double d7 = d3 * Math.sin(-d2);
        Complex complex = new Complex(0.5 * (d4 -= d6), 0.5 * (d5 -= d7));
        d = -this.im;
        d2 = this.re;
        d3 = Math.exp(d);
        d4 = d3 * Math.cos(d2);
        d5 = d3 * Math.sin(d2);
        d3 = Math.exp(-d);
        d6 = d3 * Math.cos(-d2);
        d7 = d3 * Math.sin(-d2);
        Complex complex2 = new Complex(0.5 * (d4 += d6), 0.5 * (d5 += d7));
        return complex.div(complex2);
    }

    public Complex asin() {
        double d = 1.0 - (this.re * this.re - this.im * this.im);
        double d2 = 0.0 - (this.re * this.im + this.im * this.re);
        Complex complex = new Complex(d, d2);
        complex = complex.sqrt();
        complex.re += -this.im;
        complex.im += this.re;
        d = Math.log(complex.abs());
        complex.re = d2 = complex.arg();
        complex.im = -d;
        return complex;
    }

    public Complex acos() {
        double d = 1.0 - (this.re * this.re - this.im * this.im);
        double d2 = 0.0 - (this.re * this.im + this.im * this.re);
        Complex complex = new Complex(d, d2);
        complex = complex.sqrt();
        d = -complex.im;
        d2 = complex.re;
        complex.re = this.re + d;
        complex.im = this.im + d2;
        d = Math.log(complex.abs());
        complex.re = d2 = complex.arg();
        complex.im = -d;
        return complex;
    }

    public Complex atan() {
        Complex complex = new Complex(-this.re, 1.0 - this.im);
        double d = this.re;
        double d2 = 1.0 + this.im;
        complex = complex.div(new Complex(d, d2));
        d = Math.log(complex.abs());
        d2 = complex.arg();
        complex.re = 0.5 * d2;
        complex.im = -0.5 * d;
        return complex;
    }

    public Complex sinh() {
        double d = Math.exp(this.re);
        double d2 = d * Math.cos(this.im);
        double d3 = d * Math.sin(this.im);
        d = Math.exp(-this.re);
        double d4 = d * Math.cos(-this.im);
        double d5 = d * Math.sin(-this.im);
        return new Complex(0.5 * (d2 -= d4), 0.5 * (d3 -= d5));
    }

    public Complex cosh() {
        double d = Math.exp(this.re);
        double d2 = d * Math.cos(this.im);
        double d3 = d * Math.sin(this.im);
        d = Math.exp(-this.re);
        double d4 = d * Math.cos(-this.im);
        double d5 = d * Math.sin(-this.im);
        return new Complex(0.5 * (d2 += d4), 0.5 * (d3 += d5));
    }

    public Complex tanh() {
        double d = Math.exp(this.re);
        double d2 = d * Math.cos(this.im);
        double d3 = d * Math.sin(this.im);
        d = Math.exp(-this.re);
        double d4 = d * Math.cos(-this.im);
        double d5 = d * Math.sin(-this.im);
        Complex complex = new Complex(0.5 * (d2 -= d4), 0.5 * (d3 -= d5));
        d = Math.exp(this.re);
        d2 = d * Math.cos(this.im);
        d3 = d * Math.sin(this.im);
        d = Math.exp(-this.re);
        d4 = d * Math.cos(-this.im);
        d5 = d * Math.sin(-this.im);
        Complex complex2 = new Complex(0.5 * (d2 += d4), 0.5 * (d3 += d5));
        return complex.div(complex2);
    }

    public Complex asinh() {
        Complex complex = new Complex(this.re * this.re - this.im * this.im + 1.0, this.re * this.im + this.im * this.re);
        complex = complex.sqrt();
        complex.re += this.re;
        complex.im += this.im;
        double d = complex.arg();
        complex.re = Math.log(complex.abs());
        complex.im = d;
        return complex;
    }

    public Complex acosh() {
        Complex complex = new Complex(this.re * this.re - this.im * this.im - 1.0, this.re * this.im + this.im * this.re);
        complex = complex.sqrt();
        complex.re += this.re;
        complex.im += this.im;
        double d = complex.arg();
        complex.re = Math.log(complex.abs());
        complex.im = d;
        return complex;
    }

    public Complex atanh() {
        Complex complex = new Complex(1.0 + this.re, this.im);
        double d = 1.0 - this.re;
        double d2 = -this.im;
        complex = complex.div(new Complex(d, d2));
        d = Math.log(complex.abs());
        d2 = complex.arg();
        complex.re = 0.5 * d;
        complex.im = 0.5 * d2;
        return complex;
    }

    public static Complex polarValueOf(Number number, Number number2) {
        double d = number.doubleValue();
        double d2 = number2.doubleValue();
        return new Complex(d * Math.cos(d2), d * Math.sin(d2));
    }

    public double doubleValue() {
        return this.re;
    }

    public float floatValue() {
        return (float)this.re;
    }

    public int intValue() {
        return (int)this.re;
    }

    public long longValue() {
        return (long)this.re;
    }
}

