/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl.sun14;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.HashMap;
import org.garret.perst.impl.ReflectionProvider;
import sun.misc.Unsafe;
import sun.reflect.ReflectionFactory;

public class Sun14ReflectionProvider
implements ReflectionProvider {
    private Constructor javaLangObjectConstructor;
    private Unsafe unsafe;
    private ReflectionFactory factory;
    private HashMap constructorHash;
    static final Class[] defaultConstructorProfile = new Class[0];

    public Sun14ReflectionProvider() {
        try {
            Class<?> objectStreamClass = Class.forName("java.io.ObjectStreamClass$FieldReflector");
            Field unsafeField = objectStreamClass.getDeclaredField("unsafe");
            unsafeField.setAccessible(true);
            this.unsafe = (Unsafe)unsafeField.get(null);
            this.javaLangObjectConstructor = Object.class.getDeclaredConstructor(new Class[0]);
            this.factory = ReflectionFactory.getReflectionFactory();
            this.constructorHash = new HashMap();
        }
        catch (Exception x) {
            throw new Error("Failed to initialize reflection provider");
        }
    }

    public Constructor getDefaultConstructor(Class cls) throws Exception {
        Constructor<Object> cons = (Constructor)this.constructorHash.get(cls);
        if (cons == null) {
            try {
                cons = cls.getDeclaredConstructor(defaultConstructorProfile);
            }
            catch (NoSuchMethodException x) {
                cons = this.factory.newConstructorForSerialization(cls, this.javaLangObjectConstructor);
            }
            this.constructorHash.put(cls, cons);
        }
        return cons;
    }

    public void setInt(Field field, Object object, int value) throws Exception {
        this.unsafe.putInt(object, this.unsafe.objectFieldOffset(field), value);
    }

    public void setLong(Field field, Object object, long value) throws Exception {
        this.unsafe.putLong(object, this.unsafe.objectFieldOffset(field), value);
    }

    public void setShort(Field field, Object object, short value) throws Exception {
        this.unsafe.putShort(object, this.unsafe.objectFieldOffset(field), value);
    }

    public void setChar(Field field, Object object, char value) throws Exception {
        this.unsafe.putChar(object, this.unsafe.objectFieldOffset(field), value);
    }

    public void setByte(Field field, Object object, byte value) throws Exception {
        this.unsafe.putByte(object, this.unsafe.objectFieldOffset(field), value);
    }

    public void setFloat(Field field, Object object, float value) throws Exception {
        this.unsafe.putFloat(object, this.unsafe.objectFieldOffset(field), value);
    }

    public void setDouble(Field field, Object object, double value) throws Exception {
        this.unsafe.putDouble(object, this.unsafe.objectFieldOffset(field), value);
    }

    public void setBoolean(Field field, Object object, boolean value) throws Exception {
        this.unsafe.putBoolean(object, this.unsafe.objectFieldOffset(field), value);
    }

    public void set(Field field, Object object, Object value) throws Exception {
        this.unsafe.putObject(object, this.unsafe.objectFieldOffset(field), value);
    }
}

