/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.lang.reflect.Array;
import org.garret.perst.impl.FilterIterator;
import org.garret.perst.impl.Node;

class UnaryOpNode
extends Node {
    Node opd;

    public boolean equals(Object o) {
        return o instanceof UnaryOpNode && super.equals(o) && ((UnaryOpNode)o).opd.equals(this.opd);
    }

    Object evaluateObj(FilterIterator t) {
        Object val = this.opd.evaluateObj(t);
        switch (this.tag) {
            case 127: {
                return val instanceof Double || val instanceof Float ? (Number)new Double(-((Number)val).doubleValue()) : (Number)new Long(-((Number)val).longValue());
            }
            case 129: {
                if (val instanceof Double || val instanceof Float) {
                    double rval = ((Number)val).doubleValue();
                    return new Double(rval < 0.0 ? -rval : rval);
                }
                long ival = ((Number)val).longValue();
                return new Long(ival < 0L ? -ival : ival);
            }
            case 128: {
                return val instanceof Boolean ? (Comparable<Boolean>)(((Boolean)val).booleanValue() ? Boolean.FALSE : Boolean.TRUE) : (Comparable<Boolean>)new Long(((Number)val).longValue() ^ 0xFFFFFFFFFFFFFFFFL);
            }
        }
        throw new Error("Invalid tag " + this.tag);
    }

    long evaluateInt(FilterIterator t) {
        switch (this.tag) {
            case 8: {
                return this.opd.evaluateInt(t) ^ 0xFFFFFFFFFFFFFFFFL;
            }
            case 7: {
                return -this.opd.evaluateInt(t);
            }
            case 9: {
                long val = this.opd.evaluateInt(t);
                return val < 0L ? -val : val;
            }
            case 46: {
                return (long)this.opd.evaluateReal(t);
            }
            case 138: {
                Object obj = this.opd.evaluateObj(t);
                if (obj instanceof String) {
                    return ((String)obj).length();
                }
                try {
                    return Array.getLength(obj);
                }
                catch (IllegalArgumentException x) {
                    throw new Error("Argument is not array");
                }
            }
            case 61: {
                try {
                    return Array.getLength(this.opd.evaluateObj(t));
                }
                catch (IllegalArgumentException x) {
                    throw new Error("Argument is not array");
                }
            }
            case 100: {
                return this.opd.evaluateStr(t).length();
            }
        }
        throw new Error("Invalid tag " + this.tag);
    }

    double evaluateReal(FilterIterator t) {
        switch (this.tag) {
            case 42: {
                return -this.opd.evaluateReal(t);
            }
            case 43: {
                double val = this.opd.evaluateReal(t);
                return val < 0.0 ? -val : val;
            }
            case 83: {
                return Math.sin(this.opd.evaluateReal(t));
            }
            case 84: {
                return Math.cos(this.opd.evaluateReal(t));
            }
            case 85: {
                return Math.tan(this.opd.evaluateReal(t));
            }
            case 86: {
                return Math.asin(this.opd.evaluateReal(t));
            }
            case 87: {
                return Math.acos(this.opd.evaluateReal(t));
            }
            case 88: {
                return Math.atan(this.opd.evaluateReal(t));
            }
            case 90: {
                return Math.exp(this.opd.evaluateReal(t));
            }
            case 91: {
                return Math.log(this.opd.evaluateReal(t));
            }
            case 89: {
                return Math.sqrt(this.opd.evaluateReal(t));
            }
            case 92: {
                return Math.ceil(this.opd.evaluateReal(t));
            }
            case 93: {
                return Math.floor(this.opd.evaluateReal(t));
            }
            case 45: {
                return this.opd.evaluateInt(t);
            }
        }
        throw new Error("Invalid tag " + this.tag);
    }

    String evaluateStr(FilterIterator t) {
        switch (this.tag) {
            case 98: {
                return this.opd.evaluateStr(t).toUpperCase();
            }
            case 97: {
                return this.opd.evaluateStr(t).toLowerCase();
            }
            case 47: {
                return Long.toString(this.opd.evaluateInt(t), 10);
            }
            case 48: {
                return Double.toString(this.opd.evaluateReal(t));
            }
            case 140: {
                return this.opd.evaluateObj(t).toString();
            }
        }
        throw new Error("Invalid tag " + this.tag);
    }

    boolean evaluateBool(FilterIterator t) {
        switch (this.tag) {
            case 96: {
                return !this.opd.evaluateBool(t);
            }
            case 49: {
                return this.opd.evaluateObj(t) == null;
            }
        }
        throw new Error("Invalid tag " + this.tag);
    }

    UnaryOpNode(int type, int tag, Node node) {
        super(type, tag);
        this.opd = node;
    }
}

