/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.util.ArrayList;
import org.garret.perst.IPersistent;
import org.garret.perst.Persistent;
import org.garret.perst.PersistentComparator;

public class TtreePage
extends Persistent {
    static final int maxItems = 1017;
    static final int minItems = 1015;
    TtreePage left;
    TtreePage right;
    int balance;
    int nItems;
    IPersistent[] item;
    static final int OK = 0;
    static final int NOT_UNIQUE = 1;
    static final int NOT_FOUND = 2;
    static final int OVERFLOW = 3;
    static final int UNDERFLOW = 4;

    public boolean recursiveLoading() {
        return false;
    }

    TtreePage() {
    }

    TtreePage(IPersistent mbr) {
        this.nItems = 1;
        this.item = new IPersistent[1017];
        this.item[0] = mbr;
    }

    final IPersistent loadItem(int i) {
        IPersistent mbr = this.item[i];
        mbr.load();
        return mbr;
    }

    final boolean find(PersistentComparator comparator, Object minValue, int minInclusive, Object maxValue, int maxInclusive, ArrayList selection) {
        this.load();
        int n = this.nItems;
        if (minValue != null && -comparator.compareMemberWithKey(this.loadItem(0), minValue) >= minInclusive) {
            if (-comparator.compareMemberWithKey(this.loadItem(n - 1), minValue) >= minInclusive) {
                if (this.right != null) {
                    return this.right.find(comparator, minValue, minInclusive, maxValue, maxInclusive, selection);
                }
                return true;
            }
            int l = 0;
            int r = n;
            while (l < r) {
                int m = l + r >> 1;
                if (-comparator.compareMemberWithKey(this.loadItem(m), minValue) >= minInclusive) {
                    l = m + 1;
                    continue;
                }
                r = m;
            }
            while (r < n) {
                if (maxValue != null && comparator.compareMemberWithKey(this.loadItem(r), maxValue) >= maxInclusive) {
                    return false;
                }
                selection.add(this.loadItem(r));
                ++r;
            }
            if (this.right != null) {
                return this.right.find(comparator, minValue, minInclusive, maxValue, maxInclusive, selection);
            }
            return true;
        }
        if (this.left != null && !this.left.find(comparator, minValue, minInclusive, maxValue, maxInclusive, selection)) {
            return false;
        }
        for (int l = 0; l < n; ++l) {
            if (maxValue != null && comparator.compareMemberWithKey(this.loadItem(l), maxValue) >= maxInclusive) {
                return false;
            }
            selection.add(this.loadItem(l));
        }
        if (this.right != null) {
            return this.right.find(comparator, minValue, minInclusive, maxValue, maxInclusive, selection);
        }
        return true;
    }

    final boolean contains(PersistentComparator comparator, IPersistent mbr) {
        this.load();
        int n = this.nItems;
        if (comparator.compareMembers(this.loadItem(0), mbr) < 0) {
            if (comparator.compareMembers(this.loadItem(n - 1), mbr) < 0) {
                if (this.right != null) {
                    return this.right.contains(comparator, mbr);
                }
                return false;
            }
            int l = 0;
            int r = n;
            while (l < r) {
                int m = l + r >> 1;
                if (comparator.compareMembers(this.loadItem(m), mbr) < 0) {
                    l = m + 1;
                    continue;
                }
                r = m;
            }
            while (r < n) {
                if (mbr == this.loadItem(r)) {
                    return true;
                }
                if (comparator.compareMembers(this.item[r], mbr) > 0) {
                    return false;
                }
                ++r;
            }
            if (this.right != null) {
                return this.right.contains(comparator, mbr);
            }
            return false;
        }
        if (this.left != null && this.left.contains(comparator, mbr)) {
            return true;
        }
        for (int l = 0; l < n; ++l) {
            if (mbr == this.loadItem(l)) {
                return true;
            }
            if (comparator.compareMembers(this.item[l], mbr) <= 0) continue;
            return false;
        }
        if (this.right != null) {
            return this.right.contains(comparator, mbr);
        }
        return false;
    }

    final int insert(PersistentComparator comparator, IPersistent mbr, boolean unique, PageReference ref) {
        IPersistent reinsertItem;
        this.load();
        int n = this.nItems;
        int diff = comparator.compareMembers(mbr, this.loadItem(0));
        if (diff <= 0) {
            if (unique && diff == 0) {
                return 1;
            }
            if ((this.left == null || diff == 0) && n != 1017) {
                this.modify();
                System.arraycopy(this.item, 0, this.item, 1, n);
                this.item[0] = mbr;
                ++this.nItems;
                return 0;
            }
            if (this.left == null) {
                this.modify();
                this.left = new TtreePage(mbr);
            } else {
                TtreePage pg = ref.pg;
                ref.pg = this.left;
                int result = this.left.insert(comparator, mbr, unique, ref);
                if (result == 1) {
                    return 1;
                }
                this.modify();
                this.left = ref.pg;
                ref.pg = pg;
                if (result == 0) {
                    return 0;
                }
            }
            if (this.balance > 0) {
                this.balance = 0;
                return 0;
            }
            if (this.balance == 0) {
                this.balance = -1;
                return 3;
            }
            TtreePage left = this.left;
            left.load();
            left.modify();
            if (left.balance < 0) {
                this.left = left.right;
                left.right = this;
                this.balance = 0;
                left.balance = 0;
                ref.pg = left;
            } else {
                TtreePage right = left.right;
                right.load();
                right.modify();
                left.right = right.left;
                right.left = left;
                this.left = right.right;
                right.right = this;
                this.balance = right.balance < 0 ? 1 : 0;
                left.balance = right.balance > 0 ? -1 : 0;
                right.balance = 0;
                ref.pg = right;
            }
            return 0;
        }
        diff = comparator.compareMembers(mbr, this.loadItem(n - 1));
        if (diff >= 0) {
            if (unique && diff == 0) {
                return 1;
            }
            if ((this.right == null || diff == 0) && n != 1017) {
                this.modify();
                this.item[n] = mbr;
                ++this.nItems;
                return 0;
            }
            if (this.right == null) {
                this.modify();
                this.right = new TtreePage(mbr);
            } else {
                TtreePage pg = ref.pg;
                ref.pg = this.right;
                int result = this.right.insert(comparator, mbr, unique, ref);
                if (result == 1) {
                    return 1;
                }
                this.modify();
                this.right = ref.pg;
                ref.pg = pg;
                if (result == 0) {
                    return 0;
                }
            }
            if (this.balance < 0) {
                this.balance = 0;
                return 0;
            }
            if (this.balance == 0) {
                this.balance = 1;
                return 3;
            }
            TtreePage right = this.right;
            right.load();
            right.modify();
            if (right.balance > 0) {
                this.right = right.left;
                right.left = this;
                this.balance = 0;
                right.balance = 0;
                ref.pg = right;
            } else {
                TtreePage left = right.left;
                left.load();
                left.modify();
                right.left = left.right;
                left.right = right;
                this.right = left.left;
                left.left = this;
                this.balance = left.balance > 0 ? -1 : 0;
                right.balance = left.balance < 0 ? 1 : 0;
                left.balance = 0;
                ref.pg = left;
            }
            return 0;
        }
        int l = 1;
        int r = n - 1;
        while (l < r) {
            int i = l + r >> 1;
            diff = comparator.compareMembers(mbr, this.loadItem(i));
            if (diff > 0) {
                l = i + 1;
                continue;
            }
            r = i;
            if (diff != 0) continue;
            if (!unique) break;
            return 1;
        }
        this.modify();
        if (n != 1017) {
            System.arraycopy(this.item, r, this.item, r + 1, n - r);
            this.item[r] = mbr;
            ++this.nItems;
            return 0;
        }
        if (this.balance >= 0) {
            reinsertItem = this.loadItem(0);
            System.arraycopy(this.item, 1, this.item, 0, r - 1);
            this.item[r - 1] = mbr;
        } else {
            reinsertItem = this.loadItem(n - 1);
            System.arraycopy(this.item, r, this.item, r + 1, n - r - 1);
            this.item[r] = mbr;
        }
        return this.insert(comparator, reinsertItem, unique, ref);
    }

    final int balanceLeftBranch(PageReference ref) {
        if (this.balance < 0) {
            this.balance = 0;
            return 4;
        }
        if (this.balance == 0) {
            this.balance = 1;
            return 0;
        }
        TtreePage right = this.right;
        right.load();
        right.modify();
        if (right.balance >= 0) {
            this.right = right.left;
            right.left = this;
            if (right.balance == 0) {
                this.balance = 1;
                right.balance = -1;
                ref.pg = right;
                return 0;
            }
            this.balance = 0;
            right.balance = 0;
            ref.pg = right;
            return 4;
        }
        TtreePage left = right.left;
        left.load();
        left.modify();
        right.left = left.right;
        left.right = right;
        this.right = left.left;
        left.left = this;
        this.balance = left.balance > 0 ? -1 : 0;
        right.balance = left.balance < 0 ? 1 : 0;
        left.balance = 0;
        ref.pg = left;
        return 4;
    }

    final int balanceRightBranch(PageReference ref) {
        if (this.balance > 0) {
            this.balance = 0;
            return 4;
        }
        if (this.balance == 0) {
            this.balance = -1;
            return 0;
        }
        TtreePage left = this.left;
        left.load();
        left.modify();
        if (left.balance <= 0) {
            this.left = left.right;
            left.right = this;
            if (left.balance == 0) {
                this.balance = -1;
                left.balance = 1;
                ref.pg = left;
                return 0;
            }
            this.balance = 0;
            left.balance = 0;
            ref.pg = left;
            return 4;
        }
        TtreePage right = left.right;
        right.load();
        right.modify();
        left.right = right.left;
        right.left = left;
        this.left = right.right;
        right.right = this;
        this.balance = right.balance < 0 ? 1 : 0;
        left.balance = right.balance > 0 ? -1 : 0;
        right.balance = 0;
        ref.pg = right;
        return 4;
    }

    final int remove(PersistentComparator comparator, IPersistent mbr, PageReference ref) {
        int h;
        TtreePage pg;
        this.load();
        int n = this.nItems;
        int diff = comparator.compareMembers(mbr, this.loadItem(0));
        if (diff <= 0 && this.left != null) {
            this.modify();
            pg = ref.pg;
            ref.pg = this.left;
            h = this.left.remove(comparator, mbr, ref);
            this.left = ref.pg;
            ref.pg = pg;
            if (h == 4) {
                return this.balanceLeftBranch(ref);
            }
            if (h == 0) {
                return 0;
            }
        }
        if ((diff = comparator.compareMembers(mbr, this.loadItem(n - 1))) <= 0) {
            for (int i = 0; i < n; ++i) {
                if (this.item[i] != mbr) continue;
                if (n == 1) {
                    if (this.right == null) {
                        this.deallocate();
                        ref.pg = this.left;
                        return 4;
                    }
                    if (this.left == null) {
                        this.deallocate();
                        ref.pg = this.right;
                        return 4;
                    }
                }
                this.modify();
                if (n <= 1015) {
                    if (this.left != null && this.balance <= 0) {
                        TtreePage prev = this.left;
                        prev.load();
                        while (prev.right != null) {
                            prev = prev.right;
                            prev.load();
                        }
                        System.arraycopy(this.item, 0, this.item, 1, i);
                        this.item[0] = prev.item[prev.nItems - 1];
                        pg = ref.pg;
                        ref.pg = this.left;
                        int h2 = this.left.remove(comparator, this.loadItem(0), ref);
                        this.left = ref.pg;
                        ref.pg = pg;
                        if (h2 == 4) {
                            h2 = this.balanceLeftBranch(ref);
                        }
                        return h2;
                    }
                    if (this.right != null) {
                        TtreePage next = this.right;
                        next.load();
                        while (next.left != null) {
                            next = next.left;
                            next.load();
                        }
                        System.arraycopy(this.item, i + 1, this.item, i, n - i - 1);
                        this.item[n - 1] = next.item[0];
                        pg = ref.pg;
                        ref.pg = this.right;
                        int h3 = this.right.remove(comparator, this.loadItem(n - 1), ref);
                        this.right = ref.pg;
                        ref.pg = pg;
                        if (h3 == 4) {
                            h3 = this.balanceRightBranch(ref);
                        }
                        return h3;
                    }
                }
                System.arraycopy(this.item, i + 1, this.item, i, n - i - 1);
                this.item[n - 1] = null;
                --this.nItems;
                return 0;
            }
        }
        if (this.right != null) {
            this.modify();
            pg = ref.pg;
            ref.pg = this.right;
            h = this.right.remove(comparator, mbr, ref);
            this.right = ref.pg;
            ref.pg = pg;
            if (h == 4) {
                return this.balanceRightBranch(ref);
            }
            return h;
        }
        return 2;
    }

    final int toArray(IPersistent[] arr, int index) {
        this.load();
        if (this.left != null) {
            index = this.left.toArray(arr, index);
        }
        int n = this.nItems;
        for (int i = 0; i < n; ++i) {
            arr[index++] = this.loadItem(i);
        }
        if (this.right != null) {
            index = this.right.toArray(arr, index);
        }
        return index;
    }

    final void prune() {
        this.load();
        if (this.left != null) {
            this.left.prune();
        }
        if (this.right != null) {
            this.right.prune();
        }
        this.deallocate();
    }

    static class PageReference {
        TtreePage pg;

        PageReference(TtreePage p) {
            this.pg = p;
        }
    }
}

