/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import org.garret.perst.IPersistent;
import org.garret.perst.impl.OidHashTable;

public class StrongHashTable
implements OidHashTable {
    Entry[] table;
    static final float loadFactor = 0.75f;
    int count;
    int threshold;

    public StrongHashTable(int initialCapacity) {
        this.threshold = (int)((float)initialCapacity * 0.75f);
        if (initialCapacity != 0) {
            this.table = new Entry[initialCapacity];
        }
    }

    public synchronized boolean remove(int oid) {
        Entry[] tab = this.table;
        int index = (oid & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        Entry prev = null;
        while (e != null) {
            if (e.oid == oid) {
                e.obj = null;
                --this.count;
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                return true;
            }
            prev = e;
            e = e.next;
        }
        return false;
    }

    public synchronized void put(int oid, IPersistent obj) {
        Entry[] tab = this.table;
        int index = (oid & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.oid == oid) {
                e.obj = obj;
                return;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (oid & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = new Entry(oid, obj, tab[index]);
        ++this.count;
    }

    public synchronized IPersistent get(int oid) {
        Entry[] tab = this.table;
        int index = (oid & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.oid == oid) {
                return e.obj;
            }
            e = e.next;
        }
        return null;
    }

    void rehash() {
        int oldCapacity = this.table.length;
        Entry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        this.threshold = (int)((float)newCapacity * 0.75f);
        this.table = newMap;
        int i = oldCapacity;
        while (--i >= 0) {
            Entry old = oldMap[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index = (e.oid & Integer.MAX_VALUE) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public synchronized void flush() {
        for (int i = 0; i < this.table.length; ++i) {
            Entry e = this.table[i];
            while (e != null) {
                if (e.obj.isModified()) {
                    e.obj.store();
                }
                e = e.next;
            }
        }
    }

    public synchronized void invalidate() {
        for (int i = 0; i < this.table.length; ++i) {
            Entry e = this.table[i];
            while (e != null) {
                if (e.obj.isModified()) {
                    e.obj.invalidate();
                }
                e = e.next;
            }
            this.table[i] = null;
        }
        this.count = 0;
    }

    public void setDirty(int oid) {
    }

    public void clearDirty(int oid) {
    }

    public int size() {
        return this.count;
    }

    public void preprocess() {
    }

    static class Entry {
        Entry next;
        IPersistent obj;
        int oid;

        Entry(int oid, IPersistent obj, Entry chain) {
            this.next = chain;
            this.oid = oid;
            this.obj = obj;
        }
    }
}

