/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.util.ArrayList;
import org.garret.perst.Assert;
import org.garret.perst.IPersistent;
import org.garret.perst.Link;
import org.garret.perst.Persistent;
import org.garret.perst.Rectangle;
import org.garret.perst.Storage;

public class RtreePage
extends Persistent {
    static final int card = 203;
    static final int minFill = 101;
    int n;
    Rectangle[] b;
    Link branch;

    RtreePage(Storage storage, IPersistent obj, Rectangle r) {
        this.branch = storage.createLink(203);
        this.branch.setSize(203);
        this.b = new Rectangle[203];
        this.setBranch(0, new Rectangle(r), obj);
        this.n = 1;
        for (int i = 1; i < 203; ++i) {
            this.b[i] = new Rectangle();
        }
    }

    RtreePage(Storage storage, RtreePage root, RtreePage p) {
        this.branch = storage.createLink(203);
        this.branch.setSize(203);
        this.b = new Rectangle[203];
        this.n = 2;
        this.setBranch(0, root.cover(), root);
        this.setBranch(1, p.cover(), p);
        for (int i = 2; i < 203; ++i) {
            this.b[i] = new Rectangle();
        }
    }

    RtreePage() {
    }

    RtreePage insert(Storage storage, Rectangle r, IPersistent obj, int level) {
        this.modify();
        if (--level != 0) {
            int mini = 0;
            long minIncr = Long.MAX_VALUE;
            long minArea = Long.MAX_VALUE;
            for (int i = 0; i < this.n; ++i) {
                long area = this.b[i].area();
                long incr = Rectangle.joinArea(this.b[i], r) - area;
                if (incr < minIncr) {
                    minIncr = incr;
                    minArea = area;
                    mini = i;
                    continue;
                }
                if (incr != minIncr || area >= minArea) continue;
                minArea = area;
                mini = i;
            }
            RtreePage p = (RtreePage)this.branch.get(mini);
            RtreePage q = p.insert(storage, r, obj, level);
            if (q == null) {
                this.b[mini].join(r);
                return null;
            }
            this.setBranch(mini, p.cover(), p);
            return this.addBranch(storage, q.cover(), q);
        }
        return this.addBranch(storage, new Rectangle(r), obj);
    }

    int remove(Rectangle r, IPersistent obj, int level, ArrayList reinsertList) {
        if (--level != 0) {
            for (int i = 0; i < this.n; ++i) {
                RtreePage pg;
                int reinsertLevel;
                if (!r.intersects(this.b[i]) || (reinsertLevel = (pg = (RtreePage)this.branch.get(i)).remove(r, obj, level, reinsertList)) < 0) continue;
                if (pg.n >= 101) {
                    this.setBranch(i, pg.cover(), pg);
                    this.modify();
                } else {
                    reinsertList.add(pg);
                    reinsertLevel = level - 1;
                    this.removeBranch(i);
                }
                return reinsertLevel;
            }
        } else {
            for (int i = 0; i < this.n; ++i) {
                if (!this.branch.containsElement(i, obj)) continue;
                this.removeBranch(i);
                return 0;
            }
        }
        return -1;
    }

    void find(Rectangle r, ArrayList result, int level) {
        if (--level != 0) {
            for (int i = 0; i < this.n; ++i) {
                if (!r.intersects(this.b[i])) continue;
                ((RtreePage)this.branch.get(i)).find(r, result, level);
            }
        } else {
            for (int i = 0; i < this.n; ++i) {
                if (!r.intersects(this.b[i])) continue;
                result.add(this.branch.get(i));
            }
        }
    }

    void purge(int level) {
        if (--level != 0) {
            for (int i = 0; i < this.n; ++i) {
                ((RtreePage)this.branch.get(i)).purge(level);
            }
        }
        this.deallocate();
    }

    final void setBranch(int i, Rectangle r, IPersistent obj) {
        this.b[i] = r;
        this.branch.set(i, obj);
    }

    final void removeBranch(int i) {
        --this.n;
        System.arraycopy(this.b, i + 1, this.b, i, this.n - i);
        this.branch.remove(i);
        this.branch.setSize(203);
        this.modify();
    }

    final RtreePage addBranch(Storage storage, Rectangle r, IPersistent obj) {
        if (this.n < 203) {
            this.setBranch(this.n++, r, obj);
            return null;
        }
        return this.splitPage(storage, r, obj);
    }

    final RtreePage splitPage(Storage storage, Rectangle r, IPersistent obj) {
        RtreePage pg;
        Rectangle group0;
        int j;
        int i;
        int seed0 = 0;
        int seed1 = 0;
        long[] rectArea = new long[204];
        long worstWaste = Long.MIN_VALUE;
        rectArea[0] = r.area();
        for (i = 0; i < 203; ++i) {
            rectArea[i + 1] = this.b[i].area();
        }
        Rectangle bp = r;
        for (i = 0; i < 203; ++i) {
            for (j = i + 1; j <= 203; ++j) {
                long waste = Rectangle.joinArea(bp, this.b[j - 1]) - rectArea[i] - rectArea[j];
                if (waste <= worstWaste) continue;
                worstWaste = waste;
                seed0 = i;
                seed1 = j;
            }
            bp = this.b[i];
        }
        byte[] taken = new byte[203];
        taken[seed1 - 1] = 2;
        Rectangle group1 = new Rectangle(this.b[seed1 - 1]);
        if (seed0 == 0) {
            group0 = new Rectangle(r);
            pg = new RtreePage(storage, obj, r);
        } else {
            group0 = new Rectangle(this.b[seed0 - 1]);
            pg = new RtreePage(storage, this.branch.getRaw(seed0 - 1), group0);
            this.setBranch(seed0 - 1, r, obj);
        }
        int groupCard1 = 1;
        int groupCard0 = 1;
        long groupArea0 = rectArea[seed0];
        long groupArea1 = rectArea[seed1];
        while (groupCard0 + groupCard1 < 204 && groupCard0 < 103 && groupCard1 < 103) {
            int betterGroup = -1;
            int chosen = -1;
            long biggestDiff = -1L;
            for (i = 0; i < 203; ++i) {
                long diff;
                if (taken[i] != 0 || (diff = Rectangle.joinArea(group0, this.b[i]) - groupArea0 - (Rectangle.joinArea(group1, this.b[i]) - groupArea1)) <= biggestDiff && -diff <= biggestDiff) continue;
                chosen = i;
                if (diff < 0L) {
                    betterGroup = 0;
                    biggestDiff = -diff;
                    continue;
                }
                betterGroup = 1;
                biggestDiff = diff;
            }
            Assert.that(chosen >= 0);
            if (betterGroup == 0) {
                group0.join(this.b[chosen]);
                groupArea0 = group0.area();
                taken[chosen] = 1;
                pg.setBranch(groupCard0++, this.b[chosen], this.branch.getRaw(chosen));
                continue;
            }
            ++groupCard1;
            group1.join(this.b[chosen]);
            groupArea1 = group1.area();
            taken[chosen] = 2;
        }
        if (groupCard0 + groupCard1 < 204) {
            for (i = 0; i < 203; ++i) {
                if (taken[i] != 0) continue;
                if (groupCard0 >= groupCard1) {
                    taken[i] = 2;
                    ++groupCard1;
                    continue;
                }
                taken[i] = 1;
                pg.setBranch(groupCard0++, this.b[i], this.branch.getRaw(i));
            }
        }
        pg.n = groupCard0;
        this.n = groupCard1;
        i = 0;
        j = 0;
        while (i < groupCard1) {
            if (taken[j] == 2) {
                this.setBranch(i++, this.b[j], this.branch.getRaw(j));
            }
            ++j;
        }
        return pg;
    }

    final Rectangle cover() {
        Rectangle r = new Rectangle(this.b[0]);
        for (int i = 1; i < this.n; ++i) {
            r.join(this.b[i]);
        }
        return r;
    }
}

