/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.garret.perst.IFile;
import org.garret.perst.impl.Bytes;
import org.garret.perst.impl.ReplicationMasterStorageImpl;

public class ReplicationMasterFile
implements IFile {
    public static int LINGER_TIME = 10;
    public static int MAX_CONNECT_ATTEMPTS = 10;
    public static int CONNECTION_TIMEOUT = 1000;
    OutputStream[] out;
    InputStream[] in;
    Socket[] sockets;
    byte[] txBuf;
    byte[] rcBuf;
    IFile file;
    String[] hosts;
    int nHosts;
    boolean ack;
    ReplicationMasterStorageImpl storage;

    public ReplicationMasterFile(ReplicationMasterStorageImpl storage, IFile file) {
        this(storage, file, storage.hosts, storage.replicationAck);
    }

    public ReplicationMasterFile(IFile file, String[] hosts, boolean ack) {
        this(null, file, hosts, ack);
    }

    private ReplicationMasterFile(ReplicationMasterStorageImpl storage, IFile file, String[] hosts, boolean ack) {
        this.storage = storage;
        this.file = file;
        this.hosts = hosts;
        this.ack = ack;
        this.sockets = new Socket[hosts.length];
        this.out = new OutputStream[hosts.length];
        if (ack) {
            this.in = new InputStream[hosts.length];
            this.rcBuf = new byte[1];
        }
        this.txBuf = new byte[4104];
        this.nHosts = 0;
        for (int i = 0; i < hosts.length; ++i) {
            this.connect(i);
        }
    }

    public int getNumberOfAvailableHosts() {
        return this.nHosts;
    }

    protected void connect(int i) {
        String host = this.hosts[i];
        int colon = host.indexOf(58);
        int port = Integer.parseInt(host.substring(colon + 1));
        host = host.substring(0, colon);
        Socket socket = null;
        try {
            int maxAttempts = this.storage != null ? this.storage.slaveConnectionTimeout : MAX_CONNECT_ATTEMPTS;
            for (int j = 0; j < maxAttempts; ++j) {
                try {
                    socket = new Socket(InetAddress.getByName(host), port);
                    if (socket == null) {
                        Thread.sleep(CONNECTION_TIMEOUT);
                        continue;
                    }
                    break;
                }
                catch (IOException x) {
                    // empty catch block
                }
            }
        }
        catch (InterruptedException x) {
            // empty catch block
        }
        if (socket != null) {
            try {
                try {
                    socket.setSoLinger(true, LINGER_TIME);
                }
                catch (NoSuchMethodError er) {
                    // empty catch block
                }
                try {
                    socket.setTcpNoDelay(true);
                }
                catch (Exception x) {
                    // empty catch block
                }
                this.sockets[i] = socket;
                this.out[i] = socket.getOutputStream();
                if (this.ack) {
                    this.in[i] = socket.getInputStream();
                }
                ++this.nHosts;
            }
            catch (IOException x) {
                this.handleError(this.hosts[i]);
                this.sockets[i] = null;
                this.out[i] = null;
            }
        }
    }

    public boolean handleError(String host) {
        System.err.println("Failed to establish connection with host " + host);
        return this.storage != null && this.storage.listener != null ? this.storage.listener.replicationError(host) : false;
    }

    public void write(long pos, byte[] buf) {
        block2: for (int i = 0; i < this.out.length; ++i) {
            while (this.out[i] != null) {
                try {
                    Bytes.pack8(this.txBuf, 0, pos);
                    System.arraycopy(buf, 0, this.txBuf, 8, buf.length);
                    this.out[i].write(this.txBuf);
                    if (!this.ack || pos != 0L || this.in[i].read(this.rcBuf) == 1) {
                        continue block2;
                    }
                }
                catch (IOException x) {
                    // empty catch block
                }
                this.out[i] = null;
                this.sockets[i] = null;
                --this.nHosts;
                if (!this.handleError(this.hosts[i])) continue block2;
                this.connect(i);
            }
        }
        this.file.write(pos, buf);
    }

    public int read(long pos, byte[] buf) {
        return this.file.read(pos, buf);
    }

    public void sync() {
        this.file.sync();
    }

    public boolean lock() {
        return this.file.lock();
    }

    public void close() {
        this.file.close();
        Bytes.pack8(this.txBuf, 0, -1L);
        for (int i = 0; i < this.out.length; ++i) {
            if (this.sockets[i] == null) continue;
            try {
                this.out[i].write(this.txBuf);
                this.out[i].close();
                if (this.in != null) {
                    this.in[i].close();
                }
                this.sockets[i].close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public long length() {
        return this.file.length();
    }
}

