/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.garret.perst.JSQLNoSuchFieldException;
import org.garret.perst.impl.ClassDescriptor;
import org.garret.perst.impl.QueryImpl;

class OrderNode {
    OrderNode next;
    boolean ascent;
    Field field;
    Method method;
    String fieldName;
    int type;

    final int compare(Object a, Object b) {
        int diff;
        try {
            if (this.method != null) {
                diff = ((Comparable)this.method.invoke(a, null)).compareTo(this.method.invoke(b, null));
            } else {
                switch (this.type) {
                    case 0: {
                        diff = this.field.getBoolean(a) ? (this.field.getBoolean(b) ? 0 : 1) : (this.field.getBoolean(b) ? -1 : 0);
                        break;
                    }
                    case 2: {
                        diff = this.field.getChar(a) - this.field.getChar(b);
                        break;
                    }
                    case 1: {
                        diff = this.field.getByte(a) - this.field.getByte(b);
                        break;
                    }
                    case 3: {
                        diff = this.field.getShort(a) - this.field.getShort(b);
                        break;
                    }
                    case 4: {
                        int l = this.field.getInt(a);
                        int r = this.field.getInt(b);
                        diff = l < r ? -1 : (l == r ? 0 : 1);
                        break;
                    }
                    case 5: {
                        long l = this.field.getLong(a);
                        long r = this.field.getLong(b);
                        diff = l < r ? -1 : (l == r ? 0 : 1);
                        break;
                    }
                    case 6: {
                        float l = this.field.getFloat(a);
                        float r = this.field.getFloat(b);
                        diff = l < r ? -1 : (l == r ? 0 : 1);
                        break;
                    }
                    case 7: {
                        double l = this.field.getDouble(a);
                        double r = this.field.getDouble(b);
                        diff = l < r ? -1 : (l == r ? 0 : 1);
                        break;
                    }
                    case 10: {
                        diff = ((Comparable)this.field.get(a)).compareTo(this.field.get(b));
                        break;
                    }
                    default: {
                        throw new Error("Invalid order by type tag: " + this.type);
                    }
                }
            }
        }
        catch (IllegalAccessException x) {
            x.printStackTrace();
            throw new IllegalAccessError();
        }
        catch (InvocationTargetException x) {
            x.printStackTrace();
            throw new IllegalAccessError();
        }
        if (diff == 0 && this.next != null) {
            return this.next.compare(a, b);
        }
        if (!this.ascent) {
            diff = -diff;
        }
        return diff;
    }

    void resolveName(Class cls) {
        this.field = ClassDescriptor.locateField(cls, this.fieldName);
        if (this.field == null) {
            this.method = QueryImpl.lookupMethod(cls, this.fieldName, QueryImpl.defaultProfile);
            if (this.method == null) {
                throw new JSQLNoSuchFieldException(cls, this.fieldName);
            }
        }
    }

    OrderNode(int type, Field field) {
        this.type = type;
        this.field = field;
        this.ascent = true;
    }

    OrderNode(Method method) {
        this.method = method;
        this.ascent = true;
    }

    OrderNode(String name) {
        this.fieldName = name;
        this.ascent = true;
    }
}

