/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import org.garret.perst.IFile;
import org.garret.perst.StorageError;

public class OSFile
implements IFile {
    static final long MAX_FILE_SIZE = 0x7FFFFFFFFFFFFFFDL;
    protected RandomAccessFile file;
    protected boolean noFlush;

    public void write(long pos, byte[] buf) {
        try {
            this.file.seek(pos);
            this.file.write(buf, 0, buf.length);
        }
        catch (IOException x) {
            throw new StorageError(3, x);
        }
    }

    public int read(long pos, byte[] buf) {
        try {
            this.file.seek(pos);
            return this.file.read(buf, 0, buf.length);
        }
        catch (IOException x) {
            throw new StorageError(3, x);
        }
    }

    public void sync() {
        if (!this.noFlush) {
            try {
                this.file.getFD().sync();
            }
            catch (IOException x) {
                throw new StorageError(3, x);
            }
        }
    }

    public void close() {
        try {
            this.file.close();
        }
        catch (IOException x) {
            throw new StorageError(3, x);
        }
    }

    public boolean lock() {
        return OSFile.lockFile(this.file);
    }

    public static boolean lockFile(RandomAccessFile file) {
        try {
            Class[] paramType;
            Method lock;
            Object channel;
            Class<?> cls = file.getClass();
            Method getChannel = cls.getMethod("getChannel", new Class[0]);
            if (getChannel != null && (channel = getChannel.invoke((Object)file, new Object[0])) != null && (lock = (cls = channel.getClass()).getMethod("tryLock", paramType = new Class[]{Long.TYPE, Long.TYPE, Boolean.TYPE})) != null) {
                Object[] param = new Object[]{new Long(0x7FFFFFFFFFFFFFFDL), new Long(1L), new Boolean(false)};
                return lock.invoke(channel, param) != null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public OSFile(String filePath, boolean readOnly, boolean noFlush) {
        this.noFlush = noFlush;
        try {
            this.file = new RandomAccessFile(filePath, readOnly ? "r" : "rw");
        }
        catch (IOException x) {
            throw new StorageError(3, x);
        }
    }

    public long length() {
        try {
            return this.file.length();
        }
        catch (IOException x) {
            return -1L;
        }
    }
}

