/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.StreamTokenizer;
import org.garret.perst.IFile;
import org.garret.perst.StorageError;
import org.garret.perst.impl.OSFile;

public class MultiFile
implements IFile {
    MultiFileSegment[] segment;
    long currPos;
    long currOffs;
    long fixedSize;
    int currSeg;
    boolean noFlush;

    void seek(long pos) throws IOException {
        this.currSeg = 0;
        this.currOffs = 0L;
        this.currPos = 0L;
        while (pos > this.segment[this.currSeg].size) {
            this.currPos += this.segment[this.currSeg].size;
            pos -= this.segment[this.currSeg].size;
            ++this.currSeg;
        }
        this.segment[this.currSeg].f.seek(pos);
        pos = this.segment[this.currSeg].f.getFilePointer();
        this.currOffs += pos;
        this.currPos += pos;
    }

    public void write(long pos, byte[] b) {
        try {
            int toWrite;
            this.seek(pos);
            int off = 0;
            for (int len = b.length; len > 0; len -= toWrite) {
                toWrite = len;
                if ((long)len + this.currOffs > this.segment[this.currSeg].size) {
                    toWrite = (int)(this.segment[this.currSeg].size - this.currOffs);
                }
                this.segment[this.currSeg].f.write(b, off, toWrite);
                this.currPos += (long)toWrite;
                this.currOffs += (long)toWrite;
                off += toWrite;
                if (this.currOffs != this.segment[this.currSeg].size) continue;
                this.segment[++this.currSeg].f.seek(0L);
                this.currOffs = 0L;
            }
        }
        catch (IOException x) {
            throw new StorageError(3, x);
        }
    }

    public int read(long pos, byte[] b) {
        try {
            int rc;
            this.seek(pos);
            int totalRead = 0;
            int off = 0;
            for (int len = b.length; len > 0; len -= rc) {
                int toRead = len;
                if ((long)len + this.currOffs > this.segment[this.currSeg].size) {
                    toRead = (int)(this.segment[this.currSeg].size - this.currOffs);
                }
                if ((rc = this.segment[this.currSeg].f.read(b, off, toRead)) >= 0) {
                    this.currPos += (long)rc;
                    this.currOffs += (long)rc;
                    totalRead += rc;
                    if (this.currOffs == this.segment[this.currSeg].size) {
                        this.segment[++this.currSeg].f.seek(0L);
                        this.currOffs = 0L;
                    }
                } else {
                    return totalRead == 0 ? rc : totalRead;
                }
                if (rc != toRead) {
                    return totalRead;
                }
                off += rc;
            }
            return totalRead;
        }
        catch (IOException x) {
            throw new StorageError(3, x);
        }
    }

    public void sync() {
        if (!this.noFlush) {
            try {
                int i = this.segment.length;
                while (--i >= 0) {
                    this.segment[i].f.getFD().sync();
                }
            }
            catch (IOException x) {
                throw new StorageError(3, x);
            }
        }
    }

    public boolean lock() {
        return OSFile.lockFile(this.segment[0].f);
    }

    public void close() {
        try {
            int i = this.segment.length;
            while (--i >= 0) {
                this.segment[i].f.close();
            }
        }
        catch (IOException x) {
            throw new StorageError(3, x);
        }
    }

    public MultiFile(String[] segmentPath, long[] segmentSize, boolean readOnly, boolean noFlush) {
        this.noFlush = noFlush;
        this.segment = new MultiFileSegment[segmentPath.length];
        String mode = readOnly ? "r" : "rw";
        try {
            for (int i = 0; i < this.segment.length; ++i) {
                MultiFileSegment seg = new MultiFileSegment();
                seg.f = new RandomAccessFile(segmentPath[i], mode);
                seg.size = segmentSize[i];
                this.fixedSize += seg.size;
                this.segment[i] = seg;
            }
            this.fixedSize -= this.segment[this.segment.length - 1].size;
            this.segment[this.segment.length - 1].size = Long.MAX_VALUE;
        }
        catch (IOException x) {
            throw new StorageError(3, x);
        }
    }

    public MultiFile(String filePath, boolean readOnly, boolean noFlush) {
        try {
            StreamTokenizer in = new StreamTokenizer(new BufferedReader(new FileReader(filePath)));
            this.noFlush = noFlush;
            String mode = readOnly ? "r" : "rw";
            this.segment = new MultiFileSegment[0];
            int tkn = in.nextToken();
            do {
                MultiFileSegment seg = new MultiFileSegment();
                if (tkn != -3) {
                    throw new IOException("Multifile segment name expected");
                }
                seg.name = in.sval;
                tkn = in.nextToken();
                if (tkn != -1) {
                    if (tkn != -2) {
                        throw new StorageError(3, "Multifile segment size expected");
                    }
                    seg.size = (long)in.nval * 1024L;
                    tkn = in.nextToken();
                }
                this.fixedSize += seg.size;
                seg.f = new RandomAccessFile(seg.name, mode);
                MultiFileSegment[] newSegment = new MultiFileSegment[this.segment.length + 1];
                System.arraycopy(this.segment, 0, newSegment, 0, this.segment.length);
                newSegment[this.segment.length] = seg;
                this.segment = newSegment;
            } while (tkn != -1);
            this.fixedSize -= this.segment[this.segment.length - 1].size;
            this.segment[this.segment.length - 1].size = Long.MAX_VALUE;
        }
        catch (IOException x) {
            throw new StorageError(3, x);
        }
    }

    public long length() {
        try {
            return this.fixedSize + this.segment[this.segment.length - 1].f.length();
        }
        catch (IOException x) {
            return -1L;
        }
    }

    static class MultiFileSegment {
        RandomAccessFile f;
        String name;
        long size;

        MultiFileSegment() {
        }
    }
}

