/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.garret.perst.IPersistent;
import org.garret.perst.impl.OidHashTable;

public class LruObjectCache
implements OidHashTable {
    Entry[] table;
    static final float loadFactor = 0.75f;
    static final int defaultInitSize = 1319;
    int count;
    int threshold;
    int pinLimit;
    int nPinned;
    Entry pinList;

    public LruObjectCache(int size) {
        int initialCapacity = size == 0 ? 1319 : size;
        this.threshold = (int)((float)initialCapacity * 0.75f);
        this.table = new Entry[initialCapacity];
        this.pinList = new Entry(0, null, null);
        this.pinLimit = size;
        this.pinList.lru = this.pinList.mru = this.pinList;
    }

    public synchronized boolean remove(int oid) {
        Entry[] tab = this.table;
        int index = (oid & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        Entry prev = null;
        while (e != null) {
            if (e.oid == oid) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                e.clear();
                this.unpinObject(e);
                --this.count;
                return true;
            }
            prev = e;
            e = e.next;
        }
        return false;
    }

    protected Reference createReference(Object obj) {
        return new WeakReference<Object>(obj);
    }

    private final void unpinObject(Entry e) {
        if (e.pin != null) {
            e.unpin();
            --this.nPinned;
        }
    }

    private final void pinObject(Entry e, IPersistent obj) {
        if (this.pinLimit != 0) {
            if (e.pin != null) {
                e.unlink();
            } else if (this.nPinned == this.pinLimit) {
                this.pinList.lru.unpin();
            } else {
                ++this.nPinned;
            }
            e.linkAfter(this.pinList, obj);
        }
    }

    public synchronized void put(int oid, IPersistent obj) {
        Reference ref = this.createReference(obj);
        Entry[] tab = this.table;
        int index = (oid & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.oid == oid) {
                e.ref = ref;
                this.pinObject(e, obj);
                return;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (oid & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = new Entry(oid, ref, tab[index]);
        this.pinObject(tab[index], obj);
        ++this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPersistent get(int oid) {
        while (true) {
            block10: {
                LruObjectCache lruObjectCache = this;
                synchronized (lruObjectCache) {
                    Entry[] tab = this.table;
                    int index = (oid & Integer.MAX_VALUE) % tab.length;
                    Entry e = tab[index];
                    while (e != null) {
                        if (e.oid == oid) {
                            IPersistent obj = (IPersistent)e.ref.get();
                            if (obj == null) {
                                if (e.dirty != 0) {
                                    break block10;
                                }
                            } else {
                                if (obj.isDeleted()) {
                                    e.ref.clear();
                                    this.unpinObject(e);
                                    return null;
                                }
                                this.pinObject(e, obj);
                            }
                            return obj;
                        }
                        e = e.next;
                    }
                    return null;
                }
            }
            System.runFinalization();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        while (true) {
            block10: {
                LruObjectCache lruObjectCache = this;
                synchronized (lruObjectCache) {
                    for (int i = 0; i < this.table.length; ++i) {
                        Entry e = this.table[i];
                        while (e != null) {
                            IPersistent obj = (IPersistent)e.ref.get();
                            if (obj != null) {
                                if (obj.isModified()) {
                                    obj.store();
                                }
                            } else if (e.dirty != 0) {
                                break block10;
                            }
                            e = e.next;
                        }
                    }
                    return;
                }
            }
            System.runFinalization();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        while (true) {
            block10: {
                LruObjectCache lruObjectCache = this;
                synchronized (lruObjectCache) {
                    for (int i = 0; i < this.table.length; ++i) {
                        Entry e = this.table[i];
                        while (e != null) {
                            IPersistent obj = (IPersistent)e.ref.get();
                            if (obj != null) {
                                if (obj.isModified()) {
                                    e.dirty = 0;
                                    this.unpinObject(e);
                                    obj.invalidate();
                                }
                            } else if (e.dirty != 0) {
                                break block10;
                            }
                            e = e.next;
                        }
                        this.table[i] = null;
                    }
                    this.count = 0;
                    return;
                }
            }
            System.runFinalization();
        }
    }

    void rehash() {
        int oldCapacity = this.table.length;
        Entry[] oldMap = this.table;
        int i = oldCapacity;
        while (--i >= 0) {
            Entry prev = null;
            Entry e = oldMap[i];
            while (e != null) {
                Entry next = e.next;
                IPersistent obj = (IPersistent)e.ref.get();
                if ((obj == null || obj.isDeleted()) && e.dirty == 0) {
                    --this.count;
                    e.clear();
                    if (prev == null) {
                        oldMap[i] = next;
                    } else {
                        prev.next = next;
                    }
                } else {
                    prev = e;
                }
                e = next;
            }
        }
        if (this.count <= this.threshold >>> 1) {
            return;
        }
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        this.threshold = (int)((float)newCapacity * 0.75f);
        this.table = newMap;
        i = oldCapacity;
        while (--i >= 0) {
            Entry old = oldMap[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index = (e.oid & Integer.MAX_VALUE) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public synchronized void setDirty(int oid) {
        Entry[] tab = this.table;
        int index = (oid & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.oid == oid) {
                ++e.dirty;
                return;
            }
            e = e.next;
        }
    }

    public synchronized void clearDirty(int oid) {
        Entry[] tab = this.table;
        int index = (oid & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.oid == oid) {
                if (e.dirty > 0) {
                    --e.dirty;
                }
                return;
            }
            e = e.next;
        }
    }

    public int size() {
        return this.count;
    }

    static class Entry {
        Entry next;
        Reference ref;
        int oid;
        int dirty;
        Entry lru;
        Entry mru;
        IPersistent pin;

        void unlink() {
            this.lru.mru = this.mru;
            this.mru.lru = this.lru;
        }

        void unpin() {
            this.unlink();
            this.mru = null;
            this.lru = null;
            this.pin = null;
        }

        void linkAfter(Entry head, IPersistent obj) {
            this.mru = head.mru;
            this.mru.lru = this;
            head.mru = this;
            this.lru = head;
            this.pin = obj;
        }

        void clear() {
            this.ref.clear();
            this.ref = null;
            this.dirty = 0;
            this.next = null;
        }

        Entry(int oid, Reference ref, Entry chain) {
            this.next = chain;
            this.oid = oid;
            this.ref = ref;
        }
    }
}

