/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.garret.perst.IPersistent;
import org.garret.perst.Link;
import org.garret.perst.impl.PersistentStub;
import org.garret.perst.impl.QueryImpl;
import org.garret.perst.impl.StorageImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkImpl<T extends IPersistent>
implements Link<T> {
    IPersistent[] arr;
    int used;
    transient IPersistent owner;

    private final void modify() {
        if (this.owner != null) {
            this.owner.modify();
        }
    }

    @Override
    public int size() {
        return this.used;
    }

    @Override
    public void setSize(int newSize) {
        if (newSize < this.used) {
            int i = this.used;
            while (--i >= newSize) {
                this.arr[i] = null;
            }
        } else {
            this.reserveSpace(newSize - this.used);
        }
        this.used = newSize;
    }

    @Override
    public T get(int i) {
        if (i < 0 || i >= this.used) {
            throw new IndexOutOfBoundsException();
        }
        return this.loadElem(i);
    }

    @Override
    public IPersistent getRaw(int i) {
        if (i < 0 || i >= this.used) {
            throw new IndexOutOfBoundsException();
        }
        return this.arr[i];
    }

    @Override
    public void pin() {
        int n = this.used;
        for (int i = 0; i < n; ++i) {
            this.arr[i] = this.loadElem(i);
        }
    }

    @Override
    public void unpin() {
        int n = this.used;
        for (int i = 0; i < n; ++i) {
            IPersistent elem = this.arr[i];
            if (elem == null || elem.isRaw() || !elem.isPersistent()) continue;
            this.arr[i] = new PersistentStub(elem.getStorage(), elem.getOid());
        }
    }

    @Override
    public void set(int i, T obj) {
        if (i < 0 || i >= this.used) {
            throw new IndexOutOfBoundsException();
        }
        this.arr[i] = obj;
        this.modify();
    }

    @Override
    public boolean isEmpty() {
        return this.used == 0;
    }

    @Override
    public void remove(int i) {
        if (i < 0 || i >= this.used) {
            throw new IndexOutOfBoundsException();
        }
        --this.used;
        System.arraycopy(this.arr, i + 1, this.arr, i, this.used - i);
        this.arr[this.used] = null;
        this.modify();
    }

    void reserveSpace(int len) {
        if (this.used + len > this.arr.length) {
            IPersistent[] newArr = new IPersistent[this.used + len > this.arr.length * 2 ? this.used + len : this.arr.length * 2];
            System.arraycopy(this.arr, 0, newArr, 0, this.used);
            this.arr = newArr;
        }
        this.modify();
    }

    @Override
    public void insert(int i, T obj) {
        if (i < 0 || i > this.used) {
            throw new IndexOutOfBoundsException();
        }
        this.reserveSpace(1);
        System.arraycopy(this.arr, i, this.arr, i + 1, this.used - i);
        this.arr[i] = obj;
        ++this.used;
    }

    @Override
    public boolean add(T obj) {
        this.reserveSpace(1);
        this.arr[this.used++] = obj;
        return true;
    }

    @Override
    public void addAll(T[] a) {
        this.addAll((IPersistent[])a, 0, a.length);
    }

    @Override
    public void addAll(T[] a, int from, int length) {
        this.reserveSpace(length);
        System.arraycopy(a, from, this.arr, this.used, length);
        this.used += length;
    }

    @Override
    public boolean addAll(Link<T> link) {
        int n = link.size();
        this.reserveSpace(n);
        int i = 0;
        int j = this.used;
        while (i < n) {
            this.arr[j] = link.getRaw(i);
            ++i;
            ++j;
        }
        this.used += n;
        return true;
    }

    @Override
    public Object[] toArray() {
        return this.toPersistentArray();
    }

    @Override
    public IPersistent[] toRawArray() {
        return this.arr;
    }

    @Override
    public IPersistent[] toPersistentArray() {
        IPersistent[] a = new IPersistent[this.used];
        int i = this.used;
        while (--i >= 0) {
            a[i] = this.loadElem(i);
        }
        return a;
    }

    @Override
    public <T> T[] toArray(T[] arr) {
        if (arr.length < this.used) {
            arr = (Object[])Array.newInstance(arr.getClass().getComponentType(), this.used);
        }
        int i = this.used;
        while (--i >= 0) {
            arr[i] = this.loadElem(i);
        }
        if (arr.length > this.used) {
            arr[this.used] = null;
        }
        return arr;
    }

    @Override
    public boolean contains(Object obj) {
        return this.indexOf(obj) >= 0;
    }

    @Override
    public int indexOf(Object obj) {
        int oid;
        if (obj instanceof IPersistent && (oid = ((IPersistent)obj).getOid()) != 0) {
            int i = this.used;
            while (--i >= 0) {
                IPersistent elem = this.arr[i];
                if (elem == null || elem.getOid() != oid) continue;
                return i;
            }
        } else {
            int i = this.used;
            while (--i >= 0) {
                if (this.arr[i] != obj) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean containsElement(int i, T obj) {
        IPersistent elem = this.arr[i];
        return elem == obj || elem != null && elem.getOid() != 0 && elem.getOid() == obj.getOid();
    }

    @Override
    public void clear() {
        int i = this.used;
        while (--i >= 0) {
            this.arr[i] = null;
        }
        this.used = 0;
        this.modify();
    }

    @Override
    public boolean remove(Object o) {
        int i = this.indexOf(o);
        if (i >= 0) {
            this.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> e = c.iterator();
        while (e.hasNext()) {
            if (this.contains(e.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean modified = false;
        Iterator<T> e = c.iterator();
        while (e.hasNext()) {
            if (!this.add((T)((IPersistent)e.next()))) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        Iterator<T> e = this.iterator();
        while (e.hasNext()) {
            if (!c.contains(e.next())) continue;
            e.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        Iterator<T> e = this.iterator();
        while (e.hasNext()) {
            if (c.contains(e.next())) continue;
            e.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public Iterator<T> iterator() {
        return new LinkIterator(this);
    }

    private final T loadElem(int i) {
        IPersistent elem = this.arr[i];
        if (elem != null && elem.isRaw()) {
            elem = ((StorageImpl)elem.getStorage()).lookupObject(elem.getOid(), null);
        }
        return (T)elem;
    }

    @Override
    public Iterator<T> select(Class cls, String predicate) {
        QueryImpl<T> query = new QueryImpl<T>(null);
        return query.select(cls, this.iterator(), predicate);
    }

    LinkImpl() {
    }

    LinkImpl(int initSize) {
        this.arr = new IPersistent[initSize];
    }

    LinkImpl(T[] arr, IPersistent owner) {
        this.arr = arr;
        this.owner = owner;
        this.used = arr.length;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LinkIterator<T extends IPersistent>
    implements Iterator<T> {
        private Link<T> link;
        private int i;

        LinkIterator(Link<T> link) {
            this.link = link;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.link.size();
        }

        @Override
        public T next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.link.get(this.i++);
        }

        @Override
        public void remove() {
            this.link.remove(this.i);
        }
    }
}

