/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.io.UnsupportedEncodingException;
import org.garret.perst.StorageError;
import org.garret.perst.impl.Bytes;

public class ByteBuffer {
    public byte[] arr = new byte[64];
    public int used;

    public final void extend(int size) {
        if (size > this.arr.length) {
            int newLen = size > this.arr.length * 2 ? size : this.arr.length * 2;
            byte[] newArr = new byte[newLen];
            System.arraycopy(this.arr, 0, newArr, 0, this.used);
            this.arr = newArr;
        }
        this.used = size;
    }

    final byte[] toArray() {
        byte[] result = new byte[this.used];
        System.arraycopy(this.arr, 0, result, 0, this.used);
        return result;
    }

    int packString(int dst, String value, String encoding) {
        if (value == null) {
            this.extend(dst + 4);
            Bytes.pack4(this.arr, dst, -1);
            dst += 4;
        } else {
            int length = value.length();
            if (encoding == null) {
                this.extend(dst + 4 + 2 * length);
                Bytes.pack4(this.arr, dst, length);
                dst += 4;
                for (int i = 0; i < length; ++i) {
                    Bytes.pack2(this.arr, dst, (short)value.charAt(i));
                    dst += 2;
                }
            } else {
                try {
                    byte[] bytes = value.getBytes(encoding);
                    this.extend(dst + 4 + bytes.length);
                    Bytes.pack4(this.arr, dst, -2 - bytes.length);
                    System.arraycopy(bytes, 0, this.arr, dst + 4, bytes.length);
                    dst += 4 + bytes.length;
                }
                catch (UnsupportedEncodingException x) {
                    throw new StorageError(26);
                }
            }
        }
        return dst;
    }

    ByteBuffer() {
    }
}

