/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.io.InputStream;
import java.io.OutputStream;
import org.garret.perst.Blob;
import org.garret.perst.PersistentResource;
import org.garret.perst.Storage;

public class BlobImpl
extends PersistentResource
implements Blob {
    int size;
    BlobImpl next;
    byte[] body;

    public boolean recursiveLoading() {
        return false;
    }

    public InputStream getInputStream() {
        return new BlobInputStream(this);
    }

    public OutputStream getOutputStream() {
        return new BlobOutputStream(this, -1L, false);
    }

    public OutputStream getOutputStream(boolean multisession) {
        return new BlobOutputStream(this, -1L, multisession);
    }

    public OutputStream getOutputStream(long position, boolean multisession) {
        return new BlobOutputStream(this, position, multisession);
    }

    public void deallocate() {
        this.load();
        if (this.size > 0) {
            BlobImpl curr = this.next;
            while (curr != null) {
                curr.load();
                BlobImpl tail = curr.next;
                curr.deallocate();
                curr = tail;
            }
        }
        super.deallocate();
    }

    BlobImpl(Storage storage, int size) {
        super(storage);
        this.body = new byte[size];
    }

    BlobImpl() {
    }

    static class BlobOutputStream
    extends OutputStream {
        protected BlobImpl first;
        protected BlobImpl curr;
        protected int pos;
        protected boolean multisession;

        public void write(int b) {
            byte[] buf = new byte[]{(byte)b};
            this.write(buf, 0, 1);
        }

        public void write(byte[] b, int off, int len) {
            while (len > 0) {
                if (this.pos == this.curr.body.length) {
                    BlobImpl prev = this.curr;
                    if (this.curr.next == null) {
                        BlobImpl next;
                        this.curr = prev.next = (next = new BlobImpl(this.curr.getStorage(), this.curr.body.length));
                    } else {
                        this.curr = prev.next;
                        this.curr.load();
                    }
                    if (prev != this.first) {
                        prev.store();
                        prev.invalidate();
                        prev.next = null;
                    }
                    this.pos = 0;
                }
                int n = len > this.curr.body.length - this.pos ? this.curr.body.length - this.pos : len;
                System.arraycopy(b, off, this.curr.body, this.pos, n);
                off += n;
                this.pos += n;
                len -= n;
                this.first.size += n;
            }
        }

        public void close() {
            if (!this.multisession && this.pos < this.curr.body.length && this.curr.next == null) {
                byte[] tmp = new byte[this.pos];
                System.arraycopy(this.curr.body, 0, tmp, 0, this.pos);
                this.curr.body = tmp;
            }
            this.curr.store();
            if (this.curr != this.first) {
                this.first.store();
            }
            this.curr = null;
            this.first = null;
        }

        BlobOutputStream(BlobImpl first, long offset, boolean multisession) {
            first.load();
            this.first = first;
            this.multisession = multisession;
            if (offset < 0L) {
                offset = first.size;
            }
            BlobImpl curr = first;
            while (offset >= (long)curr.body.length && curr.next != null) {
                offset -= (long)curr.body.length;
                BlobImpl next = curr.next;
                next.load();
                if (curr != first) {
                    curr.invalidate();
                    curr.next = null;
                }
                curr = next;
            }
            this.pos = offset > (long)curr.body.length ? curr.body.length : (int)offset;
            this.curr = curr;
        }
    }

    static class BlobInputStream
    extends InputStream {
        protected BlobImpl curr;
        protected int pos;
        protected int rest;

        public int read() {
            byte[] b = new byte[1];
            return this.read(b, 0, 1) == 1 ? b[0] & 0xFF : -1;
        }

        public int read(byte[] b, int off, int len) {
            if (len > this.rest) {
                len = this.rest;
            }
            int beg = off;
            while (len > 0) {
                if (this.pos == this.curr.body.length) {
                    BlobImpl prev = this.curr;
                    this.curr = this.curr.next;
                    this.curr.load();
                    prev.invalidate();
                    prev.next = null;
                    this.pos = 0;
                }
                int n = len > this.curr.body.length - this.pos ? this.curr.body.length - this.pos : len;
                System.arraycopy(this.curr.body, this.pos, b, off, n);
                this.pos += n;
                off += n;
                len -= n;
                this.rest -= n;
            }
            return off - beg;
        }

        public long skip(long offs) {
            if (offs > (long)this.rest) {
                offs = this.rest;
            }
            int len = (int)offs;
            while (len > 0) {
                if (this.pos == this.curr.body.length) {
                    BlobImpl prev = this.curr;
                    this.curr = this.curr.next;
                    this.curr.load();
                    prev.invalidate();
                    prev.next = null;
                    this.pos = 0;
                }
                int n = len > this.curr.body.length - this.pos ? this.curr.body.length - this.pos : len;
                this.pos += n;
                len -= n;
                this.rest -= n;
            }
            return offs;
        }

        public int available() {
            return this.rest;
        }

        public void close() {
            this.curr = null;
            this.rest = 0;
        }

        protected BlobInputStream(BlobImpl first) {
            first.load();
            this.curr = first;
            this.rest = first.size;
        }
    }
}

