/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.util.Collection;
import org.garret.perst.JSQLArithmeticException;
import org.garret.perst.JSQLRuntimeException;
import org.garret.perst.impl.FilterIterator;
import org.garret.perst.impl.Node;

class BinOpNode
extends Node {
    Node left;
    Node right;

    public boolean equals(Object o) {
        return o instanceof BinOpNode && super.equals(o) && ((BinOpNode)o).left.equals(this.left) && ((BinOpNode)o).right.equals(this.right);
    }

    long evaluateInt(FilterIterator t) {
        long lval = this.left.evaluateInt(t);
        long rval = this.right.evaluateInt(t);
        switch (this.tag) {
            case 1: {
                return lval + rval;
            }
            case 2: {
                return lval - rval;
            }
            case 3: {
                return lval * rval;
            }
            case 4: {
                if (rval == 0L) {
                    throw new JSQLArithmeticException("Divided by zero");
                }
                return lval / rval;
            }
            case 5: {
                return lval & rval;
            }
            case 6: {
                return lval | rval;
            }
            case 10: {
                long res = 1L;
                if (rval < 0L) {
                    lval = 1L / lval;
                    rval = -rval;
                }
                while (rval != 0L) {
                    if ((rval & 1L) != 0L) {
                        res *= lval;
                    }
                    lval *= lval;
                    rval >>>= 1;
                }
                return res;
            }
        }
        throw new Error("Invalid tag");
    }

    double evaluateReal(FilterIterator t) {
        double lval = this.left.evaluateReal(t);
        double rval = this.right.evaluateReal(t);
        switch (this.tag) {
            case 38: {
                return lval + rval;
            }
            case 39: {
                return lval - rval;
            }
            case 40: {
                return lval * rval;
            }
            case 41: {
                return lval / rval;
            }
            case 44: {
                return Math.pow(lval, rval);
            }
        }
        throw new Error("Invalid tag");
    }

    String evaluateStr(FilterIterator t) {
        String lval = this.left.evaluateStr(t);
        String rval = this.right.evaluateStr(t);
        return lval + rval;
    }

    Object evaluateObj(FilterIterator t) {
        Object lval;
        try {
            lval = this.left.evaluateObj(t);
        }
        catch (JSQLRuntimeException x) {
            t.query.reportRuntimeError(x);
            Object rval = this.right.evaluateObj(t);
            if (rval instanceof Boolean) {
                return (Boolean)rval != false ? Boolean.TRUE : Boolean.FALSE;
            }
            throw x;
        }
        if (lval instanceof Boolean) {
            switch (this.tag) {
                case 125: {
                    return (Boolean)lval != false && (Boolean)this.right.evaluateObj(t) != false ? Boolean.TRUE : Boolean.FALSE;
                }
                case 126: {
                    return (Boolean)lval != false || (Boolean)this.right.evaluateObj(t) != false ? Boolean.TRUE : Boolean.FALSE;
                }
            }
            throw new Error("Operation is not applicable to operands of boolean type");
        }
        Object rval = this.right.evaluateObj(t);
        if (lval instanceof Double || lval instanceof Float || rval instanceof Double || rval instanceof Float) {
            double r1 = ((Number)lval).doubleValue();
            double r2 = ((Number)rval).doubleValue();
            switch (this.tag) {
                case 121: {
                    return new Double(r1 + r2);
                }
                case 122: {
                    return new Double(r1 - r2);
                }
                case 123: {
                    return new Double(r1 * r2);
                }
                case 124: {
                    return new Double(r1 / r2);
                }
                case 130: {
                    return new Double(Math.pow(r1, r2));
                }
            }
            throw new Error("Operation is not applicable to operands of real type");
        }
        if (lval instanceof String && rval instanceof String) {
            return (String)lval + (String)rval;
        }
        long i1 = ((Number)lval).longValue();
        long i2 = ((Number)rval).longValue();
        switch (this.tag) {
            case 121: {
                return new Long(i1 + i2);
            }
            case 122: {
                return new Long(i1 - i2);
            }
            case 123: {
                return new Long(i1 * i2);
            }
            case 124: {
                if (i2 == 0L) {
                    throw new JSQLArithmeticException("Divided by zero");
                }
                return new Long(i1 / i2);
            }
            case 125: {
                return new Long(i1 & i2);
            }
            case 126: {
                return new Long(i1 | i2);
            }
            case 130: {
                long res = 1L;
                if (i1 < 0L) {
                    i2 = 1L / i2;
                    i1 = -i1;
                }
                while (i1 != 0L) {
                    if ((i1 & 1L) != 0L) {
                        res *= i2;
                    }
                    i2 *= i2;
                    i1 >>>= 1;
                }
                return new Long(res);
            }
        }
        throw new Error("Operation is not applicable to operands of integer type");
    }

    static boolean areEqual(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a instanceof Double || a instanceof Float || b instanceof Double || b instanceof Float) {
            return ((Number)a).doubleValue() == ((Number)b).doubleValue();
        }
        if (a instanceof Number || b instanceof Number) {
            return ((Number)a).longValue() == ((Number)b).longValue();
        }
        if (a != null) {
            return a.equals(b);
        }
        return false;
    }

    static int compare(Object a, Object b) {
        if (a instanceof Double || a instanceof Float || b instanceof Double || b instanceof Float) {
            double r2;
            double r1 = ((Number)a).doubleValue();
            return r1 < (r2 = ((Number)b).doubleValue()) ? -1 : (r1 == r2 ? 0 : 1);
        }
        if (a instanceof Number || b instanceof Number) {
            long i2;
            long i1 = ((Number)a).longValue();
            return i1 < (i2 = ((Number)b).longValue()) ? -1 : (i1 == i2 ? 0 : 1);
        }
        return ((Comparable)a).compareTo(b);
    }

    boolean evaluateBool(FilterIterator t) {
        switch (this.tag) {
            case 131: {
                return BinOpNode.areEqual(this.left.evaluateObj(t), this.right.evaluateObj(t));
            }
            case 132: {
                return !BinOpNode.areEqual(this.left.evaluateObj(t), this.right.evaluateObj(t));
            }
            case 135: {
                return BinOpNode.compare(this.left.evaluateObj(t), this.right.evaluateObj(t)) < 0;
            }
            case 136: {
                return BinOpNode.compare(this.left.evaluateObj(t), this.right.evaluateObj(t)) <= 0;
            }
            case 133: {
                return BinOpNode.compare(this.left.evaluateObj(t), this.right.evaluateObj(t)) > 0;
            }
            case 134: {
                return BinOpNode.compare(this.left.evaluateObj(t), this.right.evaluateObj(t)) >= 0;
            }
            case 139: {
                Object elem = this.left.evaluateObj(t);
                Object set = this.right.evaluateObj(t);
                if (set instanceof String) {
                    return ((String)set).indexOf((String)elem) >= 0;
                }
                Object[] arr = (Object[])set;
                int i = arr.length;
                while (--i >= 0) {
                    if (!elem.equals(arr[i])) continue;
                    return true;
                }
                return false;
            }
            case 94: {
                try {
                    if (!this.left.evaluateBool(t)) {
                        return false;
                    }
                }
                catch (JSQLRuntimeException x) {
                    t.query.reportRuntimeError(x);
                }
                return this.right.evaluateBool(t);
            }
            case 95: {
                try {
                    if (this.left.evaluateBool(t)) {
                        return true;
                    }
                }
                catch (JSQLRuntimeException x) {
                    t.query.reportRuntimeError(x);
                }
                return this.right.evaluateBool(t);
            }
            case 11: {
                return this.left.evaluateInt(t) == this.right.evaluateInt(t);
            }
            case 12: {
                return this.left.evaluateInt(t) != this.right.evaluateInt(t);
            }
            case 15: {
                return this.left.evaluateInt(t) < this.right.evaluateInt(t);
            }
            case 16: {
                return this.left.evaluateInt(t) <= this.right.evaluateInt(t);
            }
            case 13: {
                return this.left.evaluateInt(t) > this.right.evaluateInt(t);
            }
            case 14: {
                return this.left.evaluateInt(t) >= this.right.evaluateInt(t);
            }
            case 18: {
                return this.left.evaluateReal(t) == this.right.evaluateReal(t);
            }
            case 19: {
                return this.left.evaluateReal(t) != this.right.evaluateReal(t);
            }
            case 22: {
                return this.left.evaluateReal(t) < this.right.evaluateReal(t);
            }
            case 23: {
                return this.left.evaluateReal(t) <= this.right.evaluateReal(t);
            }
            case 20: {
                return this.left.evaluateReal(t) > this.right.evaluateReal(t);
            }
            case 21: {
                return this.left.evaluateReal(t) >= this.right.evaluateReal(t);
            }
            case 25: {
                return this.left.evaluateStr(t).equals(this.right.evaluateStr(t));
            }
            case 26: {
                return !this.left.evaluateStr(t).equals(this.right.evaluateStr(t));
            }
            case 29: {
                return this.left.evaluateStr(t).compareTo(this.right.evaluateStr(t)) < 0;
            }
            case 30: {
                return this.left.evaluateStr(t).compareTo(this.right.evaluateStr(t)) <= 0;
            }
            case 27: {
                return this.left.evaluateStr(t).compareTo(this.right.evaluateStr(t)) > 0;
            }
            case 28: {
                return this.left.evaluateStr(t).compareTo(this.right.evaluateStr(t)) >= 0;
            }
            case 34: {
                return this.left.evaluateBool(t) == this.right.evaluateBool(t);
            }
            case 35: {
                return this.left.evaluateBool(t) != this.right.evaluateBool(t);
            }
            case 36: {
                return BinOpNode.areEqual(this.left.evaluateObj(t), this.right.evaluateObj(t));
            }
            case 37: {
                return BinOpNode.areEqual(this.left.evaluateObj(t), this.right.evaluateObj(t));
            }
            case 143: {
                return ((Collection)this.right.evaluateObj(t)).contains(this.left.evaluateObj(t));
            }
            case 72: {
                boolean val = this.left.evaluateBool(t);
                boolean[] arr = (boolean[])this.right.evaluateObj(t);
                int i = arr.length;
                while (--i >= 0) {
                    if (arr[i] != val) continue;
                    return true;
                }
                return false;
            }
            case 74: {
                long val = this.left.evaluateInt(t);
                byte[] arr = (byte[])this.right.evaluateObj(t);
                int i = arr.length;
                while (--i >= 0) {
                    if ((long)arr[i] != val) continue;
                    return true;
                }
                return false;
            }
            case 73: {
                long val = this.left.evaluateInt(t);
                char[] arr = (char[])this.right.evaluateObj(t);
                int i = arr.length;
                while (--i >= 0) {
                    if ((long)arr[i] != val) continue;
                    return true;
                }
                return false;
            }
            case 75: {
                long val = this.left.evaluateInt(t);
                short[] arr = (short[])this.right.evaluateObj(t);
                int i = arr.length;
                while (--i >= 0) {
                    if ((long)arr[i] != val) continue;
                    return true;
                }
                return false;
            }
            case 76: {
                long val = this.left.evaluateInt(t);
                int[] arr = (int[])this.right.evaluateObj(t);
                int i = arr.length;
                while (--i >= 0) {
                    if ((long)arr[i] != val) continue;
                    return true;
                }
                return false;
            }
            case 77: {
                long val = this.left.evaluateInt(t);
                long[] arr = (long[])this.right.evaluateObj(t);
                int i = arr.length;
                while (--i >= 0) {
                    if (arr[i] != val) continue;
                    return true;
                }
                return false;
            }
            case 78: {
                double val = this.left.evaluateReal(t);
                float[] arr = (float[])this.right.evaluateObj(t);
                int i = arr.length;
                while (--i >= 0) {
                    if ((double)arr[i] != val) continue;
                    return true;
                }
                return false;
            }
            case 79: {
                double val = this.left.evaluateReal(t);
                double[] arr = (double[])this.right.evaluateObj(t);
                int i = arr.length;
                while (--i >= 0) {
                    if (arr[i] != val) continue;
                    return true;
                }
                return false;
            }
            case 80: {
                String val = this.left.evaluateStr(t);
                String[] arr = (String[])this.right.evaluateObj(t);
                int i = arr.length;
                while (--i >= 0) {
                    if (!val.equals(arr[i])) continue;
                    return true;
                }
                return false;
            }
            case 81: {
                Object val = this.left.evaluateObj(t);
                Object[] arr = (Object[])this.right.evaluateObj(t);
                int i = arr.length;
                while (--i >= 0) {
                    if (!BinOpNode.areEqual(val, arr[i])) continue;
                    return true;
                }
                return false;
            }
            case 82: {
                String substr = this.left.evaluateStr(t);
                String str = this.right.evaluateStr(t);
                return str.indexOf(substr) >= 0;
            }
        }
        throw new Error("Invalid tag " + this.tag);
    }

    BinOpNode(int type, int tag, Node left, Node right) {
        super(type, tag);
        this.left = left;
        this.right = right;
    }
}

