/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.io.IOException;
import org.garret.perst.IFile;
import org.garret.perst.impl.Bytes;
import org.garret.perst.impl.ReplicationMasterFile;
import org.garret.perst.impl.ReplicationMasterStorageImpl;

public class AsyncReplicationMasterFile
extends ReplicationMasterFile
implements Runnable {
    private int asyncBufSize;
    private int buffered;
    private boolean closed;
    private Object go;
    private Object async;
    private Parcel head;
    private Parcel tail;
    private Thread thread;

    public AsyncReplicationMasterFile(ReplicationMasterStorageImpl storage, IFile file, int asyncBufSize) {
        super(storage, file);
        this.asyncBufSize = asyncBufSize;
        this.start();
    }

    public AsyncReplicationMasterFile(IFile file, String[] hosts, int asyncBufSize, boolean ack) {
        super(file, hosts, ack);
        this.asyncBufSize = asyncBufSize;
        this.start();
    }

    private void start() {
        this.go = new Object();
        this.async = new Object();
        this.thread = new Thread(this);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(long pos, byte[] buf) {
        this.file.write(pos, buf);
        for (int i = 0; i < this.out.length; ++i) {
            Object object;
            if (this.out[i] == null) continue;
            byte[] data = new byte[8 + buf.length];
            Bytes.pack8(data, 0, pos);
            System.arraycopy(buf, 0, data, 8, buf.length);
            Parcel p = new Parcel();
            p.data = data;
            p.pos = pos;
            p.host = i;
            try {
                object = this.async;
                synchronized (object) {
                    this.buffered += data.length;
                    while (this.buffered > this.asyncBufSize) {
                        this.async.wait();
                    }
                }
            }
            catch (InterruptedException x) {
                // empty catch block
            }
            object = this.go;
            synchronized (object) {
                if (this.head == null) {
                    this.head = this.tail = p;
                } else {
                    this.tail = this.tail.next = p;
                }
                this.go.notify();
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        block10: while (true) {
            block11: while (true) {
                var2_4 = this.go;
                synchronized (var2_4) {
                    while (this.head == null) {
                        if (this.closed) {
                            return;
                        }
                        this.go.wait();
                    }
                    p = this.head;
                    this.head = p.next;
                }
                var2_4 = this.async;
                synchronized (var2_4) {
                    if (this.buffered > this.asyncBufSize) {
                        this.async.notifyAll();
                    }
                    this.buffered -= p.data.length;
                }
                i = p.host;
                while (true) {
                    block16: {
                        if (this.out[i] == null) continue block11;
                        try {
                            this.out[i].write(p.data);
                            if (this.ack && p.pos == 0L && this.in[i].read(this.rcBuf) != 1) break block16;
                            continue block10;
                        }
                        catch (IOException var3_5) {
                            // empty catch block
                        }
                    }
                    this.out[i] = null;
                    this.sockets[i] = null;
                    --this.nHosts;
                    if (this.handleError(this.hosts[i])) ** break;
                    continue block11;
                    this.connect(i);
                }
                break;
            }
            break;
        }
        catch (InterruptedException var1_2) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            Object object = this.go;
            synchronized (object) {
                this.closed = true;
                this.go.notify();
            }
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        super.close();
    }

    static class Parcel {
        byte[] data;
        long pos;
        int host;
        Parcel next;

        Parcel() {
        }
    }
}

