/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.garret.perst.FieldIndex;
import org.garret.perst.IPersistent;
import org.garret.perst.IterableIterator;
import org.garret.perst.Key;
import org.garret.perst.StorageError;
import org.garret.perst.impl.AltBtree;
import org.garret.perst.impl.ClassDescriptor;
import org.garret.perst.impl.QueryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AltBtreeMultiFieldIndex<T extends IPersistent>
extends AltBtree<T>
implements FieldIndex<T> {
    String className;
    String[] fieldName;
    transient Class cls;
    transient Field[] fld;

    AltBtreeMultiFieldIndex() {
    }

    AltBtreeMultiFieldIndex(Class cls, String[] fieldName, boolean unique) {
        this.cls = cls;
        this.unique = unique;
        this.fieldName = fieldName;
        this.className = cls.getName();
        this.locateFields();
        this.type = 12;
    }

    private final void locateFields() {
        Class scope = this.cls;
        this.fld = new Field[this.fieldName.length];
        for (int i = 0; i < this.fieldName.length; ++i) {
            this.fld[i] = ClassDescriptor.locateField(this.cls, this.fieldName[i]);
            if (this.fld[i] != null) continue;
            throw new StorageError(20, this.className + "." + this.fieldName[i]);
        }
    }

    @Override
    public Class getIndexedClass() {
        return this.cls;
    }

    @Override
    public Field[] getKeyFields() {
        return this.fld;
    }

    @Override
    public void onLoad() {
        this.cls = ClassDescriptor.loadClass(this.getStorage(), this.className);
        this.locateFields();
    }

    private Key convertKey(Key key) {
        if (key == null) {
            return null;
        }
        if (key.type != 30) {
            throw new StorageError(9);
        }
        return new Key(new CompoundKey((Object[])key.oval), key.inclusion != 0);
    }

    private Key extractKey(IPersistent obj) {
        Object[] keys = new Object[this.fld.length];
        try {
            for (int i = 0; i < keys.length; ++i) {
                keys[i] = this.fld[i].get(obj);
            }
        }
        catch (Exception x) {
            throw new StorageError(17, x);
        }
        return new Key(new CompoundKey(keys));
    }

    @Override
    public boolean put(T obj) {
        return super.put(this.extractKey((IPersistent)obj), obj);
    }

    @Override
    public T set(T obj) {
        return super.set(this.extractKey((IPersistent)obj), obj);
    }

    @Override
    public void remove(T obj) {
        super.remove(new AltBtree.BtreeKey(this.extractKey((IPersistent)obj), (IPersistent)obj));
    }

    @Override
    public T remove(Key key) {
        return super.remove(this.convertKey(key));
    }

    @Override
    public boolean contains(T obj) {
        Key key = this.extractKey((IPersistent)obj);
        if (this.unique) {
            return super.get(key) != null;
        }
        IPersistent[] mbrs = this.get(key, key);
        for (int i = 0; i < mbrs.length; ++i) {
            if (mbrs[i] != obj) continue;
            return true;
        }
        return false;
    }

    @Override
    public void append(T obj) {
        throw new StorageError(8);
    }

    public T[] get(Key from, Key till) {
        ArrayList list = new ArrayList();
        if (this.root != null) {
            this.root.find(this.convertKey(from), this.convertKey(till), this.height, list);
        }
        return list.toArray((IPersistent[])Array.newInstance(this.cls, list.size()));
    }

    public T[] getPrefix(String prefix) {
        throw new StorageError(9);
    }

    public T[] prefixSearch(String key) {
        throw new StorageError(9);
    }

    public T[] toPersistentArray() {
        IPersistent[] arr = (IPersistent[])Array.newInstance(this.cls, this.nElems);
        if (this.root != null) {
            this.root.traverseForward(this.height, arr, 0);
        }
        return arr;
    }

    @Override
    public T get(Key key) {
        return (T)super.get(this.convertKey(key));
    }

    @Override
    public IterableIterator<T> iterator(Key from, Key till, int order) {
        return super.iterator(this.convertKey(from), this.convertKey(till), order);
    }

    @Override
    public IterableIterator<Map.Entry<Object, T>> entryIterator(Key from, Key till, int order) {
        return super.entryIterator(this.convertKey(from), this.convertKey(till), order);
    }

    @Override
    public Iterator<T> select(String predicate) {
        QueryImpl query = new QueryImpl(this.getStorage());
        return query.select(this.cls, this.iterator(), predicate);
    }

    static class CompoundKey
    implements Comparable {
        Object[] keys;

        public int compareTo(Object o) {
            CompoundKey c = (CompoundKey)o;
            int n = this.keys.length < c.keys.length ? this.keys.length : c.keys.length;
            for (int i = 0; i < n; ++i) {
                int diff = ((Comparable)this.keys[i]).compareTo(c.keys[i]);
                if (diff == 0) continue;
                return diff;
            }
            return this.keys.length - c.keys.length;
        }

        CompoundKey(Object[] keys) {
            this.keys = keys;
        }
    }
}

