/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.garret.perst.Assert;
import org.garret.perst.FieldIndex;
import org.garret.perst.IPersistent;
import org.garret.perst.Key;
import org.garret.perst.StorageError;
import org.garret.perst.impl.AltBtree;
import org.garret.perst.impl.ClassDescriptor;
import org.garret.perst.impl.QueryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AltBtreeFieldIndex<T extends IPersistent>
extends AltBtree<T>
implements FieldIndex<T> {
    String className;
    String fieldName;
    long autoincCount;
    transient Class cls;
    transient Field fld;

    AltBtreeFieldIndex() {
    }

    private final void locateField() {
        this.fld = ClassDescriptor.locateField(this.cls, this.fieldName);
        if (this.fld == null) {
            throw new StorageError(20, this.className + "." + this.fieldName);
        }
    }

    @Override
    public Class getIndexedClass() {
        return this.cls;
    }

    @Override
    public Field[] getKeyFields() {
        return new Field[]{this.fld};
    }

    @Override
    public void onLoad() {
        this.cls = ClassDescriptor.loadClass(this.getStorage(), this.className);
        this.locateField();
    }

    AltBtreeFieldIndex(Class cls, String fieldName, boolean unique) {
        this.cls = cls;
        this.unique = unique;
        this.fieldName = fieldName;
        this.className = cls.getName();
        this.locateField();
        this.type = AltBtreeFieldIndex.checkType(this.fld.getType());
    }

    private Key extractKey(IPersistent obj) {
        try {
            Field f = this.fld;
            Key key = null;
            switch (this.type) {
                case 0: {
                    key = new Key(f.getBoolean(obj));
                    break;
                }
                case 1: {
                    key = new Key(f.getByte(obj));
                    break;
                }
                case 3: {
                    key = new Key(f.getShort(obj));
                    break;
                }
                case 2: {
                    key = new Key(f.getChar(obj));
                    break;
                }
                case 4: {
                    key = new Key(f.getInt(obj));
                    break;
                }
                case 10: {
                    key = new Key((IPersistent)f.get(obj));
                    break;
                }
                case 5: {
                    key = new Key(f.getLong(obj));
                    break;
                }
                case 9: {
                    key = new Key((Date)f.get(obj));
                    break;
                }
                case 6: {
                    key = new Key(f.getFloat(obj));
                    break;
                }
                case 7: {
                    key = new Key(f.getDouble(obj));
                    break;
                }
                case 14: {
                    key = new Key((Enum)f.get(obj));
                    break;
                }
                case 8: {
                    key = new Key((String)f.get(obj));
                    break;
                }
                case 12: {
                    key = new Key((Comparable)f.get(obj));
                    break;
                }
                default: {
                    Assert.failed("Invalid type");
                }
            }
            return key;
        }
        catch (Exception x) {
            throw new StorageError(17, x);
        }
    }

    @Override
    public boolean put(T obj) {
        return super.insert(this.extractKey((IPersistent)obj), obj, false) == null;
    }

    @Override
    public T set(T obj) {
        return super.set(this.extractKey((IPersistent)obj), obj);
    }

    @Override
    public void remove(T obj) {
        super.remove(new AltBtree.BtreeKey(this.extractKey((IPersistent)obj), (IPersistent)obj));
    }

    @Override
    public boolean contains(T obj) {
        Key key = this.extractKey((IPersistent)obj);
        if (this.unique) {
            return super.get(key) != null;
        }
        IPersistent[] mbrs = this.get(key, key);
        for (int i = 0; i < mbrs.length; ++i) {
            if (mbrs[i] != obj) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void append(T obj) {
        Key key;
        try {
            switch (this.type) {
                case 4: {
                    key = new Key((int)this.autoincCount);
                    this.fld.setInt(obj, (int)this.autoincCount);
                    break;
                }
                case 5: {
                    key = new Key(this.autoincCount);
                    this.fld.setLong(obj, this.autoincCount);
                    break;
                }
                default: {
                    throw new StorageError(8, this.fld.getType());
                }
            }
        }
        catch (Exception x) {
            throw new StorageError(17, x);
        }
        ++this.autoincCount;
        obj.modify();
        super.insert(key, obj, false);
    }

    public T[] getPrefix(String prefix) {
        ArrayList<IPersistent> list = this.getList(new Key(prefix, true), new Key(prefix + '\uffff', false));
        return list.toArray((IPersistent[])Array.newInstance(this.cls, list.size()));
    }

    public T[] prefixSearch(String key) {
        ArrayList<IPersistent> list = this.prefixSearchList(key);
        return list.toArray((IPersistent[])Array.newInstance(this.cls, list.size()));
    }

    public T[] get(Key from, Key till) {
        ArrayList list = new ArrayList();
        if (this.root != null) {
            this.root.find(this.checkKey(from), this.checkKey(till), this.height, list);
        }
        return list.toArray((IPersistent[])Array.newInstance(this.cls, list.size()));
    }

    public T[] toPersistentArray() {
        IPersistent[] arr = (IPersistent[])Array.newInstance(this.cls, this.nElems);
        if (this.root != null) {
            this.root.traverseForward(this.height, arr, 0);
        }
        return arr;
    }

    @Override
    public Iterator<T> select(String predicate) {
        QueryImpl query = new QueryImpl(this.getStorage());
        return query.select(this.cls, this.iterator(), predicate);
    }
}

