/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst;

import java.util.Date;
import org.garret.perst.Assert;
import org.garret.perst.AssertionFailed;
import org.garret.perst.Link;
import org.garret.perst.PersistentResource;
import org.garret.perst.Storage;
import org.garret.perst.VersionHistory;

public class Version
extends PersistentResource
implements Cloneable {
    private Link<Version> successors;
    private Link<Version> predecessors;
    private String[] labels;
    private Date date;
    private String id;
    VersionHistory history;

    public synchronized VersionHistory getVersionHistory() {
        return this.history;
    }

    public synchronized Version[] getPredecessors() {
        return this.predecessors.toArray((Version[])new Version[this.predecessors.size()]);
    }

    public synchronized Version[] getSuccessors() {
        return this.successors.toArray((Version[])new Version[this.successors.size()]);
    }

    public boolean isCheckedIn() {
        return this.id != null;
    }

    public boolean isCheckedOut() {
        return this.id == null;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public Version newVersion() {
        try {
            Version newVersion = (Version)this.clone();
            newVersion.predecessors = this.getStorage().createLink(1);
            newVersion.predecessors.add(this);
            newVersion.successors = this.getStorage().createLink(1);
            newVersion.labels = new String[0];
            return newVersion;
        }
        catch (CloneNotSupportedException x) {
            throw new AssertionFailed("Clone not supported");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkin() {
        VersionHistory versionHistory = this.history;
        synchronized (versionHistory) {
            Assert.that(this.isCheckedOut());
            for (int i = 0; i < this.predecessors.size(); ++i) {
                Version predecessor;
                Version version = predecessor = this.predecessors.get(i);
                synchronized (version) {
                    if (i == 0) {
                        this.id = predecessor.constructId();
                    }
                    predecessor.successors.add(this);
                    continue;
                }
            }
            this.date = new Date();
            this.history.versions.add(this);
            this.history.current = this;
            this.modify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPredecessor(Version predecessor) {
        Version version = predecessor;
        synchronized (version) {
            Version version2 = this;
            synchronized (version2) {
                this.predecessors.add(predecessor);
                if (this.isCheckedIn()) {
                    predecessor.successors.add(this);
                }
            }
        }
    }

    public Date getDate() {
        return this.date;
    }

    public synchronized String[] getLabels() {
        return this.labels;
    }

    public synchronized void addLabel(String label) {
        String[] newLabels = new String[this.labels.length + 1];
        System.arraycopy(this.labels, 0, newLabels, 0, this.labels.length);
        newLabels[newLabels.length - 1] = label;
        this.labels = newLabels;
        this.modify();
    }

    public synchronized boolean hasLabel(String label) {
        for (int i = 0; i < this.labels.length; ++i) {
            if (!this.labels[i].equals(label)) continue;
            return true;
        }
        return false;
    }

    public String getId() {
        return this.id;
    }

    protected Version(Storage storage) {
        super(storage);
        this.successors = storage.createLink(1);
        this.predecessors = storage.createLink(1);
        this.labels = new String[0];
        this.date = new Date();
        this.id = "1";
    }

    private Version() {
    }

    private String constructId() {
        String nextId;
        int suffixPos = this.id.lastIndexOf(46);
        int suffix = Integer.parseInt(this.id.substring(suffixPos + 1));
        String string = nextId = suffixPos < 0 ? Integer.toString(suffix + 1) : this.id.substring(0, suffixPos) + Integer.toString(suffix + 1);
        if (this.successors.size() != 0) {
            nextId = nextId + (46 + this.successors.size()) + ".1";
        }
        return nextId;
    }
}

