/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst;

import org.garret.perst.Assert;
import org.garret.perst.IValue;

public class Rectangle
implements IValue,
Cloneable {
    private int top;
    private int left;
    private int bottom;
    private int right;

    public final int getTop() {
        return this.top;
    }

    public final int getLeft() {
        return this.left;
    }

    public final int getBottom() {
        return this.bottom;
    }

    public final int getRight() {
        return this.right;
    }

    public final long area() {
        return (long)(this.bottom - this.top) * (long)(this.right - this.left);
    }

    public static long joinArea(Rectangle a, Rectangle b) {
        int left = a.left < b.left ? a.left : b.left;
        int right = a.right > b.right ? a.right : b.right;
        int top = a.top < b.top ? a.top : b.top;
        int bottom = a.bottom > b.bottom ? a.bottom : b.bottom;
        return (long)(bottom - top) * (long)(right - left);
    }

    public Object clone() {
        try {
            Rectangle r = (Rectangle)super.clone();
            r.top = this.top;
            r.left = this.left;
            r.bottom = this.bottom;
            r.right = this.right;
            return r;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public Rectangle(Rectangle r) {
        this.top = r.top;
        this.left = r.left;
        this.bottom = r.bottom;
        this.right = r.right;
    }

    public Rectangle(int top, int left, int bottom, int right) {
        Assert.that(top <= bottom && left <= right);
        this.top = top;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
    }

    public Rectangle() {
    }

    public final void join(Rectangle r) {
        if (this.left > r.left) {
            this.left = r.left;
        }
        if (this.right < r.right) {
            this.right = r.right;
        }
        if (this.top > r.top) {
            this.top = r.top;
        }
        if (this.bottom < r.bottom) {
            this.bottom = r.bottom;
        }
    }

    public static Rectangle join(Rectangle a, Rectangle b) {
        Rectangle r = new Rectangle(a);
        r.join(b);
        return r;
    }

    public final boolean intersects(Rectangle r) {
        return this.left <= r.right && this.top <= r.bottom && this.right >= r.left && this.bottom >= r.top;
    }

    public final boolean contains(Rectangle r) {
        return this.left <= r.left && this.top <= r.top && this.right >= r.right && this.bottom >= r.bottom;
    }

    public boolean equals(Object o) {
        if (o instanceof Rectangle) {
            Rectangle r = (Rectangle)o;
            return this.left == r.left && this.top == r.top && this.right == r.right && this.bottom == r.bottom;
        }
        return false;
    }

    public int hashCode() {
        return this.top ^ this.bottom << 1 ^ this.left << 2 ^ this.right << 3;
    }

    public String toString() {
        return "top=" + this.top + ", left=" + this.left + ", bottom=" + this.bottom + ", right=" + this.right;
    }
}

