/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.garret.perst.IFile;
import org.garret.perst.StorageError;
import org.garret.perst.impl.OSFile;

public class MappedFile
implements IFile {
    RandomAccessFile f;
    MappedByteBuffer map;
    FileChannel chan;
    long mapSize;

    private final void checkSize(long size) throws IOException {
        if (size > this.mapSize) {
            long newSize;
            long l = newSize = this.mapSize < 0x3FFFFFFFL ? this.mapSize * 2L : Integer.MAX_VALUE;
            if (newSize < size) {
                newSize = size;
            }
            this.mapSize = newSize;
            this.map = this.chan.map(FileChannel.MapMode.READ_WRITE, 0L, this.mapSize);
        }
    }

    public void write(long pos, byte[] buf) {
        try {
            this.checkSize(pos + (long)buf.length);
            this.map.position((int)pos);
            this.map.put(buf, 0, buf.length);
        }
        catch (IOException x) {
            throw new StorageError(3, x);
        }
    }

    public int read(long pos, byte[] buf) {
        if (pos >= this.mapSize) {
            return 0;
        }
        this.map.position((int)pos);
        this.map.get(buf, 0, buf.length);
        return buf.length;
    }

    public void sync() {
        this.map.force();
    }

    public void close() {
        try {
            this.chan.close();
            this.f.close();
        }
        catch (IOException x) {
            throw new StorageError(3, x);
        }
    }

    public boolean lock() {
        return OSFile.lockFile(this.f);
    }

    public long length() {
        try {
            return this.f.length();
        }
        catch (IOException x) {
            return -1L;
        }
    }

    public MappedFile(String filePath, long initialSize, boolean readOnly) {
        try {
            this.f = new RandomAccessFile(filePath, readOnly ? "r" : "rw");
            this.chan = this.f.getChannel();
            long size = this.chan.size();
            this.mapSize = readOnly || size > initialSize ? size : initialSize;
            this.map = this.chan.map(readOnly ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE, 0L, this.mapSize);
        }
        catch (IOException x) {
            throw new StorageError(3, x);
        }
    }
}

