/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.garret.perst.FieldIndex;
import org.garret.perst.IPersistent;
import org.garret.perst.IPersistentSet;
import org.garret.perst.Index;
import org.garret.perst.IterableIterator;
import org.garret.perst.Link;
import org.garret.perst.Persistent;
import org.garret.perst.Query;
import org.garret.perst.Storage;
import org.garret.perst.StorageError;
import org.garret.perst.impl.ClassDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Database {
    HashMap tables;
    Storage storage;
    Index metadata;

    public Database(Storage storage) {
        this.storage = storage;
        this.metadata = (Index)storage.getRoot();
        if (this.metadata == null) {
            this.metadata = storage.createIndex(String.class, true);
            storage.setRoot(this.metadata);
        }
        IterableIterator iterator = this.metadata.entryIterator();
        this.tables = new HashMap();
        while (iterator.hasNext()) {
            Map.Entry map = (Map.Entry)iterator.next();
            Class table = ClassDescriptor.loadClass(storage, (String)map.getKey());
            this.tables.put(table, map.getValue());
        }
    }

    public boolean createTable(Class table) {
        if (this.tables.get(table) == null) {
            Table t = new Table();
            t.extent = this.storage.createSet();
            t.indices = this.storage.createLink();
            t.indicesMap = new HashMap();
            this.tables.put(table, t);
            this.metadata.put(table.getName(), t);
            return true;
        }
        return false;
    }

    public boolean dropTable(Class table) {
        if (this.tables.remove(table) != null) {
            this.metadata.remove(table.getName());
            return true;
        }
        return false;
    }

    public <T extends IPersistent> boolean addRecord(T record) {
        return this.addRecord(record.getClass(), record);
    }

    private Table locateTable(Class cls) {
        Table table = null;
        for (Class c = cls; c != null && (table = (Table)this.tables.get(c)) == null; c = c.getSuperclass()) {
        }
        if (table == null) {
            throw new StorageError(18, cls.getName());
        }
        return table;
    }

    public <T extends IPersistent> boolean addRecord(Class table, T record) {
        Table t = this.locateTable(table);
        if (t.extent.add(record)) {
            for (FieldIndex index : t.indicesMap.values()) {
                index.put(record);
            }
            return true;
        }
        return false;
    }

    public <T extends IPersistent> boolean deleteRecord(T record) {
        return this.deleteRecord(record.getClass(), record);
    }

    public <T extends IPersistent> boolean deleteRecord(Class table, T record) {
        Table t = this.locateTable(table);
        if (t.extent.remove(record)) {
            for (FieldIndex index : t.indicesMap.values()) {
                index.remove(record);
            }
            record.deallocate();
            return true;
        }
        return false;
    }

    public boolean createIndex(Class table, String key, boolean unique) {
        Table t = (Table)this.tables.get(table);
        if (t == null) {
            throw new StorageError(18, table.getName());
        }
        if (t.indicesMap.get(key) == null) {
            FieldIndex index = this.storage.createFieldIndex(table, key, unique);
            t.indicesMap.put(key, index);
            t.indices.add(index);
            return true;
        }
        return false;
    }

    public boolean dropIndex(Class table, String key) {
        Table t = this.locateTable(table);
        FieldIndex index = (FieldIndex)t.indicesMap.remove(key);
        if (index != null) {
            t.indices.remove(t.indices.indexOf(index));
            return true;
        }
        return false;
    }

    public boolean excludeFromIndex(IPersistent record, String key) {
        return this.excludeFromIndex(record.getClass(), record, key);
    }

    public boolean excludeFromIndex(Class table, IPersistent record, String key) {
        Table t = this.locateTable(table);
        FieldIndex index = (FieldIndex)t.indicesMap.get(key);
        if (index != null) {
            index.remove(record);
            return true;
        }
        return false;
    }

    public boolean includeInIndex(IPersistent record, String key) {
        return this.includeInIndex(record.getClass(), record, key);
    }

    public boolean includeInIndex(Class table, IPersistent record, String key) {
        Table t = this.locateTable(table);
        FieldIndex index = (FieldIndex)t.indicesMap.get(key);
        if (index != null) {
            index.put(record);
            return true;
        }
        return false;
    }

    public <T extends IPersistent> Iterator<T> select(Class table, String predicate) {
        Query<T> q = this.prepare(table, predicate);
        return q.execute(this.getRecords(table));
    }

    public <T extends IPersistent> Query<T> prepare(Class table, String predicate) {
        Table t = this.locateTable(table);
        Query q = this.storage.createQuery();
        q.prepare(table, predicate);
        for (Map.Entry entry : t.indicesMap.entrySet()) {
            FieldIndex index = (FieldIndex)entry.getValue();
            String key = (String)entry.getKey();
            q.addIndex(key, index);
        }
        return q;
    }

    public <T extends IPersistent> Iterator<T> getRecords(Class table) {
        Table t = this.locateTable(table);
        return t.extent.iterator();
    }

    public Storage getStorage() {
        return this.storage;
    }

    static class Table
    extends Persistent {
        IPersistentSet extent;
        Link indices;
        transient HashMap indicesMap = new HashMap();

        Table() {
        }

        public void onLoad() {
            int i = this.indices.size();
            while (--i >= 0) {
                FieldIndex index = (FieldIndex)this.indices.get(i);
                this.indicesMap.put(index.getKeyFields()[0].getName(), index);
            }
        }
    }
}

