/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.utmutils.swing.tab;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaDealerGetUserAccountList;
import biz.netup.control.transport.urfa.functions.UrfaGetGroupsList;
import biz.netup.control.transport.urfa.functions.UrfaGetUserAccountList;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.mainframe.forms.tariffication.ap.MainAPTab;
import biz.netup.swing.RollPane;
import biz.netup.swing.datetime.CurrentDay;
import biz.netup.swing.datetime.CurrentMonth;
import biz.netup.swing.datetime.CurrentWeek;
import biz.netup.swing.datetime.CurrentYear;
import biz.netup.swing.datetime.LastMonth;
import biz.netup.swing.datetime.Manual;
import biz.netup.swing.datetime.OneDay;
import biz.netup.swing.datetime.OneMonth;
import biz.netup.swing.filter.impl.TimeFilter2Impl;
import biz.netup.swing.table.MapTableModel;
import biz.netup.swing.table.TablePanelAdapter;
import biz.netup.swing.table.impl.TablePanelImpl;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.control.export.ExportClass;
import biz.netup.utmutils.control.filter.FilterForm;
import biz.netup.utmutils.control.permissions.PermissionComboBox;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.control.trayicon.UTMTrayIcon;
import biz.netup.utmutils.swing.dialog.SelectFromTableDialogModel;
import biz.netup.utmutils.swing.tab.TabPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public abstract class ReportTab
extends TabPanel {
    private JButton generateButton;
    private TimeFilter2Impl timeFilter;
    private JCheckBox useDiscountPeriodCheckBox;
    private JTextField discountPeriodTextField;
    private TablePanelImpl reportTablePanel;
    private PermissionComboBox groupComboBox;
    private JComboBox reportTypeComboBox;
    protected JPanel groupAndTypePanel;
    protected JPanel typePanel;
    private JPanel mainPanel;
    private JProgressBar progressBar;
    private JPanel centerPanel;
    private JPanel additionalButtonsPanel;
    private JPanel apPanel;
    private JPanel filterPanel;
    private JPanel groupPanel;
    protected JComboBox accountComboBox;
    private JPanel accountPanel;
    protected JButton newInvoiceButton;
    private JButton exportButton;
    private JPanel graphPanel;
    private JPanel upperPanel;
    private JPanel bottomPanel;
    public static final int NORMAL_MODE = 1;
    public static final int GROUP_MODE = 2;
    public static final int TYPE_MODE = 3;
    private Map<String, String> columnNames;
    private FilterForm ff;
    private int discountPeriod;
    Vector<Map<String, Object>> dataTable = new Vector();
    private RollPane filterRP;
    private boolean summury = false;
    public boolean timeFilterEnabling = true;
    protected int uid;
    protected int aid;
    protected int did;
    Map<String, Integer> reportTypeMap;
    Map<String, Integer> groupMap;
    public Map<String, Integer> accountMap;

    public abstract int getMode();

    public abstract Map<String, String> getColumnNames();

    public abstract void setTableData() throws UrfaException;

    public JPanel getBottomPanel() {
        return this.bottomPanel;
    }

    public ReportTab(int n, boolean bl) {
        if (bl) {
            this.did = n;
        } else {
            this.uid = n;
        }
    }

    @Override
    public int getTabType() {
        return 5;
    }

    @Override
    public String getGroupName() {
        return "Reports";
    }

    protected ReportTab() {
        this.$$$setupUI$$$();
    }

    protected ReportTab(int n) {
        this.uid = n;
    }

    private void initAccount() {
        Iterator<String> iterator;
        this.accountMap = new LinkedHashMap<String, Integer>();
        this.accountMap.put("---", 0);
        if (Utils.isAdmin()) {
            iterator = new UrfaGetUserAccountList(UrfaManagerImpl.getInstance());
            ((UrfaGetUserAccountList)((Object)iterator)).setUserId(this.uid);
            try {
                ((UrfaGetUserAccountList)((Object)iterator)).call();
                for (int i = 0; i < ((UrfaGetUserAccountList)((Object)iterator)).getAccountsCount(); ++i) {
                    this.accountMap.put("" + ((UrfaGetUserAccountList)((Object)iterator)).getAccount1()[i], ((UrfaGetUserAccountList)((Object)iterator)).getAccount1()[i]);
                }
            }
            catch (UrfaException urfaException) {
                this.log.error("Cannot get accounts list", urfaException);
            }
        } else {
            iterator = new UrfaDealerGetUserAccountList(UrfaManagerImpl.getInstance());
            ((UrfaDealerGetUserAccountList)((Object)iterator)).setUserId(this.uid);
            try {
                ((UrfaDealerGetUserAccountList)((Object)iterator)).call();
                for (int i = 0; i < ((UrfaDealerGetUserAccountList)((Object)iterator)).getAccountsCount(); ++i) {
                    this.accountMap.put("" + ((UrfaDealerGetUserAccountList)((Object)iterator)).getAccount1()[i], ((UrfaDealerGetUserAccountList)((Object)iterator)).getAccount1()[i]);
                }
            }
            catch (UrfaException urfaException) {
                this.log.error("Cannot get accounts list", urfaException);
            }
        }
        for (String string : this.accountMap.keySet()) {
            this.accountComboBox.addItem(string);
        }
    }

    public int getGroupId() {
        if (this.groupComboBox.getSelectedItem() != null && this.groupMap.keySet().contains(this.groupComboBox.getSelectedItem())) {
            return this.groupMap.get(this.groupComboBox.getSelectedItem());
        }
        return 0;
    }

    public int getType() {
        if (this.reportTypeComboBox != null && this.reportTypeComboBox.getSelectedItem() != null && this.reportTypeMap.containsKey(this.reportTypeComboBox.getSelectedItem())) {
            return this.reportTypeMap.get(this.reportTypeComboBox.getSelectedItem());
        }
        return 0;
    }

    private boolean isUseDiscountPeriod() {
        return this.useDiscountPeriodCheckBox.isSelected();
    }

    public int getDiscountPeriodID() {
        if (this.isUseDiscountPeriod()) {
            return this.discountPeriod;
        }
        return 0;
    }

    public int getStartTime() {
        return (int)(this.timeFilter.getBeginDate().getTime() / 1000L);
    }

    public int getEndTime() {
        return (int)(this.timeFilter.getEndDate().getTime() / 1000L);
    }

    @Override
    protected void init() {
        ((TabPanel)this).mainPanel.add(this.getMainPanel(), "Center");
        this.init = true;
        this.generateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportTab.this.refresh();
            }
        });
        this.generateButton.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (ReportTab.this.timeFilterEnabling) {
                    ReportTab.this.timeFilter.setEnabled((Boolean)propertyChangeEvent.getNewValue());
                }
                ReportTab.this.useDiscountPeriodCheckBox.setEnabled((Boolean)propertyChangeEvent.getNewValue());
                ReportTab.this.groupComboBox.setEnabled((Boolean)propertyChangeEvent.getNewValue());
                ReportTab.this.accountComboBox.setEnabled((Boolean)propertyChangeEvent.getNewValue());
                ReportTab.this.reportTypeComboBox.setEnabled((Boolean)propertyChangeEvent.getNewValue());
                ReportTab.this.exportButton.setEnabled((Boolean)propertyChangeEvent.getNewValue());
                ReportTab.this.progressBar.setIndeterminate((Boolean)propertyChangeEvent.getNewValue() == false);
            }
        });
        this.reportTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MapTableModel mapTableModel = ReportTab.this.reportTablePanel.getTableModel();
                mapTableModel.removeAllRows();
                for (int i = mapTableModel.getColumnCount() - 1; i >= 0; --i) {
                    mapTableModel.removeColumn(mapTableModel.getColumnId(i));
                }
                for (String string : ReportTab.this.getColumnNames().keySet()) {
                    mapTableModel.addColumn(string, ReportTab.this.getColumnNames().get(string), true, false);
                }
                ReportTab.this.reportTablePanel.repaint();
            }
        });
        this.accountPanel.setVisible(false);
        switch (this.getMode()) {
            case 1: {
                this.groupAndTypePanel.setVisible(false);
                break;
            }
            case 2: {
                this.initGroup();
                this.typePanel.setVisible(false);
                break;
            }
            case 3: {
                this.initGroup();
                this.initType();
            }
        }
        if (this.uid != 0) {
            this.groupPanel.setVisible(false);
            this.accountPanel.setVisible(true);
            this.initAccount();
            this.accountComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ReportTab.this.aid = ReportTab.this.accountMap.get(ReportTab.this.accountComboBox.getSelectedItem());
                }
            });
        }
        if (this.did != 0) {
            this.groupPanel.setVisible(false);
        }
        if (!Utils.isAdmin()) {
            this.groupPanel.setVisible(false);
        }
        this.ff = new FilterForm(this.reportTablePanel, this.dataTable, this);
        this.useDiscountPeriodCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportTab.this.changeSelection();
            }
        });
        this.filterRP = new RollPane(this.resource.getString("Filter"), this.ff.$$$getRootComponent$$$(), true);
        this.filterRP.getButton().setEnabled(false);
        this.filterPanel.add(this.filterRP);
        this.ff.getClearButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportTab.this.reportTablePanel.getTableModel().removeAllRows();
                for (Map<String, Object> map : ReportTab.this.dataTable) {
                    ReportTab.this.reportTablePanel.getTableModel().addRow(map);
                }
                if (ReportTab.this.reportTablePanel.getTableModel().getRowCount() > 0) {
                    ReportTab.this.addSummary();
                }
                ReportTab.this.checkFilter();
            }
        });
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExportClass.exportToCsv(ReportTab.this.reportTablePanel);
            }
        });
    }

    private void checkFilter() {
        if (this.reportTablePanel.getTableModel().getRowCount() == 0) {
            this.filterRP.setRolled(true);
        }
        this.filterRP.getButton().setEnabled(this.reportTablePanel.getTableModel().getRowCount() > 0);
    }

    private void changeSelection() {
        if (this.useDiscountPeriodCheckBox.isSelected()) {
            SelectFromTableDialogModel selectFromTableDialogModel = new SelectFromTableDialogModel(new MainAPTab());
            selectFromTableDialogModel.setVisible(true);
            if (selectFromTableDialogModel.isOkPressed()) {
                this.timeFilter.setEnabled(false);
                this.discountPeriod = (Integer)selectFromTableDialogModel.getItem().get("serial_id");
                this.discountPeriodTextField.setText(Resolve.getAPName(this.discountPeriod));
            } else {
                this.useDiscountPeriodCheckBox.setSelected(false);
            }
        } else {
            this.timeFilter.setEnabled(true);
            this.discountPeriodTextField.setText("");
        }
    }

    protected void initGroup() {
        if (Utils.isAdmin()) {
            this.groupMap = new LinkedHashMap<String, Integer>();
            this.groupComboBox.removeAllItems();
            this.groupMap.put("---", 0);
            if (UrfaManagerImpl.getInstance().isPermitted(9216)) {
                UrfaGetGroupsList urfaGetGroupsList = new UrfaGetGroupsList(UrfaManagerImpl.getInstance());
                try {
                    urfaGetGroupsList.call();
                    for (int i = 0; i < urfaGetGroupsList.getGroupsCount(); ++i) {
                        this.groupMap.put(urfaGetGroupsList.getGroupName1()[i], urfaGetGroupsList.getGroupId1()[i]);
                    }
                }
                catch (UrfaException urfaException) {
                    this.log.error("Cannot get groups list", urfaException);
                }
            }
            for (String string : this.groupMap.keySet()) {
                this.groupComboBox.addItem(string);
            }
        }
    }

    private void initType() {
        this.reportTypeMap = new LinkedHashMap<String, Integer>();
        this.reportTypeMap.put(this.resource.getString("---"), 0);
        this.reportTypeMap.put(this.resource.getString("Groupped by IP"), 4);
        this.reportTypeMap.put(this.resource.getString("Groupped by hour"), 1);
        this.reportTypeMap.put(this.resource.getString("Groupped by day"), 2);
        this.reportTypeMap.put(this.resource.getString("Groupped by month"), 3);
        if (Utils.isAdmin()) {
            this.reportTypeMap.put(this.resource.getString("Groupped by group"), 5);
        }
        for (String string : this.reportTypeMap.keySet()) {
            this.reportTypeComboBox.addItem(string);
        }
    }

    public JPanel getTypePanel() {
        return this.typePanel;
    }

    public JComboBox getReportTypeComboBox() {
        return this.reportTypeComboBox;
    }

    public JPanel getGroupAndTypePanel() {
        return this.groupAndTypePanel;
    }

    public JComboBox getGroupComboBox() {
        return this.groupComboBox;
    }

    @Override
    protected void refreshTab() throws UrfaException {
        this.reportTablePanel.getTableModel().removeAllRows();
        this.dataTable.clear();
        Thread thread = new Thread(){

            @Override
            public void run() {
                ReportTab.this.progressBar.setIndeterminate(true);
                UTMTrayIcon.getInstance().addProcess(this, "Report - " + ReportTab.this.resource.getString(ReportTab.this.getTabName()), ReportTab.this.generateButton);
                Object var1_1 = null;
                try {
                    ReportTab.this.setTableData();
                }
                catch (UrfaException urfaException) {
                    urfaException.printStackTrace();
                    ReportTab.this.log.error("Cannot get data", urfaException);
                }
                if (ReportTab.this.reportTablePanel.getTableModel().getRowCount() > 0) {
                    ReportTab.this.addSummary();
                }
                ReportTab.this.checkFilter();
                ReportTab.this.progressBar.setIndeterminate(false);
                UTMTrayIcon.getInstance().removeProcess(this);
            }
        };
        thread.start();
    }

    @Override
    public JComponent getPanel() {
        if (this.init) {
            this.initGroup();
        }
        return super.getPanel();
    }

    private void addSummary() {
        this.summury = true;
        this.addSummaryRows();
        this.summury = false;
    }

    public void addSummaryRows() {
    }

    @Override
    protected Component getMainPanel() {
        this.$$$setupUI$$$();
        return this.mainPanel;
    }

    private void createUIComponents() {
        this.groupComboBox = new PermissionComboBox(new int[]{9216});
        this.columnNames = this.getColumnNames();
        this.timeFilter = new TimeFilter2Impl(true);
        this.timeFilter.addTimeSpan(new CurrentMonth());
        this.timeFilter.addTimeSpan(new CurrentWeek());
        this.timeFilter.addTimeSpan(new CurrentDay());
        this.timeFilter.addTimeSpan(new LastMonth());
        this.timeFilter.addTimeSpan(new CurrentYear());
        this.timeFilter.addTimeSpan(new OneMonth());
        this.timeFilter.addTimeSpan(new OneDay());
        this.timeFilter.addTimeSpan(new Manual());
        this.createTable();
    }

    public TimeFilter2Impl getTimeFilter() {
        return this.timeFilter;
    }

    private void createTable() {
        this.reportTablePanel = new TablePanelImpl(this.getClass().getName() + "_" + this.getTabName(), true);
        MapTableModel mapTableModel = this.reportTablePanel.getTableModel();
        if (this.columnNames != null) {
            for (String string : this.columnNames.keySet()) {
                mapTableModel.addColumn(string, this.columnNames.get(string), this.getVisibleState(string), false);
            }
        } else {
            this.log.log(1, "No column defined: " + this.getTabName());
        }
        this.reportTablePanel.setEditable(false);
        this.reportTablePanel.setAppendable(false);
        this.reportTablePanel.setTablePanelListener(new TablePanelAdapter(){

            @Override
            public JMenuItem[] getTableContextMenuItems(Map<String, Object>[] mapArray) {
                JMenuItem jMenuItem = new JMenuItem(ReportTab.this.resource.getString("Refresh"));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ReportTab.this.refresh();
                    }
                });
                ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
                arrayList.add(jMenuItem);
                if (ReportTab.this.getMenuItems(mapArray) != null) {
                    for (JMenuItem jMenuItem2 : ReportTab.this.getMenuItems(mapArray)) {
                        arrayList.add(jMenuItem2);
                    }
                }
                return arrayList.toArray(new JMenuItem[arrayList.size()]);
            }
        });
        this.reportTablePanel.applyTableSettings();
        this.reportTablePanel.setSummaryVisible(true);
        this.reportTablePanel.getTableModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (!ReportTab.this.summury) {
                    ReportTab.this.reportTablePanel.setSummaryText(ReportTab.this.resource.getString("Row count") + ": " + ReportTab.this.reportTablePanel.getTable().getRowCount());
                }
            }
        });
    }

    protected boolean getVisibleState(String string) {
        return true;
    }

    protected JMenuItem[] getMenuItems(Map<String, Object>[] mapArray) {
        return null;
    }

    public JPanel getAdditionalButtonsPanel() {
        return this.additionalButtonsPanel;
    }

    public TablePanelImpl getReportTablePanel() {
        return this.reportTablePanel;
    }

    public Vector<Map<String, Object>> getDataTable() {
        return this.dataTable;
    }

    public JPanel getApPanel() {
        return this.apPanel;
    }

    public JPanel getCenterPanel() {
        return this.centerPanel;
    }

    public JButton getExportButton() {
        return this.exportButton;
    }

    public JPanel getGraphPanel() {
        return this.graphPanel;
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout(0, 0));
        this.upperPanel = new JPanel();
        this.upperPanel.setLayout(new GridBagLayout());
        this.mainPanel.add((Component)this.upperPanel, "North");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        this.upperPanel.add((Component)this.timeFilter, gridBagConstraints);
        this.apPanel = new JPanel();
        this.apPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.upperPanel.add((Component)this.apPanel, gridBagConstraints);
        this.useDiscountPeriodCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.useDiscountPeriodCheckBox, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Accounting period"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        this.apPanel.add((Component)this.useDiscountPeriodCheckBox, gridBagConstraints);
        this.discountPeriodTextField = new JTextField();
        this.discountPeriodTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.apPanel.add((Component)this.discountPeriodTextField, gridBagConstraints);
        JPanel jPanel = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.apPanel.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.apPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.upperPanel.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.upperPanel.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.upperPanel.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.upperPanel.add((Component)jPanel6, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.upperPanel.add((Component)jPanel7, gridBagConstraints);
        this.groupAndTypePanel = new JPanel();
        this.groupAndTypePanel.setLayout(new GridBagLayout());
        this.groupAndTypePanel.setVisible(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.upperPanel.add((Component)this.groupAndTypePanel, gridBagConstraints);
        this.typePanel = new JPanel();
        this.typePanel.setLayout(new GridBagLayout());
        this.typePanel.setEnabled(true);
        this.typePanel.setVisible(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.groupAndTypePanel.add((Component)this.typePanel, gridBagConstraints);
        this.reportTypeComboBox = new JComboBox();
        this.reportTypeComboBox.setMaximumSize(new Dimension(110, 23));
        this.reportTypeComboBox.setMinimumSize(new Dimension(110, 23));
        this.reportTypeComboBox.setPreferredSize(new Dimension(110, 23));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.typePanel.add((Component)this.reportTypeComboBox, gridBagConstraints);
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.typePanel.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.typePanel.add((Component)jPanel8, gridBagConstraints);
        JPanel jPanel9 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.typePanel.add((Component)jPanel9, gridBagConstraints);
        this.groupPanel = new JPanel();
        this.groupPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.groupAndTypePanel.add((Component)this.groupPanel, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Group"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.groupPanel.add((Component)jLabel2, gridBagConstraints);
        JPanel jPanel10 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.groupPanel.add((Component)jPanel10, gridBagConstraints);
        this.groupComboBox.setMaximumSize(new Dimension(110, 23));
        this.groupComboBox.setMinimumSize(new Dimension(110, 23));
        this.groupComboBox.setPreferredSize(new Dimension(110, 23));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.groupPanel.add((Component)this.groupComboBox, gridBagConstraints);
        this.accountPanel = new JPanel();
        this.accountPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.groupAndTypePanel.add((Component)this.accountPanel, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Account"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.accountPanel.add((Component)jLabel3, gridBagConstraints);
        JPanel jPanel11 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.accountPanel.add((Component)jPanel11, gridBagConstraints);
        this.accountComboBox = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.accountPanel.add((Component)this.accountComboBox, gridBagConstraints);
        JPanel jPanel12 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.fill = 2;
        this.upperPanel.add((Component)jPanel12, gridBagConstraints);
        this.additionalButtonsPanel = new JPanel();
        this.additionalButtonsPanel.setLayout(new BorderLayout(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.upperPanel.add((Component)this.additionalButtonsPanel, gridBagConstraints);
        this.filterPanel = new JPanel();
        this.filterPanel.setLayout(new BorderLayout(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 10;
        gridBagConstraints.fill = 1;
        this.upperPanel.add((Component)this.filterPanel, gridBagConstraints);
        JPanel jPanel13 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        this.upperPanel.add((Component)jPanel13, gridBagConstraints);
        JPanel jPanel14 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.upperPanel.add((Component)jPanel14, gridBagConstraints);
        JPanel jPanel15 = new JPanel();
        jPanel15.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.upperPanel.add((Component)jPanel15, gridBagConstraints);
        this.generateButton = new JButton();
        this.generateButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/next16.png")));
        this.$$$loadButtonText$$$(this.generateButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Generate"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel15.add((Component)this.generateButton, gridBagConstraints);
        this.newInvoiceButton = new JButton();
        this.newInvoiceButton.setEnabled(false);
        this.$$$loadButtonText$$$(this.newInvoiceButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("New invoice"));
        this.newInvoiceButton.setVisible(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel15.add((Component)this.newInvoiceButton, gridBagConstraints);
        this.exportButton = new JButton();
        this.exportButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/export16.png")));
        this.$$$loadButtonText$$$(this.exportButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Export"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel15.add((Component)this.exportButton, gridBagConstraints);
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new BorderLayout(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.fill = 1;
        this.upperPanel.add((Component)this.bottomPanel, gridBagConstraints);
        JPanel jPanel16 = new JPanel();
        jPanel16.setLayout(new GridBagLayout());
        this.mainPanel.add((Component)jPanel16, "Center");
        this.centerPanel = new JPanel();
        this.centerPanel.setLayout(new BorderLayout(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel16.add((Component)this.centerPanel, gridBagConstraints);
        this.centerPanel.add((Component)this.reportTablePanel, "Center");
        this.progressBar = new JProgressBar();
        this.progressBar.setVisible(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel16.add((Component)this.progressBar, gridBagConstraints);
        this.graphPanel = new JPanel();
        this.graphPanel.setLayout(new BorderLayout(0, 0));
        this.graphPanel.setVisible(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel16.add((Component)this.graphPanel, gridBagConstraints);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    @Override
    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

