/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.utmutils.swing.dialog;

import biz.netup.utmutils.control.Logger;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.control.print.JComponentVista;
import biz.netup.utmutils.control.trayicon.UTMTrayIcon;
import biz.netup.utmutils.swing.localization.ResourceBundleWrapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PrintDialog
extends JDialog {
    private JPanel panel1;
    private JSpinner spinner1;
    private JLabel numLabel;
    private JButton closeButton;
    private JButton printButton;
    private JEditorPane editorPane1;
    private JScrollPane scrollPane;
    private JButton editButton;
    private JButton keyButton;
    private boolean landscape;
    private Vector<String> pages = new Vector();
    private int orientation;
    protected Logger log = Utils.getLogger();
    protected ResourceBundleWrapper resource = Utils.getResource();
    private Thread printThread;
    private boolean settingAP = false;
    private Object lock = new Object();
    private boolean ready = false;

    public PrintDialog(boolean bl, final Window window) {
        this.landscape = bl;
        this.$$$setupUI$$$();
        URL uRL = this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/logo32.png");
        ImageIcon imageIcon = new ImageIcon(uRL);
        if (bl) {
            this.setSize(800, 600);
        } else {
            this.setSize(600, 800);
        }
        this.setMinimumSize(this.getPreferredSize());
        this.setResizable(false);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        this.setLocation(dimension.width - dimension2.width < 0 ? 0 : (dimension.width - dimension2.width) / 2, dimension.height - dimension2.height < 0 ? 0 : (dimension.height - dimension2.height) / 2);
        this.setTitle(this.resource.getString("Print"));
        this.setIconImage(imageIcon.getImage());
        this.setContentPane(this.panel1);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.closeButton);
        this.printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrintDialog.this.print();
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrintDialog.this.setVisible(false);
                PrintDialog.this.dispose();
            }
        });
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrintDialog.this.setVisible(false);
                PrintDialog.this.dispose();
                window.setVisible(true);
            }
        });
        this.keyButton.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PrintDialog.this.enableButtons((Boolean)propertyChangeEvent.getNewValue());
            }
        });
        this.panel1.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrintDialog.this.setVisible(false);
                PrintDialog.this.dispose();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
    }

    private void print() {
        final Book book = new Book();
        final PageFormat pageFormat = new PageFormat();
        final PrinterJob printerJob = PrinterJob.getPrinterJob();
        Paper paper = new Paper();
        if (this.landscape) {
            pageFormat.setOrientation(2);
        } else {
            pageFormat.setOrientation(1);
        }
        paper.setImageableArea(35.0, 35.0, 555.0, 720.0);
        paper.setSize(612.0, 792.0);
        pageFormat.setPaper(paper);
        SwingWorker<List<Integer>, Integer> swingWorker = new SwingWorker<List<Integer>, Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected List<Integer> doInBackground() throws Exception {
                for (int i = 0; i < PrintDialog.this.pages.size(); ++i) {
                    PrintDialog.this.ready = false;
                    this.publish(i);
                    this.setProgress(i);
                    Object object = PrintDialog.this.lock;
                    synchronized (object) {
                        while (!PrintDialog.this.ready) {
                            PrintDialog.this.lock.wait();
                        }
                    }
                    Thread.sleep(1000L);
                }
                printerJob.setPageable(book);
                if (printerJob.printDialog()) {
                    try {
                        printerJob.print();
                    }
                    catch (PrinterException printerException) {
                        Utils.getLogger().error(printerException);
                    }
                }
                UTMTrayIcon.getInstance().removePrintProcess();
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void process(List<Integer> list) {
                for (Integer n : list) {
                    PrintDialog.this.setActivePage(n + 1);
                    JComponentVista jComponentVista = new JComponentVista(PrintDialog.this.editorPane1, pageFormat);
                    if (PrintDialog.this.landscape) {
                        jComponentVista.scaleToFit(false);
                    } else {
                        jComponentVista.scaleToFit(true);
                    }
                    book.append(jComponentVista.getPrintable(0), pageFormat, 1);
                    Object object = PrintDialog.this.lock;
                    synchronized (object) {
                        PrintDialog.this.ready = true;
                        PrintDialog.this.lock.notifyAll();
                    }
                }
            }
        };
        UTMTrayIcon.getInstance().addPrintProcess(this.keyButton, swingWorker);
        swingWorker.execute();
    }

    private void print2() {
        final PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (printerJob.printDialog()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < PrintDialog.this.pages.size(); ++i) {
                        PrintDialog.this.setActivePage(i + 1);
                        PageFormat pageFormat = new PageFormat();
                        Paper paper = new Paper();
                        if (PrintDialog.this.landscape) {
                            pageFormat.setOrientation(2);
                        } else {
                            pageFormat.setOrientation(1);
                        }
                        paper.setImageableArea(35.0, 35.0, 555.0, 720.0);
                        paper.setSize(612.0, 792.0);
                        pageFormat.setPaper(paper);
                        JComponentVista jComponentVista = new JComponentVista(PrintDialog.this.editorPane1, pageFormat);
                        if (PrintDialog.this.landscape) {
                            jComponentVista.scaleToFit(false);
                        } else {
                            jComponentVista.scaleToFit(true);
                        }
                        printerJob.setPageable(jComponentVista);
                        try {
                            printerJob.print();
                            continue;
                        }
                        catch (PrinterException printerException) {
                            Utils.getLogger().error(printerException);
                        }
                    }
                }
            });
        }
    }

    private void enableButtons(boolean bl) {
        this.spinner1.setEnabled(bl);
        this.printButton.setEnabled(bl);
        this.editButton.setEnabled(bl);
        this.closeButton.setEnabled(bl);
    }

    private void createUIComponents() {
        this.spinner1 = new JSpinner(new SpinnerNumberModel(0, 0, 0, 1));
        this.spinner1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!PrintDialog.this.settingAP) {
                    PrintDialog.this.setActivePage((Integer)PrintDialog.this.spinner1.getValue());
                }
            }
        });
        this.keyButton = new JButton();
    }

    public void addPage(String string) {
        this.pages.add(string);
        this.setActivePage(1);
        this.spinner1.setModel(new SpinnerNumberModel(1, 1, this.pages.size(), 1));
        this.numLabel.setText("" + this.pages.size());
    }

    private void setActivePage(int n) {
        this.settingAP = true;
        this.spinner1.setValue(n);
        this.editorPane1 = new JEditorPane();
        this.scrollPane.setViewportView(this.editorPane1);
        this.editorPane1.setContentType("text/html");
        this.editorPane1.setEditable(false);
        this.editorPane1.setText(this.pages.get(n - 1));
        this.editorPane1.repaint();
        this.editorPane1.scrollRectToVisible(new Rectangle(0, 0, 0, 0));
        this.editorPane1.setCaretPosition(0);
        this.settingAP = false;
    }

    public JButton getEditButton() {
        return this.editButton;
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.panel1 = new JPanel();
        this.panel1.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.panel1.add((Component)jPanel, gridBagConstraints);
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Page"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 30;
        jPanel.add((Component)this.spinner1, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("of"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        this.numLabel = new JLabel();
        this.numLabel.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.numLabel, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jPanel6, gridBagConstraints);
        this.closeButton = new JButton();
        this.$$$loadButtonText$$$(this.closeButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Close"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)this.closeButton, gridBagConstraints);
        this.printButton = new JButton();
        this.$$$loadButtonText$$$(this.printButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Print"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)this.printButton, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)jPanel7, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)jPanel8, gridBagConstraints);
        JPanel jPanel9 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel6.add((Component)jPanel9, gridBagConstraints);
        this.editButton = new JButton();
        this.$$$loadButtonText$$$(this.editButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Edit"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)this.editButton, gridBagConstraints);
        JPanel jPanel10 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel6.add((Component)jPanel10, gridBagConstraints);
        JPanel jPanel11 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel6.add((Component)jPanel11, gridBagConstraints);
        JPanel jPanel12 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.panel1.add((Component)jPanel12, gridBagConstraints);
        JPanel jPanel13 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.panel1.add((Component)jPanel13, gridBagConstraints);
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout(new BorderLayout(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.panel1.add((Component)jPanel14, gridBagConstraints);
        jPanel14.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLoweredBevelBorder(), null));
        this.scrollPane = new JScrollPane();
        jPanel14.add((Component)this.scrollPane, "Center");
        this.editorPane1 = new JEditorPane();
        this.scrollPane.setViewportView(this.editorPane1);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.panel1;
    }
}

