/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.utmutils.swing.context;

import biz.netup.utmutils.control.trayicon.UTMTrayIcon;
import biz.netup.utmutils.swing.context.CopyAction;
import biz.netup.utmutils.swing.context.CutAction;
import biz.netup.utmutils.swing.context.DeleteAction;
import biz.netup.utmutils.swing.context.PasteAction;
import biz.netup.utmutils.swing.context.SelectAllAction;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class MyEventQueue
extends EventQueue {
    @Override
    protected void dispatchEvent(AWTEvent aWTEvent) {
        super.dispatchEvent(aWTEvent);
        if (!(aWTEvent instanceof MouseEvent)) {
            return;
        }
        if (UTMTrayIcon.getInstance().isPrinting()) {
            return;
        }
        MouseEvent mouseEvent = (MouseEvent)aWTEvent;
        if (!mouseEvent.isPopupTrigger()) {
            return;
        }
        Component component = null;
        try {
            component = SwingUtilities.getDeepestComponentAt(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
        if (!(component instanceof JTextComponent)) {
            return;
        }
        if (MenuSelectionManager.defaultManager().getSelectedPath().length > 0) {
            return;
        }
        JTextComponent jTextComponent = (JTextComponent)component;
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new CutAction(jTextComponent));
        jPopupMenu.add(new CopyAction(jTextComponent));
        jPopupMenu.add(new PasteAction(jTextComponent));
        jPopupMenu.add(new DeleteAction(jTextComponent));
        jPopupMenu.addSeparator();
        jPopupMenu.add(new SelectAllAction(jTextComponent));
        Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), jTextComponent);
        jPopupMenu.show(jTextComponent, point.x, point.y);
    }
}

