/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.utmutils.control.trayicon;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaGetMessagesListNew;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.gui.logindialog.LoginDialog;
import biz.netup.projects.utmadmin.gui.mainframe.MainFrame;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.swing.localization.ResourceBundleWrapper;
import java.awt.AWTException;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.SwingWorker;
import javax.swing.Timer;

public class UTMTrayIcon {
    private TrayIcon trayIcon;
    Menu frames;
    Menu processes;
    private PopupMenu popup;
    private boolean initialization;
    private JButton printerKeyButton;
    private SwingWorker pt;
    private MenuItem printing;
    private boolean isPrinting = false;
    private MenuItem main;
    private static LoginDialog ld = null;
    private Timer timer;
    private int newMessages = 0;
    private int oldMessages = 0;
    private static UTMTrayIcon instance;
    private ResourceBundleWrapper resource = Utils.getResource();
    private boolean visible = false;
    private Map<Thread, String> processList = new HashMap<Thread, String>();
    private Map<Thread, JButton> processButtons = new HashMap<Thread, JButton>();
    private Map<JFrame, String> frameList = new HashMap<JFrame, String>();

    public static UTMTrayIcon getInstance() {
        if (instance == null) {
            instance = new UTMTrayIcon();
        }
        return instance;
    }

    private UTMTrayIcon() {
        if (!SystemTray.isSupported()) {
            this.initialization = false;
            Utils.getLogger().log(2, "System Tray is not supported");
            return;
        }
        this.popup = new PopupMenu();
        this.main = new MenuItem(this.resource.getString("Main window"));
        this.main.setEnabled(false);
        this.frames = new Menu(this.resource.getString("Frames"));
        this.processes = new Menu(this.resource.getString("Processes"));
        this.trayIcon = new TrayIcon(UTMTrayIcon.createImage("/biz/netup/utmutils/swing/resourses/tray/tray.png"));
        this.trayIcon.setPopupMenu(this.popup);
        this.trayIcon.setImageAutoSize(true);
        this.processes.setEnabled(false);
        this.frames.setEnabled(false);
        this.popup.add(this.main);
        this.popup.add(this.frames);
        this.popup.add(this.processes);
        this.popup.addSeparator();
        this.printing = new MenuItem(this.resource.getString("Cancel printing"));
        this.printing.setEnabled(false);
        this.printing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UTMTrayIcon.this.removePrintProcess();
            }
        });
        this.popup.add(this.printing);
        this.popup.addSeparator();
        MenuItem menuItem = new MenuItem(this.resource.getString("Exit"));
        this.popup.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        this.trayIcon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ld != null) {
                    ld.toFront();
                } else {
                    MainFrame.getInstance().toFront();
                    if (UTMTrayIcon.this.newMessages > UTMTrayIcon.this.oldMessages) {
                        UTMTrayIcon.this.oldMessages = UTMTrayIcon.this.newMessages;
                        MainFrame.getInstance().openMessages();
                    } else {
                        UTMTrayIcon.this.oldMessages = UTMTrayIcon.this.newMessages;
                    }
                }
            }
        });
        this.initialization = true;
    }

    protected static Image createImage(String string) {
        URL uRL = UTMTrayIcon.class.getResource(string);
        if (uRL == null) {
            System.err.println("Resource not found: " + string);
            return null;
        }
        return new ImageIcon(uRL).getImage();
    }

    public void show() {
        if (!this.initialization) {
            return;
        }
        if (!this.visible) {
            SystemTray systemTray = SystemTray.getSystemTray();
            try {
                systemTray.add(this.trayIcon);
                this.visible = true;
            }
            catch (AWTException aWTException) {
                Utils.getLogger().log(2, "TrayIcon could not be added");
                return;
            }
        }
    }

    public void addProcess(Thread thread) {
        this.addProcess(thread, "Unknown");
    }

    public void addProcess(Thread thread, String string) {
        this.addProcess(thread, string, null);
    }

    private void revalidateProcesses() {
        this.processes.removeAll();
        for (final Thread thread : this.processList.keySet()) {
            MenuItem menuItem = new MenuItem(this.processList.get(thread));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    thread.stop();
                    UTMTrayIcon.this.removeProcess(thread);
                }
            });
            this.processes.add(menuItem);
        }
        this.processes.setEnabled(this.processList.size() > 0);
    }

    public void removeProcess(Thread thread) {
        if (!this.initialization) {
            return;
        }
        this.processList.remove(thread);
        if (this.processList.size() == 0) {
            this.setWait(false);
        }
        if (this.processButtons.containsKey(thread)) {
            this.processButtons.get(thread).setEnabled(true);
            this.processButtons.remove(thread);
        }
        this.revalidateProcesses();
    }

    private void setWait(boolean bl) {
        if (bl) {
            this.trayIcon.setImage(UTMTrayIcon.createImage("/biz/netup/utmutils/swing/resourses/tray/tray_wait.png"));
        } else {
            this.trayIcon.setImage(UTMTrayIcon.createImage("/biz/netup/utmutils/swing/resourses/tray/tray.png"));
        }
    }

    public void addProcess(Thread thread, String string, JButton jButton) {
        if (!this.initialization) {
            return;
        }
        this.processList.put(thread, string);
        if (jButton != null) {
            this.processButtons.put(thread, jButton);
            jButton.setEnabled(false);
        }
        this.setWait(true);
        this.revalidateProcesses();
    }

    public void addFrame(JFrame jFrame) {
        if (!this.initialization) {
            return;
        }
        this.frameList.put(jFrame, jFrame.getTitle());
        this.revalidateFrames();
    }

    public void removeFrame(JFrame jFrame) {
        if (!this.initialization) {
            return;
        }
        this.frameList.remove(jFrame);
        this.revalidateFrames();
    }

    private void revalidateFrames() {
        this.frames.removeAll();
        for (final JFrame jFrame : this.frameList.keySet()) {
            MenuItem menuItem = new MenuItem(this.frameList.get(jFrame));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    jFrame.toFront();
                }
            });
            this.frames.add(menuItem);
        }
        this.frames.setEnabled(this.frameList.size() > 0);
    }

    public void addPrintProcess(JButton jButton, SwingWorker swingWorker) {
        if (!this.initialization) {
            return;
        }
        this.isPrinting = true;
        this.setWait(true);
        if (jButton != null) {
            this.printerKeyButton = jButton;
            jButton.setEnabled(false);
        }
        this.pt = swingWorker;
        this.printing.setEnabled(true);
    }

    public void removePrintProcess() {
        if (!this.initialization) {
            return;
        }
        this.isPrinting = false;
        this.setWait(false);
        if (this.printerKeyButton != null) {
            this.printerKeyButton.setEnabled(true);
        }
        this.printerKeyButton = null;
        if (this.pt != null) {
            this.pt.cancel(true);
        }
        this.pt = null;
        this.printing.setEnabled(false);
    }

    public void setToolTip(String string) {
        if (!this.initialization) {
            return;
        }
        this.trayIcon.setToolTip(string);
    }

    public boolean isPrinting() {
        return this.isPrinting;
    }

    public void registerMain(final Frame frame) {
        if (!this.initialization) {
            return;
        }
        this.main.setEnabled(true);
        this.main.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                frame.toFront();
            }
        });
    }

    public void unregisterMain(Frame frame) {
        if (!this.initialization) {
            return;
        }
        this.main.setEnabled(false);
        for (ActionListener actionListener : this.main.getActionListeners()) {
            this.main.removeActionListener(actionListener);
        }
    }

    public static void regiserLogin(LoginDialog loginDialog) {
        ld = loginDialog;
    }

    public static void unregiserLogin() {
        ld = null;
    }

    public void startMessageChecking() {
        if (!this.initialization || !UrfaManagerImpl.getInstance().isPermitted(20491)) {
            return;
        }
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        this.timer = new Timer(60000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    UrfaGetMessagesListNew urfaGetMessagesListNew = new UrfaGetMessagesListNew(UrfaManagerImpl.getInstance());
                    urfaGetMessagesListNew.call();
                    int n = 0;
                    for (int n2 : urfaGetMessagesListNew.getFlag1()) {
                        if ((1 & n2) <= 0 || (0x10 & n2) != 0) continue;
                        ++n;
                    }
                    if (n > 0) {
                        UTMTrayIcon.this.newMessages = n;
                        if (UTMTrayIcon.this.newMessages > UTMTrayIcon.this.oldMessages) {
                            UTMTrayIcon.this.trayIcon.displayMessage(UTMTrayIcon.this.resource.getString("Mail"), UTMTrayIcon.this.resource.getString("You have new messages"), TrayIcon.MessageType.INFO);
                        } else {
                            UTMTrayIcon.this.oldMessages = UTMTrayIcon.this.newMessages;
                        }
                    } else {
                        UTMTrayIcon.this.oldMessages = (UTMTrayIcon.this.newMessages = 0);
                    }
                }
                catch (UrfaException urfaException) {
                    urfaException.printStackTrace();
                }
            }
        });
        this.timer.start();
    }
}

