/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.utmutils.control.resolvers;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaDealerGetEntityNameById;
import biz.netup.control.transport.urfa.functions.UrfaDealerGetKbyteSize;
import biz.netup.control.transport.urfa.functions.UrfaDealerGetTclasses;
import biz.netup.control.transport.urfa.functions.UrfaGetBytesInKb;
import biz.netup.control.transport.urfa.functions.UrfaGetDialupService;
import biz.netup.control.transport.urfa.functions.UrfaGetGroupInfo;
import biz.netup.control.transport.urfa.functions.UrfaGetGroupsList;
import biz.netup.control.transport.urfa.functions.UrfaGetHotspotService;
import biz.netup.control.transport.urfa.functions.UrfaGetIptrafficService;
import biz.netup.control.transport.urfa.functions.UrfaGetOnceServiceNew;
import biz.netup.control.transport.urfa.functions.UrfaGetPaymentMethodsList;
import biz.netup.control.transport.urfa.functions.UrfaGetPeriodicService;
import biz.netup.control.transport.urfa.functions.UrfaGetSysUser;
import biz.netup.control.transport.urfa.functions.UrfaGetSysgroup;
import biz.netup.control.transport.urfa.functions.UrfaGetSysgroupsList;
import biz.netup.control.transport.urfa.functions.UrfaGetTariff;
import biz.netup.control.transport.urfa.functions.UrfaGetTclass;
import biz.netup.control.transport.urfa.functions.UrfaGetTclasses;
import biz.netup.control.transport.urfa.functions.UrfaGetTelephonyService;
import biz.netup.control.transport.urfa.functions.UrfaGetUserinfo;
import biz.netup.control.transport.urfa.functions.UrfaGetUsersCount;
import biz.netup.control.transport.urfa.functions.UrfaGetUsersList;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.functions.dealer.custom.CurrencyFunctions;
import biz.netup.projects.utmadmin.functions.dealer.custom.PasswordFunctions;
import biz.netup.projects.utmadmin.functions.dealer.custom.PeriodFunctions;
import biz.netup.projects.utmadmin.functions.dealer.custom.TPFunctions;
import biz.netup.projects.utmadmin.functions.dealer.main.tariffication.ServiceFunctions;
import biz.netup.projects.utmadmin.functions.objects.TP;
import biz.netup.projects.utmadmin.functions.objects.UTMCurrency;
import biz.netup.utmutils.control.Settings;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.swing.localization.ResourceBundleWrapper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Vector;

public class Resolve {
    public static Map<Integer, String> userLogins;
    static Map<Integer, String> groupsNames;
    static Map<Integer, String> systemGroupsNames;
    static Map<Integer, String> tpNames;
    static Map<Integer, String> servicesNames;
    static Map<Integer, TP> tpMap;
    static Map<Integer, String> pm;
    private static boolean pmInit;
    private static ResourceBundleWrapper resource;
    public static final int payment_cash = 1;
    public static final int payment_wire_transfer = 2;
    public static final int payment_card = 3;
    public static final int payment_credit = 7;
    public static final int payment_rollback = 8;
    public static final int not_blocked = 0;
    public static final int blocked_0 = 1;
    public static final int unabon_0 = 2;
    public static final int unprepay_0 = 4;
    public static final int blocked_1 = 16;
    public static final int unabon_1 = 32;
    public static final int unprepay_1 = 64;
    public static final int blocked_2 = 256;
    public static final int unabon_2 = 512;
    public static final int unprepay_2 = 1024;
    public static final int not_change = 8192;
    public static final int wb_gluck = 0;
    public static final int wb_user = 1;
    public static final int wb_account = 2;
    public static final int wb_slink = 3;
    public static final int bt_gluk = -1;
    public static final int bt_user = 0;
    public static final int bt_system = 1;
    public static final int bt_admin = 2;
    private static Map<Integer, String> tclassMap;
    private static boolean tcFirstTime;
    public static UTMCurrency[] curList;

    public static String getPMName(int n) {
        if (!pmInit) {
            Resolve.initPM();
            pmInit = true;
        }
        if (n == 1) {
            return Utils.getResource().getString("Cash in office");
        }
        if (n == 2) {
            return Utils.getResource().getString("Wire transfer");
        }
        if (n == 3) {
            return Utils.getResource().getString("Cash via card");
        }
        if (n == 7) {
            return Utils.getResource().getString("Credit");
        }
        if (n == 8) {
            return Utils.getResource().getString("Payment rollback");
        }
        if (pm.containsKey(n)) {
            return pm.get(n) + " (" + n + ")";
        }
        return "(" + n + ")";
    }

    private static void initPM() {
        UrfaGetPaymentMethodsList urfaGetPaymentMethodsList = new UrfaGetPaymentMethodsList(UrfaManagerImpl.getInstance());
        try {
            urfaGetPaymentMethodsList.call();
            for (int i = 0; i < urfaGetPaymentMethodsList.getPaymentsListCount(); ++i) {
                pm.put(urfaGetPaymentMethodsList.getId1()[i], urfaGetPaymentMethodsList.getName1()[i]);
            }
        }
        catch (UrfaException urfaException) {
            // empty catch block
        }
    }

    private static void initGroupNames() throws UrfaException {
        groupsNames = new HashMap<Integer, String>();
        UrfaGetGroupsList urfaGetGroupsList = new UrfaGetGroupsList(UrfaManagerImpl.getInstance());
        urfaGetGroupsList.call();
        for (int i = 0; i < urfaGetGroupsList.getGroupsCount(); ++i) {
            groupsNames.put(urfaGetGroupsList.getGroupId1()[i], urfaGetGroupsList.getGroupName1()[i]);
        }
    }

    public static String getGroupName(int n) {
        if (groupsNames == null) {
            try {
                Resolve.initGroupNames();
            }
            catch (UrfaException urfaException) {
                Utils.getLogger().log(10, "Cannot init groups");
            }
        }
        if (groupsNames.containsKey(n)) {
            return groupsNames.get(n);
        }
        UrfaGetGroupInfo urfaGetGroupInfo = new UrfaGetGroupInfo(UrfaManagerImpl.getInstance());
        urfaGetGroupInfo.setGroupId(n);
        try {
            urfaGetGroupInfo.call();
            groupsNames.put(n, urfaGetGroupInfo.getGroupName());
            return urfaGetGroupInfo.getGroupName();
        }
        catch (UrfaException urfaException) {
            return "(" + n + ")";
        }
    }

    private static void initSystemGroupNames() throws UrfaException {
        systemGroupsNames = new HashMap<Integer, String>();
        UrfaGetSysgroupsList urfaGetSysgroupsList = new UrfaGetSysgroupsList(UrfaManagerImpl.getInstance());
        urfaGetSysgroupsList.call();
        for (int i = 0; i < urfaGetSysgroupsList.getGroupsSize(); ++i) {
            systemGroupsNames.put(urfaGetSysgroupsList.getGroupId1()[i], urfaGetSysgroupsList.getGroupName1()[i]);
        }
    }

    public static String getSystemGroupName(int n) {
        if (systemGroupsNames == null) {
            try {
                Resolve.initSystemGroupNames();
            }
            catch (UrfaException urfaException) {
                Utils.getLogger().log(10, "Cannot init system groups");
            }
        }
        if (systemGroupsNames.containsKey(n)) {
            return systemGroupsNames.get(n);
        }
        UrfaGetSysgroup urfaGetSysgroup = new UrfaGetSysgroup(UrfaManagerImpl.getInstance());
        urfaGetSysgroup.setGroupId(n);
        try {
            urfaGetSysgroup.call();
            systemGroupsNames.put(n, urfaGetSysgroup.getGroupName());
            return urfaGetSysgroup.getGroupName();
        }
        catch (UrfaException urfaException) {
            return "(" + n + ")";
        }
    }

    public static String getUserName(int n) {
        if (userLogins == null) {
            try {
                Resolve.initUserLogins();
            }
            catch (UrfaException urfaException) {
                Utils.getLogger().log(10, "Cannot init system groups");
            }
        }
        if (n == 0) {
            return resource.getString("System") + " (0)";
        }
        if (userLogins.containsKey(n)) {
            return userLogins.get(n) + " (" + n + ")";
        }
        String string = "";
        if (!Utils.isAdmin()) {
            UrfaDealerGetEntityNameById urfaDealerGetEntityNameById = new UrfaDealerGetEntityNameById(UrfaManagerImpl.getInstance());
            urfaDealerGetEntityNameById.setEntityId(n);
            urfaDealerGetEntityNameById.setEntityType(1);
            try {
                urfaDealerGetEntityNameById.call();
                string = urfaDealerGetEntityNameById.getEntityName();
            }
            catch (UrfaException urfaException) {}
        } else if (n > 0) {
            UrfaGetUserinfo urfaGetUserinfo = new UrfaGetUserinfo(UrfaManagerImpl.getInstance());
            urfaGetUserinfo.setUserId(n);
            try {
                urfaGetUserinfo.call();
                string = urfaGetUserinfo.getLogin();
            }
            catch (UrfaException urfaException) {}
        } else {
            UrfaGetSysUser urfaGetSysUser = new UrfaGetSysUser(UrfaManagerImpl.getInstance());
            urfaGetSysUser.setUserId(n);
            try {
                urfaGetSysUser.call();
                string = urfaGetSysUser.getLogin();
            }
            catch (UrfaException urfaException) {
                // empty catch block
            }
        }
        userLogins.put(n, string);
        string = string + " (" + n + ")";
        return string;
    }

    private static void initUserLogins() throws UrfaException {
        userLogins = new HashMap<Integer, String>();
        if (Utils.isAdmin() && UrfaManagerImpl.getInstance().isPermitted(new int[]{8209, 8193})) {
            UrfaGetUsersCount urfaGetUsersCount = new UrfaGetUsersCount(UrfaManagerImpl.getInstance());
            urfaGetUsersCount.setCardUser(0);
            urfaGetUsersCount.call();
            UrfaGetUsersList urfaGetUsersList = new UrfaGetUsersList(UrfaManagerImpl.getInstance());
            urfaGetUsersList.setCardUser(0);
            urfaGetUsersList.setFrom(0);
            urfaGetUsersList.setTo(urfaGetUsersCount.getCount());
            urfaGetUsersList.call();
            for (int i = 0; i < urfaGetUsersList.getCnt(); ++i) {
                userLogins.put(urfaGetUsersList.getUserIdArray1()[i], urfaGetUsersList.getLoginArray1()[i]);
            }
        }
    }

    public static TP getTP(int n) throws UrfaException {
        if (tpMap.containsKey(n)) {
            return tpMap.get(n);
        }
        return TPFunctions.getTp(n);
    }

    private static void initTPNames() throws UrfaException {
        tpNames = new HashMap<Integer, String>();
        for (TP tP : TPFunctions.getTPList()) {
            tpNames.put(tP.getTariffId(), tP.getTariffName());
        }
    }

    public static String getTPName(int n) throws UrfaException {
        if (tpNames == null) {
            try {
                Resolve.initTPNames();
            }
            catch (UrfaException urfaException) {
                Utils.getLogger().log(10, "Cannot init tps");
            }
        }
        if (tpNames.containsKey(n)) {
            return tpNames.get(n);
        }
        String string = TPFunctions.getTp(n).getTariffName();
        tpNames.put(n, string);
        return string;
    }

    private static void initServicesNames() throws UrfaException {
        servicesNames = new HashMap<Integer, String>();
        for (Map<String, Object> map : ServiceFunctions.getServicesList(1)) {
            servicesNames.put((Integer)map.get("id"), (String)map.get("name"));
        }
    }

    public static String getServiceName(int n) throws UrfaException {
        if (servicesNames == null) {
            try {
                Resolve.initServicesNames();
            }
            catch (UrfaException urfaException) {
                Utils.getLogger().log(10, "Cannot init services");
            }
        }
        if (servicesNames.containsKey(n)) {
            return servicesNames.get(n);
        }
        String string = "";
        for (Map<String, Object> map : ServiceFunctions.getServicesList(1)) {
            if (!map.get("id").equals(n)) continue;
            string = (String)map.get("name");
            servicesNames.put(n, string);
        }
        return string;
    }

    public static String getAPName(int n) {
        if (n == 1) {
            return Utils.getResource().getString("Never expired") + " (1)";
        }
        try {
            for (Map<String, Object> map : PeriodFunctions.getPeriodsList()) {
                if (n != (Integer)map.get("serial_id")) continue;
                return "" + map.get("name");
            }
            return "(" + n + ")";
        }
        catch (UrfaException urfaException) {
            return "(" + n + ")";
        }
    }

    public static String getTemplateType(int n) {
        switch (n) {
            case 2: {
                return resource.getString("User's info sheet");
            }
            case 3: {
                return resource.getString("Contract");
            }
            case 4: {
                return resource.getString("Receipt");
            }
            case 5: {
                return resource.getString("Invoice");
            }
            case 6: {
                return resource.getString("Tax invoice");
            }
            case 7: {
                return resource.getString("Report of completion for individual");
            }
            case 8: {
                return resource.getString("Report of completion for legal person");
            }
            case 9: {
                return resource.getString("Individual invoice");
            }
            case 10: {
                return resource.getString("User IP row");
            }
            case 11: {
                return resource.getString("User Tel row");
            }
            case 12: {
                return resource.getString("User Dialup row");
            }
            case 13: {
                return resource.getString("User IP table");
            }
            case 14: {
                return resource.getString("User Tel table");
            }
            case 15: {
                return resource.getString("User Dialup table");
            }
            case 16: {
                return resource.getString("Invoice row");
            }
            case 17: {
                return resource.getString("Account invoice row");
            }
            case 18: {
                return resource.getString("Individual invoice row");
            }
            case 19: {
                return resource.getString("Individual end of work row");
            }
            case 20: {
                return resource.getString("Legal end of work row");
            }
            case 21: {
                return resource.getString("Invoice table");
            }
            case 22: {
                return resource.getString("Account invoice table");
            }
            case 23: {
                return resource.getString("Individual end of work table");
            }
            case 24: {
                return resource.getString("Legal end of work table");
            }
            case 25: {
                return resource.getString("Web invoice");
            }
            case 26: {
                return resource.getString("Web individual invoice");
            }
            case 27: {
                return resource.getString("Web receipt");
            }
        }
        return "" + n;
    }

    public static String getTCname(int n) {
        if (n == 0) {
            return resource.getString("Undefined") + " (0)";
        }
        if (tcFirstTime) {
            Resolve.updateTClasses();
            tcFirstTime = false;
        }
        if (tclassMap.containsKey(n)) {
            return tclassMap.get(n) + " (" + n + ")";
        }
        return "(" + n + ")";
    }

    public static void updateTClasses() {
        if (Utils.isAdmin()) {
            UrfaGetTclasses urfaGetTclasses = new UrfaGetTclasses(UrfaManagerImpl.getInstance());
            try {
                urfaGetTclasses.call();
                for (int i = 0; i < urfaGetTclasses.getTclassListSize(); ++i) {
                    tclassMap.put(urfaGetTclasses.getTclassId1()[i], urfaGetTclasses.getTclassName1()[i]);
                }
            }
            catch (UrfaException urfaException) {}
        } else {
            UrfaDealerGetTclasses urfaDealerGetTclasses = new UrfaDealerGetTclasses(UrfaManagerImpl.getInstance());
            try {
                urfaDealerGetTclasses.call();
                for (int i = 0; i < urfaDealerGetTclasses.getTclassListSize(); ++i) {
                    tclassMap.put(urfaDealerGetTclasses.getTclassId1()[i], urfaDealerGetTclasses.getTclassName1()[i]);
                }
            }
            catch (UrfaException urfaException) {
                // empty catch block
            }
        }
    }

    public static int getTCColour(int n) {
        UrfaGetTclass urfaGetTclass = new UrfaGetTclass(UrfaManagerImpl.getInstance());
        urfaGetTclass.setTclassId(n);
        try {
            urfaGetTclass.call();
            return urfaGetTclass.getGraphColor();
        }
        catch (UrfaException urfaException) {
            return 0;
        }
    }

    public static String getICUserStatus(int n) {
        switch (n) {
            case 0: {
                return resource.getString("Not syncronized");
            }
            case 1: {
                return resource.getString("Syncronized");
            }
            case 2: {
                return resource.getString("Unsyncronized");
            }
        }
        return "";
    }

    public static String getICInvoiceStatus(int n) {
        switch (n) {
            case 0: {
                return resource.getString("Not syncronized");
            }
            case 1: {
                return resource.getString("Partly syncronized");
            }
            case 2: {
                return resource.getString("Syncronized");
            }
        }
        return "";
    }

    public static String getICPaymentStatus(int n) {
        switch (n) {
            case 0: {
                return resource.getString("Not syncronized");
            }
            case 1: {
                return resource.getString("Sent to 1C");
            }
            case 2: {
                return resource.getString("Recieved from 1C");
            }
        }
        return "";
    }

    public static String getSessionType(int n) {
        switch (n) {
            case 0: {
                return resource.getString("URFA");
            }
            case 1: {
                return resource.getString("Stream");
            }
            case 2: {
                return resource.getString("SocketConnection");
            }
        }
        return "";
    }

    public static String getLicenseName(int n) {
        switch (n) {
            case 1: {
                return resource.getString("CORE MODULE");
            }
            case 2: {
                return resource.getString("RADIUS MODULE");
            }
            case 3: {
                return resource.getString("TEL MODULE");
            }
            case 4: {
                return resource.getString("HOTSPOT MODULE");
            }
            case 5: {
                return resource.getString("DYNASHAPE MODULE");
            }
            case 6: {
                return resource.getString("URFACLIENT MODULE");
            }
            case 7: {
                return resource.getString("DEALER MODULE");
            }
            case 8: {
                return resource.getString("1C MODULE");
            }
        }
        return "";
    }

    public static String getLicenseValueName(int n) {
        switch (n) {
            case 1: {
                return "MAX_USERS";
            }
            case 2: {
                return "MAX_ACCOUNTS";
            }
            case 3: {
                return "MAX_ONCE_LINKS";
            }
            case 4: {
                return "MAX_PERIODIC_LINKS";
            }
            case 5: {
                return "MAX_IP_LINKS";
            }
            case 6: {
                return "MAX_TEL_LINKS";
            }
            case 7: {
                return "MAX_HOTSPOT_LINKS";
            }
            case 8: {
                return "MAX_DIALUP_LINKS";
            }
            case 9: {
                return "MAX_NF_RECORDS";
            }
            case 10: {
                return "MAX_RADIUS_AUTH";
            }
            case 11: {
                return "MAX_RADIUS_ACCT";
            }
            case 12: {
                return "RPCF_LIST";
            }
            case 13: {
                return "MAX_DYNA_RULES";
            }
            case 14: {
                return "MAX_DEALER_USERS";
            }
            case 15: {
                return "MAX_DEALER_SERVICES";
            }
            case 16: {
                return "MAX_DEALER_TARIFFS";
            }
            case 17: {
                return "MAX_DEALER_PERIODS";
            }
            case 18: {
                return "MAX_HOTSPOT_SESSIONS";
            }
            case 19: {
                return "MAX_HOTSPOT_AUTH";
            }
            case 20: {
                return "MAX_HOTSPOT_USERS";
            }
            case 21: {
                return "EVENT_LIST";
            }
        }
        return "";
    }

    public static String getSessionStatusName(int n) {
        if (n == 1) {
            return Utils.getResource().getString("Session open") + " (" + n + ")";
        }
        if (n == 2) {
            return Utils.getResource().getString("Session close") + " (" + n + ")";
        }
        if (n == 3) {
            return Utils.getResource().getString("Session updated") + " (" + n + ")";
        }
        return Utils.getResource().getString("Status unknown") + " (" + n + ")";
    }

    public static String getServiceTypeName(int n) {
        if (n == 1) {
            return Utils.getResource().getString("One time");
        }
        if (n == 2) {
            return Utils.getResource().getString("Periodic");
        }
        if (n == 3) {
            return Utils.getResource().getString("IP-traffic");
        }
        if (n == 4) {
            return Utils.getResource().getString("Hotspot");
        }
        if (n == 5) {
            return Utils.getResource().getString("Dial-UP");
        }
        if (n == 6) {
            return Utils.getResource().getString("Telephony");
        }
        return "" + n;
    }

    public static String getSystemUserLoginById(int n) {
        if (!Utils.isAdmin()) {
            UrfaDealerGetEntityNameById urfaDealerGetEntityNameById = new UrfaDealerGetEntityNameById(UrfaManagerImpl.getInstance());
            urfaDealerGetEntityNameById.setEntityType(1);
            urfaDealerGetEntityNameById.setEntityId(n);
            try {
                urfaDealerGetEntityNameById.call();
            }
            catch (Exception exception) {
                return Integer.toString(n);
            }
            return urfaDealerGetEntityNameById.getEntityName() + "(" + n + ")";
        }
        return Integer.toString(n);
    }

    public static String getStatus(int n) {
        switch (n) {
            case 1: {
                return Utils.getResource().getString("Not blocked");
            }
            case 0: {
                return Utils.getResource().getString("System block");
            }
            case -1: {
                return Utils.getResource().getString("Internet off");
            }
        }
        return "";
    }

    public static int parse_currency_id(String string, Vector vector) {
        for (Object e : vector) {
            Vector vector2 = (Vector)e;
            if (string.compareTo((String)vector2.get(1)) != 0) continue;
            return Integer.parseInt((String)vector2.get(0));
        }
        return 0;
    }

    public static String get_currency_name(int n, Vector vector) {
        for (Object e : vector) {
            Vector vector2 = (Vector)e;
            if (n != Integer.parseInt((String)vector2.get(0))) continue;
            return (String)vector2.get(1);
        }
        return "[unknown]";
    }

    public static int parse_bank_id(String string, Vector vector) {
        for (Object e : vector) {
            Vector vector2 = (Vector)e;
            if (((String)vector2.get(2)).compareTo(string) != 0) continue;
            return Integer.valueOf((String)vector2.get(0));
        }
        return 0;
    }

    public static String get_bank_name(int n, Vector vector) {
        for (Object e : vector) {
            Vector vector2 = (Vector)e;
            if (Integer.valueOf(String.valueOf(vector2.get(0))) != n) continue;
            return (String)vector2.get(2);
        }
        return "[no bank]";
    }

    public static String get_contract_name(int n, Vector vector) {
        for (Object e : vector) {
            Vector vector2 = (Vector)e;
            if (Integer.valueOf(String.valueOf(vector2.get(0))) != n) continue;
            return (String)vector2.get(1);
        }
        return "[no contract]";
    }

    public static int parse_group_id(String string, Vector vector) {
        for (Object e : vector) {
            Vector vector2 = (Vector)e;
            if (string.compareTo((String)vector2.get(1)) != 0) continue;
            return (Integer)vector2.get(0);
        }
        return 0;
    }

    public static String get_group_name(int n, Vector vector) {
        for (Object e : vector) {
            Vector vector2 = (Vector)e;
            if ((Integer)vector2.get(0) != n) continue;
            return (String)vector2.get(1);
        }
        return "[no group]";
    }

    public static String mask_toString(int n) {
        int n2 = 0;
        int n3 = n;
        for (int i = 0; i < 32 && (n3 & 1) == 0; ++i) {
            ++n2;
            n3 >>= 1;
        }
        return "" + (32 - n2);
    }

    public static String get_contract_text(String string, Vector vector) {
        for (Object e : vector) {
            Vector vector2 = (Vector)e;
            if (((String)vector2.get(1)).compareTo(string) != 0) continue;
            return (String)vector2.get(3);
        }
        return "";
    }

    public static int parse_contract_id(String string, Vector vector) {
        for (Object e : vector) {
            Vector vector2 = (Vector)e;
            if (((String)vector2.get(1)).compareTo(string) != 0) continue;
            return Integer.valueOf((String)vector2.get(0));
        }
        return 0;
    }

    public static String ip_toString(int n) {
        int n2 = n & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n >> 16 & 0xFF;
        int n5 = n >> 24 & 0xFF;
        return "" + n5 + "." + n4 + "." + n3 + "." + n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int parse_ip(String string) throws Exception {
        int n;
        if (string == null || string.isEmpty()) {
            return -1;
        }
        string = string.trim();
        int n2 = (string = string.replaceAll(" ", "")).indexOf(".", 0);
        if (n2 <= 0) throw new Exception("Source addres format error");
        String string2 = string.substring(0, n2);
        if (string2.length() == 0) throw new Exception("Source addres format error");
        try {
            n = Integer.decode(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new Exception("Source address format error: " + numberFormatException.getMessage());
        }
        if (n < 0 || n > 255) {
            throw new Exception("Source addres format error");
        }
        int n3 = n << 24;
        int n4 = n2;
        if ((n2 = string.indexOf(".", n4 + 1)) <= 0) throw new Exception("Source addres format error");
        string2 = string.substring(n4 + 1, n2);
        if (string2.length() == 0) throw new Exception("Source addres format error");
        try {
            n = Integer.decode(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new Exception("Source address format error: " + numberFormatException.getMessage());
        }
        if (n < 0 || n > 255) {
            throw new Exception("Source addres format error");
        }
        n3 += n << 16;
        n4 = n2;
        if ((n2 = string.indexOf(".", n4 + 1)) <= 0) throw new Exception("Source addres format error");
        string2 = string.substring(n4 + 1, n2);
        if (string2.length() == 0) throw new Exception("Source addres format error");
        try {
            n = Integer.decode(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new Exception("Source address format error: " + numberFormatException.getMessage());
        }
        if (n < 0 || n > 255) {
            throw new Exception("Source addres format error");
        }
        n3 += n << 8;
        n4 = n2;
        if (n2 <= 0) throw new Exception("Source addres format error");
        string2 = string.substring(n4 + 1);
        int n5 = string2.indexOf(" (", 1);
        if (n5 > 0) {
            string2 = string2.substring(0, n5);
        }
        if (string2.length() == 0) throw new Exception("Source addres format error");
        try {
            n = Integer.decode(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new Exception("Source address format error: " + numberFormatException.getMessage());
        }
        if (n >= 0 && n <= 255) return n3 += n;
        throw new Exception("Source addres format error");
    }

    public static int parse_mask(String string) throws Exception {
        int n;
        try {
            string = string.replaceAll("/", "");
            n = Integer.valueOf(string);
        }
        catch (Exception exception) {
            int n2;
            try {
                n2 = Resolve.parse_ip(string);
            }
            catch (Exception exception2) {
                throw new Exception(exception2.getMessage());
            }
            int n3 = -1;
            for (int i = 0; i <= 32; ++i) {
                if (n2 == n3) {
                    return n2;
                }
                n3 <<= 1;
            }
            throw new Exception("Incorrect mask format");
        }
        if (n < 0 || n > 32) {
            throw new Exception("Mask out of range");
        }
        return -1 << 32 - n;
    }

    public static int getBlockType(int n) {
        if (n == 0) {
            return 0;
        }
        if ((n & 0x100) != 0) {
            return 1;
        }
        return 2;
    }

    public static String getBlockTypeName(int n) {
        if (n == 0) {
            return Utils.getResource().getString("No");
        }
        if ((n & 0x100) != 0) {
            if ((n & 0x200) > 0 && (n & 0x400) > 0) {
                return Utils.getResource().getString("Yes (RRF and RPR)");
            }
            if ((n & 0x200) > 0) {
                return Utils.getResource().getString("Yes (RRF)");
            }
            if ((n & 0x400) > 0) {
                return Utils.getResource().getString("Yes (RPR)");
            }
            return Utils.getResource().getString("Yes");
        }
        return Utils.getResource().getString("Yes (non admin block)");
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < 10; ++i) {
            System.out.println((1 << i) + " = " + Resolve.getBlockTypeName(1 << i));
        }
    }

    public static String getBlockTypeNameForReport(int n) {
        if (n == 0) {
            return Utils.getResource().getString("User block");
        }
        if (n == 1) {
            return Utils.getResource().getString("System block");
        }
        if (n == 2) {
            return Utils.getResource().getString("Admin block");
        }
        return "";
    }

    public static void updateCurList() {
        try {
            curList = CurrencyFunctions.getCurrencyList();
        }
        catch (UrfaException urfaException) {
            urfaException.printStackTrace();
        }
    }

    public static String getCurrencyName(int n) {
        if (curList == null) {
            return "";
        }
        for (UTMCurrency uTMCurrency : curList) {
            if (n != uTMCurrency.getId()) continue;
            return uTMCurrency.getCurrencyBriefName();
        }
        return "";
    }

    public static double do_round(int n, double d) {
        double d2 = Math.pow(10.0, n);
        return (double)Math.round(d2 * d) / d2;
    }

    public static String do_round_to_str(int n, double d) {
        double d2 = Math.pow(10.0, n);
        String string = "";
        double d3 = (double)Math.round(d2 * d) / d2;
        for (int i = 1; i < n; ++i) {
            if (Math.IEEEremainder(Math.round(d2 * d), d2 / Math.pow(10.0, i)) != 0.0) continue;
            string = string + "0";
        }
        return String.valueOf(new Double(d3)) + string;
    }

    public static String getPassword() {
        if ("1".equals(Settings.getValueFromPerst("UseCustomPassword"))) {
            String string = Settings.getValueFromPerst("CustomPasswordCharset");
            int n = Integer.parseInt(Settings.getValueFromPerst("CustomPasswordLength"));
            Random random = new Random(System.currentTimeMillis());
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                int n2 = random.nextInt(string.length());
                stringBuffer.append(string.charAt(n2));
            }
            return stringBuffer.toString();
        }
        return PasswordFunctions.getPassword(8);
    }

    public static int getBytesInKb() {
        int n;
        try {
            if (Utils.isAdmin()) {
                UrfaGetBytesInKb urfaGetBytesInKb = new UrfaGetBytesInKb(UrfaManagerImpl.getInstance());
                urfaGetBytesInKb.call();
                n = urfaGetBytesInKb.getBytesInKb();
            } else {
                UrfaDealerGetKbyteSize urfaDealerGetKbyteSize = new UrfaDealerGetKbyteSize(UrfaManagerImpl.getInstance());
                urfaDealerGetKbyteSize.call();
                n = urfaDealerGetKbyteSize.getKbyteSize();
            }
        }
        catch (UrfaException urfaException) {
            Utils.getLogger().log(1, "Error upload 'bytes in kb'");
            n = 1024;
        }
        return n;
    }

    public static boolean checkTP(int n, int n2) throws UrfaException {
        int n3;
        if (!Utils.isAdmin()) {
            return true;
        }
        if (n <= 0 || n2 <= 0) {
            return true;
        }
        UrfaGetTariff urfaGetTariff = new UrfaGetTariff(UrfaManagerImpl.getInstance());
        urfaGetTariff.setTariffId(n);
        urfaGetTariff.call();
        UrfaGetTariff urfaGetTariff2 = new UrfaGetTariff(UrfaManagerImpl.getInstance());
        urfaGetTariff2.setTariffId(n2);
        urfaGetTariff2.call();
        if (urfaGetTariff.getServicesCount() != urfaGetTariff2.getServicesCount()) {
            return false;
        }
        int n4 = urfaGetTariff.getServicesCount();
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            nArray[n3] = Resolve.getParentService(urfaGetTariff.getServiceIdArray1()[n3], urfaGetTariff.getServiceTypeArray1()[n3]);
            nArray2[n3] = Resolve.getParentService(urfaGetTariff2.getServiceIdArray1()[n3], urfaGetTariff.getServiceTypeArray1()[n3]);
        }
        Arrays.sort(nArray);
        Arrays.sort(nArray2);
        for (n3 = 0; n3 < n4; ++n3) {
            if (nArray[n3] == nArray2[n3] && nArray[n3] != -1) continue;
            return false;
        }
        return true;
    }

    private static int getParentService(int n, int n2) throws UrfaException {
        switch (n2) {
            case 1: {
                UrfaGetOnceServiceNew urfaGetOnceServiceNew = new UrfaGetOnceServiceNew(UrfaManagerImpl.getInstance());
                urfaGetOnceServiceNew.setSid(n);
                urfaGetOnceServiceNew.call();
                return urfaGetOnceServiceNew.getParentId();
            }
            case 2: {
                UrfaGetPeriodicService urfaGetPeriodicService = new UrfaGetPeriodicService(UrfaManagerImpl.getInstance());
                urfaGetPeriodicService.setSid(n);
                urfaGetPeriodicService.call();
                return urfaGetPeriodicService.getParentId();
            }
            case 3: {
                UrfaGetIptrafficService urfaGetIptrafficService = new UrfaGetIptrafficService(UrfaManagerImpl.getInstance());
                urfaGetIptrafficService.setSid(n);
                urfaGetIptrafficService.call();
                return urfaGetIptrafficService.getParentId();
            }
            case 4: {
                UrfaGetHotspotService urfaGetHotspotService = new UrfaGetHotspotService(UrfaManagerImpl.getInstance());
                urfaGetHotspotService.setSid(n);
                urfaGetHotspotService.call();
                return urfaGetHotspotService.getParentId();
            }
            case 5: {
                UrfaGetDialupService urfaGetDialupService = new UrfaGetDialupService(UrfaManagerImpl.getInstance());
                urfaGetDialupService.setSid(n);
                urfaGetDialupService.call();
                return urfaGetDialupService.getParentId();
            }
            case 6: {
                UrfaGetTelephonyService urfaGetTelephonyService = new UrfaGetTelephonyService(UrfaManagerImpl.getInstance());
                urfaGetTelephonyService.setServiceId(n);
                urfaGetTelephonyService.call();
                return urfaGetTelephonyService.getParentId();
            }
        }
        return -1;
    }

    static {
        tpMap = new HashMap<Integer, TP>();
        pm = new HashMap<Integer, String>();
        pmInit = false;
        resource = Utils.getResource();
        tclassMap = new HashMap<Integer, String>();
        tcFirstTime = true;
    }
}

