/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.utmutils.control.permissions;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaGetSysgroup;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.utmutils.control.Logger;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.control.permissions.PermFunc;
import biz.netup.utmutils.control.permissions.PermGroup;
import biz.netup.utmutils.control.permissions.Permission;
import biz.netup.utmutils.swing.checkboxtree.CheckTreeManager;
import biz.netup.utmutils.swing.localization.ResourceBundleWrapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class Permissions {
    static Logger log = Utils.getLogger();
    JTree permissions;
    DefaultMutableTreeNode top;
    DefaultMutableTreeNode baseTop;
    DefaultMutableTreeNode mainTop;
    DefaultMutableTreeNode reportsTop;
    DefaultMutableTreeNode userTop;
    Set<Integer> functions = new HashSet<Integer>();
    Map<Integer, String> availableFunctions = new HashMap<Integer, String>();
    static Map<String, Integer[]> permissionsMap = new HashMap<String, Integer[]>();
    private ResourceBundleWrapper resource = Utils.getResource();
    private CheckTreeManager checkTreeManager;
    private static Permissions INSTANCE;

    public CheckTreeManager getCheckTreeManager() {
        return this.checkTreeManager;
    }

    public Set<Integer> getFunctions() {
        return this.functions;
    }

    private Permissions() {
        if (Utils.isAdmin()) {
            this.top = new DefaultMutableTreeNode(new PermGroup(this.resource.getString("All")));
            this.baseTop = new DefaultMutableTreeNode(new PermGroup(this.resource.getString("Base")));
            this.mainTop = new DefaultMutableTreeNode(new PermGroup(this.resource.getString("Main window")));
            this.reportsTop = new DefaultMutableTreeNode(new PermGroup(this.resource.getString("Reports")));
            this.userTop = new DefaultMutableTreeNode(new PermGroup(this.resource.getString("User")));
            this.permissions = new JTree(this.top);
            this.top.add(this.baseTop);
            this.top.add(this.mainTop);
            this.top.add(this.userTop);
            this.top.add(this.reportsTop);
            this.checkTreeManager = new CheckTreeManager(this.permissions);
            this.fillListOfAvailableFunc();
            this.addBasePermissions();
        }
    }

    private void addBasePermissions() {
        this.addPerm(new Permission("base", "Base", "All", new Integer[]{17418, 69, 70, 69906}));
    }

    public void addAdditionslPermissions() {
        this.addPerm(new Permission("prepaid_sl", "Prepaid traffic", "Service links", new Integer[]{8960, 21760, 21761}));
        this.addPerm(new Permission("radius_sl", "Set RADIUS", "Service links", new Integer[]{65793, 65792}));
        this.addPerm(new Permission("history_tl", "History", "Tariff links", new Integer[]{12316}), 2);
        this.addPerm(new Permission("add_sl_tl", "Add SL", "Tariff links", new Integer[]{12314, 69906, 9553, 9728, 20482, 8198, 17419, 10259, 65538, 8960}), 2);
        this.addPerm(new Permission("link_to_dealer", "Link to dealer", "Dealers", new Integer[]{77849, 77850}), 2);
        this.addPerm(new Permission("generate_doc", "Generate document for user", "User", new Integer[]{28720}), 2);
        this.addPerm(new Permission("contract_sign", "Sign contract", "Contracts", new Integer[]{28724}), 2);
        this.addPerm(new Permission("add_user_new", "Add user", "Users", new Integer[]{96, 8485, 8241}));
        this.addPerm(new Permission("view_user", "View user", "Users", new Integer[]{8198, 17419, 17417, 20482, 10512, 36897, 36866}));
        this.addPerm(new Permission("edit_user", "Edit user", "Users", new Integer[]{8198, 17419, 17417, 20482, 10512, 36897, 36866, 8486}));
        this.addPerm(new Permission("delete_user", "Add user", "Users", new Integer[]{8206}));
        this.addPerm(new Permission("search_user", "Search users", "Users", new Integer[]{4613}));
        this.addPerm(new Permission("new_payment", "New payment", "Users", new Integer[]{69906, 8198, 17419, 10512, 12544, 12563}));
        this.addPerm(new Permission("payment_for_invoice", "Payment for invoice", "Users", new Integer[]{32770}));
        this.addPerm(new Permission("add_to_group", "Add to group", "Users", new Integer[]{9216, 9223}));
        this.addPerm(new Permission("change_intstat_for_user", "Change Internet status", "Users", new Integer[]{8195}));
        this.addPerm(new Permission("liburfa-load", "Liburfa-load", "LibURFA Plugins", new Integer[]{65}));
        this.addPerm(new Permission("liburfa-unload", "Liburfa-unload", "LibURFA Plugins", new Integer[]{66}));
        this.addPerm(new Permission("liburfa-reload", "Liburfa-reload", "LibURFA Plugins", new Integer[]{67}));
        this.addPerm(new Permission("update_templates_from_db", "Update templates from DB", "Templates of documents", new Integer[]{28727}));
        this.addPerm(new Permission("set_default_doc_template", "Set default document template", "Templates of documents", new Integer[]{28709}));
        this.addPerm(new Permission("save_sup", "Save provider", "Provider", new Integer[]{32786}));
        this.addPerm(new Permission("select_bank", "Select bank", "Provider", new Integer[]{24578}));
        if (this.isAvailable(new Integer[]{77849})) {
            this.addPerm(new Permission("", "Dealer functions", "All", new Integer[0]));
        }
        this.addPerm(new Permission("", "Cashier", "All", new Integer[0]));
        this.addPerm(new Permission("groups", "Groups", "Reports", new Integer[]{9216}));
    }

    public static boolean isInitialized() {
        return INSTANCE != null;
    }

    private void fillListOfAvailableFunc() {
        if (!UrfaManagerImpl.getInstance().isPermitted(9222)) {
            return;
        }
        UrfaGetSysgroup urfaGetSysgroup = new UrfaGetSysgroup(UrfaManagerImpl.getInstance());
        urfaGetSysgroup.setGroupId(1);
        try {
            urfaGetSysgroup.call();
            for (int i = 0; i < urfaGetSysgroup.getInfoSize(); ++i) {
                this.availableFunctions.put(urfaGetSysgroup.getId1()[i], urfaGetSysgroup.getName1()[i]);
            }
        }
        catch (UrfaException urfaException) {
            // empty catch block
        }
    }

    public static Permissions getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new Permissions();
        }
        return INSTANCE;
    }

    public void addPerm(Permission permission) {
        this.addPerm(permission, 0);
    }

    public void addPerm(Permission permission, int n) {
        block17: {
            Object object;
            block16: {
                if (!Utils.isAdmin()) {
                    return;
                }
                if (permission.name.equals("Other")) {
                    System.out.println("0x" + Integer.toHexString(permission.permissions[0]) + "  " + this.availableFunctions.get(permission.permissions[0]));
                }
                try {
                    permission.name = this.resource.getString(permission.name);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                try {
                    permission.group = this.resource.getString(permission.group);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                permissionsMap.put(permission.id, permission.permissions);
                object = permission.permissions;
                int n2 = ((Integer[])object).length;
                for (int i = 0; i < n2; ++i) {
                    int n3 = object[i];
                    this.functions.add(n3);
                }
                switch (n) {
                    case 1: {
                        object = this.mainTop;
                        break;
                    }
                    case 2: {
                        object = this.userTop;
                        break;
                    }
                    case 5: {
                        object = this.reportsTop;
                        break;
                    }
                    default: {
                        object = this.top;
                    }
                }
                DefaultMutableTreeNode defaultMutableTreeNode = this.getGroup((DefaultMutableTreeNode)object, permission.group);
                if (defaultMutableTreeNode == null) break block16;
                if (!this.isAvailable(permission.permissions)) break block17;
                DefaultMutableTreeNode defaultMutableTreeNode2 = this.getGroup(defaultMutableTreeNode, permission.name);
                if (defaultMutableTreeNode2 == null) {
                    defaultMutableTreeNode2 = new DefaultMutableTreeNode(new PermGroup(permission.name));
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                }
                Integer[] integerArray = permission.permissions;
                int n4 = integerArray.length;
                for (int i = 0; i < n4; ++i) {
                    int n5 = integerArray[i];
                    if (this.hasFunc(defaultMutableTreeNode2, this.availableFunctions.get(n5))) continue;
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new PermFunc(n5, this.availableFunctions.get(n5))));
                }
                break block17;
            }
            if (this.isAvailable(permission.permissions)) {
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new PermGroup(permission.group));
                ((DefaultMutableTreeNode)object).add(defaultMutableTreeNode);
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new PermGroup(permission.name));
                defaultMutableTreeNode.add(defaultMutableTreeNode3);
                Integer[] integerArray = permission.permissions;
                int n6 = integerArray.length;
                for (int i = 0; i < n6; ++i) {
                    int n7 = integerArray[i];
                    if (this.hasFunc(defaultMutableTreeNode3, this.availableFunctions.get(n7))) continue;
                    defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new PermFunc(n7, this.availableFunctions.get(n7))));
                }
            }
        }
    }

    public boolean isAvailable(Integer[] integerArray) {
        for (Integer n : integerArray) {
            if (this.availableFunctions.containsKey(n)) continue;
            return false;
        }
        return true;
    }

    public String getName(int n) {
        if (!this.availableFunctions.containsKey(n)) {
            return "";
        }
        return this.availableFunctions.get(n);
    }

    DefaultMutableTreeNode getGroup(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        if (defaultMutableTreeNode != null && defaultMutableTreeNode.getUserObject() instanceof PermGroup) {
            if (string.compareTo(((PermGroup)defaultMutableTreeNode.getUserObject()).getName()) == 0) {
                for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = this.getGroup((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i), string);
                    if (defaultMutableTreeNode2 == null) continue;
                    return defaultMutableTreeNode2;
                }
                return defaultMutableTreeNode;
            }
            for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = this.getGroup((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i), string);
                if (defaultMutableTreeNode3 == null) continue;
                return defaultMutableTreeNode3;
            }
        }
        return null;
    }

    boolean hasFunc(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        if (defaultMutableTreeNode != null && defaultMutableTreeNode.getUserObject() instanceof PermGroup) {
            for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                if (!this.hasFunc((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i), string)) continue;
                return true;
            }
            return false;
        }
        return defaultMutableTreeNode != null && defaultMutableTreeNode.getUserObject() instanceof PermFunc && ((PermFunc)defaultMutableTreeNode.getUserObject()).getName().equals(string);
    }

    public JTree getRoot() {
        return this.permissions;
    }

    public DefaultMutableTreeNode getTop() {
        return this.top;
    }

    public static void apply(JButton jButton, Permission permission) {
        Permissions.getInstance().addPerm(permission);
        Permissions.apply((JComponent)jButton, permission.name);
    }

    public static void apply(JComponent jComponent, String string) {
        if (!Utils.isAdmin()) {
            return;
        }
        if (permissionsMap.containsKey(string)) {
            Integer[] integerArray = permissionsMap.get(string);
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int n2 = integerArray[i];
                if (UrfaManagerImpl.getInstance().isPermitted(n2)) continue;
                jComponent.setEnabled(false);
            }
        } else {
            jComponent.setEnabled(false);
            log.log(1, "No such permission: " + string);
        }
    }

    public static boolean isPermitted(String string) {
        if (!Utils.isAdmin()) {
            return true;
        }
        if (permissionsMap.containsKey(string)) {
            Integer[] integerArray = permissionsMap.get(string);
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int n2 = integerArray[i];
                if (UrfaManagerImpl.getInstance().isPermitted(n2)) continue;
                return false;
            }
            return true;
        }
        log.log(1, "No such permission: " + string);
        return false;
    }
}

