/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.utmutils.control.importing;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.projects.utmadmin.gui.mainframe.MainFrame;
import biz.netup.utmutils.control.importing.XmlChecker;
import biz.netup.utmutils.control.importing.XmlImporter;
import biz.netup.utmutils.control.importing.XmlTester;
import biz.netup.utmutils.swing.dialog.DialogModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class ImportDialog
extends DialogModel {
    private JPanel panel;
    private JButton browseButton;
    private JTextField browseTextField;
    private JCheckBox usersCheckBox;
    private JProgressBar progressBar1;
    private JLabel statusLabel;
    private JButton importButton;
    private JCheckBox telephoneDirectionsCheckBox;
    private JLabel warnLabel;

    public ImportDialog() {
        this.$$$setupUI$$$();
    }

    public ImportDialog(Map<String, Object> map) {
        super(map);
        this.usersCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImportDialog.this.chechImportEnabling();
            }
        });
        this.telephoneDirectionsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImportDialog.this.chechImportEnabling();
            }
        });
    }

    @Override
    public Component getForm() {
        this.$$$setupUI$$$();
        return this.panel;
    }

    @Override
    public String getItemName() {
        return "Import";
    }

    @Override
    protected void loadInfo() throws UrfaException {
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImportDialog.this.browse();
            }
        });
        this.importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImportDialog.this.startImport();
            }
        });
        this.buttonOK.setVisible(false);
        this.buttonCancel.setText(this.resource.getString("Close"));
    }

    private void browse() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file != null) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    String string = this.getExtension(file);
                    if (string != null) {
                        return string.equalsIgnoreCase("xml");
                    }
                }
                return false;
            }

            @Override
            public String getDescription() {
                return "*.XML";
            }

            String getExtension(File file) {
                String string = null;
                String string2 = file.getName();
                int n = string2.lastIndexOf(46);
                if (n > 0 && n < string2.length() - 1) {
                    string = string2.substring(n + 1).toLowerCase();
                }
                return string;
            }
        });
        if (jFileChooser.showOpenDialog(null) == 0 && jFileChooser.getSelectedFile().exists() && jFileChooser.getSelectedFile().getPath().endsWith(".xml")) {
            File file = jFileChooser.getSelectedFile();
            this.browseTextField.setText(file.getPath());
            this.warnLabel.setText(" ");
        } else {
            this.browseTextField.setText("");
            this.warnLabel.setText(this.resource.getString("Select .xml file"));
        }
        this.chechImportEnabling();
    }

    private void chechImportEnabling() {
        if (!this.browseTextField.getText().isEmpty() && (this.usersCheckBox.isSelected() || this.telephoneDirectionsCheckBox.isSelected())) {
            this.importButton.setEnabled(true);
        } else {
            this.importButton.setEnabled(false);
        }
    }

    private void startImport() {
        this.statusLabel.setText("Testing XML");
        try {
            new XmlTester().run(this.browseTextField.getText());
            if (this.usersCheckBox.isSelected()) {
                this.statusLabel.setText("Checking users");
                try {
                    new XmlChecker().checkUsers(this.browseTextField.getText());
                    this.statusLabel.setText("Importing users");
                    new XmlImporter().importUsers(this.browseTextField.getText());
                    MainFrame.getInstance().refreshUsers();
                }
                catch (Exception exception) {
                    this.log.error(exception);
                }
            }
            if (this.telephoneDirectionsCheckBox.isSelected()) {
                this.statusLabel.setText("Checking telephone zones and directions");
                try {
                    new XmlChecker().checkTelZonesDirs(this.browseTextField.getText());
                    this.statusLabel.setText("Importing telephone zones and directions");
                    new XmlImporter().importTelZonesDirs(this.browseTextField.getText());
                    MainFrame.getInstance().refreshTelDirZones();
                }
                catch (Exception exception) {
                    this.log.error(exception);
                }
            }
        }
        catch (Exception exception) {
            this.log.error("Error in .xml file", exception);
        }
        this.statusLabel.setText("");
    }

    @Override
    protected void saveInfo() throws UrfaException {
    }

    @Override
    protected void checkInfo() throws IllegalArgumentException {
    }

    private void $$$setupUI$$$() {
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        this.browseButton = new JButton();
        this.$$$loadButtonText$$$(this.browseButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Browse..."));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.panel.add((Component)this.browseButton, gridBagConstraints);
        this.browseTextField = new JTextField();
        this.browseTextField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.panel.add((Component)this.browseTextField, gridBagConstraints);
        this.usersCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.usersCheckBox, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Users"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        this.panel.add((Component)this.usersCheckBox, gridBagConstraints);
        this.importButton = new JButton();
        this.importButton.setEnabled(false);
        this.$$$loadButtonText$$$(this.importButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Import"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.panel.add((Component)this.importButton, gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.panel.add((Component)jPanel, gridBagConstraints);
        this.progressBar1 = new JProgressBar();
        jPanel.add((Component)this.progressBar1, "Center");
        JPanel jPanel2 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.panel.add((Component)jPanel2, gridBagConstraints);
        this.statusLabel = new JLabel();
        this.statusLabel.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.panel.add((Component)this.statusLabel, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        this.panel.add((Component)jPanel3, gridBagConstraints);
        this.telephoneDirectionsCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.telephoneDirectionsCheckBox, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Telephone zones and directions"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        this.panel.add((Component)this.telephoneDirectionsCheckBox, gridBagConstraints);
        this.warnLabel = new JLabel();
        this.$$$loadLabelText$$$(this.warnLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Select .xml file"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.panel.add((Component)this.warnLabel, gridBagConstraints);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    @Override
    public JComponent $$$getRootComponent$$$() {
        return this.panel;
    }
}

