/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.utmutils.control.filter;

import biz.netup.swing.table.CheckboxCellEditor;
import biz.netup.swing.table.ComboBoxCellEditor;
import biz.netup.swing.table.DateTimeCellEditor;
import biz.netup.swing.table.DoubleCellEditor;
import biz.netup.swing.table.IntegerCellEditor;
import biz.netup.swing.table.LongCellEditor;
import biz.netup.swing.table.MapTableModel;
import biz.netup.swing.table.TablePanel;
import biz.netup.swing.table.TablePanelAdapter;
import biz.netup.swing.table.impl.TablePanelImpl;
import biz.netup.utmutils.control.Logger;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.swing.localization.ResourceBundleWrapper;
import biz.netup.utmutils.swing.tab.ReportTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class FilterForm {
    private JButton filterButton;
    private JComboBox andOrComboBox;
    private JButton addButton;
    private JButton removeButton;
    private TablePanelImpl customSearchTablePanel;
    private JPanel mainPanel;
    private JButton clearButton;
    private ResourceBundleWrapper resource = Utils.getResource();
    private Map<String, String> whatData;
    private Map<String, Integer> criteriaData;
    private TablePanelImpl tablePanel;
    private Logger log = Utils.getLogger();
    private Vector<Map<String, Object>> dataTable;
    private ReportTab reportTab;
    private boolean updatingTable = false;

    public FilterForm(TablePanelImpl tablePanelImpl, Vector<Map<String, Object>> vector) {
        this(tablePanelImpl, vector, null);
    }

    public Map<String, String> getWhatData() {
        return this.whatData;
    }

    public JButton getClearButton() {
        return this.clearButton;
    }

    public Map<String, Integer> getCriteriaData() {
        return this.criteriaData;
    }

    public int getAndOrComboBox() {
        return this.andOrComboBox.getSelectedIndex();
    }

    public TablePanelImpl getCustomSearchTablePanel() {
        return this.customSearchTablePanel;
    }

    public JButton getFilterButton() {
        return this.filterButton;
    }

    public FilterForm(TablePanelImpl tablePanelImpl, Vector<Map<String, Object>> vector, ReportTab reportTab) {
        this.tablePanel = tablePanelImpl;
        this.dataTable = vector;
        this.reportTab = reportTab;
        this.$$$setupUI$$$();
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FilterForm.this.addSearchCriteria();
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FilterForm.this.deleteSearchCriteria();
            }
        });
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FilterForm.this.getCustomSearchTablePanel().getTableModel().removeAllRows();
                FilterForm.this.clearButton.setEnabled(false);
                FilterForm.this.filterButton.setEnabled(false);
            }
        });
        this.getFilterButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FilterForm.this.filter();
            }
        });
    }

    private void createUIComponents() {
        this.createCustomSearchTable();
        this.andOrComboBox = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement(this.resource.getString("All conditions"));
        defaultComboBoxModel.addElement(this.resource.getString("At least one condition"));
        this.andOrComboBox.setModel(defaultComboBoxModel);
    }

    private void createCustomSearchTable() {
        this.customSearchTablePanel = new TablePanelImpl(this.getClass().getName() + "_customSearch", true);
        MapTableModel mapTableModel = this.customSearchTablePanel.getTableModel();
        mapTableModel.addColumn("field", "Field:", true, true);
        mapTableModel.addColumn("condition", "Condition:", true, true);
        mapTableModel.addColumn("value", "Value:", true, true);
        this.customSearchTablePanel.setEditable(true);
        this.customSearchTablePanel.setAppendable(false);
        this.customSearchTablePanel.setTablePanelListener(new TablePanelAdapter(){

            @Override
            public JMenuItem[] getTableContextMenuItems(Map<String, Object>[] mapArray) {
                JMenuItem jMenuItem = new JMenuItem(FilterForm.this.resource.getString("Remove"));
                JMenuItem jMenuItem2 = new JMenuItem(FilterForm.this.resource.getString("Add"));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        FilterForm.this.deleteSearchCriteria();
                    }
                });
                jMenuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        FilterForm.this.addSearchCriteria();
                    }
                });
                if (mapArray.length < 1) {
                    return new JMenuItem[]{jMenuItem2};
                }
                return new JMenuItem[]{jMenuItem2, jMenuItem};
            }

            @Override
            public void performTableRowDoubleClicked(Map<String, Object> map) {
            }

            @Override
            public void performSelectionChanged(Map<String, Object>[] mapArray) {
            }

            @Override
            public void performRowModified(Map<String, Object> map) {
                map.put("X-STATUS", null);
            }

            @Override
            public void performColumnVisibilityChanged(String string, boolean bl) {
            }
        });
        this.customSearchTablePanel.applyTableSettings();
        this.fillCombo();
        JComboBox<String> jComboBox = new JComboBox<String>();
        JComboBox<String> jComboBox2 = new JComboBox<String>();
        for (String string : this.whatData.keySet()) {
            jComboBox2.addItem(string);
        }
        for (String string : this.criteriaData.keySet()) {
            jComboBox.addItem(string);
        }
        this.customSearchTablePanel.setCellEditor("field", new ComboBoxCellEditor(jComboBox2, true, false));
        this.customSearchTablePanel.setCellEditor("condition", new ComboBoxCellEditor(jComboBox, true, false));
        this.customSearchTablePanel.getTableModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (tableModelEvent.getColumn() == 0 && tableModelEvent.getFirstRow() >= 0 && !((FilterForm)FilterForm.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).get("field").equals(((FilterForm)FilterForm.this).customSearchTablePanel.getTableModel().data.get(tableModelEvent.getFirstRow()).get("old_field"))) {
                    FilterForm.this.updateEditor(tableModelEvent.getFirstRow());
                }
            }
        });
    }

    private void updateEditor(int n) {
        if (this.tablePanel.getTableModel().getRowCount() == 0) {
            return;
        }
        if (!this.updatingTable) {
            this.updatingTable = true;
            this.customSearchTablePanel.getTableModel().data.get(n).put("old_field", this.customSearchTablePanel.getTableModel().data.get(n).get("field"));
            String string = this.whatData.get(this.customSearchTablePanel.getTableModel().data.get(n).get("field"));
            Object object = this.tablePanel.getTableModel().data.get(0).get(string);
            if (object instanceof Date) {
                HashMap<String, DateTimeCellEditor> hashMap = new HashMap<String, DateTimeCellEditor>();
                hashMap.put("value", new DateTimeCellEditor("Not defined", true));
                this.customSearchTablePanel.getTableModel().data.get(n).put("X-EDITORS", hashMap);
                this.customSearchTablePanel.getTableModel().data.get(n).put("value", "");
            } else if (object instanceof Integer) {
                HashMap<String, IntegerCellEditor> hashMap = new HashMap<String, IntegerCellEditor>();
                hashMap.put("value", new IntegerCellEditor(1, 0));
                this.customSearchTablePanel.getTableModel().data.get(n).put("X-EDITORS", hashMap);
                this.customSearchTablePanel.getTableModel().data.get(n).put("value", "");
            } else if (object instanceof Boolean) {
                HashMap<String, CheckboxCellEditor> hashMap = new HashMap<String, CheckboxCellEditor>();
                hashMap.put("value", new CheckboxCellEditor());
                this.customSearchTablePanel.getTableModel().data.get(n).put("X-EDITORS", hashMap);
                this.customSearchTablePanel.getTableModel().data.get(n).put("value", "");
            } else if (object instanceof Long) {
                HashMap<String, LongCellEditor> hashMap = new HashMap<String, LongCellEditor>();
                hashMap.put("value", new LongCellEditor(1, 0L));
                this.customSearchTablePanel.getTableModel().data.get(n).put("X-EDITORS", hashMap);
                this.customSearchTablePanel.getTableModel().data.get(n).put("value", "");
            } else if (object instanceof Double) {
                HashMap<String, DoubleCellEditor> hashMap = new HashMap<String, DoubleCellEditor>();
                hashMap.put("value", new DoubleCellEditor(4));
                this.customSearchTablePanel.getTableModel().data.get(n).put("X-EDITORS", hashMap);
                this.customSearchTablePanel.getTableModel().data.get(n).put("value", "");
            } else {
                this.customSearchTablePanel.getTableModel().data.get(n).put("X-EDITORS", null);
                this.customSearchTablePanel.getTableModel().data.get(n).put("value", "");
            }
            this.customSearchTablePanel.getTableModel().fireTableDataChanged();
            this.updatingTable = false;
        }
    }

    private void addSearchCriteria() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("condition", this.criteriaData.keySet().toArray()[0]);
        hashMap.put("field", this.whatData.keySet().toArray()[0]);
        this.customSearchTablePanel.getTableModel().addRow(hashMap);
        this.updateEditor(this.customSearchTablePanel.getTableModel().getRowCount() - 1);
        this.filterButton.setEnabled(true);
        this.clearButton.setEnabled(true);
    }

    private void deleteSearchCriteria() {
        for (Map<String, Object> map : this.customSearchTablePanel.getSelectedTableRows()) {
            this.customSearchTablePanel.getTableModel().removeRow(map);
        }
        if (this.customSearchTablePanel.getTable().getRowCount() == 0) {
            this.filterButton.setEnabled(false);
        }
    }

    void fillCombo() {
        this.whatData = new LinkedHashMap<String, String>();
        for (int i = 0; i < this.tablePanel.getTableModel().getColumnCount(); ++i) {
            this.whatData.put(this.tablePanel.getTableModel().getColumnName(i), this.tablePanel.getTableModel().getColumnId(i));
        }
        this.criteriaData = new LinkedHashMap<String, Integer>();
        this.criteriaData.put(this.resource.getString("contains"), 1);
        this.criteriaData.put(this.resource.getString("not contains"), 11);
        this.criteriaData.put(this.resource.getString("equals"), 3);
        this.criteriaData.put(this.resource.getString("not equals"), 4);
        this.criteriaData.put(this.resource.getString("higher"), 7);
        this.criteriaData.put(this.resource.getString("lower"), 8);
        this.criteriaData.put(this.resource.getString("higher or equals"), 9);
        this.criteriaData.put(this.resource.getString("lower or equals"), 10);
    }

    public void filter() {
        if (this.dataTable.size() == 0) {
            return;
        }
        this.getReportTablePanel().getTableModel().removeAllRows();
        for (Map<String, Object> map : this.dataTable) {
            boolean bl;
            if (this.getAndOrComboBox() == 0) {
                bl = true;
                for (Map<String, Object> map2 : this.getCustomSearchTablePanel().getTableModel().data) {
                    if (this.checkRule(map, map2)) continue;
                    bl = false;
                }
            } else {
                bl = false;
                for (Map<String, Object> map2 : this.getCustomSearchTablePanel().getTableModel().data) {
                    if (!this.checkRule(map, map2)) continue;
                    bl = true;
                }
            }
            if (!bl) continue;
            this.getReportTablePanel().getTableModel().addRow(map);
        }
        if (this.reportTab != null) {
            this.reportTab.addSummaryRows();
        }
    }

    private TablePanel getReportTablePanel() {
        return this.tablePanel;
    }

    private boolean checkType() {
        for (Map<String, Object> map : this.getCustomSearchTablePanel().getTableModel().data) {
            String string = this.getWhatData().get(map.get("field"));
            if (this.dataTable.get(0).get(string) instanceof Integer) {
                try {
                    Integer.parseInt("" + map.get("value"));
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    this.log.error(map.get("field") + " " + "format is incorrect", numberFormatException);
                    return false;
                }
            }
            if (this.dataTable.get(0).get(string) instanceof Double) {
                try {
                    Double.parseDouble("" + map.get("value"));
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    this.log.error(map.get("field") + " " + "format is incorrect", numberFormatException);
                    return false;
                }
            }
            if (this.dataTable.get(0).get(string) instanceof Date) {
                try {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
                    simpleDateFormat.parse("" + map.get("value"));
                    return true;
                }
                catch (ParseException parseException) {
                    try {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy");
                        simpleDateFormat.parse("" + map.get("value"));
                        return true;
                    }
                    catch (ParseException parseException2) {
                        try {
                            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM");
                            simpleDateFormat.parse("" + map.get("value"));
                            return true;
                        }
                        catch (ParseException parseException3) {
                            this.log.error(map.get("field") + " " + "format is incorrect", parseException3);
                            return false;
                        }
                    }
                }
            }
            if (!(this.dataTable.get(0).get(string) instanceof String)) continue;
            return true;
        }
        return false;
    }

    boolean checkRule(Map<String, Object> map, Map<String, Object> map2) {
        String string = this.getWhatData().get(map2.get("field"));
        try {
            if (this.getCriteriaData().get(map2.get("condition")) == 1 || this.getCriteriaData().get(map2.get("condition")) == 11) {
                return this.checkStr("" + map.get(string), "" + map2.get("value"), this.getCriteriaData().get(map2.get("condition")));
            }
            if (map.get(string) instanceof Integer) {
                return this.checkNum(((Integer)map.get(string)).doubleValue(), ((Integer)map2.get("value")).doubleValue(), this.getCriteriaData().get(map2.get("condition")));
            }
            if (map.get(string) instanceof Long) {
                return this.checkNum(((Long)map.get(string)).doubleValue(), ((Long)map2.get("value")).doubleValue(), this.getCriteriaData().get(map2.get("condition")));
            }
            if (map.get(string) instanceof Double) {
                return this.checkNum((Double)map.get(string), (Double)map2.get("value"), this.getCriteriaData().get(map2.get("condition")));
            }
            if (map.get(string) instanceof Date) {
                return this.checkNum(Long.valueOf(((Date)map.get(string)).getTime()).doubleValue(), Long.valueOf(((Date)map2.get("value")).getTime()).doubleValue(), this.getCriteriaData().get(map2.get("condition")));
            }
            if (map.get(string) instanceof String) {
                return this.checkStr((String)map.get(string), "" + map2.get("value"), this.getCriteriaData().get(map2.get("condition")));
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return false;
    }

    private boolean checkStr(String string, String string2, Integer n) {
        switch (n) {
            case 1: {
                return string.lastIndexOf(string2) != -1;
            }
            case 3: {
                return string.equals(string2);
            }
            case 4: {
                return !string.equals(string2);
            }
            case 7: {
                return string.compareToIgnoreCase(string2) > 0;
            }
            case 8: {
                return string.compareToIgnoreCase(string2) < 0;
            }
            case 9: {
                return string.compareToIgnoreCase(string2) >= 0;
            }
            case 10: {
                return string.compareToIgnoreCase(string2) <= 0;
            }
            case 11: {
                return string.lastIndexOf(string2) == -1;
            }
        }
        return false;
    }

    boolean checkNum(Double d, Double d2, int n) {
        switch (n) {
            case 1: {
                return d.toString().lastIndexOf(d2.toString()) != -1;
            }
            case 3: {
                return d.equals(d2);
            }
            case 4: {
                return !d.equals(d2);
            }
            case 7: {
                return d > d2;
            }
            case 8: {
                return d < d2;
            }
            case 9: {
                return d >= d2;
            }
            case 10: {
                return d <= d2;
            }
            case 11: {
                return d.toString().lastIndexOf(d2.toString()) == -1;
            }
        }
        return false;
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout(0, 0));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.mainPanel.add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null));
        this.filterButton = new JButton();
        this.filterButton.setEnabled(false);
        this.$$$loadButtonText$$$(this.filterButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Filter"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.filterButton, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel5, gridBagConstraints);
        this.clearButton = new JButton();
        this.clearButton.setEnabled(false);
        this.$$$loadButtonText$$$(this.clearButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Clear"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.clearButton, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel6, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jPanel7, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridBagLayout());
        jPanel7.add((Component)jPanel8, "Center");
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        jPanel8.add((Component)jPanel9, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        jPanel9.add((Component)this.andOrComboBox, gridBagConstraints);
        this.addButton = new JButton();
        this.$$$loadButtonText$$$(this.addButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Add"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 4, 0);
        jPanel9.add((Component)this.addButton, gridBagConstraints);
        this.removeButton = new JButton();
        this.$$$loadButtonText$$$(this.removeButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Remove"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        jPanel9.add((Component)this.removeButton, gridBagConstraints);
        JPanel jPanel10 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel9.add((Component)jPanel10, gridBagConstraints);
        JPanel jPanel11 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel9.add((Component)jPanel11, gridBagConstraints);
        JPanel jPanel12 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel9.add((Component)jPanel12, gridBagConstraints);
        JPanel jPanel13 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel9.add((Component)jPanel13, gridBagConstraints);
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel8.add((Component)jPanel14, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel14.add((Component)this.customSearchTablePanel, gridBagConstraints);
        JPanel jPanel15 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel14.add((Component)jPanel15, gridBagConstraints);
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

