/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.utmutils.control.export;

import biz.netup.swing.table.impl.TablePanelImpl;
import biz.netup.utmutils.control.Logger;
import biz.netup.utmutils.control.Settings;
import biz.netup.utmutils.control.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;

public class ExportClass {
    static String str;
    static Logger log;
    static String separator;

    public static void exportToCsv(TablePanelImpl tablePanelImpl) {
        ExportClass.exportToCsv(tablePanelImpl, "");
    }

    public static void exportToCsv(TablePanelImpl tablePanelImpl, String string) {
        separator = Settings.getValueFromPerst("CSVSeparator").isEmpty() ? ";" : Settings.getValueFromPerst("CSVSeparator");
        JFileChooser jFileChooser = new JFileChooser(".");
        jFileChooser.setSelectedFile(new File(string));
        ExtensionFilter extensionFilter = new ExtensionFilter("csv", ".csv");
        ExtensionFilter extensionFilter2 = new ExtensionFilter("xml", ".xml");
        jFileChooser.removeChoosableFileFilter(jFileChooser.getAcceptAllFileFilter());
        jFileChooser.addChoosableFileFilter(extensionFilter2);
        jFileChooser.addChoosableFileFilter(extensionFilter);
        if (jFileChooser.showSaveDialog(null) == 0) {
            File file = null;
            file = !jFileChooser.getSelectedFile().getAbsolutePath().endsWith(".csv") && !jFileChooser.getSelectedFile().getAbsolutePath().endsWith(".xml") ? new File(jFileChooser.getSelectedFile().getAbsolutePath() + "." + jFileChooser.getFileFilter().getDescription()) : new File(jFileChooser.getSelectedFile().getAbsolutePath());
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
                if (file.getAbsolutePath().endsWith("xml")) {
                    bufferedWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                    bufferedWriter.write("<UTM_export>\n");
                    for (int i = 0; i < tablePanelImpl.getTableModel().getRowCount(); ++i) {
                        bufferedWriter.write("<row>\n");
                        bufferedWriter.write("<row_id>" + i + "</row_id>\n");
                        for (int j = 0; j < tablePanelImpl.getTableModel().getColumnCount(); ++j) {
                            bufferedWriter.write("<col_" + tablePanelImpl.getTableModel().getColumnId(j).replace(' ', '_').replace("(", "").replace(")", "") + ">");
                            bufferedWriter.write("" + ExportClass.fixCSV(tablePanelImpl.getTableModel().data.get(i).get(tablePanelImpl.getTableModel().getColumnId(j))));
                            bufferedWriter.write("</col_" + tablePanelImpl.getTableModel().getColumnId(j).replace(' ', '_').replace("(", "").replace(")", "") + ">\n");
                        }
                        bufferedWriter.write("</row>\n");
                    }
                    bufferedWriter.write("</UTM_export>\n");
                } else if (file.getAbsolutePath().endsWith("csv")) {
                    for (int i = 0; i < tablePanelImpl.getTableModel().getColumnCount(); ++i) {
                        bufferedWriter.write(ExportClass.fixCSV(tablePanelImpl.getTableModel().getColumnName(i)) + separator);
                    }
                    bufferedWriter.write(10);
                    for (Map<String, Object> map : tablePanelImpl.getTableModel().data) {
                        for (int i = 0; i < tablePanelImpl.getTableModel().getColumnCount(); ++i) {
                            bufferedWriter.write(ExportClass.fixCSV(map.get(tablePanelImpl.getTableModel().getColumnId(i))) + separator);
                        }
                        bufferedWriter.write(10);
                    }
                }
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                log.error(iOException);
            }
        }
    }

    private static String fixXML(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof Double) {
            String string = new DecimalFormat("0.000").format((double)Math.round(1000.0 * (Double)object) / 1000.0).replaceAll(",", ".");
            return string.toString();
        }
        return object.toString();
    }

    private static String fixCSV(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof Double) {
            String string = new DecimalFormat("0.000").format((double)Math.round(1000.0 * (Double)object) / 1000.0).replaceAll(",", ".");
            return string.toString();
        }
        String string = object.toString();
        if (string.contains(separator) || string.contains("\"")) {
            return "\"" + string.replaceAll("\"", "\"\"") + "\"";
        }
        return string;
    }

    public static boolean importFromCsv(TablePanelImpl tablePanelImpl) {
        separator = Settings.getValueFromPerst("CSVSeparator").isEmpty() ? ";" : Settings.getValueFromPerst("CSVSeparator");
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file != null) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    String string = this.getExtension(file);
                    if (string != null) {
                        return string.equalsIgnoreCase("csv");
                    }
                }
                return false;
            }

            @Override
            public String getDescription() {
                return "*.CSV";
            }

            String getExtension(File file) {
                String string = null;
                String string2 = file.getName();
                int n = string2.lastIndexOf(46);
                if (n > 0 && n < string2.length() - 1) {
                    string = string2.substring(n + 1).toLowerCase();
                }
                return string;
            }
        });
        Vector<String> vector = new Vector<String>();
        int n = 0;
        int n2 = 0;
        if (jFileChooser.showOpenDialog(null) == 0) {
            File file = jFileChooser.getSelectedFile();
            InputStreamReader inputStreamReader = null;
            try {
                inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file.getPath()), Charset.forName("UTF-8"));
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                str = bufferedReader.readLine();
                ++n2;
                if (str != null) {
                    String string = ExportClass.getNextVal();
                    if (string == null) {
                        log.log(1, "Error in .csv header. Header has incorrect format");
                        return false;
                    }
                    while (string != null) {
                        ++n;
                        if (tablePanelImpl.getTableModel().getColumnId(string).isEmpty()) {
                            log.log(1, "Error in .csv header. No such column: " + string);
                            return false;
                        }
                        vector.add(tablePanelImpl.getTableModel().getColumnId(string));
                        string = ExportClass.getNextVal();
                    }
                } else {
                    log.log(1, "Error in .csv. File is empty");
                    return false;
                }
                str = bufferedReader.readLine();
                if (str == null) {
                    log.log(1, "Error in .csv. Import file has no data");
                    return false;
                }
                while (str != null) {
                    ++n2;
                    int n3 = 0;
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    String string = ExportClass.getNextVal();
                    while (string != null) {
                        if (n3 > n) {
                            log.log(1, "Error in .csv row " + n2 + ". Incorrect items count");
                            return false;
                        }
                        if (!((String)vector.get(n3)).isEmpty()) {
                            hashMap.put((String)vector.get(n3), string);
                        }
                        ++n3;
                        string = ExportClass.getNextVal();
                    }
                    if (n3 != n) {
                        log.log(1, "Error in .csv row " + n2 + ". Incorrect items count");
                        return false;
                    }
                    tablePanelImpl.getTableModel().addRow(hashMap);
                    str = bufferedReader.readLine();
                }
                bufferedReader.close();
                inputStreamReader.close();
            }
            catch (IOException iOException) {
                log.error(iOException);
                return false;
            }
            return true;
        }
        return false;
    }

    private static String getNextVal() {
        String string = "";
        boolean bl = false;
        for (int i = 0; i < str.length(); ++i) {
            if (bl) {
                if (str.charAt(i) == '\"') {
                    if (str.length() > i + 1 && str.charAt(i + 1) == '\"') {
                        string = string + '\"';
                        ++i;
                        continue;
                    }
                    if ((str = str.substring(i + 1)).indexOf(separator) != -1) {
                        str = str.substring(str.indexOf(separator) + 1);
                    }
                    return string;
                }
                string = string + str.charAt(i);
                continue;
            }
            if (str.charAt(i) == separator.charAt(0)) {
                str = str.substring(i + 1);
                return string;
            }
            if (str.charAt(i) == '\"') {
                bl = true;
                continue;
            }
            string = string + str.charAt(i);
        }
        return null;
    }

    static {
        log = Utils.getLogger();
        separator = Settings.getValueFromPerst("CSVSeparator").isEmpty() ? ";" : Settings.getValueFromPerst("CSVSeparator");
    }

    public static class ExtensionFilter
    extends FileFilter {
        private String[] extensions;
        private String description;

        public ExtensionFilter(String string, String string2) {
            this(string, new String[]{string2});
        }

        public ExtensionFilter(String string, String[] stringArray) {
            this.description = string;
            this.extensions = (String[])stringArray.clone();
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            int n = this.extensions.length;
            String string = file.getAbsolutePath();
            for (int i = 0; i < n; ++i) {
                String string2 = this.extensions[i];
                if (!string.endsWith(string2) || string.charAt(string.length() - string2.length()) != '.') continue;
                return true;
            }
            return false;
        }

        @Override
        public String getDescription() {
            return this.description == null ? this.extensions[0] : this.description;
        }
    }

    public static class IconView
    extends FileView {
        private HashMap hash = new HashMap();

        public IconView() {
            this.hash.put("csv", new AnOvalIcon(Color.RED));
            this.hash.put("xml", new AnOvalIcon(Color.GREEN));
        }

        @Override
        public String getName(File file) {
            String string = file.getName();
            if (string.length() == 0) {
                string = file.getAbsolutePath();
            }
            return string;
        }

        @Override
        public String getDescription(File file) {
            return file.getName();
        }

        @Override
        public String getTypeDescription(File file) {
            return file.getAbsolutePath();
        }

        @Override
        public Icon getIcon(File file) {
            String string = file.getAbsolutePath();
            int n = string.lastIndexOf(46);
            if (n >= 0 && n < string.length() - 1) {
                String string2 = string.substring(n + 1).toLowerCase();
                return (Icon)this.hash.get(string2);
            }
            return null;
        }

        @Override
        public Boolean isTraversable(File file) {
            return new Boolean(file.isDirectory());
        }
    }

    static class AnOvalIcon
    implements Icon {
        Color color;

        public AnOvalIcon(Color color) {
            this.color = color;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(this.color);
            graphics.fillOval(n, n2, this.getIconWidth(), this.getIconHeight());
        }

        @Override
        public int getIconWidth() {
            return 10;
        }

        @Override
        public int getIconHeight() {
            return 15;
        }
    }
}

