/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.utmutils.control;

import biz.netup.utmutils.control.Utils;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class MyExceptionHandler
implements Thread.UncaughtExceptionHandler {
    @Override
    public void uncaughtException(final Thread thread, final Throwable throwable) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.showException(thread, throwable);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MyExceptionHandler.this.showException(thread, throwable);
                }
            });
        }
    }

    private void showException(Thread thread, Throwable throwable) {
        String string = String.format("Unexpected problem on thread %s: %s. Examine console.log", thread.getName(), throwable.getMessage());
        this.logException(thread, throwable);
        int n = 0;
        if (throwable instanceof OutOfMemoryError) {
            if (1 == ++n) {
                JOptionPane.showMessageDialog(null, Utils.getResource().getString("error_out_of_memory"), Utils.getResource().getString("wnd_Title"), 0);
            }
        } else {
            JOptionPane.showMessageDialog(null, string);
        }
    }

    private void logException(Thread thread, Throwable throwable) {
        Utils.getLogger().log(10, throwable);
    }
}

