/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.utmutils.control;

import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.swing.dialogs.ErrorDialog;
import java.awt.Component;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.MissingResourceException;
import javax.swing.JOptionPane;

public class Logger {
    private static final int level = 2;
    public static final int CRITICAL = 0;
    public static final int ERROR = 1;
    public static final int INFO = 2;
    public static final int DEBUG = 10;
    private HashMap map;
    private static Logger INSTANCE = new Logger();
    private BufferedWriter bw;
    private Component owner;

    public void error(Exception exception) {
        this.error(exception.getMessage(), exception);
    }

    public static Logger getInstance() {
        return INSTANCE;
    }

    public Logger() {
        File file = new File("console.log");
        try {
            FileWriter fileWriter = new FileWriter(file);
            this.bw = new BufferedWriter(fileWriter);
        }
        catch (IOException iOException) {
            this.bw = null;
        }
        this.owner = this.owner;
        this.map = new HashMap();
        this.map.put(new Integer(0), new pair(Utils.getResource().getString("CRITICAL"), 0));
        this.map.put(new Integer(1), new pair(Utils.getResource().getString("ERROR"), 0));
        this.map.put(new Integer(2), new pair(Utils.getResource().getString("INFO"), 1));
        this.map.put(new Integer(10), new pair(Utils.getResource().getString("DEBUG"), 1));
    }

    public void log(int n, Throwable throwable) {
        Object object;
        try {
            if (this.bw != null) {
                object = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss:SS");
                this.bw.write(((DateFormat)object).format(new Date()) + " : " + ((pair)this.map.get(new Integer(n))).get_x() + " : " + throwable.getMessage());
                this.bw.newLine();
                throwable.printStackTrace(new PrintWriter(this.bw));
                this.bw.newLine();
                this.bw.flush();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (n < 2) {
            object = ((pair)this.map.get(new Integer(n))).get_x();
            int n2 = ((pair)this.map.get(new Integer(n))).get_y();
            JOptionPane.showMessageDialog(this.owner, "Check console.log for details", (String)object, n2);
        }
    }

    public void log(int n, String string) {
        Object object;
        try {
            if (this.bw != null) {
                object = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss:SS");
                this.bw.write(((DateFormat)object).format(new Date()) + " : " + ((pair)this.map.get(new Integer(n))).get_x() + " : " + string);
                this.bw.newLine();
                this.bw.flush();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (n < 2) {
            object = ((pair)this.map.get(new Integer(n))).get_x();
            int n2 = ((pair)this.map.get(new Integer(n))).get_y();
            JOptionPane.showMessageDialog(this.owner, string, (String)object, n2);
        }
    }

    public void error(String string, Throwable throwable) {
        try {
            string = Utils.getResource().getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        ErrorDialog errorDialog = new ErrorDialog(string, throwable);
        errorDialog.setVisible(true);
    }

    private class pair {
        private String x;
        private int y;

        public pair(String string, int n) {
            this.x = string;
            this.y = n;
        }

        public String get_x() {
            return this.x;
        }

        public int get_y() {
            return this.y;
        }
    }
}

