/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.swing.table;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.text.DecimalFormat;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;

public class IntegerCellEditor
extends DefaultCellEditor {
    public int default_value = 0;

    public IntegerCellEditor() {
        this(2, 0);
    }

    public IntegerCellEditor(int n, int n2) {
        super(new JTextField());
        this.clickCountToStart = n;
        this.default_value = n2;
        final DecimalFormat decimalFormat = new DecimalFormat("0");
        final JTextField jTextField = new JTextField();
        jTextField.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                jTextField.setSelectionStart(0);
                jTextField.setSelectionEnd(0);
            }
        });
        jTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                IntegerCellEditor.this.stopCellEditing();
            }
        });
        this.editorComponent = jTextField;
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            @Override
            public void setValue(Object object) {
                jTextField.requestFocus();
                jTextField.setText(object == null ? "" : (object instanceof Integer ? decimalFormat.format((Integer)object) : object.toString()));
            }

            @Override
            public Object getCellEditorValue() {
                try {
                    return Integer.parseInt(jTextField.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    return IntegerCellEditor.this.default_value;
                }
            }
        };
        jTextField.addActionListener(this.delegate);
    }
}

