/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.swing.plaf.utm;

import biz.netup.swing.JSideMenu;
import biz.netup.swing.JSideMenuGroup;
import biz.netup.swing.plaf.SideMenuGroupUI;
import biz.netup.swing.plaf.utm.UtmSideMenuUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.ComponentUI;

public class UtmSideMenuGroupUI
extends SideMenuGroupUI {
    protected JSideMenuGroup sideMenuGroup;
    protected SideMenuGroupMouseListener mouseListener;
    protected SideMenuGroupFocusListener focusListener;
    protected SideMenuGroupKeyListener keyListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new UtmSideMenuGroupUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.sideMenuGroup = (JSideMenuGroup)jComponent;
        this.installDefaults();
        this.installListeners();
        this.sideMenuGroup.setLayout(new SideMenuGroupLayoutManager());
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.sideMenuGroup.setLayout(null);
        this.uninstallListeners();
        this.uninstallDefaults();
        this.sideMenuGroup = null;
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.sideMenuGroup, "SideMenuGroup.background", "SideMenuGroup.foreground", "SideMenuGroup.font");
        this.sideMenuGroup.setBorderColor(UIManager.getColor("SideMenuGroup.borderColor"));
        LookAndFeel.installBorder(this.sideMenuGroup, "SideMenuGroup.border");
        LookAndFeel.installProperty(this.sideMenuGroup, "opaque", Boolean.TRUE);
    }

    protected void uninstallDefaults() {
        LookAndFeel.installColorsAndFont(this.sideMenuGroup, "SideMenuGroup.background", "SideMenuGroup.foreground", "SideMenuGroup.font");
        this.sideMenuGroup.setBorderColor(UIManager.getColor("SideMenuGroup.borderColor"));
        LookAndFeel.uninstallBorder(this.sideMenuGroup);
    }

    protected void installListeners() {
        this.mouseListener = new SideMenuGroupMouseListener();
        this.focusListener = new SideMenuGroupFocusListener();
        this.keyListener = new SideMenuGroupKeyListener();
        this.sideMenuGroup.addMouseListener(this.mouseListener);
        this.sideMenuGroup.addMouseMotionListener(this.mouseListener);
        this.sideMenuGroup.addFocusListener(this.focusListener);
        this.sideMenuGroup.addKeyListener(this.keyListener);
    }

    protected void uninstallListeners() {
        this.sideMenuGroup.removeKeyListener(this.keyListener);
        this.sideMenuGroup.removeFocusListener(this.focusListener);
        this.sideMenuGroup.removeMouseMotionListener(this.mouseListener);
        this.sideMenuGroup.removeMouseListener(this.mouseListener);
    }

    public class SideMenuGroupKeyListener
    implements KeyListener {
        @Override
        public void keyPressed(KeyEvent keyEvent) {
            Container container;
            Component component;
            if (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 32) {
                UtmSideMenuGroupUI.this.sideMenuGroup.setMinimized(!UtmSideMenuGroupUI.this.sideMenuGroup.isMinimized());
            }
            if (keyEvent.getKeyCode() == 38) {
                component = null;
                container = UtmSideMenuGroupUI.this.sideMenuGroup.getParent();
                if (container != null && container instanceof JSideMenu) {
                    component = UtmSideMenuUtils.getPreviousFocusable((JSideMenu)container, UtmSideMenuGroupUI.this.sideMenuGroup, null);
                }
                if (component != null) {
                    component.requestFocusInWindow();
                }
            }
            if (keyEvent.getKeyCode() == 40) {
                component = null;
                container = UtmSideMenuGroupUI.this.sideMenuGroup.getParent();
                if (container != null && container instanceof JSideMenu) {
                    component = UtmSideMenuUtils.getNextFocusable((JSideMenu)container, UtmSideMenuGroupUI.this.sideMenuGroup, null);
                }
                if (component != null) {
                    component.requestFocusInWindow();
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }
    }

    public class SideMenuGroupFocusListener
    implements FocusListener {
        @Override
        public void focusGained(FocusEvent focusEvent) {
            UtmSideMenuGroupUI.this.sideMenuGroup.revalidate();
            UtmSideMenuGroupUI.this.sideMenuGroup.repaint();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            UtmSideMenuGroupUI.this.sideMenuGroup.revalidate();
            UtmSideMenuGroupUI.this.sideMenuGroup.repaint();
        }
    }

    public class SideMenuGroupMouseListener
    implements MouseListener,
    MouseMotionListener {
        private Cursor savedCursor;
        private Cursor handCursor;
        private int maxY;

        public SideMenuGroupMouseListener() {
            this.savedCursor = UtmSideMenuGroupUI.this.sideMenuGroup.getCursor();
            this.handCursor = Cursor.getPredefinedCursor(12);
            this.maxY = UtmSideMenuGroupUI.this.sideMenuGroup.getInsets().top - 3;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getY() < this.maxY) {
                UtmSideMenuGroupUI.this.sideMenuGroup.setMinimized(!UtmSideMenuGroupUI.this.sideMenuGroup.isMinimized());
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            UtmSideMenuGroupUI.this.sideMenuGroup.setCursor(this.savedCursor);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getY() < this.maxY) {
                UtmSideMenuGroupUI.this.sideMenuGroup.requestFocusInWindow();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (mouseEvent.getY() < this.maxY) {
                UtmSideMenuGroupUI.this.sideMenuGroup.setCursor(this.handCursor);
            } else {
                UtmSideMenuGroupUI.this.sideMenuGroup.setCursor(this.savedCursor);
            }
        }
    }

    public static class SideMenuGroupBorder
    extends AbstractBorder {
        public static final int MARGIN_TOP = 2;
        public static final int MARGIN_LEFT = 6;
        public static final int INNER_MARGIN = 3;

        @Override
        public Insets getBorderInsets(Component component) {
            JSideMenuGroup jSideMenuGroup = (JSideMenuGroup)component;
            FontMetrics fontMetrics = jSideMenuGroup.getFontMetrics(jSideMenuGroup.getFont());
            int n = fontMetrics.getHeight() + 4 + 3;
            int n2 = 4;
            int n3 = 4;
            int n4 = jSideMenuGroup.isMinimized() ? 0 : 4;
            return new Insets(n, n2, n4, n3);
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JSideMenuGroup jSideMenuGroup = (JSideMenuGroup)component;
            Font font = jSideMenuGroup.getFont();
            FontMetrics fontMetrics = jSideMenuGroup.getFontMetrics(font);
            Color color = graphics.getColor();
            Font font2 = graphics.getFont();
            Graphics2D graphics2D = (Graphics2D)graphics;
            Paint paint = graphics2D.getPaint();
            Color color2 = jSideMenuGroup.getBorderColor();
            graphics2D.setColor(color2);
            graphics2D.fillRect(n, n2, n3, fontMetrics.getHeight() + 4);
            graphics2D.setPaint(paint);
            if (!jSideMenuGroup.isMinimized()) {
                int n5 = n2 + fontMetrics.getHeight() + 4;
                int n6 = n4 - fontMetrics.getHeight() - 4;
                graphics.setColor(color2);
                graphics.drawLine(n, n5, n, n5 + n6 - 1);
                graphics.drawLine(n, n5 + n6 - 1, n + n3 - 1, n5 + n6 - 1);
                graphics2D.drawLine(n + n3 - 1, n5 + n6 - 1, n + n3 - 1, n5);
                graphics2D.setPaint(paint);
            }
            graphics.setColor(jSideMenuGroup.getForeground());
            graphics.setFont(font);
            graphics.drawString(jSideMenuGroup.getText(), n + 6, n2 + fontMetrics.getHeight());
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(jSideMenuGroup.getText(), graphics);
            rectangle2D.setFrame(rectangle2D.getX() + 6.0 - 2.0, rectangle2D.getY() + (double)fontMetrics.getHeight(), rectangle2D.getWidth() + 4.0, rectangle2D.getHeight());
            if (jSideMenuGroup.isFocusPainted() && jSideMenuGroup.isFocusOwner()) {
                graphics.setColor(UIManager.getColor("SideMenuGroup.focus"));
                graphics2D.draw(rectangle2D);
            }
            graphics.setColor(color);
            graphics.setFont(font2);
        }
    }

    public class SideMenuGroupLayoutManager
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void layoutContainer(Container container) {
            JSideMenuGroup jSideMenuGroup = (JSideMenuGroup)container;
            Insets insets = container.getInsets();
            Rectangle rectangle = container.getBounds();
            int n = insets.left;
            int n2 = insets.top;
            int n3 = rectangle.width - insets.left - insets.right;
            int n4 = rectangle.height - insets.top - insets.bottom;
            Component[] componentArray = jSideMenuGroup.getComponents();
            int n5 = componentArray.length == 0 ? n4 : n4 / componentArray.length;
            for (int i = 0; i < componentArray.length; ++i) {
                if (jSideMenuGroup.isMinimized()) {
                    componentArray[i].setBounds(0, 0, 0, 0);
                    continue;
                }
                componentArray[i].setBounds(n, n2, Math.min(n3, componentArray[i].getPreferredSize().width), n5);
                n2 += n5;
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.layoutSize((JSideMenuGroup)container, true);
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return this.layoutSize((JSideMenuGroup)container, false);
        }

        public Dimension layoutSize(JSideMenuGroup jSideMenuGroup, boolean bl) {
            Object object;
            Insets insets = jSideMenuGroup.getInsets();
            int n = 0;
            int n2 = 0;
            if (!bl) {
                object = jSideMenuGroup.getFontMetrics(jSideMenuGroup.getFont());
                n = ((FontMetrics)object).stringWidth(jSideMenuGroup.getText() + 12);
            }
            object = jSideMenuGroup.getComponents();
            for (int i = 0; i < ((Component[])object).length; ++i) {
                Dimension dimension = this.size(object[i], bl);
                if (!jSideMenuGroup.isMinimized()) {
                    n2 += dimension.height;
                }
                if (dimension.width <= n) continue;
                n = dimension.width;
            }
            return new Dimension(insets.left + insets.right + n, insets.top + insets.bottom + n2);
        }

        public Dimension size(Component component, boolean bl) {
            if (bl) {
                return component.getMinimumSize();
            }
            return component.getPreferredSize();
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }
    }
}

