/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.swing.plaf.looks.windows;

import java.awt.Component;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public final class WindowsTreeUI
extends com.sun.java.swing.plaf.windows.WindowsTreeUI {
    private boolean linesEnabled = true;
    private PropertyChangeListener lineStyleHandler;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsTreeUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.updateLineStyle(jComponent.getClientProperty("JTree.lineStyle"));
        this.lineStyleHandler = new LineStyleHandler();
        jComponent.addPropertyChangeListener(this.lineStyleHandler);
    }

    public void uninstallUI(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this.lineStyleHandler);
        super.uninstallUI(jComponent);
    }

    protected void paintVerticalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
        if (this.linesEnabled) {
            super.paintVerticalLine(graphics, jComponent, n, n2, n3);
        }
    }

    protected void paintHorizontalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
        if (this.linesEnabled) {
            super.paintHorizontalLine(graphics, jComponent, n, n2, n3);
        }
    }

    protected void drawCentered(Component component, Graphics graphics, Icon icon, int n, int n2) {
        icon.paintIcon(component, graphics, n - icon.getIconWidth() / 2 - 1, n2 - icon.getIconHeight() / 2);
    }

    private void updateLineStyle(Object object) {
        this.linesEnabled = !"None".equals(object);
    }

    private class LineStyleHandler
    implements PropertyChangeListener {
        private LineStyleHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getNewValue();
            if (string.equals("JTree.lineStyle")) {
                WindowsTreeUI.this.updateLineStyle(object);
            }
        }
    }
}

