/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.swing.plaf.looks.windows;

import biz.netup.swing.plaf.looks.common.MenuItemRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public final class WindowsMenuUI
extends com.sun.java.swing.plaf.windows.WindowsMenuUI {
    private static final String MENU_PROPERTY_PREFIX = "Menu";
    private static final String SUBMENU_PROPERTY_PREFIX = "MenuItem";
    private String propertyPrefix = "Menu";
    private MenuItemRenderer renderer;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsMenuUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        if (this.arrowIcon == null || this.arrowIcon instanceof UIResource) {
            this.arrowIcon = UIManager.getIcon("Menu.arrowIcon");
        }
        this.renderer = new MenuItemRenderer(this.menuItem, false, this.acceleratorFont, this.selectionForeground, this.disabledForeground, this.acceleratorForeground, this.acceleratorSelectionForeground);
        Integer n = (Integer)UIManager.get(this.getPropertyPrefix() + ".textIconGap");
        this.defaultTextIconGap = n != null ? n : 2;
    }

    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.renderer = null;
    }

    protected String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    protected Dimension getPreferredMenuItemSize(JComponent jComponent, Icon icon, Icon icon2, int n) {
        if (this.isSubMenu(this.menuItem)) {
            this.ensureSubMenuInstalled();
            return this.renderer.getPreferredMenuItemSize(jComponent, icon, icon2, n);
        }
        Dimension dimension = super.getPreferredMenuItemSize(jComponent, icon, icon2, n);
        int n2 = dimension.width;
        int n3 = dimension.height;
        if (n3 % 2 == 1) {
            --n3;
        }
        return new Dimension(n2, n3);
    }

    protected void paintMenuItem(Graphics graphics, JComponent jComponent, Icon icon, Icon icon2, Color color, Color color2, int n) {
        if (this.isSubMenu(this.menuItem)) {
            this.renderer.paintMenuItem(graphics, jComponent, icon, icon2, color, color2, n);
        } else {
            super.paintMenuItem(graphics, jComponent, icon, icon2, color, color2, n);
        }
    }

    private void ensureSubMenuInstalled() {
        if (this.propertyPrefix.equals(SUBMENU_PROPERTY_PREFIX)) {
            return;
        }
        this.uninstallDefaults();
        this.propertyPrefix = SUBMENU_PROPERTY_PREFIX;
        this.installDefaults();
    }

    private boolean isSubMenu(JMenuItem jMenuItem) {
        return !((JMenu)jMenuItem).isTopLevelMenu();
    }
}

