/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.swing.plaf.looks.plastic;

import biz.netup.swing.plaf.looks.common.ExtBasicArrowButtonHandler;
import biz.netup.swing.plaf.looks.plastic.PlasticArrowButton;
import biz.netup.swing.plaf.looks.plastic.PlasticLookAndFeel;
import biz.netup.swing.plaf.looks.plastic.PlasticSpinnerUI;
import biz.netup.swing.plaf.looks.plastic.PlasticUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public final class PlasticXPSpinnerUI
extends PlasticSpinnerUI {
    private static final ExtBasicArrowButtonHandler nextButtonHandler = new ExtBasicArrowButtonHandler("increment", true);
    private static final ExtBasicArrowButtonHandler previousButtonHandler = new ExtBasicArrowButtonHandler("decrement", false);

    public static ComponentUI createUI(JComponent jComponent) {
        return new PlasticXPSpinnerUI();
    }

    @Override
    protected Component createPreviousButton() {
        return new SpinnerXPArrowButton(5, previousButtonHandler);
    }

    @Override
    protected Component createNextButton() {
        return new SpinnerXPArrowButton(1, nextButtonHandler);
    }

    private static class SpinnerXPArrowButton
    extends PlasticArrowButton {
        private SpinnerXPArrowButton(int n, ExtBasicArrowButtonHandler extBasicArrowButtonHandler) {
            super(n, UIManager.getInt("ScrollBar.width") - 2, false);
            this.addActionListener(extBasicArrowButtonHandler);
            this.addMouseListener(extBasicArrowButtonHandler);
        }

        @Override
        protected int calculateArrowHeight(int n, int n2) {
            int n3 = Math.min((n - 4) / 3, (n2 - 4) / 3);
            return Math.max(n3, 3);
        }

        @Override
        protected boolean isPaintingNorthBottom() {
            return true;
        }

        @Override
        protected void paintNorth(Graphics graphics, boolean bl, boolean bl2, Color color, boolean bl3, int n, int n2, int n3, int n4, int n5, int n6, boolean bl4) {
            if (!this.isFreeStanding) {
                ++n2;
                graphics.translate(0, -1);
                if (!bl) {
                    ++n;
                    graphics.translate(-1, 0);
                } else {
                    n += 2;
                }
            }
            graphics.setColor(color);
            int n7 = (n4 + 1 - n5) / 2;
            int n8 = n3 / 2;
            for (int i = 0; i < n5; ++i) {
                graphics.fillRect(n8 - i - n6, n7 + i, 2 * (i + 1), 1);
            }
            if (bl2) {
                Color color2 = UIManager.getColor("ScrollBar.darkShadow");
                graphics.setColor(color2);
                graphics.drawLine(0, 0, n - 2, 0);
                graphics.drawLine(0, 0, 0, n2 - 1);
                graphics.drawLine(n - 2, 1, n - 2, n2 - 1);
                if (bl4) {
                    graphics.fillRect(0, n2 - 1, n - 1, 1);
                }
            } else {
                PlasticUtils.drawDisabledBorder(graphics, 0, 0, n, n2 + 1);
                if (bl4) {
                    graphics.setColor(PlasticLookAndFeel.getControlShadow());
                    graphics.fillRect(0, n2 - 1, n - 1, 1);
                }
            }
            if (!this.isFreeStanding) {
                --n2;
                graphics.translate(0, 1);
                if (!bl) {
                    --n;
                    graphics.translate(1, 0);
                } else {
                    n -= 2;
                }
            }
        }

        @Override
        protected void paintSouth(Graphics graphics, boolean bl, boolean bl2, Color color, boolean bl3, int n, int n2, int n3, int n4, int n5, int n6) {
            if (!this.isFreeStanding) {
                ++n2;
                if (!bl) {
                    ++n;
                    graphics.translate(-1, 0);
                } else {
                    n += 2;
                }
            }
            graphics.setColor(color);
            int n7 = (n4 + 0 - n5) / 2 + n5 - 1;
            int n8 = n3 / 2;
            for (int i = 0; i < n5; ++i) {
                graphics.fillRect(n8 - i - n6, n7 - i, 2 * (i + 1), 1);
            }
            if (bl2) {
                Color color2 = UIManager.getColor("ScrollBar.darkShadow");
                graphics.setColor(color2);
                graphics.drawLine(0, 0, 0, n2 - 2);
                graphics.drawLine(n - 2, 0, n - 2, n2 - 2);
            } else {
                PlasticUtils.drawDisabledBorder(graphics, 0, -1, n, n2 + 1);
            }
            if (!this.isFreeStanding) {
                --n2;
                if (!bl) {
                    --n;
                    graphics.translate(1, 0);
                } else {
                    n -= 2;
                }
            }
        }
    }
}

