/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.swing.plaf.looks.plastic;

import biz.netup.swing.plaf.AdvancedTabbedPaneUI;
import biz.netup.swing.plaf.looks.LookUtils;
import biz.netup.swing.plaf.looks.Options;
import biz.netup.swing.plaf.looks.plastic.PlasticArrowButton;
import biz.netup.swing.plaf.looks.plastic.PlasticLookAndFeel;
import biz.netup.swing.plaf.looks.plastic.PlasticUtils;
import biz.netup.swing.plaf.looks.plastic.PlasticXPUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;

public final class PlasticXPAdvancedTabbedPaneUI
extends AdvancedTabbedPaneUI {
    private static boolean isTabIconsEnabled = Options.isTabIconsEnabled();
    private Boolean noContentBorder;
    private Boolean embeddedTabs;
    private AbstractRenderer renderer;
    private ScrollableTabSupport tabScroller;
    private int[] xCropLen = new int[]{1, 1, 0, 0, 1, 1, 2, 2};
    private int[] yCropLen = new int[]{0, 3, 3, 6, 6, 9, 9, 12};
    private static final int CROP_SEGMENT = 12;

    public static ComponentUI createUI(JComponent jComponent) {
        return new PlasticXPAdvancedTabbedPaneUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.embeddedTabs = (Boolean)jComponent.getClientProperty("jgoodies.embeddedTabs");
        this.noContentBorder = (Boolean)jComponent.getClientProperty("jgoodies.noContentBorder");
        this.renderer = this.createRenderer(this.tabPane);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.renderer = null;
        super.uninstallUI(jComponent);
    }

    @Override
    protected void installComponents() {
        if (this.scrollableTabLayoutEnabled() && this.tabScroller == null) {
            this.tabScroller = new ScrollableTabSupport(this.tabPane.getTabPlacement());
            this.tabPane.add(this.tabScroller.viewport);
        }
    }

    @Override
    protected void uninstallComponents() {
        if (this.scrollableTabLayoutEnabled()) {
            this.tabPane.remove(this.tabScroller.viewport);
            this.tabPane.remove(this.tabScroller.scrollForwardButton);
            this.tabPane.remove(this.tabScroller.scrollBackwardButton);
            this.tabScroller = null;
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        if (this.mouseListener != null && LookUtils.IS_JAVA_1_4 && this.scrollableTabLayoutEnabled()) {
            this.tabPane.removeMouseListener(this.mouseListener);
            this.tabScroller.tabPanel.addMouseListener(this.mouseListener);
        }
    }

    @Override
    protected void uninstallListeners() {
        if (this.mouseListener != null && LookUtils.IS_JAVA_1_4) {
            if (this.scrollableTabLayoutEnabled()) {
                this.tabScroller.tabPanel.removeMouseListener(this.mouseListener);
            } else {
                this.tabPane.removeMouseListener(this.mouseListener);
            }
            this.mouseListener = null;
        }
        super.uninstallListeners();
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        if (this.scrollableTabLayoutEnabled()) {
            ScrollTabsForwardAction scrollTabsForwardAction = new ScrollTabsForwardAction();
            ScrollTabsBackwardAction scrollTabsBackwardAction = new ScrollTabsBackwardAction();
            ActionMap actionMap = SwingUtilities.getUIActionMap(this.tabPane);
            actionMap.put("scrollTabsForwardAction", scrollTabsForwardAction);
            actionMap.put("scrollTabsBackwardAction", scrollTabsBackwardAction);
            this.tabScroller.scrollForwardButton.setAction(scrollTabsForwardAction);
            this.tabScroller.scrollBackwardButton.setAction(scrollTabsBackwardAction);
        }
    }

    private boolean hasNoContentBorder() {
        return Boolean.TRUE.equals(this.noContentBorder);
    }

    private boolean hasEmbeddedTabs() {
        return Boolean.TRUE.equals(this.embeddedTabs);
    }

    private AbstractRenderer createRenderer(JTabbedPane jTabbedPane) {
        return this.hasEmbeddedTabs() ? AbstractRenderer.createEmbeddedRenderer(jTabbedPane) : AbstractRenderer.createRenderer(this.tabPane);
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new MyPropertyChangeHandler();
    }

    @Override
    protected ChangeListener createChangeListener() {
        return new TabSelectionHandler();
    }

    private void doLayout() {
        this.tabPane.revalidate();
        this.tabPane.repaint();
    }

    private void tabPlacementChanged() {
        this.renderer = this.createRenderer(this.tabPane);
        if (this.scrollableTabLayoutEnabled()) {
            this.tabScroller.createButtons();
        }
        this.doLayout();
    }

    private void embeddedTabsPropertyChanged(Boolean bl) {
        this.embeddedTabs = bl;
        this.renderer = this.createRenderer(this.tabPane);
        this.doLayout();
    }

    private void noContentBorderPropertyChanged(Boolean bl) {
        this.noContentBorder = bl;
        this.tabPane.repaint();
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        int n = this.tabPane.getSelectedIndex();
        int n2 = this.tabPane.getTabPlacement();
        this.ensureCurrentLayout();
        if (!this.scrollableTabLayoutEnabled()) {
            this.paintTabArea(graphics, n2, n);
        }
        this.paintContentBorder(graphics, n2, n);
    }

    @Override
    protected void paintTab(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2) {
        Object object;
        Rectangle rectangle3 = rectangleArray[n2];
        int n3 = this.tabPane.getSelectedIndex();
        boolean bl = n3 == n2;
        Graphics2D graphics2D = null;
        Polygon polygon = null;
        Shape shape = null;
        int n4 = 0;
        int n5 = 0;
        if (this.scrollableTabLayoutEnabled() && graphics instanceof Graphics2D) {
            graphics2D = (Graphics2D)graphics;
            object = this.tabScroller.viewport.getViewRect();
            switch (n) {
                case 2: 
                case 4: {
                    int n6 = ((Rectangle)object).y + ((Rectangle)object).height;
                    if (rectangle3.y >= n6 || rectangle3.y + rectangle3.height <= n6) break;
                    polygon = this.createCroppedTabClip(n, rectangle3, n6);
                    n4 = rectangle3.x;
                    n5 = n6 - 1;
                    break;
                }
                default: {
                    int n6 = ((Rectangle)object).x + ((Rectangle)object).width;
                    if (rectangle3.x >= n6 || rectangle3.x + rectangle3.width <= n6) break;
                    polygon = this.createCroppedTabClip(n, rectangle3, n6);
                    n4 = n6 - 1;
                    n5 = rectangle3.y;
                }
            }
            if (polygon != null) {
                shape = graphics2D.getClip();
                graphics2D.clip(polygon);
            }
        }
        this.paintTabBackground(graphics, n, n2, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, bl);
        this.paintTabBorder(graphics, n, n2, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, bl);
        object = this.tabPane.getTitleAt(n2);
        Font font = this.tabPane.getFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        Icon icon = this.getIconForTab(n2);
        this.layoutLabel(n, fontMetrics, n2, (String)object, icon, rectangle3, rectangle, rectangle2, bl);
        this.paintText(graphics, n, font, fontMetrics, n2, (String)object, rectangle2, bl);
        this.paintIcon(graphics, n, n2, icon, rectangle, bl);
        this.paintFocusIndicator(graphics, n, rectangleArray, n2, rectangle, rectangle2, bl);
        if (polygon != null) {
            this.paintCroppedTabEdge(graphics, n, n2, bl, n4, n5);
            graphics2D.setClip(shape);
        }
    }

    private Polygon createCroppedTabClip(int n, Rectangle rectangle, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        switch (n) {
            case 2: 
            case 4: {
                n3 = rectangle.width;
                n4 = rectangle.x;
                n5 = rectangle.x + rectangle.width;
                n6 = rectangle.y;
                break;
            }
            default: {
                n3 = rectangle.height;
                n4 = rectangle.y;
                n5 = rectangle.y + rectangle.height;
                n6 = rectangle.x;
            }
        }
        int n7 = n3 / 12;
        if (n3 % 12 > 0) {
            ++n7;
        }
        int n8 = 2 + n7 * 8;
        int[] nArray = new int[n8];
        int[] nArray2 = new int[n8];
        int n9 = 0;
        nArray[n9] = n6;
        nArray2[n9++] = n5;
        nArray[n9] = n6;
        nArray2[n9++] = n4;
        block3: for (int i = 0; i < n7; ++i) {
            for (int j = 0; j < this.xCropLen.length; ++j) {
                nArray[n9] = n2 - this.xCropLen[j];
                nArray2[n9] = n4 + i * 12 + this.yCropLen[j];
                if (nArray2[n9] >= n5) {
                    nArray2[n9] = n5;
                    ++n9;
                    continue block3;
                }
                ++n9;
            }
        }
        if (n == 1 || n == 3) {
            return new Polygon(nArray, nArray2, n9);
        }
        return new Polygon(nArray2, nArray, n9);
    }

    private void paintCroppedTabEdge(Graphics graphics, int n, int n2, boolean bl, int n3, int n4) {
        switch (n) {
            case 2: 
            case 4: {
                graphics.setColor(this.shadow);
                for (int i = n3; i <= n3 + this.rects[n2].width; i += 12) {
                    for (int j = 0; j < this.xCropLen.length; j += 2) {
                        graphics.drawLine(i + this.yCropLen[j], n4 - this.xCropLen[j], i + this.yCropLen[j + 1] - 1, n4 - this.xCropLen[j + 1]);
                    }
                }
                break;
            }
            default: {
                graphics.setColor(this.shadow);
                for (int i = n4; i <= n4 + this.rects[n2].height; i += 12) {
                    for (int j = 0; j < this.xCropLen.length; j += 2) {
                        graphics.drawLine(n3 - this.xCropLen[j], i + this.yCropLen[j], n3 - this.xCropLen[j + 1], i + this.yCropLen[j + 1] - 1);
                    }
                }
            }
        }
    }

    private void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            TabbedPaneLayout tabbedPaneLayout = (TabbedPaneLayout)this.tabPane.getLayout();
            tabbedPaneLayout.calculateLayoutInfo();
        }
    }

    @Override
    public int tabForCoordinate(JTabbedPane jTabbedPane, int n, int n2) {
        this.ensureCurrentLayout();
        Point point = new Point(n, n2);
        if (this.scrollableTabLayoutEnabled()) {
            this.translatePointToTabPanel(n, n2, point);
            Rectangle rectangle = this.tabScroller.viewport.getViewRect();
            if (!rectangle.contains(point)) {
                return -1;
            }
        }
        int n3 = this.tabPane.getTabCount();
        for (int i = 0; i < n3; ++i) {
            if (!this.rects[i].contains(point.x, point.y)) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected Rectangle getTabBounds(int n, Rectangle rectangle) {
        rectangle.width = this.rects[n].width;
        rectangle.height = this.rects[n].height;
        if (this.scrollableTabLayoutEnabled()) {
            Point point = this.tabScroller.viewport.getLocation();
            Point point2 = this.tabScroller.viewport.getViewPosition();
            rectangle.x = this.rects[n].x + point.x - point2.x;
            rectangle.y = this.rects[n].y + point.y - point2.y;
        } else {
            rectangle.x = this.rects[n].x;
            rectangle.y = this.rects[n].y;
        }
        return rectangle;
    }

    private int getClosestTab(int n, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        int n6 = n4 = Math.min(this.rects.length, this.tabPane.getTabCount());
        int n7 = this.tabPane.getTabPlacement();
        boolean bl = n7 == 1 || n7 == 3;
        int n8 = n3 = bl ? n : n2;
        while (n5 != n6) {
            int n9;
            int n10;
            int n11 = (n6 + n5) / 2;
            if (bl) {
                n10 = this.rects[n11].x;
                n9 = n10 + this.rects[n11].width;
            } else {
                n10 = this.rects[n11].y;
                n9 = n10 + this.rects[n11].height;
            }
            if (n3 < n10) {
                n6 = n11;
                if (n5 != n6) continue;
                return Math.max(0, n11 - 1);
            }
            if (n3 >= n9) {
                n5 = n11;
                if (n6 - n5 > 1) continue;
                return Math.max(n11 + 1, n4 - 1);
            }
            return n11;
        }
        return n5;
    }

    private Point translatePointToTabPanel(int n, int n2, Point point) {
        Point point2 = this.tabScroller.viewport.getLocation();
        Point point3 = this.tabScroller.viewport.getViewPosition();
        point.x = n - point2.x + point3.x;
        point.y = n2 - point2.y + point3.y;
        return point;
    }

    @Override
    protected void paintTabArea(Graphics graphics, int n, int n2) {
        int n3 = this.tabPane.getTabCount();
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = graphics.getClipBounds();
        for (int i = this.runCount - 1; i >= 0; --i) {
            int n4;
            int n5 = this.tabRuns[i];
            int n6 = this.tabRuns[i == this.runCount - 1 ? 0 : i + 1];
            for (int j = n4 = n6 != 0 ? n6 - 1 : n3 - 1; j >= n5; --j) {
                if (j == n2 || !this.rects[j].intersects(rectangle3)) continue;
                this.paintTab(graphics, n, this.rects, j, rectangle, rectangle2);
            }
        }
        if (n2 >= 0 && this.rects[n2].intersects(rectangle3)) {
            this.paintTab(graphics, n, this.rects, n2, rectangle, rectangle2);
        }
    }

    @Override
    protected void layoutLabel(int n, FontMetrics fontMetrics, int n2, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl) {
        rectangle2.y = 0;
        rectangle2.x = 0;
        rectangle3.y = 0;
        rectangle3.x = 0;
        View view = this.getTextViewForTab(n2);
        if (view != null) {
            this.tabPane.putClientProperty("html", view);
        }
        Rectangle rectangle4 = new Rectangle(rectangle);
        if (bl) {
            Insets insets = this.getSelectedTabPadInsets(n);
            rectangle4.x += insets.left;
            rectangle4.y += insets.top;
            rectangle4.width -= insets.left + insets.right;
            rectangle4.height -= insets.bottom + insets.top;
        }
        int n3 = this.getTabLabelShiftX(n, n2, bl);
        int n4 = this.getTabLabelShiftY(n, n2, bl);
        if (!(n != 4 && n != 2 || icon == null || string == null || string.equals(""))) {
            SwingUtilities.layoutCompoundLabel(this.tabPane, fontMetrics, string, icon, 0, 2, 0, 11, rectangle4, rectangle2, rectangle3, this.textIconGap);
            n3 += 4;
        } else {
            SwingUtilities.layoutCompoundLabel(this.tabPane, fontMetrics, string, icon, 0, 2, 0, 11, rectangle4, rectangle2, rectangle3, this.textIconGap);
            rectangle2.y += rectangle4.height % 2;
            n3 += 4;
        }
        this.tabPane.putClientProperty("html", null);
        rectangle2.x += n3;
        rectangle2.y += n4;
        rectangle3.x += n3;
        rectangle3.y += n4;
    }

    @Override
    protected Icon getIconForTab(int n) {
        String string = this.tabPane.getTitleAt(n);
        boolean bl = string != null && string.length() > 0;
        return !isTabIconsEnabled && bl ? null : super.getIconForTab(n);
    }

    @Override
    protected LayoutManager createLayoutManager() {
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            return new TabbedPaneScrollLayout();
        }
        return new TabbedPaneLayout();
    }

    private boolean scrollableTabLayoutEnabled() {
        return this.tabPane.getLayout() instanceof TabbedPaneScrollLayout;
    }

    protected boolean isTabInFirstRun(int n) {
        return this.getRunForTab(this.tabPane.getTabCount(), n) == 0;
    }

    @Override
    protected void paintContentBorder(Graphics graphics, int n, int n2) {
        int n3 = this.tabPane.getWidth();
        int n4 = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        int n5 = insets.left;
        int n6 = insets.top;
        int n7 = n3 - insets.right - insets.left;
        int n8 = n4 - insets.top - insets.bottom;
        switch (n) {
            case 2: {
                n7 -= (n5 += this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth)) - insets.left;
                break;
            }
            case 4: {
                n7 -= this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth);
                break;
            }
            case 3: {
                n8 -= this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight);
                break;
            }
            default: {
                n8 -= (n6 += this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight)) - insets.top;
            }
        }
        graphics.setColor(this.selectColor == null ? this.tabPane.getBackground() : this.selectColor);
        graphics.fillRect(n5, n6, n7, n8);
        Rectangle rectangle = n2 < 0 ? null : this.getTabBounds(n2, this.calcRect);
        boolean bl = n2 >= 0 && this.isTabInFirstRun(n2);
        boolean bl2 = !this.hasNoContentBorder();
        this.renderer.paintContentBorderTopEdge(graphics, n5, n6, n7, n8, bl, rectangle, bl2);
        this.renderer.paintContentBorderLeftEdge(graphics, n5, n6, n7, n8, bl, rectangle, bl2);
        this.renderer.paintContentBorderBottomEdge(graphics, n5, n6, n7, n8, bl, rectangle, bl2);
        this.renderer.paintContentBorderRightEdge(graphics, n5, n6, n7, n8, bl, rectangle, bl2);
    }

    @Override
    protected Insets getContentBorderInsets(int n) {
        return this.renderer.getContentBorderInsets(super.getContentBorderInsets(n));
    }

    @Override
    protected Insets getTabAreaInsets(int n) {
        return this.renderer.getTabAreaInsets(super.getTabAreaInsets(n));
    }

    @Override
    protected int getTabLabelShiftX(int n, int n2, boolean bl) {
        return this.renderer.getTabLabelShiftX(n2, bl);
    }

    @Override
    protected int getTabLabelShiftY(int n, int n2, boolean bl) {
        return this.renderer.getTabLabelShiftY(n2, bl);
    }

    @Override
    protected int getTabRunOverlay(int n) {
        return this.renderer.getTabRunOverlay(this.tabRunOverlay);
    }

    @Override
    protected boolean shouldPadTabRun(int n, int n2) {
        return this.renderer.shouldPadTabRun(n2, super.shouldPadTabRun(n, n2));
    }

    @Override
    protected int getTabRunIndent(int n, int n2) {
        return this.renderer.getTabRunIndent(n2);
    }

    @Override
    protected Insets getTabInsets(int n, int n2) {
        return this.renderer.getTabInsets(n2, this.tabInsets);
    }

    @Override
    protected Insets getSelectedTabPadInsets(int n) {
        return this.renderer.getSelectedTabPadInsets();
    }

    @Override
    protected void paintFocusIndicator(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
        this.renderer.paintFocusIndicator(graphics, rectangleArray, n2, rectangle, rectangle2, bl);
    }

    @Override
    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        this.renderer.paintTabBackground(graphics, n2, n3, n4, n5, n6, bl);
    }

    @Override
    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        this.renderer.paintTabBorder(graphics, n2, n3, n4, n5, n6, bl);
    }

    @Override
    protected boolean shouldRotateTabRuns(int n) {
        return false;
    }

    private boolean requestFocusForVisibleComponent() {
        Component component = this.getVisibleComponent();
        if (component.isFocusable()) {
            component.requestFocus();
            return true;
        }
        return component instanceof JComponent && ((JComponent)component).requestDefaultFocus();
    }

    @Override
    public AdvancedTabbedPaneUI.CloseButton createCloseButton(Component component) {
        return new PlasticCloseButton(component, 15);
    }

    private static class TopRenderer
    extends AbstractRenderer {
        private TopRenderer(JTabbedPane jTabbedPane) {
            super(jTabbedPane);
        }

        @Override
        protected Insets getTabAreaInsets(Insets insets) {
            return insets;
        }

        @Override
        protected int getTabLabelShiftY(int n, boolean bl) {
            return bl ? -1 : 0;
        }

        @Override
        protected int getTabRunOverlay(int n) {
            return n - 2;
        }

        @Override
        protected int getTabRunIndent(int n) {
            return n == 0 ? 0 : 6;
        }

        @Override
        protected Insets getSelectedTabPadInsets() {
            return NORTH_INSETS;
        }

        @Override
        protected Insets getTabInsets(int n, Insets insets) {
            return new Insets(insets.top + 3, insets.left - 4, insets.bottom, insets.right - 4);
        }

        @Override
        protected void paintFocusIndicator(Graphics graphics, Rectangle[] rectangleArray, int n, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
            if (!this.tabPane.hasFocus() || !bl) {
                return;
            }
            Rectangle rectangle3 = rectangleArray[n];
            int n2 = rectangle3.y + 4;
            int n3 = rectangle3.x + 4;
            int n4 = rectangle3.height - 8;
            int n5 = rectangle2.x + rectangle2.width - n3;
            graphics.setColor(this.focus);
            graphics.drawRect(n3, n2, n5, n4);
        }

        @Override
        protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
            boolean bl2 = !bl;
            graphics.setColor(this.selectColor);
            graphics.fillRect(n2, n3, n4, n5);
            if (!bl) {
                Rectangle rectangle = new Rectangle(n2, n3, n4, n5 + 1);
                PlasticUtils.add3DEffekt(graphics, rectangle);
            }
        }

        @Override
        protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
            boolean bl2 = false;
            if (bl || bl2) {
                PlasticXPUtils.drawSelectedTabBorder(graphics, n2, n3, n4, n5);
            } else {
                PlasticXPUtils.drawPlainTabBorder(graphics, n2, n3, n4, n5);
            }
        }

        @Override
        protected void paintContentBorderTopEdge(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, Rectangle rectangle, boolean bl2) {
            int n5 = n + n3 - 1;
            int n6 = n2;
            graphics.setColor(this.darkShadow);
            if (bl && rectangle.x >= n && rectangle.x <= n + n3) {
                graphics.fillRect(n, n6, rectangle.x + 1 - n, 1);
                if (rectangle.x + rectangle.width < n + n3 - 2) {
                    graphics.fillRect(rectangle.x + rectangle.width - 1, n6, n5 - rectangle.x - rectangle.width + 1, 1);
                }
            } else {
                graphics.fillRect(n, n6, n3 - 1, 1);
            }
        }

        @Override
        protected int getTabsOverlay() {
            return 6;
        }
    }

    private static class TopEmbeddedRenderer
    extends AbstractRenderer {
        private TopEmbeddedRenderer(JTabbedPane jTabbedPane) {
            super(jTabbedPane);
        }

        @Override
        protected Insets getTabAreaInsets(Insets insets) {
            return EMPTY_INSETS;
        }

        @Override
        protected Insets getContentBorderInsets(Insets insets) {
            return NORTH_INSETS;
        }

        @Override
        protected Insets getTabInsets(int n, Insets insets) {
            return new Insets(insets.top, insets.left + 1, insets.bottom, insets.right);
        }

        @Override
        protected Insets getSelectedTabPadInsets() {
            return EMPTY_INSETS;
        }

        @Override
        protected void paintFocusIndicator(Graphics graphics, Rectangle[] rectangleArray, int n, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
        }

        @Override
        protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
            graphics.setColor(this.selectColor);
            graphics.fillRect(n2, n3, n4, n5);
        }

        @Override
        protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
            graphics.translate(n2, n3);
            int n6 = n4;
            int n7 = n5;
            if (this.isFirstDisplayedTab(n, n2, this.tabPane.getBounds().x)) {
                if (bl) {
                    graphics.setColor(this.selectHighlight);
                    graphics.fillRect(0, 0, 1, n7);
                    graphics.fillRect(0, 0, n6 - 1, 1);
                    graphics.fillRect(n6 - 1, 0, 1, n7);
                    graphics.setColor(this.shadowColor);
                    graphics.fillRect(n6 - 1, 0, 1, 1);
                    graphics.fillRect(n6, 1, 1, n7);
                }
            } else if (bl) {
                graphics.setColor(this.selectHighlight);
                graphics.fillRect(1, 1, 1, n7 - 1);
                graphics.fillRect(2, 0, n6 - 3, 1);
                graphics.fillRect(n6 - 1, 1, 1, n7 - 1);
                graphics.setColor(this.shadowColor);
                graphics.fillRect(0, 1, 1, n7 - 1);
                graphics.fillRect(1, 0, 1, 1);
                graphics.fillRect(n6 - 1, 0, 1, 1);
                graphics.fillRect(n6, 1, 1, n7);
            } else {
                graphics.setColor(this.shadowColor);
                graphics.fillRect(0, 0, 1, n7 + 2 - n7 / 2);
            }
            graphics.translate(-n2, -n3);
        }

        @Override
        protected void paintContentBorderTopEdge(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, Rectangle rectangle, boolean bl2) {
            graphics.setColor(this.shadowColor);
            graphics.fillRect(n, n2, n3, 1);
        }
    }

    private static class RightRenderer
    extends AbstractRenderer {
        private RightRenderer(JTabbedPane jTabbedPane) {
            super(jTabbedPane);
        }

        @Override
        protected int getTabLabelShiftX(int n, boolean bl) {
            return 1;
        }

        @Override
        protected int getTabRunOverlay(int n) {
            return 1;
        }

        @Override
        protected boolean shouldPadTabRun(int n, boolean bl) {
            return false;
        }

        @Override
        protected Insets getTabInsets(int n, Insets insets) {
            return new Insets(insets.top, insets.left - 5, insets.bottom + 1, insets.right - 5);
        }

        @Override
        protected Insets getSelectedTabPadInsets() {
            return EAST_INSETS;
        }

        @Override
        protected void paintFocusIndicator(Graphics graphics, Rectangle[] rectangleArray, int n, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
            if (!this.tabPane.hasFocus() || !bl) {
                return;
            }
            Rectangle rectangle3 = rectangleArray[n];
            int n2 = rectangle3.y + 2;
            int n3 = rectangle3.x + 3;
            int n4 = rectangle3.height - 5;
            int n5 = rectangle3.width - 6;
            graphics.setColor(this.focus);
            graphics.drawRect(n3, n2, n5, n4);
        }

        @Override
        protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
            if (!bl) {
                graphics.setColor(this.selectLight);
                graphics.fillRect(n2, n3, n4, n5);
            } else {
                graphics.setColor(this.selectColor);
                graphics.fillRect(n2 + 2, n3, n4 - 2, n5);
            }
        }

        @Override
        protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
            int n6 = n5 - 1;
            int n7 = n4;
            graphics.translate(n2, n3);
            graphics.setColor(this.selectHighlight);
            graphics.fillRect(0, 0, n7 - 1, 1);
            graphics.setColor(this.darkShadow);
            graphics.fillRect(n7 - 1, 1, 1, 1);
            graphics.fillRect(n7, 2, 1, n6 - 3);
            graphics.fillRect(n7 - 1, n6 - 1, 1, 1);
            graphics.fillRect(0, n6, n7 - 1, 1);
            graphics.translate(-n2, -n3);
        }

        @Override
        protected void paintContentBorderRightEdge(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, Rectangle rectangle, boolean bl2) {
            graphics.setColor(this.darkShadow);
            if (bl && rectangle.y >= n2 && rectangle.y <= n2 + n4) {
                graphics.fillRect(n + n3 - 1, n2, 1, rectangle.y - n2);
                if (rectangle.y + rectangle.height < n2 + n4 - 2) {
                    graphics.fillRect(n + n3 - 1, rectangle.y + rectangle.height, 1, n2 + n4 - rectangle.y - rectangle.height);
                }
            } else {
                graphics.fillRect(n + n3 - 1, n2, 1, n4 - 1);
            }
        }
    }

    private static class RightEmbeddedRenderer
    extends AbstractRenderer {
        private RightEmbeddedRenderer(JTabbedPane jTabbedPane) {
            super(jTabbedPane);
        }

        @Override
        protected Insets getTabAreaInsets(Insets insets) {
            return EMPTY_INSETS;
        }

        @Override
        protected Insets getContentBorderInsets(Insets insets) {
            return EAST_INSETS;
        }

        @Override
        protected int getTabRunIndent(int n) {
            return 4 * n;
        }

        @Override
        protected int getTabRunOverlay(int n) {
            return 0;
        }

        @Override
        protected boolean shouldPadTabRun(int n, boolean bl) {
            return false;
        }

        @Override
        protected Insets getTabInsets(int n, Insets insets) {
            return new Insets(insets.top, insets.left, insets.bottom, insets.right);
        }

        @Override
        protected Insets getSelectedTabPadInsets() {
            return EMPTY_INSETS;
        }

        @Override
        protected void paintFocusIndicator(Graphics graphics, Rectangle[] rectangleArray, int n, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
        }

        @Override
        protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
            graphics.setColor(this.selectColor);
            graphics.fillRect(n2, n3, n4, n5);
        }

        @Override
        protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
            int n6 = n5;
            int n7 = n4 - 1;
            graphics.translate(n2 + 1, n3);
            if (this.isFirstDisplayedTab(n, n3, this.tabPane.getBounds().y)) {
                if (bl) {
                    graphics.setColor(this.shadowColor);
                    graphics.fillRect(n7 - 1, n6 - 1, 1, 1);
                    graphics.fillRect(0, n6, n7 - 1, 1);
                    graphics.setColor(this.selectHighlight);
                    graphics.fillRect(0, 0, n7 - 1, 1);
                    graphics.fillRect(n7 - 1, 0, 1, n6 - 1);
                    graphics.fillRect(0, n6 - 1, n7 - 1, 1);
                }
            } else if (bl) {
                graphics.setColor(this.shadowColor);
                graphics.fillRect(0, -1, n7 - 1, 1);
                graphics.fillRect(n7 - 1, 0, 1, 1);
                graphics.fillRect(n7 - 1, n6 - 1, 1, 1);
                graphics.fillRect(0, n6, n7 - 1, 1);
                graphics.setColor(this.selectHighlight);
                graphics.fillRect(0, 0, n7 - 1, 1);
                graphics.fillRect(n7 - 1, 1, 1, n6 - 2);
                graphics.fillRect(0, n6 - 1, n7 - 1, 1);
            } else {
                graphics.setColor(this.shadowColor);
                graphics.fillRect(2 * n7 / 3, 0, n7 / 3, 1);
            }
            graphics.translate(-n2 - 1, -n3);
        }

        @Override
        protected void paintContentBorderRightEdge(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, Rectangle rectangle, boolean bl2) {
            graphics.setColor(this.shadowColor);
            graphics.fillRect(n + n3 - 1, n2, 1, n4);
        }
    }

    private static class LeftRenderer
    extends AbstractRenderer {
        private LeftRenderer(JTabbedPane jTabbedPane) {
            super(jTabbedPane);
        }

        @Override
        protected Insets getTabAreaInsets(Insets insets) {
            return new Insets(insets.top + 4, insets.left, insets.bottom, insets.right);
        }

        @Override
        protected int getTabLabelShiftX(int n, boolean bl) {
            return 1;
        }

        @Override
        protected int getTabRunOverlay(int n) {
            return 1;
        }

        @Override
        protected boolean shouldPadTabRun(int n, boolean bl) {
            return false;
        }

        @Override
        protected Insets getTabInsets(int n, Insets insets) {
            return new Insets(insets.top, insets.left - 5, insets.bottom + 1, insets.right - 5);
        }

        @Override
        protected Insets getSelectedTabPadInsets() {
            return WEST_INSETS;
        }

        @Override
        protected void paintFocusIndicator(Graphics graphics, Rectangle[] rectangleArray, int n, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
            if (!this.tabPane.hasFocus() || !bl) {
                return;
            }
            Rectangle rectangle3 = rectangleArray[n];
            int n2 = rectangle3.y + 2;
            int n3 = rectangle3.x + 3;
            int n4 = rectangle3.height - 5;
            int n5 = rectangle3.width - 6;
            graphics.setColor(this.focus);
            graphics.drawRect(n3, n2, n5, n4);
        }

        @Override
        protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
            if (!bl) {
                graphics.setColor(this.selectLight);
                graphics.fillRect(n2 + 1, n3 + 1, n4 - 1, n5 - 2);
            } else {
                graphics.setColor(this.selectColor);
                graphics.fillRect(n2 + 1, n3 + 1, n4 - 3, n5 - 2);
            }
        }

        @Override
        protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
            int n6 = n5 - 1;
            int n7 = 0;
            graphics.translate(n2, n3);
            graphics.setColor(this.selectHighlight);
            graphics.fillRect(n7 + 2, 0, n4 - 2 - n7, 1);
            graphics.fillRect(n7 + 1, 1, 1, 1);
            graphics.fillRect(n7, 2, 1, n6 - 3);
            graphics.setColor(this.darkShadow);
            graphics.fillRect(n7 + 1, n6 - 1, 1, 1);
            graphics.fillRect(n7 + 2, n6, n4 - 2 - n7, 1);
            graphics.translate(-n2, -n3);
        }

        @Override
        protected void paintContentBorderLeftEdge(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, Rectangle rectangle, boolean bl2) {
            graphics.setColor(this.selectHighlight);
            if (bl && rectangle.y >= n2 && rectangle.y <= n2 + n4) {
                graphics.fillRect(n, n2, 1, rectangle.y + 1 - n2);
                if (rectangle.y + rectangle.height < n2 + n4 - 2) {
                    graphics.fillRect(n, rectangle.y + rectangle.height - 1, 1, n2 + n4 - rectangle.y - rectangle.height);
                }
            } else {
                graphics.fillRect(n, n2, 1, n4 - 1);
            }
        }
    }

    private static class LeftEmbeddedRenderer
    extends AbstractRenderer {
        private LeftEmbeddedRenderer(JTabbedPane jTabbedPane) {
            super(jTabbedPane);
        }

        @Override
        protected Insets getTabAreaInsets(Insets insets) {
            return EMPTY_INSETS;
        }

        @Override
        protected Insets getContentBorderInsets(Insets insets) {
            return WEST_INSETS;
        }

        @Override
        protected int getTabRunOverlay(int n) {
            return 0;
        }

        @Override
        protected boolean shouldPadTabRun(int n, boolean bl) {
            return false;
        }

        @Override
        protected Insets getTabInsets(int n, Insets insets) {
            return new Insets(insets.top, insets.left, insets.bottom, insets.right);
        }

        @Override
        protected Insets getSelectedTabPadInsets() {
            return EMPTY_INSETS;
        }

        @Override
        protected void paintFocusIndicator(Graphics graphics, Rectangle[] rectangleArray, int n, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
        }

        @Override
        protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
            graphics.setColor(this.selectColor);
            graphics.fillRect(n2, n3, n4, n5);
        }

        @Override
        protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
            int n6 = n5;
            int n7 = n4;
            graphics.translate(n2, n3);
            if (this.isFirstDisplayedTab(n, n3, this.tabPane.getBounds().y)) {
                if (bl) {
                    graphics.setColor(this.selectHighlight);
                    graphics.fillRect(0, 0, n7, 1);
                    graphics.fillRect(0, 0, 1, n6 - 1);
                    graphics.fillRect(1, n6 - 1, n7 - 1, 1);
                    graphics.setColor(this.shadowColor);
                    graphics.fillRect(0, n6 - 1, 1, 1);
                    graphics.fillRect(1, n6, n7 - 1, 1);
                }
            } else if (bl) {
                graphics.setColor(this.selectHighlight);
                graphics.fillRect(1, 1, n7 - 1, 1);
                graphics.fillRect(0, 2, 1, n6 - 2);
                graphics.fillRect(1, n6 - 1, n7 - 1, 1);
                graphics.setColor(this.shadowColor);
                graphics.fillRect(1, 0, n7 - 1, 1);
                graphics.fillRect(0, 1, 1, 1);
                graphics.fillRect(0, n6 - 1, 1, 1);
                graphics.fillRect(1, n6, n7 - 1, 1);
            } else {
                graphics.setColor(this.shadowColor);
                graphics.fillRect(0, 0, n7 / 3, 1);
            }
            graphics.translate(-n2, -n3);
        }

        @Override
        protected void paintContentBorderLeftEdge(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, Rectangle rectangle, boolean bl2) {
            graphics.setColor(this.shadowColor);
            graphics.fillRect(n, n2, 1, n4);
        }
    }

    private static final class BottomRenderer
    extends AbstractRenderer {
        private BottomRenderer(JTabbedPane jTabbedPane) {
            super(jTabbedPane);
        }

        @Override
        protected Insets getTabAreaInsets(Insets insets) {
            return new Insets(insets.top, insets.left + 5, insets.bottom, insets.right);
        }

        @Override
        protected int getTabLabelShiftY(int n, boolean bl) {
            return bl ? 0 : -1;
        }

        @Override
        protected int getTabRunOverlay(int n) {
            return n - 2;
        }

        @Override
        protected int getTabRunIndent(int n) {
            return 6 * n;
        }

        @Override
        protected Insets getSelectedTabPadInsets() {
            return SOUTH_INSETS;
        }

        @Override
        protected Insets getTabInsets(int n, Insets insets) {
            return new Insets(insets.top, insets.left - 2, insets.bottom, insets.right - 2);
        }

        @Override
        protected void paintFocusIndicator(Graphics graphics, Rectangle[] rectangleArray, int n, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
            if (!this.tabPane.hasFocus() || !bl) {
                return;
            }
            Rectangle rectangle3 = rectangleArray[n];
            int n2 = rectangle3.y;
            int n3 = rectangle3.x + 6;
            int n4 = rectangle3.height - 3;
            int n5 = rectangle3.width - 12;
            graphics.setColor(this.focus);
            graphics.drawRect(n3, n2, n5, n4);
        }

        @Override
        protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
            graphics.setColor(this.selectColor);
            graphics.fillRect(n2, n3, n4, n5);
        }

        @Override
        protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
            int n6 = n5 - 1;
            int n7 = n4 + 4;
            graphics.translate(n2 - 3, n3);
            graphics.setColor(this.selectHighlight);
            graphics.fillRect(0, 0, 1, 2);
            graphics.drawLine(0, 2, 4, n6 - 4);
            graphics.fillRect(5, n6 - 3, 1, 2);
            graphics.fillRect(6, n6 - 1, 1, 1);
            graphics.fillRect(7, n6, 1, 1);
            graphics.setColor(this.darkShadow);
            graphics.fillRect(8, n6, n7 - 13, 1);
            graphics.drawLine(n7 + 1, 0, n7 - 3, n6 - 4);
            graphics.fillRect(n7 - 4, n6 - 3, 1, 2);
            graphics.fillRect(n7 - 5, n6 - 1, 1, 1);
            graphics.translate(-n2 + 3, -n3);
        }

        @Override
        protected void paintContentBorderBottomEdge(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, Rectangle rectangle, boolean bl2) {
            int n5 = n2 + n4 - 1;
            int n6 = n + n3 - 1;
            graphics.translate(n, n5);
            if (bl && rectangle.x >= n && rectangle.x <= n + n3) {
                graphics.setColor(this.darkShadow);
                graphics.fillRect(0, 0, rectangle.x - n - 2, 1);
                if (rectangle.x + rectangle.width < n + n3 - 2) {
                    graphics.setColor(this.darkShadow);
                    graphics.fillRect(rectangle.x + rectangle.width + 2 - n, 0, n6 - rectangle.x - rectangle.width - 2, 1);
                }
            } else {
                graphics.setColor(this.darkShadow);
                graphics.fillRect(0, 0, n3 - 1, 1);
            }
            graphics.translate(-n, -n5);
        }

        @Override
        protected int getTabsOverlay() {
            return 4;
        }
    }

    private static class BottomEmbeddedRenderer
    extends AbstractRenderer {
        private BottomEmbeddedRenderer(JTabbedPane jTabbedPane) {
            super(jTabbedPane);
        }

        @Override
        protected Insets getTabAreaInsets(Insets insets) {
            return EMPTY_INSETS;
        }

        @Override
        protected Insets getContentBorderInsets(Insets insets) {
            return SOUTH_INSETS;
        }

        @Override
        protected Insets getSelectedTabPadInsets() {
            return EMPTY_INSETS;
        }

        @Override
        protected Insets getTabInsets(int n, Insets insets) {
            return new Insets(insets.top, insets.left, insets.bottom, insets.right);
        }

        @Override
        protected void paintFocusIndicator(Graphics graphics, Rectangle[] rectangleArray, int n, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
        }

        @Override
        protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
            graphics.setColor(this.selectColor);
            graphics.fillRect(n2, n3, n4 + 1, n5);
        }

        @Override
        protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
            int n6 = n5;
            int n7 = n4 + 1;
            graphics.translate(n2, n3);
            if (this.isFirstDisplayedTab(n, n2, this.tabPane.getBounds().x)) {
                if (bl) {
                    graphics.setColor(this.shadowColor);
                    graphics.fillRect(n7, 0, 1, n6 - 1);
                    graphics.fillRect(n7 - 1, n6 - 1, 1, 1);
                    graphics.setColor(this.selectHighlight);
                    graphics.fillRect(0, 0, 1, n6);
                    graphics.fillRect(n7 - 1, 0, 1, n6 - 1);
                    graphics.fillRect(1, n6 - 1, n7 - 2, 1);
                }
            } else if (bl) {
                graphics.setColor(this.shadowColor);
                graphics.fillRect(0, 0, 1, n6 - 1);
                graphics.fillRect(1, n6 - 1, 1, 1);
                graphics.fillRect(n7, 0, 1, n6 - 1);
                graphics.fillRect(n7 - 1, n6 - 1, 1, 1);
                graphics.setColor(this.selectHighlight);
                graphics.fillRect(1, 0, 1, n6 - 1);
                graphics.fillRect(n7 - 1, 0, 1, n6 - 1);
                graphics.fillRect(2, n6 - 1, n7 - 3, 1);
            } else {
                graphics.setColor(this.shadowColor);
                graphics.fillRect(1, n5 / 2, 1, n5 - n5 / 2);
            }
            graphics.translate(-n2, -n3);
        }

        @Override
        protected void paintContentBorderBottomEdge(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, Rectangle rectangle, boolean bl2) {
            graphics.setColor(this.shadowColor);
            graphics.fillRect(n, n2 + n4 - 1, n3, 1);
        }
    }

    private static abstract class AbstractRenderer {
        protected static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
        protected static final Insets NORTH_INSETS = new Insets(2, 2, 0, 2);
        protected static final Insets WEST_INSETS = new Insets(0, 1, 0, 0);
        protected static final Insets SOUTH_INSETS = new Insets(0, 0, 1, 0);
        protected static final Insets EAST_INSETS = new Insets(0, 0, 0, 1);
        protected final JTabbedPane tabPane;
        protected final int tabPlacement;
        protected Color shadowColor;
        protected Color darkShadow;
        protected Color selectColor;
        protected Color selectLight;
        protected Color selectHighlight;
        protected Color lightHighlight;
        protected Color focus;

        private AbstractRenderer(JTabbedPane jTabbedPane) {
            this.initColors();
            this.tabPane = jTabbedPane;
            this.tabPlacement = jTabbedPane.getTabPlacement();
        }

        private static AbstractRenderer createRenderer(JTabbedPane jTabbedPane) {
            switch (jTabbedPane.getTabPlacement()) {
                case 1: {
                    return new TopRenderer(jTabbedPane);
                }
                case 3: {
                    return new BottomRenderer(jTabbedPane);
                }
                case 2: {
                    return new LeftRenderer(jTabbedPane);
                }
                case 4: {
                    return new RightRenderer(jTabbedPane);
                }
            }
            return new TopRenderer(jTabbedPane);
        }

        private static AbstractRenderer createEmbeddedRenderer(JTabbedPane jTabbedPane) {
            switch (jTabbedPane.getTabPlacement()) {
                case 1: {
                    return new TopEmbeddedRenderer(jTabbedPane);
                }
                case 3: {
                    return new BottomEmbeddedRenderer(jTabbedPane);
                }
                case 2: {
                    return new LeftEmbeddedRenderer(jTabbedPane);
                }
                case 4: {
                    return new RightEmbeddedRenderer(jTabbedPane);
                }
            }
            return new TopEmbeddedRenderer(jTabbedPane);
        }

        private void initColors() {
            this.shadowColor = UIManager.getColor("TabbedPane.shadow");
            this.darkShadow = UIManager.getColor("TabbedPane.darkShadow");
            this.selectColor = UIManager.getColor("TabbedPane.selected");
            this.focus = UIManager.getColor("TabbedPane.focus");
            this.selectHighlight = UIManager.getColor("TabbedPane.selectHighlight");
            this.lightHighlight = UIManager.getColor("TabbedPane.highlight");
            this.selectLight = new Color((2 * this.selectColor.getRed() + this.selectHighlight.getRed()) / 3, (2 * this.selectColor.getGreen() + this.selectHighlight.getGreen()) / 3, (2 * this.selectColor.getBlue() + this.selectHighlight.getBlue()) / 3);
        }

        protected boolean isFirstDisplayedTab(int n, int n2, int n3) {
            return n == 0;
        }

        protected Insets getTabAreaInsets(Insets insets) {
            return insets;
        }

        protected Insets getContentBorderInsets(Insets insets) {
            return insets;
        }

        protected int getTabLabelShiftX(int n, boolean bl) {
            return 0;
        }

        protected int getTabLabelShiftY(int n, boolean bl) {
            return 0;
        }

        protected int getTabRunOverlay(int n) {
            return n;
        }

        protected boolean shouldPadTabRun(int n, boolean bl) {
            return bl;
        }

        protected int getTabRunIndent(int n) {
            return 0;
        }

        protected abstract Insets getTabInsets(int var1, Insets var2);

        protected abstract void paintFocusIndicator(Graphics var1, Rectangle[] var2, int var3, Rectangle var4, Rectangle var5, boolean var6);

        protected abstract void paintTabBackground(Graphics var1, int var2, int var3, int var4, int var5, int var6, boolean var7);

        protected abstract void paintTabBorder(Graphics var1, int var2, int var3, int var4, int var5, int var6, boolean var7);

        protected Insets getSelectedTabPadInsets() {
            return EMPTY_INSETS;
        }

        protected void paintContentBorderTopEdge(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, Rectangle rectangle, boolean bl2) {
            if (bl2) {
                graphics.setColor(this.selectHighlight);
                graphics.fillRect(n, n2, n3 - 1, 1);
            }
        }

        protected void paintContentBorderBottomEdge(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, Rectangle rectangle, boolean bl2) {
            if (bl2) {
                graphics.setColor(this.darkShadow);
                graphics.fillRect(n, n2 + n4 - 1, n3 - 1, 1);
            }
        }

        protected void paintContentBorderLeftEdge(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, Rectangle rectangle, boolean bl2) {
            if (bl2) {
                graphics.setColor(this.darkShadow);
                graphics.fillRect(n, n2, 1, n4 - 1);
            }
        }

        protected void paintContentBorderRightEdge(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, Rectangle rectangle, boolean bl2) {
            if (bl2) {
                graphics.setColor(this.darkShadow);
                graphics.fillRect(n + n3 - 1, n2, 1, n4);
            }
        }

        protected int getTabsOverlay() {
            return 0;
        }
    }

    private static class ArrowButton
    extends JButton
    implements UIResource {
        private final int buttonWidth;
        private final int direction;
        private boolean mouseIsOver;

        ArrowButton(int n, int n2) {
            this.direction = n;
            this.buttonWidth = n2;
            this.setRequestFocusEnabled(false);
        }

        @Override
        protected void processMouseEvent(MouseEvent mouseEvent) {
            super.processMouseEvent(mouseEvent);
            switch (mouseEvent.getID()) {
                case 504: {
                    this.mouseIsOver = true;
                    this.revalidate();
                    this.repaint();
                    break;
                }
                case 505: {
                    this.mouseIsOver = false;
                    this.revalidate();
                    this.repaint();
                }
            }
        }

        @Override
        protected void paintBorder(Graphics graphics) {
            if (this.mouseIsOver && this.isEnabled()) {
                super.paintBorder(graphics);
            }
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (this.mouseIsOver) {
                super.paintComponent(graphics);
            } else {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            this.paintArrow(graphics);
        }

        private void paintArrow(Graphics graphics) {
            int n;
            int n2;
            Color color = graphics.getColor();
            boolean bl = this.isEnabled();
            graphics.setColor(bl ? PlasticLookAndFeel.getControlInfo() : PlasticLookAndFeel.getControlDisabled());
            switch (this.direction) {
                case 1: 
                case 5: {
                    n2 = 9;
                    n = 5;
                    break;
                }
                default: {
                    n2 = 5;
                    n = 9;
                }
            }
            int n3 = (this.getWidth() - n2) / 2;
            int n4 = (this.getHeight() - n) / 2;
            graphics.translate(n3, n4);
            boolean bl2 = !this.mouseIsOver || !bl;
            Color color2 = bl ? PlasticLookAndFeel.getControlShadow() : UIManager.getColor("ScrollBar.highlight");
            switch (this.direction) {
                case 1: {
                    graphics.fillRect(0, 4, 9, 1);
                    graphics.fillRect(1, 3, 7, 1);
                    graphics.fillRect(2, 2, 5, 1);
                    graphics.fillRect(3, 1, 3, 1);
                    graphics.fillRect(4, 0, 1, 1);
                    if (!bl2) break;
                    graphics.setColor(color2);
                    graphics.fillRect(1, 5, 9, 1);
                    break;
                }
                case 5: {
                    graphics.fillRect(0, 0, 9, 1);
                    graphics.fillRect(1, 1, 7, 1);
                    graphics.fillRect(2, 2, 5, 1);
                    graphics.fillRect(3, 3, 3, 1);
                    graphics.fillRect(4, 4, 1, 1);
                    if (!bl2) break;
                    graphics.setColor(color2);
                    graphics.drawLine(5, 4, 8, 1);
                    graphics.drawLine(5, 5, 9, 1);
                    break;
                }
                case 7: {
                    graphics.fillRect(0, 4, 1, 1);
                    graphics.fillRect(1, 3, 1, 3);
                    graphics.fillRect(2, 2, 1, 5);
                    graphics.fillRect(3, 1, 1, 7);
                    graphics.fillRect(4, 0, 1, 9);
                    if (!bl2) break;
                    graphics.setColor(color2);
                    graphics.fillRect(5, 1, 1, 9);
                    break;
                }
                case 3: {
                    graphics.fillRect(0, 0, 1, 9);
                    graphics.fillRect(1, 1, 1, 7);
                    graphics.fillRect(2, 2, 1, 5);
                    graphics.fillRect(3, 3, 1, 3);
                    graphics.fillRect(4, 4, 1, 1);
                    if (!bl2) break;
                    graphics.setColor(color2);
                    graphics.drawLine(1, 8, 4, 5);
                    graphics.drawLine(1, 9, 5, 5);
                }
            }
            graphics.translate(-n3, -n4);
            graphics.setColor(color);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.buttonWidth, this.buttonWidth);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
    }

    private class PlasticCloseButton
    extends AdvancedTabbedPaneUI.CloseButton
    implements UIResource {
        private Component component;
        private final int buttonWidth;
        private boolean mouseIsOver;

        PlasticCloseButton(Component component, int n) {
            this.component = component;
            this.buttonWidth = n;
            this.setRequestFocusEnabled(false);
            this.setFocusable(false);
            this.setOpaque(false);
        }

        @Override
        public Component getAssociatedComponent() {
            return this.component;
        }

        @Override
        protected void processMouseEvent(MouseEvent mouseEvent) {
            super.processMouseEvent(mouseEvent);
            switch (mouseEvent.getID()) {
                case 504: {
                    this.mouseIsOver = true;
                    this.revalidate();
                    this.repaint();
                    break;
                }
                case 505: {
                    this.mouseIsOver = false;
                    this.revalidate();
                    this.repaint();
                }
            }
        }

        @Override
        protected void paintBorder(Graphics graphics) {
            if (this.mouseIsOver && this.isEnabled()) {
                super.paintBorder(graphics);
            }
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (this.mouseIsOver) {
                super.paintComponent(graphics);
            }
            this.paintX(graphics);
        }

        private void paintX(Graphics graphics) {
            Color color = graphics.getColor();
            boolean bl = this.isEnabled();
            graphics.setColor(bl ? PlasticLookAndFeel.getControlInfo() : PlasticLookAndFeel.getControlDisabled());
            int n = (this.getWidth() - 9) / 2;
            int n2 = (this.getHeight() - 9) / 2;
            graphics.translate(n, n2);
            boolean bl2 = !this.mouseIsOver || !bl;
            Color color2 = bl ? PlasticLookAndFeel.getControlShadow() : UIManager.getColor("ScrollBar.highlight");
            graphics.fillRect(0, 0, 2, 2);
            graphics.fillRect(1, 1, 2, 2);
            graphics.fillRect(2, 2, 2, 2);
            graphics.fillRect(7, 0, 2, 2);
            graphics.fillRect(6, 1, 2, 2);
            graphics.fillRect(5, 2, 2, 2);
            graphics.fillRect(0, 7, 2, 2);
            graphics.fillRect(1, 6, 2, 2);
            graphics.fillRect(2, 5, 2, 2);
            graphics.fillRect(7, 7, 2, 2);
            graphics.fillRect(6, 6, 2, 2);
            graphics.fillRect(5, 5, 2, 2);
            graphics.fillRect(3, 3, 3, 3);
            if (bl2) {
                graphics.setColor(color2);
                graphics.fillRect(2, 8, 1, 1);
                graphics.fillRect(3, 7, 1, 1);
                graphics.fillRect(4, 6, 1, 1);
                graphics.fillRect(6, 4, 1, 1);
                graphics.fillRect(7, 3, 1, 1);
                graphics.fillRect(8, 2, 1, 1);
            }
            graphics.translate(-n, -n2);
            graphics.setColor(color);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.buttonWidth, this.buttonWidth);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
    }

    private class ScrollableTabPanel
    extends JPanel
    implements UIResource {
        public ScrollableTabPanel() {
            super(null);
            this.setOpaque(PlasticXPAdvancedTabbedPaneUI.this.tabPane.isOpaque());
            Color color = UIManager.getColor("TabbedPane.tabAreaBackground");
            if (color == null) {
                color = PlasticXPAdvancedTabbedPaneUI.this.tabPane.getBackground();
            }
            this.setBackground(color);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            PlasticXPAdvancedTabbedPaneUI.this.paintTabArea(graphics, PlasticXPAdvancedTabbedPaneUI.this.tabPane.getTabPlacement(), PlasticXPAdvancedTabbedPaneUI.this.tabPane.getSelectedIndex());
        }
    }

    private class ScrollableTabViewport
    extends JViewport
    implements UIResource {
        public ScrollableTabViewport() {
            this.setName("TabbedPane.scrollableViewport");
            this.setScrollMode(0);
            this.setOpaque(PlasticXPAdvancedTabbedPaneUI.this.tabPane.isOpaque());
            Color color = UIManager.getColor("TabbedPane.tabAreaBackground");
            if (color == null) {
                color = PlasticXPAdvancedTabbedPaneUI.this.tabPane.getBackground();
            }
            this.setBackground(color);
        }
    }

    private class ScrollableTabSupport
    implements ActionListener,
    ChangeListener {
        public ScrollableTabViewport viewport;
        public ScrollableTabPanel tabPanel;
        public JButton scrollForwardButton;
        public JButton scrollBackwardButton;
        public int leadingTabIndex;
        private Point tabViewPosition = new Point(0, 0);

        ScrollableTabSupport(int n) {
            this.viewport = new ScrollableTabViewport();
            this.tabPanel = new ScrollableTabPanel();
            this.viewport.setView(this.tabPanel);
            this.viewport.addChangeListener(this);
            this.createButtons();
        }

        void createButtons() {
            if (this.scrollForwardButton != null) {
                PlasticXPAdvancedTabbedPaneUI.this.tabPane.remove(this.scrollForwardButton);
                this.scrollForwardButton.removeActionListener(this);
                PlasticXPAdvancedTabbedPaneUI.this.tabPane.remove(this.scrollBackwardButton);
                this.scrollBackwardButton.removeActionListener(this);
            }
            int n = PlasticXPAdvancedTabbedPaneUI.this.tabPane.getTabPlacement();
            int n2 = UIManager.getInt("ScrollBar.width");
            if (n == 1 || n == 3) {
                this.scrollForwardButton = new ArrowButton(3, n2);
                this.scrollBackwardButton = new ArrowButton(7, n2);
            } else {
                this.scrollForwardButton = new ArrowButton(5, n2);
                this.scrollBackwardButton = new ArrowButton(1, n2);
            }
            this.scrollForwardButton.addActionListener(this);
            this.scrollBackwardButton.addActionListener(this);
            PlasticXPAdvancedTabbedPaneUI.this.tabPane.add(this.scrollForwardButton);
            PlasticXPAdvancedTabbedPaneUI.this.tabPane.add(this.scrollBackwardButton);
        }

        public void scrollForward(int n) {
            Dimension dimension = this.viewport.getViewSize();
            Rectangle rectangle = this.viewport.getViewRect();
            if (n == 1 || n == 3 ? rectangle.width >= dimension.width - rectangle.x : rectangle.height >= dimension.height - rectangle.y) {
                return;
            }
            this.setLeadingTabIndex(n, this.leadingTabIndex + 1);
        }

        public void scrollBackward(int n) {
            if (this.leadingTabIndex == 0) {
                return;
            }
            this.setLeadingTabIndex(n, this.leadingTabIndex - 1);
        }

        public void setLeadingTabIndex(int n, int n2) {
            this.leadingTabIndex = n2;
            Dimension dimension = this.viewport.getViewSize();
            Rectangle rectangle = this.viewport.getViewRect();
            switch (n) {
                case 1: 
                case 3: {
                    int n3 = this.tabViewPosition.x = this.leadingTabIndex == 0 ? 0 : ((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).rects[this.leadingTabIndex].x - PlasticXPAdvancedTabbedPaneUI.this.renderer.getTabsOverlay();
                    if (dimension.width - this.tabViewPosition.x >= rectangle.width) break;
                    Dimension dimension2 = new Dimension(dimension.width - this.tabViewPosition.x, rectangle.height);
                    this.viewport.setExtentSize(dimension2);
                    break;
                }
                case 2: 
                case 4: {
                    int n4 = this.tabViewPosition.y = this.leadingTabIndex == 0 ? 0 : ((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).rects[this.leadingTabIndex].y;
                    if (dimension.height - this.tabViewPosition.y >= rectangle.height) break;
                    Dimension dimension3 = new Dimension(rectangle.width, dimension.height - this.tabViewPosition.y);
                    this.viewport.setExtentSize(dimension3);
                }
            }
            this.viewport.setViewPosition(this.tabViewPosition);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            JViewport jViewport = (JViewport)changeEvent.getSource();
            int n = PlasticXPAdvancedTabbedPaneUI.this.tabPane.getTabPlacement();
            int n2 = PlasticXPAdvancedTabbedPaneUI.this.tabPane.getTabCount();
            Rectangle rectangle = jViewport.getBounds();
            Dimension dimension = jViewport.getViewSize();
            Rectangle rectangle2 = jViewport.getViewRect();
            this.leadingTabIndex = PlasticXPAdvancedTabbedPaneUI.this.getClosestTab(rectangle2.x, rectangle2.y);
            if (this.leadingTabIndex + 1 < n2) {
                switch (n) {
                    case 1: 
                    case 3: {
                        if (((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).rects[this.leadingTabIndex].x >= rectangle2.x) break;
                        ++this.leadingTabIndex;
                        break;
                    }
                    case 2: 
                    case 4: {
                        if (((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).rects[this.leadingTabIndex].y >= rectangle2.y) break;
                        ++this.leadingTabIndex;
                    }
                }
            }
            Insets insets = PlasticXPAdvancedTabbedPaneUI.this.getContentBorderInsets(n);
            switch (n) {
                case 2: {
                    PlasticXPAdvancedTabbedPaneUI.this.tabPane.repaint(rectangle.x + rectangle.width, rectangle.y, insets.left, rectangle.height);
                    this.scrollBackwardButton.setEnabled(rectangle2.y > 0 && this.leadingTabIndex > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n2 - 1 && dimension.height - rectangle2.y > rectangle2.height);
                    break;
                }
                case 4: {
                    PlasticXPAdvancedTabbedPaneUI.this.tabPane.repaint(rectangle.x - insets.right, rectangle.y, insets.right, rectangle.height);
                    this.scrollBackwardButton.setEnabled(rectangle2.y > 0 && this.leadingTabIndex > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n2 - 1 && dimension.height - rectangle2.y > rectangle2.height);
                    break;
                }
                case 3: {
                    PlasticXPAdvancedTabbedPaneUI.this.tabPane.repaint(rectangle.x, rectangle.y - insets.bottom, rectangle.width, insets.bottom);
                    this.scrollBackwardButton.setEnabled(rectangle2.x > 0 && this.leadingTabIndex > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n2 - 1 && dimension.width - rectangle2.x > rectangle2.width);
                    break;
                }
                default: {
                    PlasticXPAdvancedTabbedPaneUI.this.tabPane.repaint(rectangle.x, rectangle.y + rectangle.height, rectangle.width, insets.top);
                    this.scrollBackwardButton.setEnabled(rectangle2.x > 0 && this.leadingTabIndex > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n2 - 1 && dimension.width - rectangle2.x > rectangle2.width);
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            Action action;
            ActionMap actionMap = PlasticXPAdvancedTabbedPaneUI.this.tabPane.getActionMap();
            if (actionMap != null && (action = actionMap.get(string = actionEvent.getSource() == this.scrollForwardButton ? "scrollTabsForwardAction" : "scrollTabsBackwardAction")) != null && action.isEnabled()) {
                action.actionPerformed(new ActionEvent(PlasticXPAdvancedTabbedPaneUI.this.tabPane, 1001, null, actionEvent.getWhen(), actionEvent.getModifiers()));
            }
        }
    }

    private class TabbedPaneScrollLayout
    extends TabbedPaneLayout {
        private TabbedPaneScrollLayout() {
        }

        @Override
        protected int preferredTabAreaHeight(int n, int n2) {
            return PlasticXPAdvancedTabbedPaneUI.this.calculateMaxTabHeight(n);
        }

        @Override
        protected int preferredTabAreaWidth(int n, int n2) {
            return PlasticXPAdvancedTabbedPaneUI.this.calculateMaxTabWidth(n);
        }

        @Override
        public void layoutContainer(Container container) {
            int n = PlasticXPAdvancedTabbedPaneUI.this.tabPane.getTabPlacement();
            int n2 = PlasticXPAdvancedTabbedPaneUI.this.tabPane.getTabCount();
            Insets insets = PlasticXPAdvancedTabbedPaneUI.this.tabPane.getInsets();
            int n3 = PlasticXPAdvancedTabbedPaneUI.this.tabPane.getSelectedIndex();
            Component component = PlasticXPAdvancedTabbedPaneUI.this.getVisibleComponent();
            this.calculateLayoutInfo();
            if (n3 < 0) {
                if (component != null) {
                    PlasticXPAdvancedTabbedPaneUI.this.setVisibleComponent(null);
                }
            } else {
                Component component2 = PlasticXPAdvancedTabbedPaneUI.this.tabPane.getComponentAt(n3);
                boolean bl = false;
                if (component2 != null) {
                    if (component2 != component && component != null && SwingUtilities.findFocusOwner(component) != null) {
                        bl = true;
                    }
                    PlasticXPAdvancedTabbedPaneUI.this.setVisibleComponent(component2);
                }
                Insets insets2 = PlasticXPAdvancedTabbedPaneUI.this.getContentBorderInsets(n);
                Rectangle rectangle = PlasticXPAdvancedTabbedPaneUI.this.tabPane.getBounds();
                int n4 = PlasticXPAdvancedTabbedPaneUI.this.tabPane.getComponentCount();
                if (n4 > 0) {
                    int n5;
                    int n6;
                    int n7;
                    int n8;
                    int n9;
                    int n10;
                    int n11;
                    int n12;
                    switch (n) {
                        case 2: {
                            n12 = PlasticXPAdvancedTabbedPaneUI.this.calculateTabAreaWidth(n, PlasticXPAdvancedTabbedPaneUI.this.runCount, PlasticXPAdvancedTabbedPaneUI.this.maxTabWidth);
                            n11 = rectangle.height - insets.top - insets.bottom;
                            n10 = insets.left;
                            n9 = insets.top;
                            n8 = n10 + n12 + insets2.left;
                            n7 = n9 + insets2.top;
                            n6 = rectangle.width - insets.left - insets.right - n12 - insets2.left - insets2.right;
                            n5 = rectangle.height - insets.top - insets.bottom - insets2.top - insets2.bottom;
                            break;
                        }
                        case 4: {
                            n12 = PlasticXPAdvancedTabbedPaneUI.this.calculateTabAreaWidth(n, PlasticXPAdvancedTabbedPaneUI.this.runCount, PlasticXPAdvancedTabbedPaneUI.this.maxTabWidth);
                            n11 = rectangle.height - insets.top - insets.bottom;
                            n10 = rectangle.width - insets.right - n12;
                            n9 = insets.top;
                            n8 = insets.left + insets2.left;
                            n7 = insets.top + insets2.top;
                            n6 = rectangle.width - insets.left - insets.right - n12 - insets2.left - insets2.right;
                            n5 = rectangle.height - insets.top - insets.bottom - insets2.top - insets2.bottom;
                            break;
                        }
                        case 3: {
                            n12 = rectangle.width - insets.left - insets.right;
                            n11 = PlasticXPAdvancedTabbedPaneUI.this.calculateTabAreaHeight(n, PlasticXPAdvancedTabbedPaneUI.this.runCount, PlasticXPAdvancedTabbedPaneUI.this.maxTabHeight);
                            n10 = insets.left;
                            n9 = rectangle.height - insets.bottom - n11;
                            n8 = insets.left + insets2.left;
                            n7 = insets.top + insets2.top;
                            n6 = rectangle.width - insets.left - insets.right - insets2.left - insets2.right;
                            n5 = rectangle.height - insets.top - insets.bottom - n11 - insets2.top - insets2.bottom;
                            break;
                        }
                        default: {
                            n12 = rectangle.width - insets.left - insets.right;
                            n11 = PlasticXPAdvancedTabbedPaneUI.this.calculateTabAreaHeight(n, PlasticXPAdvancedTabbedPaneUI.this.runCount, PlasticXPAdvancedTabbedPaneUI.this.maxTabHeight);
                            n10 = insets.left;
                            n9 = insets.top;
                            n8 = n10 + insets2.left;
                            n7 = n9 + n11 + insets2.top;
                            n6 = rectangle.width - insets.left - insets.right - insets2.left - insets2.right;
                            n5 = rectangle.height - insets.top - insets.bottom - n11 - insets2.top - insets2.bottom;
                        }
                    }
                    for (int i = 0; i < n4; ++i) {
                        int n13;
                        int n14;
                        int n15;
                        Cloneable cloneable;
                        int n16;
                        Serializable serializable;
                        Component component3 = PlasticXPAdvancedTabbedPaneUI.this.tabPane.getComponent(i);
                        if (PlasticXPAdvancedTabbedPaneUI.this.tabScroller != null && component3 == ((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).tabScroller.viewport) {
                            JViewport jViewport = (JViewport)component3;
                            serializable = jViewport.getViewRect();
                            int n17 = n12;
                            n16 = n11;
                            cloneable = ((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).tabScroller.scrollForwardButton.getPreferredSize();
                            switch (n) {
                                case 2: 
                                case 4: {
                                    n15 = ((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).rects[n2 - 1].y + ((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).rects[n2 - 1].height;
                                    if (n15 <= n11) break;
                                    int n18 = n16 = n11 > 2 * cloneable.height ? n11 - 2 * cloneable.height : 0;
                                    if (n15 - serializable.y > n16) break;
                                    n16 = n15 - serializable.y;
                                    break;
                                }
                                default: {
                                    n14 = ((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).rects[n2 - 1].x + ((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).rects[n2 - 1].width + PlasticXPAdvancedTabbedPaneUI.this.renderer.getTabsOverlay();
                                    if (n14 <= n12) break;
                                    int n19 = n17 = n12 > 2 * cloneable.width ? n12 - 2 * cloneable.width : 0;
                                    if (n14 - serializable.x > n17) break;
                                    n17 = n14 - serializable.x;
                                }
                            }
                            component3.setBounds(n10, n9, n17, n16);
                            continue;
                        }
                        if (PlasticXPAdvancedTabbedPaneUI.this.tabScroller != null && (component3 == ((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).tabScroller.scrollForwardButton || component3 == ((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).tabScroller.scrollBackwardButton)) {
                            Component component4 = component3;
                            serializable = component4.getPreferredSize();
                            int n20 = 0;
                            n16 = 0;
                            int n21 = ((Dimension)serializable).width;
                            n15 = ((Dimension)serializable).height;
                            n14 = 0;
                            switch (n) {
                                case 2: 
                                case 4: {
                                    int n22 = ((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).rects[n2 - 1].y + ((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).rects[n2 - 1].height;
                                    if (n22 <= n11) break;
                                    n14 = 1;
                                    n20 = n == 2 ? n10 + n12 - ((Dimension)serializable).width : n10;
                                    n16 = component3 == ((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).tabScroller.scrollForwardButton ? rectangle.height - insets.bottom - ((Dimension)serializable).height : rectangle.height - insets.bottom - 2 * ((Dimension)serializable).height;
                                    break;
                                }
                                default: {
                                    n13 = ((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).rects[n2 - 1].x + ((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).rects[n2 - 1].width;
                                    if (n13 <= n12) break;
                                    n14 = 1;
                                    n20 = component3 == ((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).tabScroller.scrollForwardButton ? rectangle.width - insets.left - ((Dimension)serializable).width : rectangle.width - insets.left - 2 * ((Dimension)serializable).width;
                                    n16 = n == 1 ? n9 + n11 - ((Dimension)serializable).height : n9;
                                }
                            }
                            component3.setVisible(n14 != 0);
                            if (n14 == 0) continue;
                            component3.setBounds(n20, n16, n21, n15);
                            continue;
                        }
                        if (component3 instanceof PlasticCloseButton) {
                            int n23 = UIManager.getInt("ScrollBar.width");
                            serializable = (PlasticCloseButton)component3;
                            Component component5 = ((PlasticCloseButton)serializable).getAssociatedComponent();
                            n16 = PlasticXPAdvancedTabbedPaneUI.this.tabPane.indexOfComponent(component5);
                            if (n16 < 0) continue;
                            cloneable = PlasticXPAdvancedTabbedPaneUI.this.getTabBounds(n16, new Rectangle());
                            n15 = ((Rectangle)cloneable).x + ((Rectangle)cloneable).width - n23 - (n16 == n3 - 1 ? 4 : 2);
                            n14 = ((Rectangle)cloneable).y + (n16 == n3 ? 4 : 2);
                            component3.setBounds(n15, n14, n23, n23);
                            if (!PlasticXPAdvancedTabbedPaneUI.this.scrollableTabLayoutEnabled()) continue;
                            Rectangle rectangle2 = ((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).tabScroller.viewport.getViewRect();
                            switch (n) {
                                case 2: 
                                case 4: {
                                    n13 = rectangle2.height;
                                    component3.setVisible(n14 > 0 && n14 + n23 < n13);
                                    break;
                                }
                                default: {
                                    n13 = rectangle2.width;
                                    component3.setVisible(n15 > 0 && n15 + n23 < n13);
                                }
                            }
                            continue;
                        }
                        component3.setBounds(n8, n7, n6, n5);
                    }
                    if (bl && !PlasticXPAdvancedTabbedPaneUI.this.requestFocusForVisibleComponent()) {
                        PlasticXPAdvancedTabbedPaneUI.this.tabPane.requestFocus();
                    }
                }
            }
        }

        @Override
        protected void calculateTabRects(int n, int n2) {
            int n3;
            FontMetrics fontMetrics = PlasticXPAdvancedTabbedPaneUI.this.getFontMetrics();
            Dimension dimension = PlasticXPAdvancedTabbedPaneUI.this.tabPane.getSize();
            Insets insets = PlasticXPAdvancedTabbedPaneUI.this.tabPane.getInsets();
            Insets insets2 = PlasticXPAdvancedTabbedPaneUI.this.getTabAreaInsets(n);
            int n4 = fontMetrics.getHeight();
            int n5 = PlasticXPAdvancedTabbedPaneUI.this.tabPane.getSelectedIndex();
            boolean bl = n == 2 || n == 4;
            boolean bl2 = PlasticUtils.isLeftToRight(PlasticXPAdvancedTabbedPaneUI.this.tabPane);
            int n6 = insets2.left;
            int n7 = insets2.top;
            int n8 = 0;
            int n9 = 0;
            switch (n) {
                case 2: 
                case 4: {
                    PlasticXPAdvancedTabbedPaneUI.this.maxTabWidth = PlasticXPAdvancedTabbedPaneUI.this.calculateMaxTabWidth(n);
                    break;
                }
                default: {
                    PlasticXPAdvancedTabbedPaneUI.this.maxTabHeight = PlasticXPAdvancedTabbedPaneUI.this.calculateMaxTabHeight(n);
                }
            }
            PlasticXPAdvancedTabbedPaneUI.this.runCount = 0;
            PlasticXPAdvancedTabbedPaneUI.this.selectedRun = -1;
            if (n2 == 0) {
                return;
            }
            PlasticXPAdvancedTabbedPaneUI.this.selectedRun = 0;
            PlasticXPAdvancedTabbedPaneUI.this.runCount = 1;
            for (n3 = 0; n3 < n2; ++n3) {
                Rectangle rectangle = PlasticXPAdvancedTabbedPaneUI.this.rects[n3];
                if (!bl) {
                    if (n3 > 0) {
                        rectangle.x = ((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).rects[n3 - 1].x + ((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).rects[n3 - 1].width - 1;
                    } else {
                        ((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).tabRuns[0] = 0;
                        PlasticXPAdvancedTabbedPaneUI.this.maxTabWidth = 0;
                        n9 += PlasticXPAdvancedTabbedPaneUI.this.maxTabHeight;
                        rectangle.x = n6;
                    }
                    rectangle.width = PlasticXPAdvancedTabbedPaneUI.this.calculateTabWidth(n, n3, fontMetrics);
                    rectangle.width += 20;
                    n8 = rectangle.x + rectangle.width + PlasticXPAdvancedTabbedPaneUI.this.renderer.getTabsOverlay();
                    PlasticXPAdvancedTabbedPaneUI.this.maxTabWidth = Math.max(PlasticXPAdvancedTabbedPaneUI.this.maxTabWidth, rectangle.width);
                    rectangle.y = n7;
                    rectangle.height = PlasticXPAdvancedTabbedPaneUI.this.maxTabHeight;
                    continue;
                }
                if (n3 > 0) {
                    rectangle.y = ((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).rects[n3 - 1].y + ((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).rects[n3 - 1].height;
                } else {
                    ((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).tabRuns[0] = 0;
                    PlasticXPAdvancedTabbedPaneUI.this.maxTabHeight = 0;
                    n8 = PlasticXPAdvancedTabbedPaneUI.this.maxTabWidth;
                    rectangle.y = n7;
                }
                rectangle.height = PlasticXPAdvancedTabbedPaneUI.this.calculateTabHeight(n, n3, n4);
                n9 = rectangle.y + rectangle.height;
                PlasticXPAdvancedTabbedPaneUI.this.maxTabHeight = Math.max(PlasticXPAdvancedTabbedPaneUI.this.maxTabHeight, rectangle.height);
                rectangle.x = n6;
                rectangle.width = PlasticXPAdvancedTabbedPaneUI.this.maxTabWidth;
            }
            if (!bl2 && !bl) {
                int n10 = dimension.width - (insets.right + insets2.right);
                for (n3 = 0; n3 < n2; ++n3) {
                    ((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).rects[n3].x = n10 - ((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).rects[n3].x - ((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).rects[n3].width;
                }
            }
            ((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).tabScroller.tabPanel.setPreferredSize(new Dimension(n8, n9));
        }
    }

    private static class ScrollTabsBackwardAction
    extends AbstractAction {
        private ScrollTabsBackwardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = null;
            Object object = actionEvent.getSource();
            if (object instanceof JTabbedPane) {
                jTabbedPane = (JTabbedPane)object;
            } else if (object instanceof PlasticArrowButton) {
                jTabbedPane = (JTabbedPane)((PlasticArrowButton)object).getParent();
            } else {
                return;
            }
            PlasticXPAdvancedTabbedPaneUI plasticXPAdvancedTabbedPaneUI = (PlasticXPAdvancedTabbedPaneUI)jTabbedPane.getUI();
            if (plasticXPAdvancedTabbedPaneUI.scrollableTabLayoutEnabled()) {
                plasticXPAdvancedTabbedPaneUI.tabScroller.scrollBackward(jTabbedPane.getTabPlacement());
            }
        }
    }

    private static class ScrollTabsForwardAction
    extends AbstractAction {
        private ScrollTabsForwardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = null;
            Object object = actionEvent.getSource();
            if (object instanceof JTabbedPane) {
                jTabbedPane = (JTabbedPane)object;
            } else if (object instanceof PlasticArrowButton) {
                jTabbedPane = (JTabbedPane)((PlasticArrowButton)object).getParent();
            } else {
                return;
            }
            PlasticXPAdvancedTabbedPaneUI plasticXPAdvancedTabbedPaneUI = (PlasticXPAdvancedTabbedPaneUI)jTabbedPane.getUI();
            if (plasticXPAdvancedTabbedPaneUI.scrollableTabLayoutEnabled()) {
                plasticXPAdvancedTabbedPaneUI.tabScroller.scrollForward(jTabbedPane.getTabPlacement());
            }
        }
    }

    private class TabbedPaneLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout
    implements LayoutManager {
        private TabbedPaneLayout() {
            super(PlasticXPAdvancedTabbedPaneUI.this);
        }

        @Override
        protected void calculateTabRects(int n, int n2) {
            int n3;
            Rectangle rectangle;
            int n4;
            int n5;
            int n6;
            int n7;
            FontMetrics fontMetrics = PlasticXPAdvancedTabbedPaneUI.this.getFontMetrics();
            Dimension dimension = PlasticXPAdvancedTabbedPaneUI.this.tabPane.getSize();
            Insets insets = PlasticXPAdvancedTabbedPaneUI.this.tabPane.getInsets();
            Insets insets2 = PlasticXPAdvancedTabbedPaneUI.this.getTabAreaInsets(n);
            int n8 = fontMetrics.getHeight();
            int n9 = PlasticXPAdvancedTabbedPaneUI.this.tabPane.getSelectedIndex();
            boolean bl = n == 2 || n == 4;
            boolean bl2 = PlasticUtils.isLeftToRight(PlasticXPAdvancedTabbedPaneUI.this.tabPane);
            switch (n) {
                case 2: {
                    PlasticXPAdvancedTabbedPaneUI.this.maxTabWidth = PlasticXPAdvancedTabbedPaneUI.this.calculateMaxTabWidth(n);
                    n7 = insets.left + insets2.left;
                    n6 = insets.top + insets2.top;
                    n5 = dimension.height - (insets.bottom + insets2.bottom);
                    break;
                }
                case 4: {
                    PlasticXPAdvancedTabbedPaneUI.this.maxTabWidth = PlasticXPAdvancedTabbedPaneUI.this.calculateMaxTabWidth(n);
                    n7 = dimension.width - insets.right - insets2.right - PlasticXPAdvancedTabbedPaneUI.this.maxTabWidth;
                    n6 = insets.top + insets2.top;
                    n5 = dimension.height - (insets.bottom + insets2.bottom);
                    break;
                }
                case 3: {
                    PlasticXPAdvancedTabbedPaneUI.this.maxTabHeight = PlasticXPAdvancedTabbedPaneUI.this.calculateMaxTabHeight(n);
                    n7 = insets.left + insets2.left;
                    n6 = dimension.height - insets.bottom - insets2.bottom - PlasticXPAdvancedTabbedPaneUI.this.maxTabHeight;
                    n5 = dimension.width - (insets.right + insets2.right);
                    break;
                }
                default: {
                    PlasticXPAdvancedTabbedPaneUI.this.maxTabHeight = PlasticXPAdvancedTabbedPaneUI.this.calculateMaxTabHeight(n);
                    n7 = insets.left + insets2.left;
                    n6 = insets.top + insets2.top;
                    n5 = dimension.width - (insets.right + insets2.right);
                }
            }
            int n10 = PlasticXPAdvancedTabbedPaneUI.this.getTabRunOverlay(n);
            PlasticXPAdvancedTabbedPaneUI.this.runCount = 0;
            PlasticXPAdvancedTabbedPaneUI.this.selectedRun = -1;
            int n11 = -1;
            int n12 = n5;
            if (n2 == 0) {
                return;
            }
            for (n4 = 0; n4 < n2; ++n4) {
                rectangle = PlasticXPAdvancedTabbedPaneUI.this.rects[n4];
                ++n11;
                if (!bl) {
                    if (n4 > 0) {
                        rectangle.x = ((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).rects[n4 - 1].x + ((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).rects[n4 - 1].width;
                    } else {
                        ((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).tabRuns[0] = 0;
                        PlasticXPAdvancedTabbedPaneUI.this.runCount = 1;
                        PlasticXPAdvancedTabbedPaneUI.this.maxTabWidth = 0;
                        rectangle.x = n7;
                    }
                    rectangle.width = PlasticXPAdvancedTabbedPaneUI.this.calculateTabWidth(n, n4, fontMetrics);
                    PlasticXPAdvancedTabbedPaneUI.this.maxTabWidth = Math.max(PlasticXPAdvancedTabbedPaneUI.this.maxTabWidth, rectangle.width);
                    if (n11 != 0 && rectangle.x + rectangle.width > n12) {
                        if (PlasticXPAdvancedTabbedPaneUI.this.runCount > PlasticXPAdvancedTabbedPaneUI.this.tabRuns.length - 1) {
                            PlasticXPAdvancedTabbedPaneUI.this.expandTabRunsArray();
                        }
                        n11 = 0;
                        ((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).tabRuns[((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).runCount] = n4;
                        PlasticXPAdvancedTabbedPaneUI.this.runCount++;
                        rectangle.x = n7;
                        n12 -= 2 * PlasticXPAdvancedTabbedPaneUI.this.getTabRunIndent(n, PlasticXPAdvancedTabbedPaneUI.this.runCount);
                    }
                    rectangle.y = n6;
                    rectangle.height = PlasticXPAdvancedTabbedPaneUI.this.maxTabHeight;
                } else {
                    if (n4 > 0) {
                        rectangle.y = ((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).rects[n4 - 1].y + ((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).rects[n4 - 1].height;
                    } else {
                        ((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).tabRuns[0] = 0;
                        PlasticXPAdvancedTabbedPaneUI.this.runCount = 1;
                        PlasticXPAdvancedTabbedPaneUI.this.maxTabHeight = 0;
                        rectangle.y = n6;
                    }
                    rectangle.height = PlasticXPAdvancedTabbedPaneUI.this.calculateTabHeight(n, n4, n8);
                    PlasticXPAdvancedTabbedPaneUI.this.maxTabHeight = Math.max(PlasticXPAdvancedTabbedPaneUI.this.maxTabHeight, rectangle.height);
                    if (n11 != 0 && rectangle.y + rectangle.height > n12) {
                        if (PlasticXPAdvancedTabbedPaneUI.this.runCount > PlasticXPAdvancedTabbedPaneUI.this.tabRuns.length - 1) {
                            PlasticXPAdvancedTabbedPaneUI.this.expandTabRunsArray();
                        }
                        ((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).tabRuns[((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).runCount] = n4;
                        PlasticXPAdvancedTabbedPaneUI.this.runCount++;
                        rectangle.y = n6;
                        n11 = 0;
                        n12 -= 2 * PlasticXPAdvancedTabbedPaneUI.this.getTabRunIndent(n, PlasticXPAdvancedTabbedPaneUI.this.runCount);
                    }
                    rectangle.x = n7;
                    rectangle.width = PlasticXPAdvancedTabbedPaneUI.this.maxTabWidth;
                }
                if (n4 != n9) continue;
                PlasticXPAdvancedTabbedPaneUI.this.selectedRun = PlasticXPAdvancedTabbedPaneUI.this.runCount - 1;
            }
            if (PlasticXPAdvancedTabbedPaneUI.this.runCount > 1 && PlasticXPAdvancedTabbedPaneUI.this.shouldRotateTabRuns(n)) {
                this.rotateTabRuns(n, PlasticXPAdvancedTabbedPaneUI.this.selectedRun);
            }
            for (n4 = PlasticXPAdvancedTabbedPaneUI.this.runCount - 1; n4 >= 0; --n4) {
                int n13;
                n3 = PlasticXPAdvancedTabbedPaneUI.this.tabRuns[n4];
                int n14 = PlasticXPAdvancedTabbedPaneUI.this.tabRuns[n4 == PlasticXPAdvancedTabbedPaneUI.this.runCount - 1 ? 0 : n4 + 1];
                int n15 = n14 != 0 ? n14 - 1 : n2 - 1;
                int n16 = PlasticXPAdvancedTabbedPaneUI.this.getTabRunIndent(n, n4);
                if (!bl) {
                    for (n13 = n3; n13 <= n15; ++n13) {
                        rectangle = PlasticXPAdvancedTabbedPaneUI.this.rects[n13];
                        rectangle.y = n6;
                        rectangle.x += n16;
                    }
                    if (PlasticXPAdvancedTabbedPaneUI.this.shouldPadTabRun(n, n4)) {
                        this.padTabRun(n, n3, n15, n5 - 2 * n16);
                    }
                    if (n == 3) {
                        n6 -= PlasticXPAdvancedTabbedPaneUI.this.maxTabHeight - n10;
                        continue;
                    }
                    n6 += PlasticXPAdvancedTabbedPaneUI.this.maxTabHeight - n10;
                    continue;
                }
                for (n13 = n3; n13 <= n15; ++n13) {
                    rectangle = PlasticXPAdvancedTabbedPaneUI.this.rects[n13];
                    rectangle.x = n7;
                    rectangle.y += n16;
                }
                if (PlasticXPAdvancedTabbedPaneUI.this.shouldPadTabRun(n, n4)) {
                    this.padTabRun(n, n3, n15, n5 - 2 * n16);
                }
                if (n == 4) {
                    n7 -= PlasticXPAdvancedTabbedPaneUI.this.maxTabWidth - n10;
                    continue;
                }
                n7 += PlasticXPAdvancedTabbedPaneUI.this.maxTabWidth - n10;
            }
            this.padSelectedTab(n, n9);
            if (!bl2 && !bl) {
                n3 = dimension.width - (insets.right + insets2.right);
                for (n4 = 0; n4 < n2; ++n4) {
                    ((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).rects[n4].x = n3 - ((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).rects[n4].x - ((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).rects[n4].width + PlasticXPAdvancedTabbedPaneUI.this.renderer.getTabsOverlay();
                }
            }
        }
    }

    private class MyPropertyChangeHandler
    extends BasicTabbedPaneUI.PropertyChangeHandler {
        private MyPropertyChangeHandler() {
            super(PlasticXPAdvancedTabbedPaneUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (null == string) {
                return;
            }
            super.propertyChange(propertyChangeEvent);
            if (string.equals("tabPlacement")) {
                PlasticXPAdvancedTabbedPaneUI.this.tabPlacementChanged();
                return;
            }
            if (string.equals("jgoodies.embeddedTabs")) {
                PlasticXPAdvancedTabbedPaneUI.this.embeddedTabsPropertyChanged((Boolean)propertyChangeEvent.getNewValue());
                return;
            }
            if (string.equals("jgoodies.noContentBorder")) {
                PlasticXPAdvancedTabbedPaneUI.this.noContentBorderPropertyChanged((Boolean)propertyChangeEvent.getNewValue());
                return;
            }
        }
    }

    private class TabSelectionHandler
    implements ChangeListener {
        private Rectangle rect = new Rectangle();

        private TabSelectionHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            int n;
            JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
            jTabbedPane.revalidate();
            jTabbedPane.repaint();
            if (jTabbedPane.getTabLayoutPolicy() == 1 && (n = jTabbedPane.getSelectedIndex()) < PlasticXPAdvancedTabbedPaneUI.this.rects.length && n != -1) {
                this.rect.setBounds(PlasticXPAdvancedTabbedPaneUI.this.rects[n]);
                Point point = ((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).tabScroller.viewport.getViewPosition();
                this.rect.x = this.rect.x < point.x ? (this.rect.x -= PlasticXPAdvancedTabbedPaneUI.this.renderer.getTabsOverlay()) : (this.rect.x += PlasticXPAdvancedTabbedPaneUI.this.renderer.getTabsOverlay());
                ((PlasticXPAdvancedTabbedPaneUI)PlasticXPAdvancedTabbedPaneUI.this).tabScroller.tabPanel.scrollRectToVisible(this.rect);
            }
        }
    }
}

