/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.swing.plaf.looks.plastic;

import biz.netup.swing.plaf.looks.plastic.PlasticLookAndFeel;
import biz.netup.swing.plaf.looks.plastic.PlasticTheme;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.UIManager;

public final class PlasticUtils {
    private static float FRACTION_3D = 0.5f;

    static void drawDark3DBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        PlasticUtils.drawFlush3DBorder(graphics, n, n2, n3, n4);
        graphics.setColor(PlasticLookAndFeel.getControl());
        graphics.drawLine(n + 1, n2 + 1, 1, n4 - 3);
        graphics.drawLine(n2 + 1, n2 + 1, n3 - 3, 1);
    }

    static void drawDisabledBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(PlasticLookAndFeel.getControlShadow());
        PlasticUtils.drawRect(graphics, n, n2, n3 - 1, n4 - 1);
    }

    static void drawFlush3DBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.translate(n, n2);
        graphics.setColor(PlasticLookAndFeel.getControlHighlight());
        PlasticUtils.drawRect(graphics, 1, 1, n3 - 2, n4 - 2);
        graphics.drawLine(0, n4 - 1, 0, n4 - 1);
        graphics.drawLine(n3 - 1, 0, n3 - 1, 0);
        graphics.setColor(PlasticLookAndFeel.getControlDarkShadow());
        PlasticUtils.drawRect(graphics, 0, 0, n3 - 2, n4 - 2);
        graphics.translate(-n, -n2);
    }

    static void drawPressed3DBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.translate(n, n2);
        PlasticUtils.drawFlush3DBorder(graphics, 0, 0, n3, n4);
        graphics.setColor(PlasticLookAndFeel.getControlShadow());
        graphics.drawLine(1, 1, 1, n4 - 3);
        graphics.drawLine(1, 1, n3 - 3, 1);
        graphics.translate(-n, -n2);
    }

    static void drawButtonBorder(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            PlasticUtils.drawActiveButtonBorder(graphics, n, n2, n3, n4);
        } else {
            PlasticUtils.drawFlush3DBorder(graphics, n, n2, n3, n4);
        }
    }

    static void drawActiveButtonBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        PlasticUtils.drawFlush3DBorder(graphics, n, n2, n3, n4);
        graphics.setColor(PlasticLookAndFeel.getPrimaryControl());
        graphics.drawLine(n + 1, n2 + 1, n + 1, n4 - 3);
        graphics.drawLine(n + 1, n2 + 1, n3 - 3, n + 1);
        graphics.setColor(PlasticLookAndFeel.getPrimaryControlDarkShadow());
        graphics.drawLine(n + 2, n4 - 2, n3 - 2, n4 - 2);
        graphics.drawLine(n3 - 2, n2 + 2, n3 - 2, n4 - 2);
    }

    static void drawDefaultButtonBorder(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        PlasticUtils.drawButtonBorder(graphics, n + 1, n2 + 1, n3 - 1, n4 - 1, bl);
        graphics.translate(n, n2);
        graphics.setColor(PlasticLookAndFeel.getControlDarkShadow());
        PlasticUtils.drawRect(graphics, 0, 0, n3 - 3, n4 - 3);
        graphics.drawLine(n3 - 2, 0, n3 - 2, 0);
        graphics.drawLine(0, n4 - 2, 0, n4 - 2);
        graphics.setColor(PlasticLookAndFeel.getControl());
        graphics.drawLine(n3 - 1, 0, n3 - 1, 0);
        graphics.drawLine(0, n4 - 1, 0, n4 - 1);
        graphics.translate(-n, -n2);
    }

    static void drawDefaultButtonPressedBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        PlasticUtils.drawPressed3DBorder(graphics, n + 1, n2 + 1, n3 - 1, n4 - 1);
        graphics.translate(n, n2);
        graphics.setColor(PlasticLookAndFeel.getControlDarkShadow());
        PlasticUtils.drawRect(graphics, 0, 0, n3 - 3, n4 - 3);
        graphics.drawLine(n3 - 2, 0, n3 - 2, 0);
        graphics.drawLine(0, n4 - 2, 0, n4 - 2);
        graphics.setColor(PlasticLookAndFeel.getControl());
        graphics.drawLine(n3 - 1, 0, n3 - 1, 0);
        graphics.drawLine(0, n4 - 1, 0, n4 - 1);
        graphics.translate(-n, -n2);
    }

    static void drawThinFlush3DBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.translate(n, n2);
        graphics.setColor(PlasticLookAndFeel.getControlHighlight());
        graphics.drawLine(0, 0, n3 - 2, 0);
        graphics.drawLine(0, 0, 0, n4 - 2);
        graphics.setColor(PlasticLookAndFeel.getControlDarkShadow());
        graphics.drawLine(n3 - 1, 0, n3 - 1, n4 - 1);
        graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
        graphics.translate(-n, -n2);
    }

    static void drawThinPressed3DBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.translate(n, n2);
        graphics.setColor(PlasticLookAndFeel.getControlDarkShadow());
        graphics.drawLine(0, 0, n3 - 2, 0);
        graphics.drawLine(0, 0, 0, n4 - 2);
        graphics.setColor(PlasticLookAndFeel.getControlHighlight());
        graphics.drawLine(n3 - 1, 0, n3 - 1, n4 - 1);
        graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
        graphics.translate(-n, -n2);
    }

    static boolean isLeftToRight(Component component) {
        return component.getComponentOrientation().isLeftToRight();
    }

    static boolean is3D(String string) {
        Object object = UIManager.get(string + "is3DEnabled");
        return Boolean.TRUE.equals(object);
    }

    static boolean force3D(JComponent jComponent) {
        Object object = jComponent.getClientProperty("Plastic.is3D");
        return Boolean.TRUE.equals(object);
    }

    static boolean forceFlat(JComponent jComponent) {
        Object object = jComponent.getClientProperty("Plastic.is3D");
        return Boolean.FALSE.equals(object);
    }

    private static void add3DEffekt(Graphics graphics, Rectangle rectangle, boolean bl, Color color, Color color2, Color color3, Color color4) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (bl) {
            n10 = rectangle.width;
            n9 = (int)((float)rectangle.height * FRACTION_3D);
            n8 = rectangle.x;
            n7 = rectangle.y;
            n6 = n8;
            n5 = n7 + n9;
            n4 = n6;
            n3 = n5;
            n2 = n4;
            n = rectangle.y + rectangle.height;
        } else {
            n10 = (int)((float)rectangle.width * FRACTION_3D);
            n9 = rectangle.height;
            n8 = rectangle.x;
            n7 = rectangle.y;
            n6 = n8 + n10;
            n5 = n7;
            n4 = n6;
            n3 = n7;
            n2 = rectangle.x + rectangle.width;
            n = n3;
        }
        graphics2D.setPaint(new GradientPaint(n8, n7, color2, n6, n5, color));
        graphics2D.fillRect(rectangle.x, rectangle.y, n10, n9);
        graphics2D.setPaint(new GradientPaint(n4, n3, color3, n2, n, color4));
        graphics2D.fillRect(n4, n3, n10, n9);
    }

    static void add3DEffekt(Graphics graphics, Rectangle rectangle) {
        Color color = UIManager.getColor("Plastic.brightenStop");
        if (null == color) {
            color = PlasticTheme.BRIGHTEN_STOP;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = 10;
        graphics2D.setPaint(new GradientPaint(rectangle.x, rectangle.y, color, rectangle.x + n, rectangle.y, PlasticTheme.BRIGHTEN_START));
        graphics2D.fillRect(rectangle.x, rectangle.y, n, rectangle.height);
        int n2 = rectangle.x + rectangle.width - n;
        int n3 = rectangle.y;
        graphics2D.setPaint(new GradientPaint(n2, n3, PlasticTheme.DARKEN_START, n2 + n, n3, PlasticTheme.LT_DARKEN_STOP));
        graphics2D.fillRect(n2, n3, n, rectangle.height);
        PlasticUtils.add3DEffekt(graphics, rectangle, true, PlasticTheme.BRIGHTEN_START, color, PlasticTheme.DARKEN_START, PlasticTheme.LT_DARKEN_STOP);
    }

    static void addLight3DEffekt(Graphics graphics, Rectangle rectangle, boolean bl) {
        Color color = UIManager.getColor("Plastic.ltBrightenStop");
        if (null == color) {
            color = PlasticTheme.LT_BRIGHTEN_STOP;
        }
        PlasticUtils.add3DEffekt(graphics, rectangle, bl, PlasticTheme.BRIGHTEN_START, color, PlasticTheme.DARKEN_START, PlasticTheme.LT_DARKEN_STOP);
    }

    public static void addLight3DEffekt(Graphics graphics, Rectangle rectangle) {
        Color color = UIManager.getColor("Plastic.ltBrightenStop");
        if (null == color) {
            color = PlasticTheme.LT_BRIGHTEN_STOP;
        }
        PlasticUtils.add3DEffekt(graphics, rectangle, true, PlasticTheme.DARKEN_START, PlasticTheme.LT_DARKEN_STOP, PlasticTheme.BRIGHTEN_START, color);
    }

    private static void drawRect(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.fillRect(n, n2, n3 + 1, 1);
        graphics.fillRect(n, n2 + 1, 1, n4);
        graphics.fillRect(n + 1, n2 + n4, n3, 1);
        graphics.fillRect(n + n3, n2 + 1, 1, n4);
    }
}

