/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.swing.plaf.looks.plastic;

import biz.netup.swing.plaf.looks.BorderStyle;
import biz.netup.swing.plaf.looks.HeaderStyle;
import biz.netup.swing.plaf.looks.plastic.PlasticUtils;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuBarUI;

public final class PlasticMenuBarUI
extends BasicMenuBarUI {
    private PropertyChangeListener listener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new PlasticMenuBarUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.installSpecialBorder();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.listener = this.createBorderStyleListener();
        this.menuBar.addPropertyChangeListener(this.listener);
    }

    @Override
    protected void uninstallListeners() {
        this.menuBar.removePropertyChangeListener(this.listener);
        super.uninstallListeners();
    }

    private PropertyChangeListener createBorderStyleListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("jgoodies.headerStyle") || string.equals("Plastic.borderStyle")) {
                    PlasticMenuBarUI.this.installSpecialBorder();
                }
            }
        };
    }

    public void installSpecialBorder() {
        String string;
        BorderStyle borderStyle = BorderStyle.from(this.menuBar, "Plastic.borderStyle");
        if (borderStyle == BorderStyle.EMPTY) {
            string = "emptyBorder";
        } else if (borderStyle == BorderStyle.ETCHED) {
            string = "etchedBorder";
        } else if (borderStyle == BorderStyle.SEPARATOR) {
            string = "separatorBorder";
        } else {
            HeaderStyle headerStyle = HeaderStyle.from(this.menuBar);
            if (headerStyle == HeaderStyle.BOTH) {
                string = "headerBorder";
            } else if (headerStyle == HeaderStyle.SINGLE && this.is3D()) {
                string = "etchedBorder";
            } else {
                return;
            }
        }
        LookAndFeel.installBorder(this.menuBar, "MenuBar." + string);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            graphics.setColor(jComponent.getBackground());
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
        if (this.is3D()) {
            PlasticUtils.addLight3DEffekt(graphics, new Rectangle(0, 0, jComponent.getWidth(), jComponent.getHeight()), true);
        }
        this.paint(graphics, jComponent);
    }

    private boolean is3D() {
        if (PlasticUtils.force3D(this.menuBar)) {
            return true;
        }
        if (PlasticUtils.forceFlat(this.menuBar)) {
            return false;
        }
        return PlasticUtils.is3D("MenuBar.") && HeaderStyle.from(this.menuBar) != null && BorderStyle.from(this.menuBar, "Plastic.borderStyle") != BorderStyle.EMPTY;
    }
}

