/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.swing.plaf.looks.common;

import biz.netup.swing.plaf.looks.common.ShadowPopupBorder;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JApplet;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.Popup;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public final class ShadowPopup
extends Popup {
    private static final int MAX_CACHE_SIZE = 5;
    private static List cache;
    private static final Border SHADOW_BORDER;
    private static final int SHADOW_SIZE = 5;
    private static boolean canSnapshot;
    private Component owner;
    private Component contents;
    private int x;
    private int y;
    private Popup popup;
    private Border oldBorder;
    private boolean oldOpaque;
    private Container heavyWeightContainer;
    private static final Point point;
    private static final Rectangle rect;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Popup getInstance(Component component, Component component2, int n, int n2, Popup popup) {
        Class<ShadowPopup> clazz = ShadowPopup.class;
        synchronized (ShadowPopup.class) {
            if (cache == null) {
                cache = new ArrayList(5);
            }
            ShadowPopup shadowPopup = cache.size() > 0 ? (ShadowPopup)cache.remove(0) : new ShadowPopup();
            // ** MonitorExit[var6_5] (shouldn't be in output)
            shadowPopup.reset(component, component2, n, n2, popup);
            return shadowPopup;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void recycle(ShadowPopup shadowPopup) {
        Class<ShadowPopup> clazz = ShadowPopup.class;
        synchronized (ShadowPopup.class) {
            if (cache.size() < 5) {
                cache.add(shadowPopup);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static boolean canSnapshot() {
        return canSnapshot;
    }

    @Override
    public void hide() {
        JComponent jComponent = (JComponent)this.contents.getParent();
        this.popup.hide();
        if (jComponent.getBorder() == SHADOW_BORDER) {
            jComponent.setBorder(this.oldBorder);
            jComponent.setOpaque(this.oldOpaque);
            this.oldBorder = null;
            if (this.heavyWeightContainer != null) {
                jComponent.putClientProperty("jgoodies.hShadowBg", null);
                jComponent.putClientProperty("jgoodies.vShadowBg", null);
                this.heavyWeightContainer = null;
            }
        }
        this.owner = null;
        this.contents = null;
        this.popup = null;
        ShadowPopup.recycle(this);
    }

    @Override
    public void show() {
        if (this.heavyWeightContainer != null) {
            this.snapshot();
        }
        this.popup.show();
    }

    private void reset(Component component, Component component2, int n, int n2, Popup popup) {
        Container container;
        this.owner = component;
        this.contents = component2;
        this.popup = popup;
        this.x = n;
        this.y = n2;
        if (component instanceof JComboBox) {
            return;
        }
        Container container2 = null;
        for (container = component2.getParent(); container != null; container = container.getParent()) {
            if (container instanceof JWindow) {
                container.setBackground(component2.getBackground());
                this.heavyWeightContainer = container;
                break;
            }
            if (!(container instanceof Panel)) continue;
            Color color = container.getBackground();
            int n3 = component2.getBackground().getRGB() & 0xFFFFFF;
            if (color == null || color.getRGB() != n3) {
                container.setBackground(new Color(n3, true));
            }
            container2 = container;
            break;
        }
        container = (JComponent)component2.getParent();
        this.oldOpaque = ((JComponent)container).isOpaque();
        this.oldBorder = ((JComponent)container).getBorder();
        ((JComponent)container).setOpaque(false);
        ((JComponent)container).setBorder(SHADOW_BORDER);
        if (container2 != null) {
            container2.setSize(container2.getPreferredSize());
        } else {
            container.setSize(((JComponent)container).getPreferredSize());
        }
    }

    private void snapshot() {
        try {
            boolean bl;
            Graphics2D graphics2D;
            Robot robot = new Robot();
            Dimension dimension = this.heavyWeightContainer.getPreferredSize();
            int n = dimension.width;
            int n2 = dimension.height;
            rect.setBounds(this.x, this.y + n2 - 5, n, 5);
            BufferedImage bufferedImage = robot.createScreenCapture(rect);
            rect.setBounds(this.x + n - 5, this.y, 5, n2 - 5);
            BufferedImage bufferedImage2 = robot.createScreenCapture(rect);
            JComponent jComponent = (JComponent)this.contents.getParent();
            jComponent.putClientProperty("jgoodies.hShadowBg", bufferedImage);
            jComponent.putClientProperty("jgoodies.vShadowBg", bufferedImage2);
            JComponent jComponent2 = this.getLayeredPane();
            if (jComponent2 == null) {
                return;
            }
            int n3 = jComponent2.getWidth();
            int n4 = jComponent2.getHeight();
            ShadowPopup.point.x = this.x;
            ShadowPopup.point.y = this.y;
            SwingUtilities.convertPointFromScreen(point, jComponent2);
            ShadowPopup.rect.x = ShadowPopup.point.x;
            ShadowPopup.rect.y = ShadowPopup.point.y + n2 - 5;
            ShadowPopup.rect.width = n;
            ShadowPopup.rect.height = 5;
            if (ShadowPopup.rect.x + ShadowPopup.rect.width > n3) {
                ShadowPopup.rect.width = n3 - ShadowPopup.rect.x;
            }
            if (ShadowPopup.rect.y + ShadowPopup.rect.height > n4) {
                ShadowPopup.rect.height = n4 - ShadowPopup.rect.y;
            }
            if (!rect.isEmpty()) {
                graphics2D = bufferedImage.createGraphics();
                ((Graphics)graphics2D).translate(-ShadowPopup.rect.x, -ShadowPopup.rect.y);
                graphics2D.setClip(rect);
                bl = jComponent2.isDoubleBuffered();
                jComponent2.setDoubleBuffered(false);
                jComponent2.paint(graphics2D);
                jComponent2.setDoubleBuffered(bl);
                graphics2D.dispose();
            }
            ShadowPopup.rect.x = ShadowPopup.point.x + n - 5;
            ShadowPopup.rect.y = ShadowPopup.point.y;
            ShadowPopup.rect.width = 5;
            ShadowPopup.rect.height = n2 - 5;
            if (ShadowPopup.rect.x + ShadowPopup.rect.width > n3) {
                ShadowPopup.rect.width = n3 - ShadowPopup.rect.x;
            }
            if (ShadowPopup.rect.y + ShadowPopup.rect.height > n4) {
                ShadowPopup.rect.height = n4 - ShadowPopup.rect.y;
            }
            if (!rect.isEmpty()) {
                graphics2D = bufferedImage2.createGraphics();
                ((Graphics)graphics2D).translate(-ShadowPopup.rect.x, -ShadowPopup.rect.y);
                graphics2D.setClip(rect);
                bl = jComponent2.isDoubleBuffered();
                jComponent2.setDoubleBuffered(false);
                jComponent2.paint(graphics2D);
                jComponent2.setDoubleBuffered(bl);
                graphics2D.dispose();
            }
        }
        catch (AWTException aWTException) {
            canSnapshot = false;
        }
        catch (SecurityException securityException) {
            canSnapshot = false;
        }
    }

    private JComponent getLayeredPane() {
        Container container = null;
        if (this.owner != null) {
            container = this.owner instanceof Container ? (Container)this.owner : this.owner.getParent();
        }
        for (Container container2 = container; container2 != null; container2 = container2.getParent()) {
            if (container2 instanceof JRootPane) {
                if (container2.getParent() instanceof JInternalFrame) continue;
                container = ((JRootPane)container2).getLayeredPane();
                continue;
            }
            if (container2 instanceof Window) {
                if (container != null) break;
                container = container2;
                break;
            }
            if (container2 instanceof JApplet) break;
        }
        return (JComponent)container;
    }

    static {
        SHADOW_BORDER = ShadowPopupBorder.getInstance();
        canSnapshot = true;
        point = new Point();
        rect = new Rectangle();
    }
}

