/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.swing.filter.impl;

import biz.netup.swing.filter.SimpleFilter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SimpleFilterImpl
extends JPanel
implements SimpleFilter {
    private static final long FILTERING_DELAY = 1000L;
    private JTextField textSimpleFilter;
    private FilterDocumentListener panelTimer;
    private List<ActionListener> listeners = new ArrayList<ActionListener>();
    private JTable table;

    public SimpleFilterImpl(JTable jTable) {
        super(new GridBagLayout());
        this.table = jTable;
        this.textSimpleFilter = new JTextField();
        this.panelTimer = new FilterDocumentListener();
        this.textSimpleFilter.getDocument().addDocumentListener(this.panelTimer);
        this.textSimpleFilter.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (10 == keyEvent.getKeyCode()) {
                    SimpleFilterImpl.this.table.grabFocus();
                    SimpleFilterImpl.this.table.getSelectionModel().setSelectionInterval(0, 0);
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        this.add((Component)this.textSimpleFilter, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        new Timer().schedule((TimerTask)this.panelTimer, 0L, 500L);
    }

    @Override
    public String getText() {
        return this.textSimpleFilter.getText();
    }

    public void setText(String string) {
        this.textSimpleFilter.setText(string);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.textSimpleFilter.setEnabled(bl);
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        this.listeners.add(actionListener);
    }

    @Override
    public void removeActionListener(ActionListener actionListener) {
        this.listeners.remove(actionListener);
    }

    @Override
    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listeners.toArray();
    }

    private class FilterDocumentListener
    extends TimerTask
    implements DocumentListener {
        long lastModification = Calendar.getInstance().getTimeInMillis();
        long lastSearch = 0L;

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.update(documentEvent);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.update(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.update(documentEvent);
        }

        private void update(DocumentEvent documentEvent) {
            this.lastModification = Calendar.getInstance().getTimeInMillis();
        }

        @Override
        public void run() {
            long l = Calendar.getInstance().getTimeInMillis();
            if (l - this.lastModification > 1000L && this.lastSearch < this.lastModification) {
                this.lastSearch = l;
                for (ActionListener actionListener : SimpleFilterImpl.this.listeners) {
                    actionListener.actionPerformed(new ActionEvent(this, 1001, "Filter"));
                }
            }
        }
    }
}

