/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.swing.filter.impl;

import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class MaskedDocumentFilter
extends DocumentFilter {
    private Pattern valueMaskPattern = Pattern.compile(".");

    public void setMaskPattern(String string) {
        this.valueMaskPattern = Pattern.compile(string);
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (string == null) {
            return;
        }
        this.replace(filterBypass, n, 0, string, attributeSet);
    }

    @Override
    public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
        this.replace(filterBypass, n, n2, "", null);
    }

    @Override
    public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
        for (int i = 0; i < string.length(); ++i) {
            this.checkSymbol(string.subSequence(i, i + 1), n);
        }
        filterBypass.replace(n, n2, string, attributeSet);
    }

    private void checkSymbol(CharSequence charSequence, int n) throws BadLocationException {
        if (!this.valueMaskPattern.matcher(charSequence).matches()) {
            throw new BadLocationException("Wrong symbol", n);
        }
    }
}

