/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.swing.datetime;

import biz.netup.swing.datetime.JDateTime;
import biz.netup.swing.datetime.TimeSpan;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TimeSpanChooser
extends JPanel {
    private JButton jButtonCreate;
    private JComboBox jComboBoxTimeSpan;
    private JDateTime jDateTimeFrom;
    private JDateTime jDateTimeTo;
    private boolean updating_ = false;
    private static final ResourceBundle RESOURCE = ResourceBundle.getBundle(TimeSpanChooser.class.getName());

    public TimeSpanChooser() {
        this.initComponents();
        this.update();
    }

    private void initComponents() {
        this.jComboBoxTimeSpan = new JComboBox();
        this.jDateTimeFrom = new JDateTime();
        this.jDateTimeTo = new JDateTime();
        this.jButtonCreate = new JButton();
        this.setLayout(new GridBagLayout());
        this.jComboBoxTimeSpan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TimeSpanChooser.this.jComboBoxTimeSpanActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jComboBoxTimeSpan, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jButtonCreate, gridBagConstraints);
        this.jDateTimeFrom.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TimeSpanChooser.this.jDateTimeFromActionPerformed(new ActionEvent(changeEvent.getSource(), 0, ""));
            }
        });
        this.jDateTimeFrom.getButton().setText("");
        this.jDateTimeFrom.getButton().setIcon(JDateTime.fromIcon);
        this.jDateTimeTo.getButton().setText("");
        this.jDateTimeTo.getButton().setIcon(JDateTime.toIcon);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jDateTimeFrom, gridBagConstraints);
        this.jDateTimeTo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TimeSpanChooser.this.jDateTimeToActionPerformed(new ActionEvent(changeEvent.getSource(), 0, ""));
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jDateTimeTo, gridBagConstraints);
        this.jButtonCreate.setText(RESOURCE.getString("Create"));
        this.jButtonCreate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TimeSpanChooser.this.jButtonCreateActionPerformed(actionEvent);
            }
        });
    }

    private void jDateTimeToActionPerformed(ActionEvent actionEvent) {
        this.update();
    }

    private void jDateTimeFromActionPerformed(ActionEvent actionEvent) {
        this.update();
    }

    private void jButtonCreateActionPerformed(ActionEvent actionEvent) {
        this.update();
        this.performCreate();
    }

    private void jComboBoxTimeSpanActionPerformed(ActionEvent actionEvent) {
        this.update();
    }

    public void addTimeSpan(TimeSpan timeSpan) {
        this.jComboBoxTimeSpan.addItem(timeSpan);
        this.update();
    }

    public Date getFrom() {
        TimeSpan timeSpan = (TimeSpan)this.jComboBoxTimeSpan.getSelectedItem();
        return timeSpan.from(this.jDateTimeFrom.getDate(), this.jDateTimeTo.getDate());
    }

    public void setFrom(Date date) {
        TimeSpan timeSpan = (TimeSpan)this.jComboBoxTimeSpan.getSelectedItem();
        if (timeSpan.fromEnabled()) {
            this.jDateTimeFrom.setDate(date);
        }
    }

    public Date getTo() {
        TimeSpan timeSpan = (TimeSpan)this.jComboBoxTimeSpan.getSelectedItem();
        return timeSpan.to(this.jDateTimeFrom.getDate(), this.jDateTimeTo.getDate());
    }

    private void update() {
        if (this.updating_) {
            return;
        }
        this.updating_ = true;
        TimeSpan timeSpan = (TimeSpan)this.jComboBoxTimeSpan.getSelectedItem();
        if (timeSpan != null) {
            Date date = timeSpan.from(this.jDateTimeFrom.getDate(), this.jDateTimeTo.getDate());
            Date date2 = timeSpan.to(this.jDateTimeFrom.getDate(), this.jDateTimeTo.getDate());
            if (!timeSpan.fromEnabled()) {
                this.jDateTimeFrom.setDate(date);
            }
            this.jDateTimeFrom.setEnabled(timeSpan.fromEnabled());
            if (!timeSpan.toEnabled()) {
                this.jDateTimeTo.setDate(date2);
            }
            this.jDateTimeTo.setEnabled(timeSpan.toEnabled());
        }
        this.updating_ = false;
    }

    @Override
    public void setEnabled(boolean bl) {
        Component[] componentArray = new Component[]{this.jButtonCreate, this.jComboBoxTimeSpan};
        for (Component component : componentArray) {
            component.setEnabled(bl);
        }
        TimeSpan timeSpan = (TimeSpan)this.jComboBoxTimeSpan.getSelectedItem();
        if (null != timeSpan) {
            this.jDateTimeFrom.setEnabled(bl && timeSpan.fromEnabled());
            this.jDateTimeTo.setEnabled(bl && timeSpan.toEnabled());
        } else {
            this.jDateTimeFrom.setEnabled(bl);
            this.jDateTimeTo.setEnabled(bl);
        }
    }

    private void performCreate() {
        this.firePropertyChange("createReport", false, true);
    }
}

