/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.swing.datetime;

import biz.netup.swing.datetime.JDateTime;
import biz.netup.swing.datetime.JWeekPopup;
import biz.netup.swing.plaf.looks.plastic.theme.ExperienceBlue;
import biz.netup.swing.plaf.utm.UtmLookAndFeel;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;

public class JWeekTime
extends JPanel {
    private JSpinner jTime;
    private JButton btnPopup;
    private boolean showTime;
    private String nullDateValue = null;
    private static final ResourceBundle resource_ = ResourceBundle.getBundle(JDateTime.class.getName());
    JWeekPopup popup;
    protected EventListenerList listenerList = new EventListenerList();
    private boolean firingActionEvent = false;
    private boolean firingChangeEvent = false;
    boolean focused = false;
    private ArrayList<FocusListener> focusListeners = new ArrayList();
    public static final Icon fromIcon = new ImageIcon(JDateTime.class.getResource("from_time.png"));
    public static final Icon toIcon = new ImageIcon(JDateTime.class.getResource("to_time.png"));
    private PropertyChangeListener focusListener;
    private JCheckBox infinityComboBox;

    public void setNullDateValue(String string) {
        this.nullDateValue = string;
        this.setDate(this.getDate());
    }

    public static void main(String[] stringArray) {
        Serializable serializable;
        try {
            serializable = new UtmLookAndFeel();
            UtmLookAndFeel.setMyCurrentTheme(new ExperienceBlue());
            UIManager.setLookAndFeel(serializable);
        }
        catch (Exception exception) {
            // empty catch block
        }
        serializable = new JDateTime();
        JFrame jFrame = new JFrame("test");
        jFrame.setLayout(new BorderLayout());
        jFrame.setDefaultCloseOperation(3);
        jFrame.add((Component)serializable);
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("asd");
        jMenu.add(new JMenuItem("xxxxx"));
        jMenu.add(new JMenuItem("xxxxx1"));
        jMenu.add(new JMenuItem("xxxxx2"));
        jMenuBar.add(jMenu);
        jFrame.add("North", jMenuBar);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public Date getDate() {
        if (this.infinityComboBox.isSelected()) {
            return new Date(2000000000000L);
        }
        return (Date)this.jTime.getValue();
    }

    public void setDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (!this.showTime) {
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
        }
        calendar.set(14, 0);
        date = calendar.getTime();
        this.jTime.setValue(date);
    }

    public void setDateFormat(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string){

            @Override
            public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
                if (null != date && 0L == date.getTime() && null != JWeekTime.this.nullDateValue) {
                    return stringBuffer.append(JWeekTime.this.nullDateValue);
                }
                return super.format(date, stringBuffer, fieldPosition);
            }

            @Override
            public Object parseObject(String string) throws ParseException {
                if ("".equals(string)) {
                    return new Date(0L);
                }
                return super.parse(string);
            }
        };
        JSpinner.DateEditor dateEditor = new JSpinner.DateEditor(this.jTime, string);
        SpinnerDateModel spinnerDateModel = (SpinnerDateModel)this.jTime.getModel();
        DateEditorFormatter dateEditorFormatter = new DateEditorFormatter(spinnerDateModel, simpleDateFormat);
        DefaultFormatterFactory defaultFormatterFactory = new DefaultFormatterFactory(dateEditorFormatter);
        JFormattedTextField jFormattedTextField = dateEditor.getTextField();
        jFormattedTextField.setFormatterFactory(defaultFormatterFactory);
        ((DefaultFormatter)dateEditor.getTextField().getFormatter()).setAllowsInvalid(true);
        ((DefaultFormatter)dateEditor.getTextField().getFormatter()).setOverwriteMode(false);
        ((DateFormat)((DateFormatter)((DefaultFormatter)dateEditor.getTextField().getFormatter())).getFormat()).setLenient(false);
        this.jTime.setEditor(dateEditor);
        dateEditor.getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (10 == keyEvent.getKeyCode()) {
                    try {
                        JWeekTime.this.jTime.commitEdit();
                        JWeekTime.this.fireActionEvent();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public JButton getButton() {
        return this.btnPopup;
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    protected void fireActionEvent() {
        if (!this.firingActionEvent) {
            this.firingActionEvent = true;
            ActionEvent actionEvent = null;
            Object[] objectArray = this.listenerList.getListenerList();
            long l = EventQueue.getMostRecentEventTime();
            int n = 0;
            AWTEvent aWTEvent = EventQueue.getCurrentEvent();
            if (aWTEvent instanceof InputEvent) {
                n = ((InputEvent)aWTEvent).getModifiers();
            } else if (aWTEvent instanceof ActionEvent) {
                n = ((ActionEvent)aWTEvent).getModifiers();
            }
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != ActionListener.class) continue;
                if (actionEvent == null) {
                    actionEvent = new ActionEvent(this, 1001, "changed", l, n);
                }
                ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent);
            }
            this.firingActionEvent = false;
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    protected void fireChangeEvent() {
        if (!this.firingChangeEvent) {
            this.firingChangeEvent = true;
            ChangeEvent changeEvent = null;
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != ChangeListener.class) continue;
                if (changeEvent == null) {
                    changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
            }
            this.firingChangeEvent = false;
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        this.btnPopup.setEnabled(bl);
        this.jTime.setEnabled(bl);
    }

    public JWeekTime() {
        this(true);
    }

    public JWeekTime(boolean bl) {
        this.showTime = bl;
        this.setLayout(new BorderLayout());
        final JButton jButton = new JButton("...");
        this.jTime = new JSpinner();
        this.jTime.setModel(new SpinnerDateModel());
        this.setDateFormat("d HH:mm:ss");
        this.add(this.jTime);
        this.btnPopup = jButton;
        this.btnPopup.setMargin(new Insets(0, 0, 0, 0));
        jButton.setFocusable(false);
        this.add((Component)jButton, "West");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (JWeekTime.this.popup == null) {
                    JWeekTime.this.popup = new JWeekPopup(JWeekTime.this.showTime);
                    JWeekTime.this.popup.setActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            if (actionEvent.getID() != 0) {
                                JWeekTime.this.setDate(JWeekTime.this.popup.getDate());
                                JWeekTime.this.fireActionEvent();
                            }
                        }
                    });
                }
                JWeekTime.this.popup.showPopup(jButton, (Date)JWeekTime.this.jTime.getValue());
                JWeekTime.this.fireFocusGained();
            }
        });
        this.jTime.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime((Date)JWeekTime.this.jTime.getValue());
                if (gregorianCalendar.get(5) == 8) {
                    gregorianCalendar.set(5, 1);
                } else if (gregorianCalendar.get(5) > 8) {
                    gregorianCalendar.set(5, 7);
                }
                JWeekTime.this.jTime.setValue(gregorianCalendar.getTime());
                JWeekTime.this.fireChangeEvent();
            }
        });
        GregorianCalendar gregorianCalendar = new GregorianCalendar(1, 1, 1, 0, 0, 0);
        this.setDate(gregorianCalendar.getTime());
        ((JSpinner.DefaultEditor)this.jTime.getEditor()).getTextField().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                JWeekTime.this.fireFocusGained();
            }
        });
        this.focusListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Component component;
                String string = propertyChangeEvent.getPropertyName();
                if (!"permanentFocusOwner".equals(string)) {
                    return;
                }
                if (null != JWeekTime.this.popup && JWeekTime.this.popup.isVisible()) {
                    return;
                }
                Component component2 = (Component)propertyChangeEvent.getNewValue();
                if (null == component2) {
                    JWeekTime.this.fireFocusLost();
                    return;
                }
                for (component = component2; null != component && JWeekTime.this.popup != component && JWeekTime.this.jTime != component; component = component.getParent()) {
                }
                if (null != JWeekTime.this.popup && JWeekTime.this.popup == component || JWeekTime.this.jTime == component) {
                    return;
                }
                JWeekTime.this.fireFocusLost();
            }
        };
        this.infinityComboBox = new JCheckBox(resource_.getString("Infinity date"));
        this.infinityComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (JWeekTime.this.infinityComboBox.isSelected()) {
                    JWeekTime.this.disableDT();
                } else {
                    JWeekTime.this.enableDT();
                }
            }
        });
    }

    private void disableDT() {
        this.setEnabled(false);
    }

    private void enableDT() {
        this.setEnabled(true);
        if (this.popup == null) {
            this.popup = new JWeekPopup(this.showTime);
            this.popup.setActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getID() != 0) {
                        JWeekTime.this.setDate(JWeekTime.this.popup.getDate());
                        JWeekTime.this.fireActionEvent();
                    }
                }
            });
        }
        this.popup.showPopup(this.btnPopup, (Date)this.jTime.getValue());
        this.fireFocusGained();
    }

    @Override
    public void requestFocus() {
        ((JSpinner.DefaultEditor)this.jTime.getEditor()).getTextField().requestFocus();
    }

    void fireFocusLost() {
        if (!this.focused) {
            return;
        }
        this.focused = false;
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.removePropertyChangeListener(this.focusListener);
        for (FocusListener focusListener : this.focusListeners) {
            focusListener.focusLost(new FocusEvent(this, 0));
        }
    }

    void fireFocusGained() {
        if (this.focused) {
            return;
        }
        this.focused = true;
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.addPropertyChangeListener(this.focusListener);
        for (FocusListener focusListener : this.focusListeners) {
            focusListener.focusGained(new FocusEvent(this, 0));
        }
    }

    @Override
    public void setNextFocusableComponent(Component component) {
        ((JSpinner.DefaultEditor)this.jTime.getEditor()).getTextField().setNextFocusableComponent(component);
        this.jTime.setNextFocusableComponent(component);
    }

    @Override
    public void addFocusListener(FocusListener focusListener) {
        this.focusListeners.add(focusListener);
    }

    @Override
    public void removeFocusListener(FocusListener focusListener) {
        this.focusListeners.remove(focusListener);
    }

    @Override
    public FocusListener[] getFocusListeners() {
        return this.focusListeners.toArray(new FocusListener[this.focusListeners.size()]);
    }

    @Override
    public synchronized void addKeyListener(KeyListener keyListener) {
        ((JSpinner.DefaultEditor)this.jTime.getEditor()).getTextField().addKeyListener(keyListener);
    }

    @Override
    public synchronized void removeKeyListener(KeyListener keyListener) {
        ((JSpinner.DefaultEditor)this.jTime.getEditor()).getTextField().removeKeyListener(keyListener);
    }

    @Override
    public synchronized KeyListener[] getKeyListeners() {
        return ((JSpinner.DefaultEditor)this.jTime.getEditor()).getTextField().getKeyListeners();
    }

    public void setInfinity(boolean bl) {
        if (bl) {
            this.add((Component)this.infinityComboBox, "East");
            this.infinityComboBox.setSelected(true);
            this.setEnabled(false);
        } else {
            this.remove(this.infinityComboBox);
        }
    }

    private static class DateEditorFormatter
    extends DateFormatter {
        private final SpinnerDateModel model;

        DateEditorFormatter(SpinnerDateModel spinnerDateModel, DateFormat dateFormat) {
            super(dateFormat);
            this.model = spinnerDateModel;
        }

        public void setMinimum(Comparable comparable) {
            this.model.setStart(comparable);
        }

        public Comparable getMinimum() {
            return this.model.getStart();
        }

        public void setMaximum(Comparable comparable) {
            this.model.setEnd(comparable);
        }

        public Comparable getMaximum() {
            return this.model.getEnd();
        }
    }
}

