/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.swing.datetime;

import com.sun.java.swing.plaf.motif.MotifComboBoxUI;
import com.sun.java.swing.plaf.windows.WindowsComboBoxUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;

public class JDateComboBox
extends JComboBox {
    protected SimpleDateFormat dateFormat = new SimpleDateFormat(resource_.getString("SimpleDateFormat"));
    protected Date date = null;
    private static final ResourceBundle resource_ = ResourceBundle.getBundle(JDateComboBox.class.getName());

    public void setDateFormat(SimpleDateFormat simpleDateFormat) {
        this.dateFormat = simpleDateFormat;
    }

    @Override
    public void setSelectedItem(Object object) {
        this.removeAllItems();
        this.addItem(object);
        this.date = this.dateFormat.parse((String)this.getSelectedItem(), new ParsePosition(0));
        super.setSelectedItem(object);
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
        if (date != null) {
            this.setSelectedItem(this.dateFormat.format(date));
        } else {
            this.setSelectedItem("");
        }
    }

    @Override
    public void updateUI() {
        Object object = (ComboBoxUI)UIManager.getUI(this);
        if (object instanceof MetalComboBoxUI) {
            object = new MetalDateComboBoxUI();
        } else if (object instanceof MotifComboBoxUI) {
            object = new MotifDateComboBoxUI();
        } else if (object instanceof WindowsComboBoxUI) {
            object = new WindowsDateComboBoxUI();
        }
        this.setUI((ComboBoxUI)object);
    }

    class DatePopup
    implements ComboPopup,
    MouseMotionListener,
    MouseListener,
    KeyListener,
    PopupMenuListener {
        protected JComboBox comboBox;
        protected Calendar calendar;
        protected JPopupMenu popup;
        protected JLabel monthLabel;
        protected JPanel days = null;
        protected SimpleDateFormat monthFormat = new SimpleDateFormat("MMM yyyy");
        protected Color selectedBackground;
        protected Color selectedForeground;
        protected Color background;
        protected Color foreground;
        protected JList list = new JList();
        protected boolean mouseInside = false;
        protected boolean hideNext = false;

        public DatePopup(JComboBox jComboBox) {
            this.comboBox = jComboBox;
            this.calendar = Calendar.getInstance();
            this.background = UIManager.getColor("ComboBox.background");
            this.foreground = UIManager.getColor("ComboBox.foreground");
            this.selectedBackground = UIManager.getColor("ComboBox.selectionBackground");
            this.selectedForeground = UIManager.getColor("ComboBox.selectionForeground");
            this.initializePopup();
        }

        @Override
        public void show() {
            try {
                this.calendar.setTime(JDateComboBox.this.dateFormat.parse(this.comboBox.getSelectedItem().toString()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.updatePopup();
            this.popup.show(this.comboBox, 0, this.comboBox.getHeight());
        }

        @Override
        public void hide() {
            this.popup.setVisible(false);
        }

        public JList getList() {
            return this.list;
        }

        @Override
        public MouseListener getMouseListener() {
            return this;
        }

        @Override
        public MouseMotionListener getMouseMotionListener() {
            return this;
        }

        @Override
        public KeyListener getKeyListener() {
            return this;
        }

        @Override
        public boolean isVisible() {
            return this.popup.isVisible();
        }

        @Override
        public void uninstallingUI() {
            this.popup.removePopupMenuListener(this);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (!this.comboBox.isEnabled()) {
                return;
            }
            if (this.comboBox.isEditable()) {
                this.comboBox.getEditor().getEditorComponent().requestFocus();
            } else {
                this.comboBox.requestFocus();
            }
            this.togglePopup();
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.mouseInside = true;
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.mouseInside = false;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 32 || keyEvent.getKeyCode() == 10) {
                this.togglePopup();
            }
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            this.hideNext = this.mouseInside;
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }

        protected void togglePopup() {
            if (this.isVisible() || this.hideNext) {
                this.hide();
            } else {
                this.show();
            }
            this.hideNext = false;
        }

        protected JLabel createUpdateButton(final int n, final int n2) {
            final JLabel jLabel = new JLabel();
            final EtchedBorder etchedBorder = new EtchedBorder();
            final EmptyBorder emptyBorder = new EmptyBorder(etchedBorder.getBorderInsets(new JLabel()));
            jLabel.setBorder(emptyBorder);
            jLabel.setForeground(this.foreground);
            jLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    DatePopup.this.calendar.add(n, n2);
                    DatePopup.this.updatePopup();
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    jLabel.setBorder(etchedBorder);
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    jLabel.setBorder(emptyBorder);
                }
            });
            return jLabel;
        }

        protected void initializePopup() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.setBackground(this.background);
            jPanel.setOpaque(true);
            JLabel jLabel = this.createUpdateButton(1, -1);
            jLabel.setText(" << ");
            jLabel.setToolTipText(resource_.getString("PreviousYear"));
            jPanel.add(Box.createHorizontalStrut(12));
            jPanel.add(jLabel);
            jPanel.add(Box.createHorizontalStrut(12));
            jLabel = this.createUpdateButton(2, -1);
            jLabel.setText(" < ");
            jLabel.setToolTipText(resource_.getString("PreviousMonth"));
            jPanel.add(jLabel);
            this.monthLabel = new JLabel("", 0);
            this.monthLabel.setForeground(this.foreground);
            jPanel.add(Box.createHorizontalGlue());
            jPanel.add(this.monthLabel);
            jPanel.add(Box.createHorizontalGlue());
            jLabel = this.createUpdateButton(2, 1);
            jLabel.setText(" > ");
            jLabel.setToolTipText(resource_.getString("NextMonth"));
            jPanel.add(jLabel);
            jLabel = this.createUpdateButton(1, 1);
            jLabel.setText(" >> ");
            jLabel.setToolTipText(resource_.getString("NextYear"));
            jPanel.add(Box.createHorizontalStrut(12));
            jPanel.add(jLabel);
            jPanel.add(Box.createHorizontalStrut(12));
            this.popup = new JPopupMenu();
            this.popup.setBorder(BorderFactory.createLineBorder(Color.black));
            this.popup.setLayout(new BorderLayout());
            this.popup.setBackground(this.background);
            this.popup.addPopupMenuListener(this);
            this.popup.add("North", jPanel);
        }

        protected void updatePopup() {
            int n;
            int n2;
            int n3;
            this.monthLabel.setText(this.monthFormat.format(this.calendar.getTime()));
            if (this.days != null) {
                this.popup.remove(this.days);
            }
            this.days = new JPanel(new GridLayout(0, 7));
            this.days.setBackground(this.background);
            this.days.setOpaque(true);
            Calendar calendar = (Calendar)this.calendar.clone();
            int n4 = calendar.getFirstDayOfWeek();
            calendar.set(7, calendar.getFirstDayOfWeek());
            for (n3 = 0; n3 < 7; ++n3) {
                n2 = (n3 + n4 - 1) % 7 + 1;
                JLabel jLabel = new JLabel();
                jLabel.setHorizontalAlignment(0);
                jLabel.setForeground(this.foreground);
                switch (n2) {
                    case 1: {
                        jLabel.setText(resource_.getString("Sun"));
                        break;
                    }
                    case 2: {
                        jLabel.setText(resource_.getString("Mon"));
                        break;
                    }
                    case 3: {
                        jLabel.setText(resource_.getString("Tue"));
                        break;
                    }
                    case 4: {
                        jLabel.setText(resource_.getString("Wed"));
                        break;
                    }
                    case 5: {
                        jLabel.setText(resource_.getString("Thu"));
                        break;
                    }
                    case 6: {
                        jLabel.setText(resource_.getString("Fri"));
                        break;
                    }
                    case 7: {
                        jLabel.setText(resource_.getString("Sat"));
                    }
                }
                this.days.add(jLabel);
            }
            calendar = (Calendar)this.calendar.clone();
            calendar.set(5, 1);
            n3 = calendar.get(7);
            n2 = n3 - n4;
            for (n = 0; n < n2; ++n) {
                this.days.add(new JLabel(""));
            }
            n = 1;
            while (n <= calendar.getActualMaximum(5)) {
                final int n5 = n++;
                final JLabel jLabel = new JLabel(String.valueOf(n5));
                jLabel.setHorizontalAlignment(0);
                jLabel.setForeground(this.foreground);
                jLabel.addMouseListener(new MouseListener(){

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                    }

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                    }

                    @Override
                    public void mouseReleased(MouseEvent mouseEvent) {
                        jLabel.setOpaque(false);
                        jLabel.setBackground(DatePopup.this.background);
                        jLabel.setForeground(DatePopup.this.foreground);
                        DatePopup.this.calendar.set(5, n5);
                        DatePopup.this.comboBox.setSelectedItem(JDateComboBox.this.dateFormat.format(DatePopup.this.calendar.getTime()));
                        DatePopup.this.hide();
                        DatePopup.this.comboBox.requestFocus();
                    }

                    @Override
                    public void mouseEntered(MouseEvent mouseEvent) {
                        jLabel.setOpaque(true);
                        jLabel.setBackground(DatePopup.this.selectedBackground);
                        jLabel.setForeground(DatePopup.this.selectedForeground);
                    }

                    @Override
                    public void mouseExited(MouseEvent mouseEvent) {
                        jLabel.setOpaque(false);
                        jLabel.setBackground(DatePopup.this.background);
                        jLabel.setForeground(DatePopup.this.foreground);
                    }
                });
                this.days.add(jLabel);
            }
            this.popup.add("Center", this.days);
            this.popup.pack();
        }
    }

    class MotifDateComboBoxUI
    extends MotifComboBoxUI {
        MotifDateComboBoxUI() {
        }

        @Override
        protected ComboPopup createPopup() {
            return new DatePopup(this.comboBox);
        }
    }

    class WindowsDateComboBoxUI
    extends WindowsComboBoxUI {
        WindowsDateComboBoxUI() {
        }

        protected ComboPopup createPopup() {
            return new DatePopup(this.comboBox);
        }
    }

    class MetalDateComboBoxUI
    extends MetalComboBoxUI {
        MetalDateComboBoxUI() {
        }

        @Override
        protected ComboPopup createPopup() {
            return new DatePopup(this.comboBox);
        }
    }
}

