/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.event.EventListenerList;

public class RollPane
extends JComponent {
    protected EventListenerList listenerList = new EventListenerList();
    private double oldWeight = 0.0;
    public static final Icon subIcon = new ImageIcon(RollPane.class.getResource("sub.png"));
    public static final Icon addIcon = new ImageIcon(RollPane.class.getResource("add.png"));
    public static final Icon closeIcon = new ImageIcon(RollPane.class.getResource("xsmall.png"));

    public RollPane(String string, Component component, boolean bl) {
        this(string, component);
        this.setRolled(bl);
    }

    public RollPane() {
        this("", null);
    }

    public RollPane(String string, Component component) {
        this.setLayout(new GridBagLayout());
        JButton jButton = new JButton(subIcon);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setFocusable(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RollPane.this.setRolled(!RollPane.this.isRolled());
            }
        });
        this.add((Component)jButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 2), 0, 0));
        this.add((Component)new JSeparator(0), new GridBagConstraints(2, 0, 1, 1, 5.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.add((Component)new JSeparator(1), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 3, new Insets(1, 1, 1, 1), 0, 0));
        this.add((Component)new JLabel(string), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        if (component != null) {
            this.add(component, new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        }
        this.setAlignmentY(0.0f);
        MouseAdapter mouseAdapter = new MouseAdapter(){
            final String hlPrefix = "<html><nobr><u>";

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!RollPane.this.getButton().isEnabled()) {
                    return;
                }
                RollPane.this.setRolled(!RollPane.this.isRolled());
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                if (!RollPane.this.getButton().isEnabled()) {
                    return;
                }
                if (!RollPane.this.getLabel().getText().startsWith("<html><nobr><u>")) {
                    RollPane.this.getLabel().setText("<html><nobr><u>" + RollPane.this.getLabel().getText());
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                if (!RollPane.this.getButton().isEnabled()) {
                    return;
                }
                if (RollPane.this.getLabel().getText().startsWith("<html><nobr><u>")) {
                    RollPane.this.getLabel().setText(RollPane.this.getLabel().getText().substring("<html><nobr><u>".length()));
                }
            }
        };
        this.getLabel().addMouseListener(mouseAdapter);
        this.getComponent(1).addMouseListener(mouseAdapter);
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                RollPane.this.setRolled(!RollPane.this.isRolled());
                RollPane.this.setRolled(!RollPane.this.isRolled());
            }
        });
    }

    public JLabel getLabel() {
        return (JLabel)this.getComponent(3);
    }

    public JComponent getComponent() {
        return this.getComponentCount() > 4 ? (JComponent)this.getComponent(4) : null;
    }

    public void setComponent(JComponent jComponent) {
        if (jComponent != this.getComponent()) {
            if (this.getComponentCount() > 4) {
                this.remove(4);
            }
            this.add(jComponent, new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0), 4);
            this.revalidate();
            this.repaint();
        }
    }

    public JButton getButton() {
        return (JButton)this.getComponent(0);
    }

    public void setButton(JButton jButton) {
        if (jButton != this.getComponent(0)) {
            this.remove(0);
            this.add(jButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0), 0);
            this.revalidate();
            this.repaint();
        }
    }

    public void setRolled(boolean bl) {
        Object object;
        if (this.isRolled() == bl) {
            return;
        }
        this.getButton().setIcon(bl ? addIcon : subIcon);
        this.getComponent(4).setVisible(!bl);
        if (null == this.getParent()) {
            return;
        }
        if (this.getParent().getLayout() instanceof GridBagLayout) {
            if (!(this.getParent().getLayout() instanceof GridBagLayout)) {
                return;
            }
            object = (GridBagLayout)this.getParent().getLayout();
            GridBagConstraints object2 = ((GridBagLayout)object).getConstraints(this);
            if (null != object2) {
                if (bl) {
                    this.oldWeight = object2.weighty;
                    object2.weighty = 0.0;
                } else {
                    if (0.0 != object2.weighty) {
                        this.oldWeight = object2.weighty;
                    }
                    object2.weighty = this.oldWeight;
                }
                ((GridBagLayout)object).setConstraints(this, object2);
            }
        }
        this.revalidate();
        object = this.listenerList.getListeners(ActionListener.class);
        for (EventListener eventListener : object) {
            ((ActionListener)eventListener).actionPerformed(null);
        }
    }

    public boolean isRolled() {
        return !this.getComponent(4).isVisible();
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    public ActionListener[] getActionListeners() {
        return this.getButton().getActionListeners();
    }
}

