/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaGetPrepaidUnits;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.functions.dealer.custom.TClassFunctions;
import biz.netup.projects.utmadmin.functions.objects.TClass;
import biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs.AddprepaidUnitsDialog;
import biz.netup.swing.table.MapTableModel;
import biz.netup.swing.table.TablePanelAdapter;
import biz.netup.swing.table.impl.TablePanelImpl;
import biz.netup.utmutils.swing.dialog.DialogModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class PrepaidUnitsDialog
extends DialogModel {
    private JPanel panel1;
    private JButton addButton;
    private TablePanelImpl mainTablePanel;
    private TClass[] tclasses;

    public PrepaidUnitsDialog(Map<String, Object> map) {
        super(map);
    }

    public PrepaidUnitsDialog() {
        this.$$$setupUI$$$();
    }

    private void createUIComponents() {
        this.createTable();
    }

    private void createTable() {
        this.mainTablePanel = new TablePanelImpl(this.getClass().getName() + "_pu", true);
        MapTableModel mapTableModel = this.mainTablePanel.getTableModel();
        mapTableModel.addColumn("traffic_class_name", "Traffic class", true, false);
        mapTableModel.addColumn("transferred", "Transferred from last accounting period", true, false);
        mapTableModel.addColumn("prepaid", "Summary prepaid", true, false);
        this.mainTablePanel.setEditable(false);
        this.mainTablePanel.setAppendable(false);
        this.mainTablePanel.setTablePanelListener(new TablePanelAdapter(){

            @Override
            public void performTableRowDoubleClicked(Map<String, Object> map) {
                PrepaidUnitsDialog.this.addEdit();
            }
        });
        this.mainTablePanel.applyTableSettings();
    }

    private void addEdit() {
        AddprepaidUnitsDialog addprepaidUnitsDialog = new AddprepaidUnitsDialog(this.mainTablePanel.getSelectedTableRows()[0]);
        addprepaidUnitsDialog.load();
        if (addprepaidUnitsDialog.isOkPressed()) {
            try {
                this.refreshTable();
            }
            catch (UrfaException urfaException) {
                urfaException.printStackTrace();
            }
        }
    }

    @Override
    public Component getForm() {
        this.$$$setupUI$$$();
        return this.panel1;
    }

    @Override
    public String getItemName() {
        return "Prepaid";
    }

    @Override
    protected void loadInfo() throws UrfaException {
        this.tclasses = TClassFunctions.getTclassList();
        this.refreshTable();
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrepaidUnitsDialog.this.addEdit();
            }
        });
        this.mainTablePanel.registerOneRowButton(this.addButton);
    }

    private void refreshTable() throws UrfaException {
        this.mainTablePanel.getTableModel().removeAllRows();
        UrfaGetPrepaidUnits urfaGetPrepaidUnits = new UrfaGetPrepaidUnits(UrfaManagerImpl.getInstance());
        urfaGetPrepaidUnits.setSlinkId((Integer)this.item.get("slink_id"));
        urfaGetPrepaidUnits.call();
        for (int i = 0; i < urfaGetPrepaidUnits.getPinfoSize(); ++i) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("traffic_class", urfaGetPrepaidUnits.getId1()[i]);
            for (TClass tClass : this.tclasses) {
                if (tClass.getTclassId() != urfaGetPrepaidUnits.getId1()[i]) continue;
                hashMap.put("traffic_class_name", tClass.getTclassName());
            }
            hashMap.put("traffic_class", urfaGetPrepaidUnits.getId1()[i]);
            hashMap.put("prepaid", urfaGetPrepaidUnits.getCur1()[i] / (long)urfaGetPrepaidUnits.getBytesInMbyte());
            hashMap.put("transferred", urfaGetPrepaidUnits.getOld1()[i] / (long)urfaGetPrepaidUnits.getBytesInMbyte());
            hashMap.put("slink_id", this.item.get("slink_id"));
            this.mainTablePanel.getTableModel().addRow(hashMap);
        }
    }

    @Override
    protected void saveInfo() throws UrfaException {
    }

    @Override
    protected void checkInfo() throws IllegalArgumentException {
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.panel1 = new JPanel();
        this.panel1.setLayout(new BorderLayout(0, 0));
        this.panel1.setMinimumSize(new Dimension(300, 300));
        this.panel1.setPreferredSize(new Dimension(300, 300));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.panel1.add((Component)jPanel, "North");
        this.addButton = new JButton();
        this.$$$loadButtonText$$$(this.addButton, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Add/Edit"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.addButton, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.panel1.add((Component)this.mainTablePanel, "Center");
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    @Override
    public JComponent $$$getRootComponent$$$() {
        return this.panel1;
    }
}

