/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.projects.utmadmin.gui.userframe.forms.tarification.sl.sldialogs;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.functions.UrfaGetIpMac;
import biz.netup.control.transport.urfa.functions.UrfaGetRoutersList;
import biz.netup.control.transport.urfa.impl.UrfaManagerImpl;
import biz.netup.projects.utmadmin.functions.dealer.custom.HouseFunctions;
import biz.netup.projects.utmadmin.functions.dealer.user.user.UserFunctions;
import biz.netup.utmutils.control.Settings;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.control.permissions.PermissionButton;
import biz.netup.utmutils.control.resolvers.Resolve;
import biz.netup.utmutils.swing.dialog.DialogModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class IpGroupDialog
extends DialogModel {
    private JCheckBox notVPNIPGroupCheckBox;
    private JCheckBox doNotAffectFirewallCheckBox;
    private JTextField allowedCIDTextField;
    private JTextField loginTextField;
    private JTextField MACAddressTextField;
    private JTextField maskTextField;
    private JComboBox IPComboBox;
    private JLabel firewallIDLabel;
    private JComboBox firewallIDComboBox;
    private JTextField passwordPasswordField;
    private JPanel mainPanel;
    private PermissionButton refreshButton;
    private int uid;
    Map<String, Integer> fwMap;
    Map<String, String> macMap = new HashMap<String, String>();
    private String pass = "";

    public IpGroupDialog() {
        this.$$$setupUI$$$();
    }

    public IpGroupDialog(Map<String, Object> map) {
        super(map);
    }

    @Override
    public Component getForm() {
        this.$$$setupUI$$$();
        return this.mainPanel;
    }

    @Override
    public String getItemName() {
        return "IP group";
    }

    @Override
    protected void loadInfo() throws UrfaException {
        this.setAddMode(!this.item.containsKey("ip"));
        this.pass = Resolve.getPassword();
        if (this.isAddMode()) {
            this.notVPNIPGroupCheckBox.setSelected("1".compareToIgnoreCase(Settings.getValueFromPerst("NotVPN")) == 0);
            this.doNotAffectFirewallCheckBox.setSelected("1".compareToIgnoreCase(Settings.getValueFromPerst("DoNotAffectFW")) == 0);
        }
        if (this.isAddMode() || ((String)this.item.get("login")).isEmpty()) {
            this.loginTextField.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent caretEvent) {
                    if (!IpGroupDialog.this.loginTextField.getText().isEmpty()) {
                        IpGroupDialog.this.passwordPasswordField.setText(IpGroupDialog.this.pass);
                    } else {
                        IpGroupDialog.this.passwordPasswordField.setText("");
                    }
                }
            });
        }
        this.uid = (Integer)this.item.get("uid");
        if (!Utils.isAdmin()) {
            this.firewallIDComboBox.setVisible(false);
            this.firewallIDLabel.setVisible(false);
            this.doNotAffectFirewallCheckBox.setVisible(false);
        } else {
            this.fillFirewall();
        }
        this.fillFields();
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IpGroupDialog.this.pass = Resolve.getPassword();
                IpGroupDialog.this.passwordPasswordField.setText(IpGroupDialog.this.pass);
            }
        });
    }

    private void fillFirewall() throws UrfaException {
        this.fwMap = new LinkedHashMap<String, Integer>();
        this.firewallIDComboBox.removeAllItems();
        this.fwMap.put(this.resource.getString("Any") + " (0)", 0);
        UrfaGetRoutersList urfaGetRoutersList = new UrfaGetRoutersList(UrfaManagerImpl.getInstance());
        urfaGetRoutersList.call();
        for (int i = 0; i < urfaGetRoutersList.getRoutersSize(); ++i) {
            if (urfaGetRoutersList.getRouterBinIp1()[i] == 0) continue;
            this.fwMap.put(Resolve.ip_toString(urfaGetRoutersList.getRouterBinIp1()[i]), urfaGetRoutersList.getRouterId1()[i]);
        }
        for (String string : this.fwMap.keySet()) {
            this.firewallIDComboBox.addItem(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void fillFields() throws UrfaException {
        if (!this.isAddMode()) {
            this.IPComboBox.setSelectedItem(this.item.get("ip_str"));
            this.maskTextField.setText((String)this.item.get("mask_str"));
            this.MACAddressTextField.setText((String)this.item.get("mac"));
            this.loginTextField.setText((String)this.item.get("login"));
            this.passwordPasswordField.setText((String)this.item.get("password"));
            this.allowedCIDTextField.setText((String)this.item.get("allowed_cid"));
            this.notVPNIPGroupCheckBox.setSelected((Integer)this.item.get("not_vpn") == 1);
            this.doNotAffectFirewallCheckBox.setSelected((Integer)this.item.get("do_not_affect_firewall") == 1);
            if (Utils.isAdmin()) {
                for (String object : this.fwMap.keySet()) {
                    if (this.fwMap.get(object) != this.item.get("router_id")) continue;
                    this.firewallIDComboBox.setSelectedItem(object);
                }
            }
        } else {
            this.maskTextField.setText("255.255.255.255");
        }
        for (Map<String, Object> map : HouseFunctions.getFreeIps(UserFunctions.getUser(this.uid).getHouseId())) {
            this.IPComboBox.addItem(Resolve.ip_toString((Integer)map.get("ip")) + " " + map.get("zone"));
        }
        if (Utils.isAdmin()) {
            void var2_6;
            this.macMap.clear();
            Iterator<String> iterator = new UrfaGetIpMac(UrfaManagerImpl.getInstance());
            ((UrfaGetIpMac)((Object)iterator)).call();
            boolean bl = false;
            while (var2_6 < ((UrfaGetIpMac)((Object)iterator)).getIpsSize()) {
                this.macMap.put(Resolve.ip_toString(((UrfaGetIpMac)((Object)iterator)).getIpsIp1()[var2_6]) + " " + ((UrfaGetIpMac)((Object)iterator)).getName1()[var2_6], ((UrfaGetIpMac)((Object)iterator)).getName1()[var2_6]);
                ++var2_6;
            }
            for (String string : this.macMap.keySet()) {
                this.IPComboBox.addItem(string);
            }
            this.IPComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (IpGroupDialog.this.macMap.containsKey(IpGroupDialog.this.IPComboBox.getSelectedItem())) {
                        IpGroupDialog.this.MACAddressTextField.setText(IpGroupDialog.this.macMap.get(IpGroupDialog.this.IPComboBox.getSelectedItem()));
                    }
                }
            });
        }
    }

    @Override
    protected void saveInfo() throws UrfaException {
        try {
            this.item.put("ip", this.getSelectedIp());
            this.item.put("ip_str", Resolve.ip_toString(this.getSelectedIp()));
            this.item.put("mask", Resolve.parse_mask(this.maskTextField.getText()));
            this.item.put("mask_str", this.maskTextField.getText());
            this.item.put("login", this.loginTextField.getText());
            this.item.put("password", this.passwordPasswordField.getText());
            this.item.put("allowed_cid", this.allowedCIDTextField.getText());
            this.item.put("mac", this.MACAddressTextField.getText());
            this.item.put("not_vpn", this.notVPNIPGroupCheckBox.isSelected() ? 1 : 0);
            this.item.put("do_not_affect_firewall", this.doNotAffectFirewallCheckBox.isSelected() ? 1 : 0);
            if (Utils.isAdmin()) {
                this.item.put("router_id", this.fwMap.get(this.firewallIDComboBox.getSelectedItem()));
            } else {
                this.item.put("router_id", 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int getSelectedIp() {
        int n = -1;
        try {
            n = ((String)this.IPComboBox.getSelectedItem()).indexOf(32) != -1 ? Resolve.parse_ip(((String)this.IPComboBox.getSelectedItem()).substring(0, ((String)this.IPComboBox.getSelectedItem()).indexOf(32))) : Resolve.parse_ip((String)this.IPComboBox.getSelectedItem());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    @Override
    protected void checkInfo() throws IllegalArgumentException {
        this.checkMask(this.maskTextField, "Mask");
        if (!this.settingListeners) {
            if (this.getSelectedIp() == -1) {
                this.log.log(1, this.resource.getString("IP") + " " + this.resource.getString("field is invalid"));
                this.IPComboBox.requestFocus();
                throw new IllegalArgumentException();
            }
            if (((Set)this.item.get("ips")).contains(this.getSelectedIp())) {
                this.log.log(1, this.resource.getString("Attempt to add one more ip / mask item"));
                this.IPComboBox.requestFocus();
                throw new IllegalArgumentException();
            }
        }
    }

    private void createUIComponents() {
        this.refreshButton = new PermissionButton(new int[]{96});
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout(0, 0));
        this.mainPanel.setMinimumSize(new Dimension(400, 263));
        this.mainPanel.setPreferredSize(new Dimension(400, 263));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.mainPanel.add((Component)jPanel, "Center");
        jPanel.setBorder(BorderFactory.createTitledBorder(""));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("IP"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Allowed CID"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Password"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jLabel3, gridBagConstraints);
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Login"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jLabel4, gridBagConstraints);
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("MAC address"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jLabel5, gridBagConstraints);
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Mask"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jLabel6, gridBagConstraints);
        this.notVPNIPGroupCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.notVPNIPGroupCheckBox, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Not VPN IP group"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.notVPNIPGroupCheckBox, gridBagConstraints);
        this.doNotAffectFirewallCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.doNotAffectFirewallCheckBox, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("Do not affect firewall rules"));
        this.doNotAffectFirewallCheckBox.setVisible(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.doNotAffectFirewallCheckBox, gridBagConstraints);
        this.allowedCIDTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.allowedCIDTextField, gridBagConstraints);
        this.loginTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.loginTextField, gridBagConstraints);
        this.MACAddressTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.MACAddressTextField, gridBagConstraints);
        this.maskTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.maskTextField, gridBagConstraints);
        this.IPComboBox = new JComboBox();
        this.IPComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.IPComboBox, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel6, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel7, gridBagConstraints);
        this.firewallIDLabel = new JLabel();
        this.$$$loadLabelText$$$(this.firewallIDLabel, ResourceBundle.getBundle("biz/netup/utmutils/swing/localization/Language").getString("NetFlow provider"));
        this.firewallIDLabel.setVisible(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.firewallIDLabel, gridBagConstraints);
        this.firewallIDComboBox = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.firewallIDComboBox, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel8, gridBagConstraints);
        this.passwordPasswordField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.passwordPasswordField, gridBagConstraints);
        JPanel jPanel9 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel9, gridBagConstraints);
        JPanel jPanel10 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)jPanel10, gridBagConstraints);
        this.refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/biz/netup/utmutils/swing/resourses/icons/refresh16.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 10;
        jPanel.add((Component)this.refreshButton, gridBagConstraints);
    }

    private void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    @Override
    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

